#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "BackOrifice";
 name["francais"] = "BackOrifice";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
This host seems to be running a passwordless
BackOrifice 1.x  on this port.

BackOrifice is trojan which allows an intruder to take
the control of the remote computer.

A cracker may use it to steal your passwords, modify
your data, and preventing you from working properly.

Solution : 
Risk factor : High";


 desc["francais"] = "
Cette machine semble faire tourner BackOrifice 1.x 
sans mot de passe sur ce port.

BackOrifice est un cheval de troie qui
permet  un intrus de prendre le controle de 
ce poste  distance.

Un pirate peut l'utiliser pour voler vos mots de passe,
modifier vos donnes, et vous empecher de travailler
correctement.

Solution : 
Facteur de risque : Elev";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Determines the presence of BackOrifice";
 summary["francais"] = "Dtermine la prsence de BackOrifice";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Backdoors";
 family["francais"] = "Backdoors";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("nmap_wrapper.nes", "queso.nes");
 
 exit(0);
}

#
# The script code starts here
#

os = get_kb_item("Host/OS");
if(os)
{
 if(!("Windows" >< os))exit(0);
}

#
# Reverse-ingeneered data. Not very meaningful.
# This is a 'ping' request for BackOrifice
#

s = raw_string(0xCE, 0x63, 0xD1, 0xD2, 0x16, 0xE7, 
	       0x13, 0xCF, 0x39, 0xA5, 0xA5, 0x86, 
	       0x4D, 0x8A, 0xB4, 0x66, 0xAA, 0x32);
	    
soc = open_sock_udp(31337);
send(socket:soc, data:s, length:18);
r = recv(socket:soc, length:10);
if(r)security_hole(31337);
close(soc);
