/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/Xmu/CharSet.h>
#include <stdlib.h>
#include <ctype.h>
#include "cvt.h"

Boolean  cvtStringToBoxType (display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToBoxType", "wrongParameters",
			"XtToolkitError",
			"String to BoxType conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "no") == 0) a = XtCno_box;
		else if (XmuCompareISOLatin1(s, "simple") == 0) a = XtCsimple_box;
		else if (XmuCompareISOLatin1(s, "up") == 0) a = XtCup_box;
		else if (XmuCompareISOLatin1(s, "down") == 0) a = XtCdown_box;
		else if (XmuCompareISOLatin1(s, "framein") == 0) a = XtCframein_box;
		else if (XmuCompareISOLatin1(s, "frameout") == 0) a = XtCframeout_box;
		else if (XmuCompareISOLatin1(s, "shadow") == 0) a = XtCshadow_box;
		
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtRBox_type);
		break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtBoxTypeToString(display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int *a = (int*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtBoxTypeToString", "wrongParameters",
			"XtToolkitError",
			"BoxType to String conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);
	switch (*a) {
		case XtCno_box: done(String, "no");
		case XtCsimple_box: done(String , "simple");
		case XtCup_box: done(String, "up");
		case XtCdown_box: done(String, "down");
		case XtCframein_box: done(String, "framein");
		case XtCframeout_box: done(String, "frameout");
		case XtCshadow_box: done(String , "shadow");
		default: done(String, "unknown");
	}
}

Boolean  cvtStringToJustify (display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;


	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToJustify", "wrongParameters",
			"XtToolkitError",
			"String to Justify conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "center") == 0) a = XtCcenter;
		else if (XmuCompareISOLatin1(s, "left") == 0) a = XtCleft;
		else if (XmuCompareISOLatin1(s, "right") == 0) a = XtCright;
		else if (XmuCompareISOLatin1(s, "bottom") == 0) a = XtCbottom;
		else if (XmuCompareISOLatin1(s, "top") == 0) a = XtCtop;
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtRJustify);
			break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtStringToIcon(dpy,args,num_args,from,to,converter_data)
Display * dpy;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	Icon *icon = (Icon *) malloc(sizeof(Icon));
	char *s = (char*) from->addr;
	char *name ,  *t;
	int status;
	Cardinal n_arg = 1;
  	unsigned int b_width,depth;
  	int x,y;

	for (; isspace(*s); s++) ;
	for (t = s; *t && ! isspace(*t); t++) ;
	*t = '\0';
	name = s;

	status = XpmReadFileToPixmap(dpy , DefaultRootWindow(dpy) , name ,
			&icon->pixmap , &icon->shape , NULL);

	switch (status) {
		case XpmOpenFailed:
		case XpmFileInvalid:
		case XpmNoMemory:
			XtAppWarningMsg
				(XtDisplayToApplicationContext(dpy),
				 "cvtStringToPixmap", "fileError",
				 "XtToolkitError",
				 "Failed to read pixmap from \"%s\"",
				 &name, &n_arg);
			break;

		case XpmColorError:
		case XpmColorFailed:
			XtAppWarningMsg
				(XtDisplayToApplicationContext(dpy),
				 "cvtStringToPixmap", "allocColor",
				 "XtToolkitError",
				 "Could not get (all) colors for pixmap \"%s\"",
				 &name, &n_arg);
		case XpmSuccess:
			if (icon->pixmap)
				status=XGetGeometry(dpy , icon->pixmap , &DefaultRootWindow(dpy) ,
					&x , &y , &icon->width , &icon->height ,
					&b_width , &depth);
			else
			{
				free(icon);
				icon = NULL;
				XtAppWarningMsg
					(XtDisplayToApplicationContext(dpy),
					 "cvtStringToPixmap", "allocColor",
					 "XtToolkitError",
					 "Could not create pixmap \"%s\"",
				 	 &name, &n_arg);
			}
			done(Icon*,icon);
	}
	return False;
}

Boolean  cvtStringToCheckType (display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToCheckType", "wrongParameters",
			"XtToolkitError",
			"String to CheckType conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "check") == 0) a = XtCcheck;
		else if (XmuCompareISOLatin1(s, "rectangle") == 0) a = XtCrectangle;
		else if (XmuCompareISOLatin1(s, "diamond") == 0) a = XtCdiamond;
		else if (XmuCompareISOLatin1(s, "circle") == 0) a = XtCcircle;
		else if (XmuCompareISOLatin1(s, "cross") == 0) a = XtCcross;
		else if (XmuCompareISOLatin1(s, "circle2") == 0) a = XtCcircle2;
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtRCheck_type);
		break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtStringToObjectType (display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToObjectType", "wrongParameters",
			"XtToolkitError",
			"String to ObjectType conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "left_arrow") == 0) a = XtCleft_arrow;
		else if (XmuCompareISOLatin1(s, "right_arrow") == 0) a = XtCright_arrow;
		else if (XmuCompareISOLatin1(s, "top_arrow") == 0) a = XtCtop_arrow;
		else if (XmuCompareISOLatin1(s, "bottom_arrow") == 0) a = XtCbottom_arrow;
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtRObject_type);
		break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtStringToOrientation (display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;


	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToOrientation", "wrongParameters",
			"XtToolkitError",
			"String to Orientation conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "vertical") == 0) a = XtCvertical;
		else if (XmuCompareISOLatin1(s, "horizontal") == 0) a = XtChorizontal;
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtROrientation);
			break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtStringToListStruct(display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	ListStruct *list = NULL;
	Boolean koniec = 0;
	long len , cnt = 0;
	char *st , *en , *s = (char*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToListStruct", "wrongParameters",
			"XtToolkitError",
			"String to ListStruct conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (!koniec)
	{
		cnt ++;

		st = strchr(s , '\"');
		st ++;
		en = strchr(st , '\"');
		len = en - st;

		list = (ListStruct *) XtRealloc((void *) list , cnt * sizeof(ListStruct));

		list[cnt - 1].label = (char *) XtMalloc(len + 1);
		strncpy(list[cnt - 1].label , st , len);
		*(list[cnt - 1].label + len) = '\0';
		list[cnt - 1].left_icon = None;
		list[cnt - 1].right_icon = None;
		list[cnt - 1].related_info = NULL;
		list[cnt - 1].index = cnt;

		s = en + 1;

		koniec = ( strchr(s , '\"') == NULL);
	}

	done(ListStruct * , list);
}

Boolean  cvtStringToButtonMode(display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	int a = 0;
	char c, *t, *s = (char*) from->addr;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToButtonMode", "wrongParameters",
			"XtToolkitError",
			"String to ButtonMode conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (*s) {
		/* vynechaj medzery */
		for (; isspace(*s); s++) ;
		for (t = s; *t && ! isspace(*t); t++) ;
		c = *t;
		*t = '\0';
		if (XmuCompareISOLatin1(s, "normal") == 0) a = XtCnormalMode;
		else if (XmuCompareISOLatin1(s, "cyclic") == 0) a = XtCcyclicMode;
		else if (XmuCompareISOLatin1(s, "toggle") == 0) a = XtCtoggleMode;
		else {
			XtDisplayStringConversionWarning(display, (char*) from->addr, 
							XtRObject_type);
		break;
		}
		*t = c;
		s = t;
	}
	done(int, a);
}

Boolean  cvtStringToStringList(display,args,num_args,from,to,converter_data)
Display * display;
XrmValuePtr  args;
Cardinal * num_args;
XrmValuePtr  from;
XrmValuePtr  to;
XtPointer * converter_data;
{
	char **list;
	Boolean koniec = 0;
	long len , cnt = 0;
	char *st , *en , *s = (char*) from->addr;

	list = (char **) XtMalloc(sizeof(char *));
	list[0] = NULL;

	if (*num_args != 0)
		XtAppErrorMsg(XtDisplayToApplicationContext(display),
			"cvtStringToStringList", "wrongParameters",
			"XtToolkitError",
			"String to StringList conversion needs no arguments",
			(String*) NULL, (Cardinal*) NULL);

	while (!koniec)
	{
		cnt ++;

		st = strchr(s , '\"');
		st ++;
		en = strchr(st , '\"');
		len = en - st;

		list = (char **) XtRealloc((void *) list , (cnt + 1) * sizeof(char *));

		list[cnt - 1] = (char *) XtMalloc(len + 1);
		strncpy(list[cnt - 1] , st , len);
		*(list[cnt - 1] + len) = '\0';
		list[cnt] = NULL;

		s = en + 1;

		koniec = (strchr(s , '\"') == NULL);
	}

	done(char ** , list);
}
