/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <stdio.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#include "config.h"

#ifdef I_FACE

#include "tools.h"
#include "html.h"
#include "lfname.h"
#include "re.h"
#include "nscache.h"
#include "log.h"
#include "authinfo.h"
#include "cookie.h"
#include "net.h"
#include "times.h"

#ifdef GTK_FACE

/*****************************************************************************/
/*			GTK GUI abstracion macros			     */ 
/*****************************************************************************/

#include "gtkscalendar.h"

#define _IFT_ gtk

#define SET_URLLIST(w, l)\
{\
	dllist *p = l;\
	gtk_clist_freeze(GTK_CLIST(w));\
	gtk_clist_clear(GTK_CLIST(w));\
	while(p)\
	{\
		url_info *ui = (url_info *)p->data;\
		int row = gtk_clist_append(GTK_CLIST(w), &ui->urlstr);\
		if (ui->type == URLI_FORM)\
		{\
			ui = url_info_duplicate(ui);\
			gtk_clist_set_row_data_full(GTK_CLIST(w), row, ui, (GtkDestroyNotify)url_info_free);\
		}\
  		p = p->next;\
	}\
	gtk_clist_thaw(GTK_CLIST(w));\
}

#define SET_LIST(w,l) \
{\
	char **p = l;\
	gtk_clist_freeze(GTK_CLIST(w));\
	gtk_clist_clear(GTK_CLIST(w));\
        if (p) while(*p)\
        {\
		gtk_clist_append(GTK_CLIST(w), p);\
  		p++;\
	}\
	gtk_clist_thaw(GTK_CLIST(w));\
}

#define SET_DLLIST(w,l) \
{\
	dllist *p = l;\
	gtk_clist_freeze(GTK_CLIST(w));\
	gtk_clist_clear(GTK_CLIST(w));\
        while(p)\
        {\
		gtk_clist_append(GTK_CLIST(w), (char **)&p->data);\
  		p = p->next;\
	}\
	gtk_clist_thaw(GTK_CLIST(w));\
}

#define SET_DOUBLE SET_NUM

#define SET_NUM(w,v) \
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(w) , (gfloat)v);\
	gtk_signal_emit_by_name(GTK_OBJECT(gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(w))) , "value_changed");

#define SET_TEXT(w,t) \
	if (t) gtk_entry_set_text(GTK_ENTRY(w) , t);\
	else gtk_entry_set_text(GTK_ENTRY(w) , "");

#define SET_BOOL(w,v) \
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(w) , v);


#define SET_HTML_TAGS \
{\
	GList *chlist;\
	int *statpointer;\
	\
	for(chlist = GTK_BOX(cfg.gtk.html_tags)->children ; chlist ; chlist = chlist->next)\
	{\
		statpointer = gtk_object_get_user_data(\
				GTK_OBJECT(((struct _GtkBoxChild *)chlist->data)->widget));\
	\
		SET_BOOL(((struct _GtkBoxChild *)chlist->data)->widget ,\
			!(*statpointer & LINK_DISABLED));\
	}\
}

#define SET_COMBO_IDX(w , i) \
  	gtk_option_menu_set_history(GTK_OPTION_MENU(w) , i);

#ifdef _GTK_FEATURES_1_2
#define SET_CALENDAR(w , ltime) \
	gtk_calendar_select_month(GTK_CALENDAR(w) , \
		ltime->tm_mon , ltime->tm_year);\
	gtk_calendar_select_day(GTK_CALENDAR(w) , \
		ltime->tm_mday);
#else
#define SET_CALENDAR(w , ltime) \
	gtk_scalendar_set_date(GTK_SCALENDAR(w) , \
		ltime->tm_mday , ltime->tm_mon , ltime->tm_year);
#endif /* _GTK_FEATURES_1_2 */

#define SET_C_EXTRAS \
	SET_BOOL(cfg. _IFT_ .http_schgr[cfg.auth_scheme - 1] , TRUE);\
	SET_BOOL(cfg. _IFT_ .httpp_schgr[cfg.proxy_auth_scheme - 1] , TRUE);\
	SET_BOOL(cfg. _IFT_ .ftpmodegr[(int)cfg.ftp_activec] , TRUE);\
	if (cfg._IFT_.ssl_version[0]) SET_BOOL(cfg. _IFT_ .ssl_version[cfg.ssl_version - 1] , TRUE);


#define GET_LIST(w,l) \
{\
	char **p=l;\
	int n=0;\
	\
	while(l && *p) _free(*p);\
	_free(l);\
	l = NULL;\
	for (n = 0 ; n < GTK_CLIST(w)->rows ; n++)\
	{\
		char *xp;\
		l = (char **)_realloc(l , (n + 2) * sizeof(char *));\
		gtk_clist_get_text(GTK_CLIST(w) , n , 0 , &xp);\
		l[n] = new_string(xp);\
		l[n+1] = NULL;\
	}\
}

#define GET_URLLIST(w,l) \
{\
	int n;\
	\
	while(l) {url_info_free((url_info *)l->data) ; l = dllist_remove_entry(l , l);}\
	for (n = 0 ; n < GTK_CLIST(w)->rows ; n++)\
	{\
		char *xp;\
		url_info *ui = (url_info *)gtk_clist_get_row_data(GTK_CLIST(w), n);\
		gtk_clist_get_text(GTK_CLIST(w) , n , 0 , &xp);\
		if (ui) ui = url_info_duplicate(ui);\
		else ui = url_info_new(xp);\
		l = dllist_append(l , ui);\
	}\
}


#define GET_DLLIST(w,l) \
{\
	int n;\
	\
	while(l) {_free(l->data) ; l = dllist_remove_entry(l , l);}\
	for (n = 0 ; n < GTK_CLIST(w)->rows ; n++)\
	{\
		char *xp;\
		gtk_clist_get_text(GTK_CLIST(w) , n , 0 , &xp);\
		l = dllist_append(l , new_string(xp));\
	}\
}

#define GET_BOOL(w,v) \
		(v = GTK_TOGGLE_BUTTON(w)->active)

#define GET_NUM(w,v) \
		(v = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(w)))

#define GET_DOUBLE(w,v) \
		(v = (double) gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(w)))

#define GET_STR(w,s) \
	_free(s);\
	s = new_string(gtk_entry_get_text (GTK_ENTRY(w)));\
	if (!(s && *s))\
	{\
		_free(s);\
	}

#define GET_S_STR(w,s) \
	s = new_string(gtk_entry_get_text (GTK_ENTRY(w)));\
	if (!(s && *s))\
	{\
		_free(s);\
	}

#define GET_HTML_TAGS \
{\
	GList *chlist;\
	int *statpointer;\
	\
	for(chlist = GTK_BOX(cfg.gtk.html_tags)->children ; chlist ; chlist = chlist->next)\
	{\
		statpointer = gtk_object_get_user_data(\
			GTK_OBJECT(((struct _GtkBoxChild *)chlist->data)->widget));\
		\
		if (GET_BOOL(((struct _GtkBoxChild *)chlist->data)->widget , b))\
			*statpointer &= ~LINK_DISABLED;\
		else\
			*statpointer |= LINK_DISABLED;\
	}\
}

#define GET_COMBO_IDX(w , i) \
	i = GTK_OPTION_MENU(w)->menu_item ? \
	 (int) gtk_object_get_user_data(GTK_OBJECT(GTK_OPTION_MENU(w)->menu_item)) : 0;

#ifdef _GTK_FEATURES_1_2
#define GET_DATE(w , ftm) \
	gtk_calendar_get_date(GTK_CALENDAR(w) ,\
		&ftm.tm_year , &ftm.tm_mon , &ftm.tm_mday);\
	ftm.tm_year -= 1900;
#else
#define GET_DATE(w , ftm) \
	ftm.tm_mday = GTK_SCALENDAR(w)->day;\
	ftm.tm_mon = GTK_SCALENDAR(w)->month;\
	ftm.tm_year = (GTK_SCALENDAR(w)->year >= 1900) ? \
		GTK_SCALENDAR(w)->year - 1900 : \
		GTK_SCALENDAR(w)->year;
#endif /* _GTK_FEATURES_1_2 */

#define GET_C_EXTRAS \
	if (GET_BOOL(cfg.gtk.http_schgr[0] , cfg.auth_scheme))\
		cfg.auth_scheme = 1;\
	else if (GET_BOOL(cfg.gtk.http_schgr[1] , cfg.auth_scheme))\
		cfg.auth_scheme = 2;\
	else if (GET_BOOL(cfg.gtk.http_schgr[2] , cfg.auth_scheme))\
		cfg.auth_scheme = 3;\
	if (GET_BOOL(cfg.gtk.httpp_schgr[0] , cfg.proxy_auth_scheme))\
		cfg.proxy_auth_scheme = 1;\
	else if (GET_BOOL(cfg.gtk.httpp_schgr[1] , cfg.proxy_auth_scheme))\
		cfg.proxy_auth_scheme = 2;\
	else if (GET_BOOL(cfg.gtk.httpp_schgr[2] , cfg.proxy_auth_scheme))\
		cfg.proxy_auth_scheme = 3;\
	GET_BOOL(cfg.gtk.ftpmodegr[1] , cfg.ftp_activec);\
	if (cfg.gtk.ssl_version[0])\
	{\
		if (GET_BOOL(cfg.gtk.ssl_version[0] , cfg.ssl_version))\
			cfg.ssl_version = 1;\
		else if (GET_BOOL(cfg.gtk.ssl_version[1] , cfg.ssl_version))\
			cfg.ssl_version = 2;\
		else if (GET_BOOL(cfg.gtk.ssl_version[2] , cfg.ssl_version))\
			cfg.ssl_version = 3;\
	}


#endif /* GTK_FACE */

#ifdef X_FACE

/*****************************************************************************/
/*			Xt GUI abstracion macros			     */
/*****************************************************************************/

#include "tools.h"
#include "html.h"
#include <Nws/MultiColP.h>

#define _IFT_ X

#define ForAllChildren(cw, child) \
        for ( (child) = (cw)->composite.children ; \
                (child) < ((cw)->composite.children + \
                (cw)->composite.num_children ) ; \
                (child)++ )

#define SET_LIST(w,l) \
{\
	ListStruct plist;\
	char **p;\
	\
 	p = l;\
	ListChange(w , NULL , 0 , True);\
        if (p) while(*p)\
        {\
		plist.sensitive = True;\
		plist.left_icon = NULL;\
		plist.right_icon = NULL;\
		plist.related_info = NULL;\
        	plist.label = *p;\
  		ListAppendItems(w , &plist , 1);\
  		p++;\
	}\
}

#define SET_DLLIST(w,l) \
{\
	ListStruct plist;\
	dllist *p;\
	\
 	p = l;\
	ListChange(w , NULL , 0 , True);\
        if (p) while(p)\
        {\
		plist.sensitive = True;\
		plist.left_icon = NULL;\
		plist.right_icon = NULL;\
		plist.related_info = NULL;\
        	plist.label = (char *) p->data;\
  		ListAppendItems(w , &plist , 1);\
  		p = p->next;\
	}\
}

#define SET_URLLIST(w,l) \
{\
	ListStruct plist;\
	dllist *p = l;\
	ListChange(w , NULL , 0 , True);\
        while(p)\
        {\
		url_info *ui = (url_info *)p->data;\
		plist.sensitive = True;\
		plist.left_icon = NULL;\
		plist.right_icon = NULL;\
		plist.related_info = NULL;\
		if (ui->type == URLI_FORM)\
		{\
			ui = url_info_duplicate(ui);\
			plist.related_info = ui;\
		}\
        	plist.label = ui->urlstr;\
  		ListAppendItems(w , &plist , 1);\
  		p = p->next;\
	}\
}

#define SET_NUM(w,v) \
	XtVaSetValues(w , XtNvalue , v , NULL);

#define SET_DOUBLE(w,v) \
	FloatEntrySetValue(w , (float)v);

#define SET_TEXT(w,t) \
	EntryLineSetText(w,t);

#define SET_BOOL(w,v) \
	if (v) CheckButtonSet(w, TRUE); else  CheckButtonReset(w, TRUE);

#define SET_HTML_TAGS \
{\
	int *statpointer;\
	Widget *child;\
\
	ForAllChildren(((MultiColWidget)cfg.X.html_tags) , child)\
	{\
		XtVaGetValues((Widget)*child , XtNuser_data , &statpointer , NULL);\
		XtVaSetValues((Widget)*child ,\
			XtNon , !(*statpointer & LINK_DISABLED) , NULL);\
	}\
}

#define SET_CALENDAR(w , ltime) \
	XtVaSetValues(w , XtNtime , ltime , NULL);

#define SET_COMBO_IDX(w , i) \
	ComboSetIndex(w , i);

#define SET_C_EXTRAS \
	RadioGroupSetSelected(cfg.X.auth_sw , cfg.auth_scheme);\
	RadioGroupSetSelected(cfg.X.proxy_auth_sw , cfg.proxy_auth_scheme);\
	RadioGroupSetSelected(cfg.X.ftp_data_sw , cfg.ftp_activec);\
	if (cfg.X.ssl_version) RadioGroupSetSelected(cfg.X.ssl_version, cfg.ssl_version);


#define GET_LIST(w,l) \
{\
	ListStruct *plist;\
	int num,i;\
	\
	for(i = 0; l && l[i] ; i++) _free(l[i]);\
	_free(l);\
	XtVaGetValues(w , XtNlist , &plist , XtNnum_entry , &num , NULL);\
	if (num > 0)\
	{\
		l = (char **) _malloc((num + 1) * sizeof(char *));\
		l[num] = NULL;\
		for(i = 0 ; i < num ; i++)\
		{\
			l[i] = new_string(plist[i].label);\
		}\
	}\
}

#define GET_DLLIST(w,l) \
{\
	ListStruct *plist;\
	int num,i;\
	\
	while(l) { _free(l->data); l = dllist_remove_entry(l , l);}\
	XtVaGetValues(w , XtNlist , &plist , XtNnum_entry , &num , NULL);\
	if (num > 0)\
	{\
		for(i = 0 ; i < num ; i++)\
		{\
			l = dllist_append(l , new_string(plist[i].label));\
		}\
	}\
}

#define GET_URLLIST(w,l) \
{\
	ListStruct *plist;\
	int num,i;\
	\
	while(l) {url_info_free((url_info *)l->data) ; l = dllist_remove_entry(l , l);}\
	XtVaGetValues(w , XtNlist , &plist , XtNnum_entry , &num , NULL);\
	if (num > 0)\
	{\
		for(i = 0 ; i < num ; i++)\
		{\
			url_info *ui = plist[i].related_info;\
			if (ui) ui = url_info_duplicate(ui);\
			else ui = url_info_new(plist[i].label);\
			l = dllist_append(l , ui);\
		}\
	}\
}


#define GET_BOOL(w,b) \
	XtVaGetValues(w , XtNon , &b , NULL);

#define GET_NUM(w,v) \
	(v = NumberEntryGetValue(w))

#define GET_DOUBLE(w,v) \
	(v = FloatEntryGetValue(w))

#define GET_STR(w,s) \
	_free(s);\
	s = new_string(EntryLineGetText(w));\
	if (!(s && *s))\
	{\
		_free(s);\
	}

#define GET_S_STR(w,s) \
	s = new_string(EntryLineGetText(w));\
	if (!(s && *s))\
	{\
		_free(s);\
	}

#define GET_HTML_TAGS \
{\
	int *statpointer;\
	Widget *child;\
	Boolean pb;\
	\
	ForAllChildren(((MultiColWidget)cfg.X.html_tags) , child)\
	{\
		XtVaGetValues((Widget)*child ,\
			XtNuser_data , &statpointer ,\
			XtNon , &pb ,\
			NULL);\
		\
		if (pb)\
			*statpointer &= ~LINK_DISABLED;\
		else\
			*statpointer |= LINK_DISABLED;\
	}\
}

#define GET_COMBO_IDX(w , i) \
	i = ComboGetIndex(w);

#define GET_DATE(w , ftm) \
{\
	struct tm *ptm;\
	\
	XtVaGetValues(w , XtNtime , &ptm , NULL);\
	ftm.tm_mday = ptm->tm_mday;\
	ftm.tm_mon = ptm->tm_mon;\
	ftm.tm_year = (ptm->tm_year >= 1900) ? ptm->tm_year - 1900 : ptm->tm_year;\
}

#define GET_C_EXTRAS \
{\
	int id;\
	\
	XtVaGetValues(RadioGroupGetSelected(cfg.X.auth_sw) , XtNid , &id , NULL);\
	cfg.auth_scheme = id;\
	XtVaGetValues(RadioGroupGetSelected(cfg.X.proxy_auth_sw) , XtNid , &id , NULL);\
	cfg.proxy_auth_scheme = id;\
	XtVaGetValues(RadioGroupGetSelected(cfg.X.ftp_data_sw) , XtNid , &id , NULL);\
	cfg.ftp_activec = id;\
	if (cfg.X.ssl_version)\
	{\
		XtVaGetValues(RadioGroupGetSelected(cfg.X.ssl_version) , XtNid , &id , NULL);\
		cfg.ssl_version = id;\
	}\
}


#endif /* X_FACE */


void xset_cfg_values_lim()
{
	char pom[2048];
	struct tm *ltime;
	time_t t;
	char **pp;


	SET_HTML_TAGS;

	SET_BOOL(cfg. _IFT_ .ftp_html , cfg.ftp_html);

	SET_BOOL(cfg. _IFT_ .leaved_sw , cfg.condition.dont_leave_dir);

	SET_BOOL(cfg. _IFT_ .leaves_sw , cfg.condition.dont_leave_site);

	SET_BOOL(cfg. _IFT_ .ftpd_sw , cfg.condition.ftpdir);

	SET_BOOL(cfg. _IFT_ .cgi_sw , cfg.condition.cgi);

	SET_BOOL(cfg. _IFT_ .hosts_sw , cfg.condition.allow_site);

	SET_BOOL(cfg. _IFT_ .domain_sw , cfg.condition.allow_domain);

	SET_BOOL(cfg. _IFT_ .mime_sw , cfg.condition.allow_mime);

	SET_BOOL(cfg. _IFT_ .prefix_sw , cfg.condition.allow_prefix);

	SET_BOOL(cfg. _IFT_ .sufix_sw , cfg.condition.allow_sufix);

	SET_BOOL(cfg. _IFT_ .robots_sw , cfg.condition.allow_robots);

	SET_NUM (cfg. _IFT_ .maxlev_label , cfg.condition.max_levels);

	SET_NUM (cfg. _IFT_ .maxdoc_label , cfg.condition.max_documents);

	SET_NUM (cfg. _IFT_ .leave_level , cfg.condition.leave_level);

	SET_NUM (cfg. _IFT_ .site_level , cfg.condition.site_level);

	SET_NUM (cfg. _IFT_ .maxsize_label , cfg.condition.max_size);
	SET_NUM (cfg. _IFT_ .min_size , cfg.condition.min_size);

#define SET_PAT(w,l)\
	pom[0] = '\0';\
	for (pp = cfg.condition.pattern ; pp && *pp ; pp++)\
	{\
		if (pp != cfg.condition.pattern)\
		{\
			strcat(pom , ",");\
			strcat(pom , *pp);\
		}\
		else strcpy(pom , *pp);\
	}\
	SET_TEXT(cfg. _IFT_ .pattern_label , pom);

	SET_PAT(cfg. _IFT_ .pattern_label, cfg.condition.pattern);
	SET_PAT(cfg. _IFT_ .skip_pattern, cfg.condition.skip_pattern);
	SET_PAT(cfg. _IFT_ .url_pattern_label, cfg.condition.url_pattern);
	SET_PAT(cfg. _IFT_ .skip_url_pattern, cfg.condition.skip_url_pattern);

#ifdef HAVE_REGEX
{
	dllist *ptr;
	char pom2[PATH_MAX];

#define SET_REPAT(w,l)\
	pom[0] = '\0';\
	for (ptr = l ; ptr ; ptr = ptr->next)\
	{\
		char *p = escape_str(((re_entry *)ptr->data)->pattern, "\\\"");\
		sprintf(pom2, "\"%s\" " , p);\
		strcat(pom , pom2);\
		_free(p);\
	}\
	SET_TEXT (w , pom);\


	SET_REPAT(cfg. _IFT_ .rpattern , cfg.condition.rpattern);
	SET_REPAT(cfg. _IFT_ .skip_rpattern , cfg.condition.rskip_pattern);
	SET_REPAT(cfg. _IFT_ .url_rpattern , cfg.condition.rurl_pattern);
	SET_REPAT(cfg. _IFT_ .url_skip_rpattern , cfg.condition.rskip_url_pattern);
}
#endif


	SET_TEXT (cfg. _IFT_ .en_uexit , cfg.condition.uexit);

	SET_LIST(cfg. _IFT_ .hosts_list , cfg.condition.sites);

	SET_LIST(cfg. _IFT_ .domain_list , cfg.condition.domains);

	SET_LIST(cfg. _IFT_ .sufixlist , cfg.condition.sufix);	

	SET_LIST(cfg. _IFT_ .prefixlist , cfg.condition.dir_prefix);

	SET_LIST(cfg. _IFT_ .amimelist , cfg.condition.mime);

	SET_NUM(cfg. _IFT_ .max_time , cfg.max_time);

	SET_BOOL(cfg. _IFT_ .btime_sw , !(cfg.condition.btime == 0));	
	t = time(NULL);

	LOCK_TIME
	if (cfg.condition.btime)
		ltime = new_tm(localtime(&cfg.condition.btime));
	else
		ltime = new_tm(localtime(&t));
	UNLOCK_TIME

	ltime->tm_year += 1900;

	SET_CALENDAR(cfg. _IFT_ .btime_cal , ltime);
#ifndef _GTK_FEATURES_1_2
	SET_COMBO_IDX(cfg. _IFT_.btime_mon , ltime->tm_mon);
	SET_NUM(cfg. _IFT_ .btime_yentry , ltime->tm_year);
#endif
	SET_NUM(cfg. _IFT_ .btime_h_entry , ltime->tm_hour);
	SET_NUM(cfg. _IFT_ .btime_min_entry , ltime->tm_min);
	_free(ltime);

	SET_BOOL(cfg. _IFT_ .etime_sw , !(cfg.condition.etime == 0));	
	LOCK_TIME
	if (cfg.condition.etime)
		ltime = new_tm(localtime(&cfg.condition.etime));
	else
		ltime = new_tm(localtime(&t));
	UNLOCK_TIME

	ltime->tm_year += 1900;

	SET_CALENDAR(cfg. _IFT_ .etime_cal , ltime);
#ifndef _GTK_FEATURES_1_2
  	SET_COMBO_IDX(cfg. _IFT_ .etime_mon , ltime->tm_mon);
   	SET_NUM(cfg. _IFT_ .etime_yentry , ltime->tm_year);
#endif
	SET_NUM(cfg. _IFT_ .etime_h_entry , ltime->tm_hour);
	SET_NUM(cfg. _IFT_ .etime_min_entry , ltime->tm_min);
	_free(ltime);

	SET_TEXT (cfg. _IFT_ .subdir_label , cfg.subdir);
}


void xset_cfg_values_comm()
{
	dllist *ptr;
	char pom[PATH_MAX];

	SET_TEXT (cfg. _IFT_ .cdir_label , cfg.cache_dir);

#ifdef HAVE_DBOPEN
	SET_TEXT (cfg. _IFT_ .ns_cache_dir , cfg.ns_cache_dir);
#endif

#ifndef GTK_FACE
	SET_TEXT (cfg. _IFT_ .auth_file_label , cfg.auth_file);
#endif

	SET_TEXT (cfg. _IFT_ .en_cookie_file , cfg.cookie_file);

	SET_TEXT (cfg. _IFT_ .index_name , cfg.index_name);

	SET_TEXT (cfg. _IFT_ .store_name , cfg.store_name);

	SET_BOOL(cfg. _IFT_ .check_size , cfg.check_size);
	SET_BOOL(cfg. _IFT_ .store_index , cfg.store_index);

	SET_BOOL(cfg. _IFT_ .preserve_perm , cfg.preserve_perm);
	SET_BOOL(cfg. _IFT_ .preserve_links , cfg.preserve_links);
	SET_BOOL(cfg. _IFT_ .ftp_list , cfg.ftp_list);
	SET_BOOL(cfg. _IFT_ .use_http11 , cfg.use_http11);

	SET_BOOL(cfg. _IFT_ .sw_cookie_send , cfg.send_cookies);
	SET_BOOL(cfg. _IFT_ .sw_cookie_recv , cfg.recv_cookies);
	SET_BOOL(cfg. _IFT_ .sw_cookie_update , cfg.update_cookies);
	SET_BOOL(cfg. _IFT_ .cookie_check_domain , cfg.cookie_check_domain);

	SET_BOOL(cfg. _IFT_ .ptime , cfg.preserve_time);

	SET_BOOL(cfg. _IFT_ .oldrm_sw , cfg.remove_old);
	
	SET_BOOL(cfg. _IFT_ .cache_sw , cfg.cache);


	SET_BOOL(cfg. _IFT_ .ftp_sw , cfg.condition.ftp);


	SET_BOOL(cfg. _IFT_ .http_sw , cfg.condition.http);

#ifdef USE_SSL
	SET_BOOL(cfg. _IFT_ .https_sw , cfg.condition.https);
	SET_BOOL(cfg. _IFT_ .ftps_sw , cfg.condition.ftps);
#endif
	SET_BOOL(cfg. _IFT_ .gopher_sw , cfg.condition.gopher);

	SET_BOOL(cfg. _IFT_ .gopher_httpgw , cfg.gopher_via_http);

	SET_BOOL(cfg. _IFT_ .ftp_httpgw , cfg.ftp_via_http);

	SET_BOOL(cfg. _IFT_ .ftp_dirtyp , cfg.ftp_dirtyp);

	SET_BOOL(cfg. _IFT_ .freget_sw , cfg.freget);

	SET_BOOL(cfg. _IFT_ .noreloc_sw , cfg.rewrite_links);

	SET_BOOL(cfg. _IFT_ .url_to_local , TRUE);

	SET_BOOL(cfg. _IFT_ .all_to_local , cfg.all_to_local);

	SET_BOOL(cfg. _IFT_ .all_to_remote , cfg.all_to_remote);

	SET_BOOL(cfg. _IFT_ .sel_to_local , cfg.sel_to_local);

	SET_BOOL(cfg. _IFT_ .enable_js , cfg.enable_js);

	SET_BOOL(cfg. _IFT_ .enable_info , cfg.enable_info);

	SET_BOOL(cfg. _IFT_ .auto_referer , cfg.auto_referer);

	SET_BOOL(cfg. _IFT_ .enc_sw , cfg.use_enc);

	SET_BOOL(cfg. _IFT_ .auth_reuse_nonce , cfg.auth_reuse_nonce);
	SET_BOOL(cfg. _IFT_ .auth_reuse_proxy_nonce , cfg.auth_reuse_proxy_nonce);

	SET_BOOL(cfg. _IFT_ .send_if_range , cfg.send_if_range);

	SET_BOOL(cfg. _IFT_ .show_time , cfg.show_time);

	SET_C_EXTRAS;

#ifdef WITH_TREE
	SET_TEXT (cfg. _IFT_ .browser_label , cfg.browser);
#endif

	SET_TEXT (cfg. _IFT_ .remind_cmd , cfg.remind_cmd);

	SET_TEXT (cfg. _IFT_ .post_cmd , cfg.post_cmd);

	SET_TEXT (cfg. _IFT_ .identity , cfg.identity);

	SET_TEXT (cfg. _IFT_ .http_proxyh_label , cfg.http_proxy);

	SET_NUM (cfg. _IFT_ .http_proxyp_label , cfg.http_proxy_port);

	SET_TEXT (cfg. _IFT_ .ftp_proxyh_label , cfg.ftp_proxy);

	SET_NUM (cfg. _IFT_ .ftp_proxyp_label , cfg.ftp_proxy_port);

	SET_TEXT (cfg. _IFT_ .gopher_proxyh_label , cfg.gopher_proxy);

	SET_NUM (cfg. _IFT_ .gopher_proxyp_label , cfg.gopher_proxy_port);

#ifdef USE_SSL
	SET_TEXT (cfg. _IFT_ .ssl_proxyh_label , cfg.ssl_proxy);

	SET_NUM (cfg. _IFT_ .ssl_proxyp_label , cfg.ssl_proxy_port);

	SET_TEXT (cfg. _IFT_ .ssl_cert_file_en , cfg.ssl_cert_file);
	SET_TEXT (cfg. _IFT_ .ssl_key_file_en , cfg.ssl_key_file);
	SET_TEXT (cfg. _IFT_ .ssl_cert_passwd_en , cfg.ssl_cert_passwd);
	SET_TEXT (cfg. _IFT_ .ssl_cipher_list , cfg.ssl_cipher_list);

	SET_BOOL (cfg. _IFT_ .unique_sslid , cfg.unique_sslid);
#endif

	SET_TEXT (cfg. _IFT_ .local_ip , cfg.local_ip);

	ptr = cfg.http_headers;
	pom[0] = '\0';
	while (ptr)
	{
		httphdr *hdr = (httphdr *) ptr->data;
		char pom2[PATH_MAX];
		char *p1,*p2;

		p1 = escape_str(hdr->name , "\\\"");
		p2 = escape_str(hdr->val , "\\\"");
		sprintf(pom2 , "\"%s%s %s\" ", hdr->all ? "+" : "" , p1, p2);
		_free(p1);
		_free(p2);
		strcat(pom , pom2);
		ptr = ptr->next;
	}
	SET_TEXT (cfg. _IFT_ .http_headers, pom);

	SET_NUM (cfg. _IFT_ .en_cookie_max , cfg.cookies_max);

	SET_NUM (cfg. _IFT_ .base_level_label , cfg.base_level);

	SET_NUM (cfg. _IFT_ .timeout_label , cfg.ctimeout);

	SET_NUM (cfg. _IFT_ .retry_label , cfg.nretry);

	SET_NUM (cfg. _IFT_ .redir_label , cfg.nredir);

	SET_NUM (cfg. _IFT_ .reget_label , cfg.nreget);

	SET_NUM (cfg. _IFT_ .sleep_label , cfg.sleep);

	SET_NUM (cfg. _IFT_ .xloglen_label , cfg.xlogsize);

	SET_NUM (cfg. _IFT_ .bufsize , cfg.bufsize);

#ifdef HAVE_FSTATFS
	SET_NUM (cfg. _IFT_ .fs_quota , cfg.fs_quota);
#endif
	SET_NUM (cfg. _IFT_ .file_quota , cfg.file_quota);

	SET_NUM (cfg. _IFT_ .trans_quota , cfg.trans_quota);
	
	SET_DOUBLE(cfg. _IFT_ .maxrate , cfg.maxrate);

	SET_DOUBLE(cfg. _IFT_ .minrate , cfg.minrate);

	SET_BOOL (cfg. _IFT_ .gen_logname , cfg.gen_logname);

	SET_TEXT (cfg. _IFT_ .log_label , cfg.logfile);

	SET_TEXT (cfg. _IFT_ .slog_label , cfg.short_logfile);

	SET_TEXT (cfg. _IFT_ .auth_label , cfg.name_auth);

	SET_TEXT (cfg. _IFT_ .pass_label , cfg.passwd_auth);

	SET_TEXT (cfg. _IFT_ .proxy_auth_label , cfg.http_proxy_user);

	SET_TEXT (cfg. _IFT_ .proxy_pass_label , cfg.http_proxy_pass);

	SET_BOOL (cfg. _IFT_ .send_from , cfg.send_from);
	SET_TEXT (cfg. _IFT_ .from_label , cfg.from);

	SET_NUM (cfg. _IFT_ .rollback_label , cfg.rollback);

	SET_NUM (cfg. _IFT_ .ddays_label , cfg.ddays);

	SET_NUM (cfg. _IFT_ .hash_size , cfg.hash_size);

	SET_LIST(cfg. _IFT_ .langlist , cfg.accept_lang);

	SET_LIST(cfg. _IFT_ .charset_list , cfg.accept_chars);

	SET_LIST(cfg. _IFT_ .cookie_domain_list , cfg.cookies_disabled_domains);

	SET_TEXT(cfg. _IFT_ .tr_del_chr , cfg.tr_del_chr);
	SET_TEXT(cfg. _IFT_ .tr_str_s1 , cfg.tr_str_s1);
	SET_TEXT(cfg. _IFT_ .tr_str_s2 , cfg.tr_str_s2);
	SET_TEXT(cfg. _IFT_ .tr_chr_s1 , cfg.tr_chr_s1);
	SET_TEXT(cfg. _IFT_ .tr_chr_s2 , cfg.tr_chr_s2);

	SET_COMBO_IDX(cfg. _IFT_ .scheduling_strategie , cfg.scheduling_strategie);

#ifdef HAVE_REGEX
	SET_BOOL(cfg. _IFT_ .remove_adv , cfg.remove_adv);
{
	dllist *ptr2 = cfg.advert_res;
	ptr = NULL;

	while(ptr2)
	{
		ptr = dllist_append(ptr , ((re_entry *)ptr2->data)->pattern);
		ptr2 = ptr2->next;
	}

	SET_DLLIST(cfg. _IFT_ .advert_res , ptr);

	while(ptr) ptr = dllist_remove_entry(ptr, ptr);
}
#endif

#ifdef GTK_FACE
{
	char *ld[3];

	ptr = cfg.lfnames;

	gtk_clist_freeze(GTK_CLIST(cfg.gtk.rules_list));

	gtk_clist_clear(GTK_CLIST(cfg.gtk.rules_list));

	while(ptr)
	{
		lfname *lf = ptr->data;

		ld[0] = (lf->type == LFNAME_FNMATCH) ? "F" : "R";
		ld[1] = lf->matchstr;
		ld[2] = lf->transstr;

		gtk_clist_append(GTK_CLIST(cfg.gtk.rules_list) , ld);
		ptr = ptr->next;
	}

	gtk_clist_thaw(GTK_CLIST(cfg.gtk.rules_list));
}
#endif
	SET_URLLIST(cfg. _IFT_ .url_list , cfg.request);
}

#ifdef HAVE_REGEX
static dllist *make_re_list(str)
char *str;
{
	dllist *retv = NULL;
	char *p;
	bool err = FALSE;

	for(p = get_1qstr(str); p ; p = get_1qstr(NULL))
	{
		re_entry *ree;

		ree = re_make(p);

		if (!ree)
		{
			err = TRUE;
			break;
		}
		else
		{
			retv = dllist_append(retv , ree);
		}
	}

	if (err)
	{
		while(retv)
		{
			re_free((re_entry *)retv->data);
			retv = dllist_remove_entry(retv , retv);
		}
	}

	return retv;
}
#endif

int xget_cfg_values_lim()
{
	struct tm ftm;
	char *p = NULL;
	int i;
	bool b;
	struct stat estat;

	GET_HTML_TAGS;

	GET_STR (cfg. _IFT_ .subdir_label , p);
	if (p && !((stat(p , &estat) >= 0) && S_ISDIR(estat.st_mode)))
	{
		_free(p);
		xprintf(0 , gettext("Bad parameter - Working subdirectory"));
		return -1;
	}
	else
	{
		_free(cfg.subdir);
		if (p) cfg.subdir = get_abs_file_path_oss(p);
		_free(p);
	}

	GET_BOOL(cfg. _IFT_ .ftp_html , cfg.ftp_html);

	GET_BOOL(cfg. _IFT_ .leaves_sw , cfg.condition.dont_leave_site);

	GET_BOOL(cfg. _IFT_ .leaved_sw , cfg.condition.dont_leave_dir);

	GET_BOOL(cfg. _IFT_ .cgi_sw , cfg.condition.cgi);

	GET_BOOL(cfg. _IFT_ .ftpd_sw , cfg.condition.ftpdir);

	GET_BOOL(cfg. _IFT_ .hosts_sw , cfg.condition.allow_site);

	GET_BOOL(cfg. _IFT_ .domain_sw , cfg.condition.allow_domain);

	GET_BOOL(cfg. _IFT_ .mime_sw , cfg.condition.allow_mime);

	GET_BOOL(cfg. _IFT_ .prefix_sw , cfg.condition.allow_prefix);

	GET_BOOL(cfg. _IFT_ .sufix_sw , cfg.condition.allow_sufix);

	GET_BOOL(cfg. _IFT_ .robots_sw , cfg.condition.allow_robots);

#define GET_PAT(w,l)\
        p = NULL;\
        GET_STR(w , p);\
        for(i = 0; l && l[i] ; i++)\
                _free(l[i]);\
        _free(l);\
        l = make_list(p , ",");\
	_free(p);\

	GET_PAT(cfg. _IFT_ .pattern_label , cfg.condition.pattern);
	GET_PAT(cfg. _IFT_ .skip_pattern , cfg.condition.skip_pattern);
	GET_PAT(cfg. _IFT_ .url_pattern_label , cfg.condition.url_pattern);
	GET_PAT(cfg. _IFT_ .skip_url_pattern , cfg.condition.skip_url_pattern);

#ifdef HAVE_REGEX
#define GET_REPAT(w,l)\
{\
	dllist *ptr;\
        p = NULL;\
        GET_STR(w , p);\
	ptr = NULL;\
	if (p && *p)\
	{\
		if (*p == '\"')\
		{\
			ptr = make_re_list(p);\
			if (!ptr)\
			{\
				_free(p);\
				return -1;\
			}\
		}\
		else\
		{\
			re_entry *ree = re_make(p);\
			if (ree)\
			{\
				ptr = dllist_append(ptr , ree);\
			}\
			else\
			{\
				_free(p);\
				return -1;\
			}\
		}\
	}\
	while(l)\
	{\
		re_free((re_entry *)l->data);\
		l = dllist_remove_entry(l, l);\
	}\
        l = ptr;\
	_free(p);\
}


	GET_REPAT(cfg. _IFT_ .rpattern , cfg.condition.rpattern);
	GET_REPAT(cfg. _IFT_ .skip_rpattern , cfg.condition.rskip_pattern);
	GET_REPAT(cfg. _IFT_ .url_rpattern , cfg.condition.rurl_pattern);
	GET_REPAT(cfg. _IFT_ .url_skip_rpattern , cfg.condition.rskip_url_pattern);
	GET_REPAT(cfg. _IFT_ .aip , cfg.condition.aip);
	GET_REPAT(cfg. _IFT_ .skipip , cfg.condition.skipip);

#endif

        GET_STR(cfg. _IFT_ .en_uexit , cfg.condition.uexit);

	GET_LIST(cfg. _IFT_ .hosts_list , cfg.condition.sites);

	GET_LIST(cfg. _IFT_ .amimelist , cfg.condition.mime);

	GET_LIST(cfg. _IFT_ .domain_list , cfg.condition.domains);

	GET_NUM(cfg. _IFT_ .maxlev_label , cfg.condition.max_levels);

	GET_NUM(cfg. _IFT_ .leave_level , cfg.condition.leave_level);

	GET_NUM(cfg. _IFT_ .site_level , cfg.condition.site_level);

	GET_NUM(cfg. _IFT_ .maxdoc_label , cfg.condition.max_documents);

	GET_NUM(cfg. _IFT_ .maxsize_label , cfg.condition.max_size);
	GET_NUM(cfg. _IFT_ .min_size , cfg.condition.min_size);

	GET_LIST(cfg. _IFT_ .sufixlist , cfg.condition.sufix);	

	GET_LIST(cfg. _IFT_ .prefixlist , cfg.condition.dir_prefix);

	GET_NUM(cfg. _IFT_ .max_time , cfg.max_time);

	GET_BOOL(cfg. _IFT_ .btime_sw , b);
	if (b)
	{
		GET_DATE(cfg. _IFT_ .btime_cal  , ftm);
		ftm.tm_sec = 0;
		ftm.tm_isdst = -1;
		GET_NUM(cfg. _IFT_ .btime_h_entry , ftm.tm_hour);
		GET_NUM(cfg. _IFT_ .btime_min_entry , ftm.tm_min);
		cfg.condition.btime = mktime(&ftm);
	}
	
	else cfg.condition.btime = (time_t)0;

	GET_BOOL(cfg. _IFT_ .etime_sw , b);
	if (b)
	{
		GET_DATE(cfg. _IFT_ .etime_cal  , ftm);
		ftm.tm_sec = 0;
		ftm.tm_isdst = -1;
		GET_NUM(cfg. _IFT_ .etime_h_entry , ftm.tm_hour);
		GET_NUM(cfg. _IFT_ .etime_min_entry , ftm.tm_min);
		cfg.condition.etime = mktime(&ftm);
	}
	else cfg.condition.etime = (time_t)0;

	return 0;
}

int xget_cfg_values_comm()
{
	char *p = NULL;
	struct stat estat;
	dllist *ptr;

	GET_STR(cfg. _IFT_ .cdir_label , p);
	if (p && !((stat(p , &estat) >= 0) && S_ISDIR(estat.st_mode)))
	{
		xprintf(0 , gettext("Bad parameter - Cache directory"));
		return -1;
	}
	else
	{
		_free(cfg.cache_dir);
		if (p) cfg.cache_dir = get_abs_file_path_oss(p);
		_free(p);
	}

#ifdef HAVE_DBOPEN
	GET_STR (cfg. _IFT_ .ns_cache_dir , cfg.ns_cache_dir);
	ns_cache_open_db(cfg.ns_cache_dir);
#endif

#ifndef GTK_FACE
	p = cfg.auth_file;
	GET_S_STR(cfg. _IFT_ .auth_file_label , cfg.auth_file);
	if (!((cfg.auth_file && p && !strcmp(p , cfg.auth_file)) || !cfg.auth_file))
		authinfo_load(cfg.auth_file);
	_free(p);
#endif

	p = cfg.cookie_file;
	GET_S_STR (cfg. _IFT_ .en_cookie_file , cfg.cookie_file);
	if (!((cfg.cookie_file && p && !strcmp(p , cfg.cookie_file)) || !cfg.cookie_file))
	{
		cookie_read_ns(cfg.cookie_file);
	}
	_free(p);

	GET_BOOL(cfg. _IFT_ .check_size , cfg.check_size);
	GET_BOOL(cfg. _IFT_ .store_index , cfg.store_index);

	GET_BOOL(cfg. _IFT_ .preserve_perm , cfg.preserve_perm);
	GET_BOOL(cfg. _IFT_ .preserve_links , cfg.preserve_links);
	GET_BOOL(cfg. _IFT_ .ftp_list , cfg.ftp_list);
	GET_BOOL(cfg. _IFT_ .use_http11 , cfg.use_http11);

	GET_STR (cfg. _IFT_ .index_name , cfg.index_name);
	GET_STR (cfg. _IFT_ .store_name , cfg.store_name);

	GET_BOOL(cfg. _IFT_ .sw_cookie_send , cfg.send_cookies);
	GET_BOOL(cfg. _IFT_ .sw_cookie_recv , cfg.recv_cookies);
	GET_BOOL(cfg. _IFT_ .sw_cookie_update , cfg.update_cookies);
	GET_BOOL(cfg. _IFT_ .cookie_check_domain , cfg.cookie_check_domain);

	GET_BOOL(cfg. _IFT_ .ptime , cfg.preserve_time);

	GET_BOOL(cfg. _IFT_ .cache_sw , cfg.cache);

	GET_BOOL(cfg. _IFT_ .oldrm_sw , cfg.remove_old);

	GET_BOOL(cfg. _IFT_ .ftp_sw , cfg.condition.ftp);


	GET_BOOL(cfg. _IFT_ .http_sw , cfg.condition.http);

#ifdef USE_SSL
	GET_BOOL(cfg. _IFT_ .https_sw , cfg.condition.https);
	GET_BOOL(cfg. _IFT_ .ftps_sw , cfg.condition.ftps);
#endif
	GET_BOOL(cfg. _IFT_ .gopher_sw , cfg.condition.gopher);

	GET_BOOL(cfg. _IFT_ .gopher_httpgw , cfg.gopher_via_http);

	GET_BOOL(cfg. _IFT_ .ftp_httpgw , cfg.ftp_via_http);

	GET_BOOL(cfg. _IFT_ .ftp_dirtyp , cfg.ftp_dirtyp);

	GET_BOOL(cfg. _IFT_ .freget_sw , cfg.freget);

	GET_BOOL(cfg. _IFT_ .noreloc_sw , cfg.rewrite_links);

	GET_BOOL(cfg. _IFT_ .all_to_local , cfg.all_to_local);

	GET_BOOL(cfg. _IFT_ .all_to_remote , cfg.all_to_remote);

	GET_BOOL(cfg. _IFT_ .sel_to_local , cfg.sel_to_local);

	GET_BOOL(cfg. _IFT_ .enable_js , cfg.enable_js);

	GET_BOOL(cfg. _IFT_ .auto_referer , cfg.auto_referer);

	GET_BOOL(cfg. _IFT_ .enable_info , cfg.enable_info);

	GET_BOOL(cfg. _IFT_ .enc_sw , cfg.use_enc);

	GET_BOOL(cfg. _IFT_ .auth_reuse_nonce , cfg.auth_reuse_nonce);
	GET_BOOL(cfg. _IFT_ .auth_reuse_proxy_nonce , cfg.auth_reuse_proxy_nonce);

	GET_BOOL(cfg. _IFT_ .send_if_range , cfg.send_if_range);

	GET_BOOL(cfg. _IFT_ .show_time , cfg.show_time);

	GET_C_EXTRAS;

#ifdef WITH_TREE
	GET_STR(cfg. _IFT_ .browser_label , cfg.browser);
#endif

	GET_STR(cfg. _IFT_ .remind_cmd , cfg.remind_cmd);

	GET_STR(cfg. _IFT_ .post_cmd , cfg.post_cmd);

	GET_STR(cfg. _IFT_ .identity , cfg.identity);

	GET_STR(cfg. _IFT_ .http_proxyh_label , cfg.http_proxy);

	GET_NUM(cfg. _IFT_ .http_proxyp_label , cfg.http_proxy_port);

	GET_STR(cfg. _IFT_ .ftp_proxyh_label , cfg.ftp_proxy);

	GET_NUM(cfg. _IFT_ .ftp_proxyp_label , cfg.ftp_proxy_port);

	GET_STR(cfg. _IFT_ .gopher_proxyh_label , cfg.gopher_proxy);

	GET_NUM(cfg. _IFT_ .gopher_proxyp_label , cfg.gopher_proxy_port);

#ifdef USE_SSL
	GET_STR(cfg. _IFT_ .ssl_proxyh_label , cfg.ssl_proxy);

	GET_NUM(cfg. _IFT_ .ssl_proxyp_label , cfg.ssl_proxy_port);

	GET_STR (cfg. _IFT_ .ssl_cert_file_en , cfg.ssl_cert_file);
	GET_STR (cfg. _IFT_ .ssl_key_file_en , cfg.ssl_key_file);
	GET_STR (cfg. _IFT_ .ssl_cert_passwd_en , cfg.ssl_cert_passwd);
	GET_STR (cfg. _IFT_ .ssl_cipher_list , cfg.ssl_cipher_list);

	GET_BOOL (cfg. _IFT_ .unique_sslid , cfg.unique_sslid);
#endif

	GET_STR (cfg. _IFT_ .local_ip , cfg.local_ip);
        cfg.local_ip_addr.s_addr = INADDR_ANY;
        if (cfg.local_ip)
        {
                if (net_host_to_in_addr(cfg.local_ip , &cfg.local_ip_addr))
                {
                        xperror(cfg.local_ip);
                }
        }

	GET_STR (cfg. _IFT_ .http_headers , p);
	while (cfg.http_headers)
	{
		httphdr_free((httphdr *)cfg.http_headers->data);
		cfg.http_headers = dllist_remove_entry(cfg.http_headers,cfg.http_headers);
	}
	if (p && *p)
	{
		while ((p = get_1qstr(p)))
		{
			httphdr *hdr = httphdr_parse(p);
			if (hdr)
				cfg.http_headers = dllist_append(cfg.http_headers, hdr);
			else
				xprintf(0 , "Bad HTTP headers entry - %s\n" , p);
			p = NULL;
		}
	}

	GET_NUM(cfg. _IFT_ .en_cookie_max , cfg.cookies_max);

	GET_NUM(cfg. _IFT_ .base_level_label , cfg.base_level);

	GET_NUM(cfg. _IFT_ .timeout_label , cfg.ctimeout);

	GET_NUM(cfg. _IFT_ .retry_label , cfg.nretry);

	GET_NUM(cfg. _IFT_ .redir_label , cfg.nredir);

	GET_NUM(cfg. _IFT_ .reget_label , cfg.nreget);

	GET_NUM(cfg. _IFT_ .sleep_label , cfg.sleep);

	GET_NUM(cfg. _IFT_ .xloglen_label , cfg.xlogsize);

	GET_NUM (cfg. _IFT_ .bufsize , cfg.bufsize);

#ifdef HAVE_FSTATFS
	GET_NUM (cfg. _IFT_ .fs_quota , cfg.fs_quota);
#endif

	GET_NUM (cfg. _IFT_ .file_quota , cfg.file_quota);

	GET_NUM (cfg. _IFT_ .trans_quota , cfg.trans_quota);
	
	GET_DOUBLE(cfg. _IFT_ .maxrate , cfg.maxrate);

	GET_DOUBLE(cfg. _IFT_ .minrate , cfg.minrate);

	GET_STR(cfg. _IFT_ .slog_label , cfg.short_logfile);

	GET_BOOL (cfg. _IFT_ .gen_logname , cfg.gen_logname);

	GET_STR(cfg. _IFT_ .log_label , cfg.logfile);
	log_start(cfg.logfile);

	GET_STR(cfg. _IFT_ .auth_label , cfg.name_auth);

	GET_STR(cfg. _IFT_ .pass_label , cfg.passwd_auth);

	GET_STR(cfg. _IFT_ .proxy_auth_label , cfg.http_proxy_user);

	GET_STR(cfg. _IFT_ .proxy_pass_label , cfg.http_proxy_pass);	

	GET_BOOL(cfg. _IFT_ .send_from , cfg.send_from);

	GET_STR(cfg. _IFT_ .from_label , cfg.from);

	GET_NUM(cfg. _IFT_ .rollback_label , cfg.rollback);

	GET_NUM(cfg. _IFT_ .ddays_label , cfg.ddays);

	GET_NUM(cfg. _IFT_ .hash_size , cfg.hash_size);
	if (!cfg.hash_size) cfg.hash_size = 0;
	dlhash_resize(cfg.url_hash_tbl, cfg.hash_size);
	dlhash_resize(cfg.fn_hash_tbl, cfg.hash_size);

	GET_LIST(cfg. _IFT_ .langlist , cfg.accept_lang);

	GET_LIST(cfg. _IFT_ .cookie_domain_list , cfg.cookies_disabled_domains);

	GET_STR(cfg. _IFT_ .tr_del_chr , cfg.tr_del_chr);
	GET_STR(cfg. _IFT_ .tr_str_s1 , cfg.tr_str_s1);
	GET_STR(cfg. _IFT_ .tr_str_s2 , cfg.tr_str_s2);
	GET_STR(cfg. _IFT_ .tr_chr_s1 , cfg.tr_chr_s1);
	GET_STR(cfg. _IFT_ .tr_chr_s2 , cfg.tr_chr_s2);

	GET_COMBO_IDX(cfg. _IFT_ .scheduling_strategie , cfg.scheduling_strategie);

#ifdef HAVE_REGEX
	GET_BOOL(cfg. _IFT_ .remove_adv , cfg.remove_adv);

	ptr = cfg.advert_res;

	while(ptr)
	{
		re_free((re_entry *)ptr->data);
		ptr = dllist_remove_entry(ptr, ptr);
	}

	cfg.advert_res = NULL;

	GET_DLLIST(cfg. _IFT_ .advert_res , ptr);

	while(ptr)
	{
		re_entry *ree;

		ree = re_make((char *)ptr->data);
		if (ree)
			cfg.advert_res = dllist_append(cfg.advert_res , ree);
		_free(ptr->data);
		ptr = dllist_remove_entry(ptr , ptr);
	}
#endif


#ifdef GTK_FACE
{
	int i;

	while(cfg.lfnames)
	{
		lfname_free((lfname *)cfg.lfnames->data);
		cfg.lfnames = dllist_remove_entry(cfg.lfnames , cfg.lfnames);
	}

	for (i = 0 ; i < GTK_CLIST(cfg.gtk.rules_list)->rows ; i++)
	{
		lfname *lfn;
		lfname_type tp;
		char *ld[3];

		gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , i , 0 , &ld[0]);
		gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , i , 1 , &ld[1]);
		gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , i , 2 , &ld[2]);
#ifdef HAVE_REGEX
		tp = (*ld[0] == 'F') ? LFNAME_FNMATCH : LFNAME_REGEX;
#else
		tp = LFNAME_FNMATCH;
#endif
		if ((lfn = lfname_new(tp , ld[1] , ld[2])))
			cfg.lfnames = dllist_append(cfg.lfnames , lfn);
		else
			return -1;
	}
}

#endif

	GET_URLLIST(cfg. _IFT_ .url_list , cfg.request);

	return 0;
}

#endif /* I_FACE */

