/*
** Copyright 1998 - 1999 Double Precision, Inc.
** See COPYING for distribution information.
*/

#include	"courier.h"
#include	"libexecdir.h"
#include	"rw.h"
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<dlfcn.h>

/*
	This module is compiled when transport modules are compiled as
	shared libraries.

	This version of rw_init() reads the modules.ctl file, and attempts
	to load each shared library, and install it via rw_install.
*/

static const char ctl[]=MODULEDIR "/modules.ctl";

int rw_init(const char *loadname)
{
FILE	*f;
char	*ctlname;
char	buf[BUFSIZ];
int	c;
char	*name, *library;
struct rw_list *(*install)(const struct rw_install_info *);
const char *(*init)();
int	err=0;

	if (rw_init_verbose_flag)
	{
		clog_msg_start_info();
		clog_msg_str("Loading SHARED transport module libraries.");
		clog_msg_send();
	}
	if (rw_install_start())	return (-1);
	ctlname=(char *)courier_malloc(
		strlen(courierdir())+sizeof(ctl));

	if ((f=fopen(
			strcat(strcpy(ctlname, courierdir()), ctl),
			"r")) == NULL)
	{
		clog_msg_start_err();
		clog_msg_str("Can't open ");
		clog_msg_str(ctlname ? ctlname:"modules.ctl");
		clog_msg_send();
		free(ctlname);
		return (-1);
	}
	free(ctlname);

	while (fgets(buf, sizeof(buf), f))
	{
	void	*dllib;

		if (strchr(buf, '\n') == 0)
			while ((c=getc(f)) >= 0 && c != '\n')
				;
		(void)strtok(buf, " \t\r\n");	/* PRIORITY */
		name=strtok(NULL, " \t\r\n");
		library=strtok(NULL, " \t\r\n");
		if (!name || !library)	continue;
		if (loadname && strcmp(name, loadname))	continue;

		if (rw_init_verbose_flag)
		{
			clog_msg_start_info();
			clog_msg_str("Opening ");
			clog_msg_str(name);
			clog_msg_str("/");
			clog_msg_str(library);
			clog_msg_send();
		}
		ctlname=(char *)courier_malloc(strlen(name)+
					strlen(library)+
					sizeof(MODULEDIR)+3);
		strcat(strcat(strcat(strcpy(ctlname, MODULEDIR "/" ),
				name),
				"/"),
				library);
		dllib=dlopen(ctlname, RTLD_NOW);
		free(ctlname);
		if (!dllib)
		{
			clog_msg_start_err();
			clog_msg_str("Can't load library - ");
			clog_msg_str(dlerror());
			clog_msg_send();
			err=1;
			continue;
		}

		ctlname=(char *)courier_malloc(strlen(name)+20);

		/*
		** In shared library foo, find the functions
		** foo_rw_install and foo_rw_init.
		*/

		if ( (install=(struct rw_list *(*)(
					const struct rw_install_info *))
			dlsym(dllib,
				strcat(strcpy(ctlname, name), "_rw_install")))
				== NULL ||
			(init=(const char *(*)())dlsym(dllib,
				strcat(strcpy(ctlname, name), "_rw_init")))
				== NULL)
		{
			clog_msg_start_err();
			clog_msg_str("Unable to resolve ");
			clog_msg_str(ctlname);
			clog_msg_str(" - ");
			clog_msg_str(dlerror());
			clog_msg_send();
			free(ctlname);
			err=1;
			continue;
		}
		free(ctlname);

		if (rw_install(name, install, init))
			err=1;
	}
	if (err || rw_install_init())
	{
		clog_msg_start_err();
		clog_msg_str("Transport module installation has FAILED.");
		clog_msg_send();
		return (-1);
	}
	fclose(f);
	return (0);
}
