/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DbMetaData.h
 *   description goes here
 *
 * $Id: DbMetaData.h,v 1.5 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@ddts.org>
 *                and Remi Lefebvre <remi@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DBMETADATA_H
#define DBMETADATA_H

#include <vector>
#include <map>
#include <string>

class DbMetaData
{
 public:
    typedef enum enumDataType
        {
            UNDEFINED = 0,
            STRING,
            INT,
            FLOAT,
            BOOL,
            DATE,
            TIME
        } eDataType;

    DbMetaData();
    ~DbMetaData();
    
    int findColumnID(const char *name);
    const char *getColumnName(unsigned int colNo);
    eDataType getColumnType(unsigned int colNo);
    int getColumnSize(unsigned int colNo);

 protected:
    class ColumnPosition
        {
        public:
            ColumnPosition();
            ColumnPosition(int pos);

            int pos;
        };
    
    class ColumnMetaData
        {
        public:
            ColumnMetaData();
            ColumnMetaData(const string &name, int size,
                           DbMetaData::eDataType dataType);
            ColumnMetaData(const ColumnMetaData &columnMetaData);
            ~ColumnMetaData();
      
            string name;
            int size;
            eDataType dataType;        
        };

    vector<ColumnMetaData> metaDataVector;
    map<string, ColumnPosition> columnNameToPosition;
};

#endif // DBMETADATA_H
