/********************************************************************************
 *   Jabberoo/Judo -- C++ Jabber Library                                        *
 *                                                                              * 
 *   Copyright (C) 1999-2000 Dave Smith (dave@jabber.org)                       *
 *                                                                              *
 *   This library is free software; you can redistribute it and/or              *
 *   modify it under the terms of the GNU Lesser General Public                 *
 *   License as published by the Free Software Foundation; either               *
 *   version 2.1 of the License, or (at your option) any later version.         *
 *                                                                              *
 *   This library is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
 *   Lesser General Public License for more details.                            *
 *                                                                              *
 *   You should have received a copy of the GNU Lesser General Public           *
 *   License along with this library; if not, write to the Free Software        *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 ********************************************************************************
 */

#include "judo.hh"

void judo::unescape(const char* src, unsigned int srcLen, string& dest, bool append)
{
     unsigned int i, j;
     // Setup string size
     if (append)
     {
	  j = dest.length();
	  dest.resize(dest.length() + srcLen);
     }
     else
     {
	  j = 0;
	  dest.resize(srcLen);
     }
     // Walk the input text, unescaping as we go..
     for (i = 0; i < srcLen; i++)
     {
	  if (strncmp(&src[i],"&amp;",5)==0)
	  {
	       dest[j] = '&';
	       i += 4;
	  } else if (strncmp(&src[i],"&quot;",6)==0) {
	       dest[j] = '\"';
	       i += 5;
	  } else if (strncmp(&src[i],"&apos;",6)==0) {
	       dest[j] = '\'';
	       i += 5;
	  } else if (strncmp(&src[i],"&lt;",4)==0) {
	       dest[j] = '<';
	       i += 3;
	  } else if (strncmp(&src[i],"&gt;",4)==0) {
	       dest[j] = '>';
	       i += 3;
	  } else {
	       dest[j] = src[i];
	  }
	  j++;
     }
     // Cleanup
     dest.resize(strlen(dest.c_str()));
}

string judo::escape(const string& src)
{
        int i,j,oldlen,newlen;

	if (src.empty())
	     return string(src);

        oldlen = newlen = src.length();
        for(i = 0; i < oldlen; i++)
        {
                switch(src[i])
                {
		case '<':
		case '>':
		     newlen+=4; break;
		case '&' : 
		     newlen+=5; break;
		case '\'': 
		case '\"': 
		     newlen+=6; break;
                }
        }

        if(oldlen == newlen) 
	     return string(src);

	string result;
	result.reserve(newlen);

        for(i = j = 0; i < oldlen; i++)
        {
                switch(src[i])
                {
		case '&':
		     result += "&amp;"; break;
		case '\'':
		     result += "&apos;"; break;
		case '\"':
		     result += "&quot;"; break;
		case '<':
		     result += "&lt;"; break;
		case '>':
		     result += "&gt;"; break;
		default:
		     result += src[i];
                }
        }
	return result;
}
