#include "image.h"
#ifndef __gifh__
  #include "gif.h"
#endif
#ifndef __jpegh__
  #include "jpeg.h"
#endif
#ifndef __pngh__
  #include "png.h"
#endif

#define IMAGE_TYPE_UNKNOWN              (0)
#define IMAGE_TYPE_GIF                  (1)
#define IMAGE_TYPE_JFIF                 (2)
#define IMAGE_TYPE_PNG                  (3)

bool OpenImage(const char *filename, IMAGEFILE *imageFile){
  if(filename == NULL) return false;
  if(imageFile == NULL) return false;
  if((imageFile->file = fopen(filename, "rb")) == NULL) return false;
  imageFile->name=filename;
  imageFile->imageType = IMAGE_TYPE_UNKNOWN;
  if(IsGIF(imageFile->file)){
    imageFile->imageType = IMAGE_TYPE_GIF;
    return true;
  }
  if(IsJPEG(imageFile->file)){
    imageFile->imageType = IMAGE_TYPE_JFIF;
    return true;
  }
  if(IsPNG(imageFile->file)){
    imageFile->imageType = IMAGE_TYPE_PNG;
    return true;
  }
  return true;
}   

void CloseImage(IMAGEFILE *imageFile){
  if(imageFile == NULL) return;
  if(imageFile->name.empty()) return;
  if(imageFile->file == NULL) return;
  fclose(imageFile->file);
  imageFile->name = "";
  imageFile->file = NULL;
}

bool GetImageDimensions(IMAGEFILE *imageFile, int& width, int& height){
  if(imageFile == NULL) return false;
  if(imageFile->imageType == IMAGE_TYPE_GIF){
    return GIFSize(imageFile->file, height, width);
  }else if(imageFile->imageType == IMAGE_TYPE_JFIF){
    return JPEGSize(imageFile->file, height, width);
  }else if(imageFile->imageType == IMAGE_TYPE_PNG){
    return PNGSize(imageFile->file, height, width);
  }
  return false;
}
