// Copyright (c) 2000 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "collections.h"

#include <qnamespace.h>
#include <qfile.h>
#include <qstringlist.h>


Collections::Collections(const QString &filename, QObject *parent)
    : QObject(parent)
{
    QFile file(filename);
    if (file.open(IO_ReadOnly)) {
	if (document.setContent(&file) &&
	    document.firstChild().toElement().tagName() == "collections")
	    collStart = document.firstChild().toElement().firstChild().toElement();
	else
	    qDebug("MQ3d: error loading collection");

	file.close();
    }
}


Collections::~Collections()
{

}


QString Collections::fileName(const QString &pathstring)
{
    if (pathstring[0] != '/' || pathstring.right(1) == "/")
	return QString::null;

    QStringList path = QStringList::split('/', pathstring);
    if (path.isEmpty() || path.count() < 2)
	return QString::null;

    QDomElement e = collStart;

    // get the collection
    bool found = FALSE;
    while (! found && ! e.isNull()) {
	if (e.tagName() == "collection") {
	    QDomElement n = e.firstChild().toElement();

	    while (! n.isNull()) {
		if (n.tagName() == "name" &&
		    n.firstChild().toText().data() == path[0]) {
		    found = TRUE;
		    break;
		}

		n = n.nextSibling().toElement();
	    }
	}

	if (! found)
	    e = e.nextSibling().toElement();
    }

    if (e.isNull())
	return QString::null;

    // look in the path
    uint curr = 1;
    bool skip;
    found = FALSE;
    e = e.firstChild().toElement();
    while (! found && ! e.isNull()) {
	skip = FALSE;
	if (curr == path.count() - 1) {
	    // looking for file
	    if (e.tagName() == "file") {
		QString fpath;
		QDomElement f = e.firstChild().toElement();

		while (! f.isNull()) {
		    if (f.tagName() == "name" &&
			f.firstChild().toText().data() == path[curr])
			found = TRUE;
		    else if (f.tagName() == "path")
			fpath = f.firstChild().toText().data();

		    f = f.nextSibling().toElement();
		}

		if (found)
		    return fpath;
	    }
	} else {
	    // looking for dir
	    if (e.tagName() == "dir") {
		QDomElement d = e.firstChild().toElement();

		while (! d.isNull()) {
		    if (d.tagName() == "name" &&
			d.firstChild().toText().data() == path[curr]) {
			curr++;
			e = e.firstChild().toElement();
			skip = TRUE;
			break;
		    }

		    d = d.nextSibling().toElement();
		}
	    }
	}

	if (! skip)
	    e = e.nextSibling().toElement();
    }

    return QString::null;
}
