// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef COLLECTION_H
#define COLLECTION_H

#include <qlistview.h>
#include <qvaluelist.h>
#include <qvaluestack.h>

#include "song.h"

class CollectionView;
class Organizer;


class Collection : public QListViewItem
{
public:
    class SongState {
    public:
	SongState(Song *song)
	    : signature(song->signature()), priority(song->priority()), on(song->isOn())
	{
	}
	SongState(Song::Signature s, int p, bool o)
	    : signature(s), priority(p), on(o)
	{
	}

	Song::Signature signature;
	int priority;
	bool on;
    };

    Collection(CollectionView *, const QString &);
    ~Collection();

    void paintCell(QPainter *, const QColorGroup &, int, int, int);

    QString name() { return text(0); }
    void setName(const QString &s) { setText(0, s); }

    Song *next();
    Song *previous();

    void add(Song *, int);
    void remove(Song *);
    SongState *match(Song *);

    void setCurrent(bool);
    void setCurrentSong(Song *, bool = true);

    void dataDescription(QDataStream &stream) const;

    static int RTTI;
    int rtti() const;

    bool current, loading;
    QValueList<SongState *> songlist;
    QValueList<Song *> randomlist;
    QValueStack<Song*> history;
    Song *currentSong;
};

#endif // COLLECTION_H
