/***************************************************************************
                          KARTEI_DEBITOR.CPP  -  description
                             -------------------                                         
    begin                : 03.03.2000
    version              : $Id: kartei_debitor.cpp,v 1.18 2001/03/26 06:45:17 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "kartei_debitor.h"
#include "qdbtableviewsum.h"
#include "calc.h"

Kartei_Debitor::Kartei_Debitor(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr )
	: QWidget( parent, name )
{
	partner = 0;

	if (sql_ptr->conn != 0) {
		QBoxLayout *topLayout = new QVBoxLayout( this );

		dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
			"select "
			"nummer,kurzname,briefanrede,name,name_2,adresse,adresse_2,postfach"
			",ort,plz,plz_postfach,telefon,fax,homepage"
			",bankverbindung,bankleitzahl,konto_nr,verkaeufercode,zahlungsbed_code"
			",kreditlimit,mwst_pflichtig,buchungsgruppe,kundengruppe,waehrungscode"
			",laendercode,sprachcode,lokationscode,bemerkung,preisgruppennr"
			",lieferungscode"
			" from debitor order by kurzname", "nummer", "debitor",	"Debitor.kdevdlg" );

		table = dialog->dialog->table;

		// This should be made as a table in the database to change it online.
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("kundengruppe")]->setStr( "Kunde1" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("buchungsgruppe")]->setStr( "FORD" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("waehrungscode")]->setStr( "EUR" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("sprachcode")]->setStr( "D" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("laendercode")]->setStr( "D" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("mwst_pflichtig")]->setStr( "t" );

		dialog->data->insertItem( "&Ansprechpartner", this, SLOT(sAnsprechpartner()) );
		buchhaltung = new QPopupMenu( this );
		buchhaltung->insertItem( "Buchungen", this, SLOT(sBuchungen()) );
		buchhaltung->insertItem( "Offene Posten", this, SLOT(sOffenePosten()) );
		buchhaltung->insertItem( "Statistik", this, SLOT(sStatistik()) );
		dialog->menuBar->insertItem( "&Buchhaltung", buchhaltung );

		topLayout->addWidget( dialog );

		table2 = new SQLTable( 0, "lfd_nr" ); // the query will be inserted later
		Posten = new QDialog( this, 0, true );
		view = new QDBTableViewSum( Posten, 0, &sql, table2,
			"betrag,restbetrag,urspr_betrag_mw,restbetrag_mw,mw,db" );
		QBoxLayout *topLayout2 = new QVBoxLayout( Posten, 5 );
		topLayout2->addWidget( view, 5 );

		// if new was pressed, get a new customer number
		connect( dialog->dialog->Page1, SIGNAL(sigNew()), SLOT(getNewNo()) );
	} else {
		QMessageBox::critical( this, "QtTudo", "Keine Datenbankverbindung aktiv!" );
	}
}

Kartei_Debitor::~Kartei_Debitor(){
}

void Kartei_Debitor::getNewNo()
{
	QString NoBO;
	QString nothing;

	sql.getLfdNr( "buchhaltungsdaten", &NoBO, "letz_debitornr", 1);
	NoBO.setNum( NoBO.toLong()+1 );
	dialog->dialog->Page1->Feld[table->fNumber("nummer")]->setText( NoBO );
	dialog->dialog->Page1->Feld[table->fNumber("kurzname")]->setFocus();
}

void Kartei_Debitor::sAnsprechpartner()
{
	QString selectStr = "SELECT * FROM ansprechpartner WHERE nummer=";
	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += " ORDER BY nummer,lfd_nr";

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Ansprechpartner", selectStr.ascii() );

	if (!partner) {
		tableAPartner = new SQLTable( selectStr.ascii(), "nummer,lfd_nr" );
		tableAPartner->execute();

		partner = new Kartei_Debitor_APartner( 0, 0, &sql, tableAPartner,
			"ansprechpartner", table );
	} else {
		tableAPartner->sQuery = selectStr;
		tableAPartner->execute();
	}
	QString sName = "QtTudo Ansprechpartner Debitor-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	partner->setCaption( sName );
	partner->show();
	//partner->raise();
}

void Kartei_Debitor::sBuchungen()
{
	QString selectStr = "select * from debitorenposten where debitornr=";
	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += " order by datum,lfd_nr";

	table2->sQuery = selectStr;

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Posten", selectStr.ascii() );

	table2->execute();

	QString sName = "QtTudo Debitorenposten Debitor-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	Posten->setCaption( sName );

	// if no columns exist, read the columns too
	view->buildSums();

	Posten->exec();
}

void Kartei_Debitor::sOffenePosten(){
	QMessageBox::information( this, "Test", "Offene Posten: Sorry, noch nicht fertig." );
}

void Kartei_Debitor::sStatistik(){
	QMessageBox::information( this, "Test", "Statistik: Sorry, noch nicht fertig." );
}
