/***************************************************************************
                    kartei_kontenplan.cpp  -  description
                    -------------------------------------
    begin                : 12.04.2000
    version              : $Id: kartei_kontenplan.cpp,v 1.2 2000/07/26 09:51:34 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qmenubar.h>
#include <qstatusbar.h>
#include <qmessagebox.h>

#include "kartei_kontenplan.h"
#include "qdbtableviewsum.h"

Kartei_Kontenplan::Kartei_Kontenplan(
				QWidget *parent, const char *name,
				SQLQuerier *sql_ptr, SQLTable *table_ptr,
				const char *tableName )
	: QDBErfassung(parent,name,sql_ptr,table_ptr,tableName)
{
	setCaption( "Linux-Tudo Kontenplan" );
	table = table_ptr;

	menuBar()->insertItem( "&Buchungen", this, SLOT(sUebersichtClicked()) );

	statusBar()->message( "Fertig", 2000 );
}

Kartei_Kontenplan::~Kartei_Kontenplan(){

}

void Kartei_Kontenplan::sUebersichtClicked()
{
	QString selectStr = "select * from sachposten where kontonr=";

	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += " order by kontonr,lfd_nr";

	SQLTable *table2 = new SQLTable( selectStr.ascii(), "lfd_nr" );

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Posten", selectStr.ascii() );

	table2->execute();

	QDialog *Posten = new QDialog( this, 0, true );
	QDBTableViewSum *view = new QDBTableViewSum( Posten, 0, &sql, table2,
			"nettobetrag,mwst_betrag" );
	QBoxLayout *topLayout = new QVBoxLayout( Posten, 5 );
	topLayout->addWidget( view, 5 );

	QString sName = "QtTudo Sachposten Konto-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	Posten->setCaption( sName );
	Posten->exec();
}
