/***************************************************************************
                     qdbeingabemaske.cpp  -  description
                     -----------------------------------
    begin                : 29.04.2000
    version              : $Id: qdbeingabemaske.cpp,v 1.18 2001/03/11 08:13:58 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : <info@bemme.de> www.bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#include <math.h>

#include "qdbeingabemaske.h"
#include "qdbsuchen.h"

QDBEingabemaske::QDBEingabemaske(QWidget *parent, const char *name,
			SQLQuerier *sql_ptr, SQLTable *table_ptr,
			const char *tableName, QDBTableView *TableP2_ptr,
			bool MakeFields, const char *filename )
	: QDBWidget(parent,name)
{
	QLabel *l;
	int Spalte = 0, Zeile = 0;
	unsigned int i;
	QCString *FeldKopie[MAXFELDER];

	TableP2 = TableP2_ptr;
	sql			= sql_ptr;
	table		= table_ptr;
	sName		= tableName;

	if ((sql==0)||(table==0)||(tableName==0)||(sql->conn == NULL)) {
		QMessageBox::warning( this, "QtTudo",
			"bergabeparameter fehlt oder Verbindung zur Datenbank unterbrochen!" );
		return;
	}

	// make shure that all is NULL
	for (i=0; i < MAXFELDER; i++) {
		Feld[i] = 0;
		FeldKopie[i] = 0;
	}

	frNavP1			= new QFrame( this );
	frNavP1->setFixedHeight(30);

	topLayoutP1 = new QVBoxLayout( this, 10 );
	navP1				= new QDBNavigator( frNavP1 );

 	// go to the end of database
 	table->pos = table->getnTuples()-1;

 	table->pos	= 0;
 	DBmodified	= false;
 	DBinserted	= false;
 	DBdeleted		= false;

	if (MakeFields) {

		// Generate mask automaticly
		//==========================

		frDfP1a = new QFrame( this );
		QGridLayout *gridP1 = new QGridLayout( frDfP1a, (int)ceil(table->getnFields()/2), 4, 5 );
		// let the lineedits stretch
		gridP1->setColStretch( 1, 1 );
		gridP1->setColStretch( 3, 1 );
		// no stretch on the labels
		gridP1->setColStretch( 0, 0 );
		gridP1->setColStretch( 2, 0 );

 		// create all database fields
 		for (i=0; i < (unsigned int) table->getnFields(); i++) {
 			Feld[i] = new QDBLineEdit( frDfP1a, table->fName(i), sql, table, table->pos );
 			FeldKopie[i] = new QCString();
 		  gridP1->addWidget( Feld[i], Zeile, Spalte+1 );
 			Feld[i]->setMinimumSize( QSize( 200, 20 ) );
   		l = new QLabel( frDfP1a );
 	  	gridP1->addWidget( l, Zeile, Spalte );
 		  l->setText( table->fName(i) );
 			l->setBuddy( Feld[i] );
 			if (Spalte == 0) // changing between left and right site
 				Spalte = 2;
 			else {
 				Spalte = 0;
 				Zeile++;
 			}
 			Feldvorgabe[i] = new QCString();
 		}

		// frame for datafields
		frDfP1a->setFrameStyle( QFrame::Box | QFrame::Sunken );
		topLayoutP1->addWidget( frDfP1a, 10 );

	} else { // if MakeFields

		// Generate mask manual
		//==========================

		if (filename != 0) {
			frMask = new MaskGenerator( this, 0, sql, table, filename, Feld );
			// frame for datafields
			frMask->setFrameStyle( QFrame::Box | QFrame::Sunken );
			topLayoutP1->addWidget( frMask, 10 );
		}

 		// create only selected database fields
 		for (i=0; i < (unsigned int) table->getnFields(); i++) {
 			FeldKopie[i] = new QCString();
 			Feldvorgabe[i] = new QCString();
 		} // for loop through all fields
	} // else from MakeFields

 	frNavP1->setFrameStyle( QFrame::Box | QFrame::Sunken );
 	topLayoutP1->addWidget( frNavP1, 10 );

	if (MakeFields)
		setMinimumSize( frDfP1a->sizeHint() );
	else
		setMinimumSize( frMask->width(), frMask->height() );

	connect( navP1->bFirst, SIGNAL(pressed()), SLOT(fFirst()) );
	connect( navP1->bBefore, SIGNAL(pressed()), SLOT(fBefore()) );
	connect( navP1->bNext, SIGNAL(pressed()), SLOT(fNext()) );
	connect( navP1->bLast, SIGNAL(pressed()), SLOT(fLast()) );
	connect( navP1->bRead, SIGNAL(pressed()), SLOT(fRead()) );
	connect( navP1->bFind, SIGNAL(pressed()), SLOT(fFind()) );
	connect( navP1->bUpdate, SIGNAL(pressed()), SLOT(fUpdate()) );
	connect( navP1->bUndo, SIGNAL(pressed()), SLOT(fUndo()) );
	connect( navP1->bNew, SIGNAL(pressed()), SLOT(fNew()) );
	connect( navP1->bDelete, SIGNAL(pressed()), SLOT(fDelete()) );

	// if page up was pressed
	connect( this, SIGNAL(changePosUp()), SLOT(fBefore()) );
	// if page down was pressed
	connect( this, SIGNAL(changePosDown()), SLOT(fNext()) );
	// if insert was pressed
	connect( this, SIGNAL(pressedInsert()), SLOT(fNew()) );
	// if escape was pressed
	connect( this, SIGNAL(pressedEsc()), SLOT(fUndo()) );
	// if delete was pressed

	// if F2 was pressed for reload database table
	connect( this, SIGNAL(pressedF2()), SLOT(fRead()) );
	// if F4 was pressed for delete tuple
	connect( this, SIGNAL(pressedF4()), SLOT(fDelete()) );
	// if F6 was pressed for get field value
	//connect( this, SIGNAL(pressedF6()), SLOT(f()) );
	// if F7 was pressed for search tuple
	connect( this, SIGNAL(pressedF7()), SLOT(fFind()) );
	// if F10 was pressed for update tuple
	connect( this, SIGNAL(pressedF10()), SLOT(fUpdate()) );
	// if shift + pos1/home was pressed
	connect( this, SIGNAL(pressedShiftPos1()), SLOT(fFirst()) );
	// if shift + end was pressed
	connect( this, SIGNAL(pressedShiftEnd()), SLOT(fLast()) );
	// if up was pressed
	connect( this, SIGNAL(pressedUp()), SLOT(fFieldBefore()) );
	// if down was pressed
	connect( this, SIGNAL(pressedDown()), SLOT(fFieldNext()) );

	topLayoutP1->activate();

	table->pos = table->getnTuples()-1;
	Neue_DBPos( table->pos );
	if (Feld[0] != 0)
		Feld[0]->setFocus();

	navP1->bFind->setFocus();
}

QDBEingabemaske::~QDBEingabemaske()
{
}

void QDBEingabemaske::DBSpeichern()
{
	int i;
	QCString *DBneu = new QCString();
	const char ueberschrift[16] = "Daten speichern";
	bool FirstDS = true;
	bool CommitOk = false;

	// we use this for making changes
	SQLTable* tableNeu;

	navP1->setButtonsUp();
	if (sql->conn != NULL) {
		// if a new tuple will be added ...
		if ( DBinserted ) {
			DBneu->setStr( "INSERT INTO " );
			DBneu->append( sName );
			DBneu->append( " (" );
			// Read the fieldnames within a loop
			for ( i = 0; i < table->getnFields(); i++) {
				// Feld[] is a array of QDBLineEdit
				if (Feld[i] != 0) {
					if ( strlen(Feld[i]->text()) != 0 ) {
						if ( i > 0 )
							DBneu->append( "," );
						DBneu->append( Feld[i]->name() );
					}
				} else {
					if (Feldvorgabe[i] != 0) { // This should be always not 0
						if ( strlen(Feldvorgabe[i]->copy()) != 0 ) {
							if ( i > 0 )
								DBneu->append( "," );
							DBneu->append( table->fName(i) );
						}
					}
				}
			}
			DBneu->append( ")" );
			DBneu->append( " VALUES (" );
			// reading the fields
			for ( i = 0; i < table->getnFields(); i++) {
				if (Feld[i] != 0) {
					if ( strlen(Feld[i]->text()) != 0 ) {
						if ( i > 0 )
							DBneu->append( ",'" );
						else
							DBneu->append( "'" );
						DBneu->append( Feld[i]->text() );
						DBneu->append( "'" );
					}
				} else {
					if (Feldvorgabe[i] != 0) { // This should be always not 0
						if ( strlen(Feldvorgabe[i]->copy()) != 0 ) {
							if ( i > 0 )
								DBneu->append( ",'" );
							else
								DBneu->append( "'" );
							if ( strlen(Feldvorgabe[i]->copy()) != 0 )
								DBneu->append( Feldvorgabe[i]->copy() );
							DBneu->append( "'" );
						}
					}
				}
			}
			DBneu->append( ")" );

			// Test: Falls man die Query vorher sehen mchte.
			//QMessageBox::information( this, "Test: Insert", DBneu->copy() );

			tableNeu = new SQLTable( DBneu->copy(), 0 );
		  if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
				QMessageBox::warning( this, ueberschrift, tableNeu->ErrorText );
			} else {
				CommitOk = true;
			}
		} // DBinserted

		if (!DBinserted) {
			for ( i = 0; i < table->getnFields(); i++)
				if (Feld[i] != 0)
					if ( Feld[i]->geaendert ) {
						DBmodified = true;
						break;
					}
		} // !DBinserted

		// if a tuple will be modified ...
		if ( DBmodified ) {
			DBneu->setStr( "UPDATE " );
			DBneu->append( sName );
			DBneu->append( " SET " );
			// reading the fields
			for ( i = 0; i < table->getnFields(); i++) {
				if (Feld[i] != 0) {
					//if (( strlen(Feld[i]->text()) != 0 ) && ( Feld[i]->geaendert )) {
					if ( Feld[i]->geaendert ) {
						if (( i > 0 ) && ( !FirstDS ))
							DBneu->append( "," );
						FirstDS = false;
						DBneu->append( Feld[i]->name() );
						DBneu->append( " = " );
						DBneu->append( "'" );
						DBneu->append( Feld[i]->text() );
						DBneu->append( "'" );
					}
				}
			}
			DBneu->append( " WHERE " );
			GetPrimaryKey( DBneu );

			// Test: If you want to see the Query before execute.
			//QMessageBox::information( this, "Test: Update", DBneu->copy() );

			tableNeu = new SQLTable( DBneu->copy(), 0 );
			if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
				QMessageBox::warning( this, ueberschrift, tableNeu->ErrorText );
			} else
				CommitOk = true;
		} // DBmodified

		if (CommitOk) {
			DBinserted = false;
			DBmodified = false;

			// Daten in den Cursor neu einlesen.
		  if (table->execute() != SUCCESS_RESULTS)
				QMessageBox::warning( this, ueberschrift, table->ErrorText );
			else {
				// Gehe ans Ende der DB (Das mu auch noch gendert werden.
				// Besser wenn man zum Datensatz springt, der zuletzt bearbeitet
				// wurde).
				Neue_DBPos( table->getnTuples() - 1 );
				emit tupleChanged();
			}
		} // CommitOk
	} // sql->conn != NULL
}

void	QDBEingabemaske::fFieldBefore()
{
	int i,ii,bigNo,i3;
	int step=1;
	bool found = false;

	for (i=0; i < MAXFELDER; i++)
		if (Feld[i] != 0)
			if (Feld[i]->hasFocus()) {
				if (Feld[i]->screenNo>0) {
					for (ii=0; ii < MAXFELDER; ii++) {
						if (Feld[ii] != 0)
							if (Feld[ii]->screenNo == Feld[i]->screenNo-step) {
								if (Feld[ii]->isReadOnly()) {
									Feld[ii]->setFocus();
									found = true;
									//printf("%s ii=%i screenNo=%i\n",Feld[ii]->name(),ii,Feld[ii]->screenNo);
									break;
								} else {
									// retry again from beginning (we need the next enabled
									// edit field
									step++;
									ii = 0;
								}
							}
					}
					if (!found) { // not found
						bigNo = 1;
						i3 = 0;
						for (ii=0; ii < MAXFELDER; ii++) {
							if ((Feld[ii] != 0) && (Feld[ii]->isReadOnly()) && (Feld[ii]->screenNo > bigNo)) {
								bigNo = Feld[ii]->screenNo;
								i3 = ii;
							}
						}
						Feld[i3]->setFocus();
						//printf("%s ii=%i screenNo=%i\n",Feld[ii]->name(),ii,Feld[ii]->screenNo);
					}
				}
				break;
			}
}

void	QDBEingabemaske::fFieldNext()
{
	int i,ii;
	int step=1;
	bool found = false;

	for (i=0; i < MAXFELDER; i++)
		if (Feld[i] != 0)
			if (Feld[i]->hasFocus()) {
				if (Feld[i]->screenNo<MAXFELDER) {
					for (ii=0; ii < MAXFELDER; ii++) {
						if (Feld[ii] != 0)
							if (Feld[ii]->screenNo == Feld[i]->screenNo+step) {
								if (Feld[ii]->isReadOnly()) {
									Feld[ii]->setFocus();
									found = true;
									break;
								} else {
									// retry again from beginning (we need the next enabled
									// edit field
									step++;
									ii = 0;
								}
							}
					}
					if (!found) { // not found
						step = 1;
						for (ii=0; ii < MAXFELDER; ii++)
							if (Feld[ii] != 0)
								if (Feld[ii]->screenNo == step) {
									if (Feld[ii]->isReadOnly()) {
										Feld[ii]->setFocus();
										break;
									} else {
										step++;
										ii = 0;
									}
								}
					}
				}
				break;
			}
}

void	QDBEingabemaske::fFirst()
{
	if ( sql->conn != NULL ) {
		if ( DBinserted || DBmodified )
			DBSpeichern();
		Neue_DBPos( 0 );
	}
}

void	QDBEingabemaske::fBefore()
{
	if ( sql->conn != NULL ) {
		//DBSpeichern();
		if ( table->pos > 0 )
			Neue_DBPos( table->pos - 1 );
	}
}

void	QDBEingabemaske::fNext()
{
	if ( sql->conn != NULL ) {
		DBSpeichern();
		if ( (table->pos + 1) < table->getnTuples() )
			Neue_DBPos( table->pos + 1 );
	}
}

void	QDBEingabemaske::fLast()
{
	if ( sql->conn != NULL ) {
		DBSpeichern();
		Neue_DBPos( table->getnTuples() - 1 );
	}
}

void QDBEingabemaske::fRead()
{
	// new read from the database
  if (table->execute() != SUCCESS_RESULTS) {
		QMessageBox::warning( this, "Daten neu lesen", table->ErrorText );
		return;
	} else {
		DBinserted	= false;
		DBmodified	= false;
		// Go to the end of the database
		// That's not so good, must be changed in the future
		if ( table->getnTuples() > 0 )
			Neue_DBPos( table->getnTuples() - 1 );
		else
			Neue_DBPos( 0 );
	}
}

void	QDBEingabemaske::fFind()
{
	navP1->bFind->setDown(false);

	// Suchfenster aufrufen
	QDBSuchen *Suchen = new QDBSuchen( this, 0, table );
	Suchen->show();
}

void	QDBEingabemaske::fUpdate()
{
	if ( sql->conn != NULL ) {
		DBSpeichern();
	}
}

void	QDBEingabemaske::fUndo()
{
	if ( sql->conn != NULL ) {
		if ( DBinserted )
			DBinserted = false;
		Neue_DBPos( table->pos ); // Einfach nochmal neu einlesen
		emit sigUndo();
	}
}

void	QDBEingabemaske::fNew()
{
	// This function don't create a new tuple, this
	// passes on leaving or pressing the button Update.
	// clear the input fields

	if ((sql->conn != NULL) && (!DBinserted)) {
		initFields();
		DBinserted = true;
		emit sigNew();
	}
}

void QDBEingabemaske::initFields()
{
	if ((sql->conn != NULL) && (!DBinserted)) {
		for (int i=0; i < table->getnFields(); i++)
			if (Feld[i] != 0) {
				if (Feldvorgabe[i] != 0)
					if (!Feldvorgabe[i]->isEmpty())
						Feld[i]->setText( Feldvorgabe[i]->copy() );
					else
						Feld[i]->setText( "" );
			}
	}
}

void	QDBEingabemaske::fDelete()
{
	QCString *DBdel = new QCString();
	const char ueberschrift[16] = "Daten lschen";
	SQLTable* tableNeu;

	navP1->bDelete->setDown(false);

	switch( QMessageBox::warning( this, "QtTudo Datensatz lschen",
		"Der Datensatz geht unwiderruflich verloren.\n"
		"Mchten Sie den Datensatz trotzdem lschen?",
		"&Ja", "&Nein", "",
		1,2 ))     // Nein == button 0 -> default
	{
		case 0: // Ja clicked, Alt-J or Enter pressed.
			// delete
			break;
		case 1: // Nein clicked or Alt-N pressed
			// don't delete
			return;
	} // switch

	// Datensatz lschen
	if (sql->conn != NULL) {
		DBdel->setStr( "DELETE FROM " );
		DBdel->append( sName );
		DBdel->append( " WHERE " );
		GetPrimaryKey( DBdel );

		// Test: Falls man die Query vorher sehen mchte.
		//QMessageBox::information( this, "Test: Delete", DBdel->copy() );

		tableNeu = new SQLTable( DBdel->copy(), 0 );
		if (tableNeu->execute() != SUCCESS_NO_RESULTS) {
			QMessageBox::warning( this, ueberschrift, tableNeu->ErrorText );
		} else {
			DBinserted = false;
			DBmodified = false;

			// Daten in den Cursor neu einlesen.
		  if (table->execute() != SUCCESS_RESULTS)
				QMessageBox::warning( this, ueberschrift, table->ErrorText );
			else {
				// Gehe ans Ende der DB (Das mu auch noch gendert werden.
				// Besser wenn man zum Datensatz springt, der zuletzt bearbeitet
				// wurde).
				DBdeleted = true;
				if ( table->getnTuples() > 0 )
					Neue_DBPos( table->getnTuples() - 1 );
				else
					Neue_DBPos( 0 );
			}
		} // execute Ok
	}
}

QCString *QDBEingabemaske::GetPrimaryKey( QCString *Key )
{
	int FeldNr;

	for (int i=0; (i < MAXKEYS) && (table->PrimaryKeys[i][0] != 0); i++) {
		if (i>0)
			Key->append( " AND " );
		Key->append( table->PrimaryKeys[i] );
		Key->append( " = " );
		Key->append( "'" );
		FeldNr = table->fNumber(table->PrimaryKeys[i]);
		if (FeldNr != -1) {
			if (Feld[FeldNr] != 0)
				Key->append( Feld[FeldNr]->text() );
			else {
				if (Feldvorgabe[FeldNr] != 0) { // This should be always not 0
					if ( strlen(Feldvorgabe[FeldNr]->copy()) != 0 ) {
						if ( strlen(Feldvorgabe[FeldNr]->copy()) != 0 )
							Key->append( Feldvorgabe[FeldNr]->copy() );
					}
				}
			}
		} else
			QMessageBox::warning( this, "Fehler", "Feld-Nr. konnte nicht ermittelt werden." );
		Key->append( "'" );
	}
	return Key;
}

void QDBEingabemaske::Neue_DBPos( int Pos )
{
	int i;

	// Here we fill the fields with the new content.
	if ((sql->conn != NULL) && (Pos > -1)) {
		for (i=0; i < table->getnFields(); i++) {
			if (Feld[i] != 0) {
	    	if (table->getnTuples() != 0) {
					switch ( table->fType(i) ) {
					case 16: // bool
							if ( strcmp(table->getValue( Pos, i ),"t") == 0 )
								Feld[i]->setText( "ja" );
							else
								Feld[i]->setText( "nein" );
							break;
						case 21:		// int2
						case 23:		// int4
						case 790:		// money
						case 1043:	// varchar
						case 1184:	// datetime
						default:
							// get the content
							Feld[i]->setText( table->getValue(Pos,i) );
						}
				} else
					Feld[i]->setText( "" );
				Feld[i]->geaendert = false;
				//Feld[i]->setPalette( QPalette(QColor(80,100,50), QColor(80,255,80)) );
				//Feld[i]->text().setBackgroundColor( QColor(80,255,80) );
			}
		}
		if ( TableP2 != 0 ) {
			if (table->getnTuples() > 0) {
				if (TableP2->currentItem() != 0) {
					if (TableP2->childCount() != table->getnTuples()) {
						table->pos = Pos;
						TableP2->update( table );
					}
					if ( Pos != TableP2->currentItem()->DBPos ) {
						table->pos = Pos;
						TableP2->update( table );
					}
					if ( DBdeleted ) {
						DBdeleted = false;
						TableP2->update( table );
					}
				} else {
					table->pos = Pos;
					TableP2->update( table );
				}
			} else {
				table->pos = 0;
				TableP2->update( table );
			}
		} else {
			if (table->getnTuples() > 0)
				table->pos = Pos;
			else
				table->pos = 0;
		}
		emit posChanged();
	}	
	table->pos = Pos;
}

bool QDBEingabemaske::setValue( const char *fieldname, QString *value )
{
	for (int i=998;i>-1;i--) {
		if (Feld[i] != 0) {
			if (strstr(Feld[i]->name(),fieldname) != NULL) {
				Feld[i]->setText( value->copy() );
				return true;
			}
		}
	}
	return false;
}
