/***************************************************************************
                          sqlquerier.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Oct 6 1999                                           
    version              : $Id: sqlquerier.cpp,v 1.12 2001/03/11 08:13:58 joerg_bemme Exp $
    copyright            : (C) 1999 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "sqlquerier.h"
#include <stdio.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qmessagebox.h>

SQLQuerier sql;

// Username
QCString Benutzer;
QCString Taskname;

// Path for init-files
QCString initPath;

// This function must be called from the main function
bool ConnectToDB( const char *fileName )
{
	sql.pgtz = "";
	sql.pgdatestyle = "";

  QFile f( fileName );

	// Konfiguration lesen aus 'tudo.ini'
  if ( f.open(IO_ReadOnly) ) {
    QTextStream t( &f );
		initPath				= t.readLine();
    sql.pghost			= t.readLine();
    sql.pgport			= t.readLine();
    sql.dbname			= t.readLine();
		sql.pgtz				= "SET TIME ZONE '";
    sql.pgtz				+= t.readLine();
    sql.pgtz				+= "'";
    sql.pgdatestyle = "SET DATESTYLE TO '";
    sql.pgdatestyle	+= t.readLine();
    sql.pgdatestyle += "'";
    f.close();
		return true;
  }
	return false;
}
/*
SQLQuery::SQLQuery( QCString *query ) {
}

SQLQuery::~SQLQuery() {
}

void SQLQuery::addSelect() { // select field
}

void SQLQuery::delSelect() { // remove selected field
}

void SQLQuery::addWhere() { // add where field
}

void SQLQuery::setWhere() { // set where = value
}

void SQLQuery::clearWhere() { // delete value from where
}

void SQLQuery::addOrder() { // add sorting field
}

void SQLQuery::delOrder() { // remove sorting field
}
*/
SQLQuerier::SQLQuerier(){
  /* begin, by setting the parameters for a backend connection
     if the parameters are null, then the system will try to use
     reasonable defaults by looking up environment variables
     or, failing that, using hardwired constants */
  pghost		= NULL;	/* host name of the backend server */
  pgport		= NULL;	/* port of the backend server */
  pgoptions	= NULL;	/* special options to start up the backend server */
  pgtty			= NULL;	/* debugging tty for the backend server */
	dbname		= NULL;
	Name			= NULL;
	Password	= NULL;
	conn			= NULL;
}

int SQLQuerier::Connect(const char *Name, const char *Password)
{
	bool Ok = false;
  SQLTable res( 0, 0 );
  ErrorText = "";  // clearing previous errors

  // make a connection to the database
  conn = PQsetdbLogin( pghost, pgport, pgoptions, pgtty, dbname, Name, Password);

  // check to see that the backend connection was successfully made
  if (PQstatus(conn) == CONNECTION_BAD) {
    ErrorText = PQerrorMessage(conn);
		PQfinish(conn);
		conn = NULL;
  } else
	{
		res.sQuery = pgtz.copy();
		if (res.execute() != SUCCESS_NO_RESULTS) {
			ErrorText = "Zeitzone konnte nicht gesetzt werden.";
		} else
		{
			res.sQuery = pgdatestyle.copy();
			if (res.execute() != SUCCESS_NO_RESULTS) {
		    ErrorText = PQerrorMessage(conn);
			} else
				Ok = true;
			}
  }
	if (Ok)
	  return SUCCESS_NO_RESULTS;
	else
		return ERRORS_RETURNED;
}

int SQLQuerier::Close()
{
	int i;

  // close the connection to the database
	if ( conn != NULL ) {
  	if (PQstatus(conn) == CONNECTION_BAD)
			i = ERRORS_RETURNED;
		else
			i = 0;  // all ok
	 	PQfinish(conn);
		return i;
	}
	return NOT_CONNECTED;
}

// This function should not be used within a transaction, because
// during the transaction another user can get the same number
// and we have a conflict. Therefore we must use this function
// before starting the transaction.
QString *SQLQuerier::getLfdNr( const char *tablename, QString *Field,
		const char *Fieldname, int NoOfTuples )
{
	QString s, s2;

	SQLTable *t = new SQLTable( "SELECT * FROM " );
	t->sQuery.append( tablename );
	t->execute();

	if ( Field->isEmpty() ) {
		// read the next LfdNr.
		Field->append( t->getValue( 0, Fieldname ));
	}

	// Setting the number for the next accounting.
	// Add NoOfTuples and save the new value.
	s = "UPDATE ";
	s.append( tablename );
	s.append(" SET ");
	s.append( Fieldname );
	s.append( " = ");
	s2.setNum( Field->toLong() + NoOfTuples );
	s.append( s2 );
	t->sQuery = s.ascii();
  if ( t->execute() != SUCCESS_NO_RESULTS ) {
		QMessageBox::warning( 0, "QtTudo ", t->ErrorText );
	}

	return Field;
}

SQLTable::SQLTable( QCString Query, QCString PrimaryKey )
{
	unsigned int i, ii=0;

	table = 0;
	sQuery = Query;
	sPrimaryKey = PrimaryKey;
	nothing	= new char[2];
	strcpy( nothing, "0" );

	for (i=(Query.find( "from", 0, false ) + 5); i < Query.length(); i++, ii++) {
		if ( Query.at(i) == ' ' )
			break;
		name[ii] = Query.at(i);
	}
	name[ii] = 0;

	for (i=0; i < MAXKEYS; i++)
		PrimaryKeys[i][0] = 0;

	// Looking in PrimaryKey for commas,
	// number of commas + 1 == number key fields
	if (strlen( sPrimaryKey ) > 0) {
		ii = 0; // begin of key
		AnzKeys = 0; // Key-Counter
		// i is the end of Key
		for (i=0; i < strlen( sPrimaryKey ); i++) {
			if (sPrimaryKey[i] == ',') {
				PrimaryKeys[AnzKeys][i-ii] = 0; // add 0 to end
				ii = i+1;
				AnzKeys++;
			}
			PrimaryKeys[AnzKeys][i-ii] = sPrimaryKey[i];
		}
		if (i > ii) {
			PrimaryKeys[AnzKeys][i-ii] = 0; // add 0 to end
			ii = i;
			AnzKeys++;
		}
	}
}

SQLTable::~SQLTable()
{
	clear();
}

void SQLTable::clear()
{
	PQclear( table );
}

int SQLTable::execute()
{
  ErrorText = "";  // clearing previous errors
	clear();

  // check to see that the backend connection was successfully made
  if (PQstatus(sql.conn) == CONNECTION_BAD) {
    ErrorText = PQerrorMessage(sql.conn);
		PQfinish(sql.conn);
    return ERRORS_RETURNED;
  }

	// clear noOfTuples
	noOfTuples = 0;

	//printf( "%s\n", (const char *) sQuery ); // Only for testing
  table = PQexec( sql.conn, sQuery.copy() ); // EXECUTING QUERY

  if (PQresultStatus( table ) == PGRES_COMMAND_OK)
  {
    // Query executed successfully, no results returned
		// CURSOR, TRANSACTION goes back here
		noOfTuples = getnTuples();
		return SUCCESS_NO_RESULTS;
  };

  if (PQresultStatus( table ) == PGRES_TUPLES_OK)
  {
    // Query executed successfully, results returned
		// A SELECT jumps back here.
		noOfTuples = getnTuples();
    return SUCCESS_RESULTS;
  };

  switch(PQresultStatus( table )) // error handling
  {
    case PGRES_EMPTY_QUERY:
      ErrorText = "Abfrage ist leer!\n";
      break;
    case PGRES_BAD_RESPONSE:
      ErrorText = "Eine unerwartete Antwort wurde von Postgres zurckgegeben!\n";
      break;
    case PGRES_NONFATAL_ERROR:
      ErrorText = "Unzulssige Abfrage\n";
      break;
    case PGRES_FATAL_ERROR:
      ErrorText = "Fehler aufgetreten!\n";
      break;
    default:
      ErrorText = "Unbekannter Fehler\n";
  };
  ErrorText += PQresultErrorMessage( table );

  return ERRORS_RETURNED;
}

int SQLTable::getnFields()
{
	return PQnfields( table );
}

int SQLTable::getnTuples()
{
	return PQntuples( table );
}

int SQLTable::fType( int field_number )
{
	return PQftype( table, field_number );
}

int SQLTable::fNumber( const char* field_name )
{
	return PQfnumber( table, field_name );
}

char* SQLTable::getValue( int tuple_number, int field_number )
{
	if (tuple_number <= -1)
		return nothing;

	char *s = PQgetvalue( table, tuple_number, field_number );

	if ( strlen(s) == 0 ) {
		if ( fType( field_number ) == 21 ) // int 2
			return nothing;
		if ( fType( field_number ) == 23 ) // int 4
			return nothing;
		if ( fType( field_number ) == 790 ) // money
			return nothing;
		if ( fType( field_number ) == 1700 ) // ???
			return nothing;
	}

	return s;
}

char* SQLTable::getValue( int tuple_number, const char *fname )
{
	if (tuple_number <= -1)
		return nothing;

	char *s = PQgetvalue( table, tuple_number, fNumber(fname) );

	if ( strlen(s) == 0 ) {
		if ( fType( fNumber(fname) ) == 21 ) // int 2
			return nothing;
		if ( fType( fNumber(fname) ) == 23 ) // int 4
			return nothing;
		if ( fType( fNumber(fname) ) == 790 ) // money
			return nothing;
		if ( fType( fNumber(fname) ) == 1700 ) // ???
			return nothing;
	}

	return s;
}

char* SQLTable::fName( int field_index )
{
	return PQfname( table, field_index );
}

// save the keyfields from tuplePos
void SQLTable::savePos( int tuplePos,	bool newPos ) {
	if (tuplePos < getnTuples()) {
		for (int i=0; i<MAXKEYS; i++) {
			if ( PrimaryKeys[i][0] != 0 ) {
				if ((!newPos) && (fNumber( PrimaryKeys[i] ) >= 0))
					sLastPos[i] = getValue( tuplePos, fNumber( PrimaryKeys[i] ));
				else
					sLastPos[i] = sNewPos[i].copy();
			}
		}
		pos = tuplePos;
	} else
		pos = getnTuples()-1;
	// Test
	//printf("savePos: %i\n", pos);
}

// get the tuplePos from the keyfields stored
// in function before
// (if the database was changed the tuplePos may be
// differend too)
// if not found the function returns -1
int SQLTable::setPos() {
	int nTuples, i;
	int result;
	int test;

	// loop through all tuples
	for ( nTuples = 0; nTuples < getnTuples();	nTuples++ ) {
		// loop through all datafields
		result = 0;
		for ( i=0; i<MAXKEYS; i++ ) {
			if ( PrimaryKeys[i][0] != 0 ) {
				if ( fNumber( PrimaryKeys[i] ) >= 0 ) {
					test = strcmp( sLastPos[i], getValue( nTuples, fNumber( PrimaryKeys[i] )));
					if (test==0)
						result++; // identical
				}
			} else
				result++;
		}
		if (result == MAXKEYS) // found
			break;
	}

	// Test
	//printf("setPos: %i\n", nTuples);

	if ( nTuples == getnTuples() )
		return -1;
	return nTuples;
}

QCString *SQLTable::GetPrimaryKey( QCString *Key )
{
	int FeldNr;

	for (int i=0; (i < MAXKEYS) && (PrimaryKeys[i][0] != 0); i++) {
		if (i>0)
			Key->append( " AND " );
		Key->append( PrimaryKeys[i] );
		Key->append( " = " );
		Key->append( "'" );
		FeldNr = fNumber(PrimaryKeys[i]);
		if (FeldNr != -1)
			Key->append( getValue( pos, FeldNr ));
/*		else
			QMessageBox::warning( this, "Fehler", "Feld-Nr. konnte nicht ermittelt werden." );*/
		Key->append( "'" );
	}
	return Key;
}
