/* Seahorse
 *
 * Copyright (C) 1999, 2000 Anthony Mulcahy
 *   
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <gnome.h>

void
show_error (char *error_msg);

int
gpg_sign_encrypt		       (int	sign,
					int	clearsign,
					int	detachedsign,
					int	encrypt,
					int	ascii_arm,
					int	textmode,
					int	clipboard,
					int	output_to_file,
					char	*filename,
					char	*outfilename,
					char	*clipboard_string,
					char	*passphrase,
					char	*username,
					char	*default_key,
					char	**output,
                                        char	**diagnostics);

int
gpg_decrypt			       (int	decrypt,
					int	clipboard,
					int	output_to_file,
					char	*filename,
					char	*outfilename,
					char	*clipboard_string,
					char	*passphrase,
					char	**output,
                                        char	**diagnostics);

int
gpg_version			       (char	**output,
                                        char	**diagnostics);

int
gpg_list_pubkeys		       (char	**output,
                                        char	**diagnostics);

int
gpg_list_seckeys		       (char	**output,
                                        char	**diagnostics);

int
gpg_revoke_key			       (char *keyid,
					char	*passphrase,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_recv_key			       (char	*keyserver,
					char	*keyid,
					int	use_proxy,
					char	**output,
                                        char	**diagnostics);

int
gpg_lsign_key			       (char *keyid,
					char	*passphrase,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_delete_pubkey		       (char *keyid,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_delete_seckey		       (char *keyid,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_change_expiry		       (char 	*keyid,
					char	*expiry,
					char	*passphrase,
					char	**output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_change_trust		       (char *keyid,
					int trust,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_add_uid			       (char	*keyid,
					char	*realname,
					char	*email,
					char	*comment,
					char	*passphrase,
					char	**output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_delete_sig			       (char *keyid,
					char *sig,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_delete_uid			       (char *keyid,
					char *uid,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_sign_key			       (char *keyid,
					char	*passphrase,
					char **output,
                                        char	**diagnostics,
					GtkWidget *log_textbox);

int
gpg_export_key			       (char *keyfile,
					char *keyid,
					int	ascii_arm,
					char **output,
                                        char	**diagnostics);

int
gpg_import_key			       (char *keyfile,
					char **output,
                                        char	**diagnostics);

int
gpg_send_key			       (char	*keyserver,
					char	*keyid,
					int	use_proxy,
					char	**output,
                                        char	**diagnostics);

int
gpg_gen_key			       (char	*keytype,
					int	keysize,
					int	expiration,
					char	*realname,
					char	*email,
					char	*comment,
					char	*passphrase,
					GtkWidget *log_textbox);

#define  GPG_DIR	"/.gnupg"

char *gpg_directory();

