/* $Id: file.c,v 1.37 2000/06/14 06:26:09 aito Exp $ */
#include "fm.h"
#include <sys/types.h>
#include "myctype.h"
#include <signal.h>
#include <setjmp.h>
#include <sys/wait.h>
#include <stdio.h>
#include <time.h>
#ifdef __EMX__
#include <strings.h>
#endif				/* __EMX__ */
/* foo */

#include "html.h"
#include "parsetag.h"
#include "local.h"
#include "regex.h"


#ifndef max
#define max(a,b)        ((a) > (b) ? (a) : (b))
#endif				/* not max */
#ifndef min
#define min(a,b)        ((a) > (b) ? (b) : (a))
#endif				/* not min */

extern Hist *SaveHist;

static FILE *gunzip_stream(FILE * infp, int compressor);
static FILE *lessopen_stream(char *path);
static void close_textarea(struct html_feed_environ *h_env);
static void addnewline(Buffer * buf, char *line, Lineprop * prop, int pos, int nlines);

static Lineprop propBuffer[LINELEN];

static JMP_BUF AbortLoading;

static struct table *tables[MAX_TABLE];
static int table_width[MAX_TABLE];
static struct table_mode table_mode[MAX_TABLE];

#ifdef MENU_SELECT
/* menu based <select>  */
FormSelectOption select_option[MAX_SELECT];
static Str cur_option;
static Str cur_option_value;
static int cur_option_selected;
static int just_after_select;
static int cur_option_maxwidth;
static int cur_status = R_ST_NORMAL;
static int n_select;
#endif				/* MENU_SELECT */
static Str cur_select;

static int n_selectitem;
static Str cur_textarea;
Str textarea_str[MAX_TEXTAREA];
static int cur_textarea_size;
static int cur_textarea_rows;
static int n_textarea;
static int select_is_multiple;

static Str proxy_auth_cookie = NULL;

static int http_response_code;

#ifdef JP_CHARSET
static char content_charset = '\0';
static char guess_charset(char *p);
#endif

static Str save_line = NULL;
static char save_prevchar = ' ';

struct link_stack {
    int cmd;
    short offset;
    short pos;
    struct link_stack *next;
};

static struct link_stack *link_stack = NULL;

#define FORMSTACK_SIZE 10
#define FRAMESTACK_SIZE 10

#ifdef USE_NNTP
#define Str_news_endline(s) ((s)->ptr[0]=='.'&&((s)->ptr[1]=='\n'||(s)->ptr[1]=='\r'||(s)->ptr[1]=='\0'))
#endif				/* USE_NNTP */

#ifdef NEW_FORM
#define INITIAL_FORM_SIZE 10
static FormList **forms;
static int form_stack[FORMSTACK_SIZE];
static int form_max = 0;
static int forms_size = 0;
#define cur_form_id ((form_sp >= 0)? form_stack[form_sp] : -1)
#else				/* not NEW_FORM */
static FormList *form_stack[FORMSTACK_SIZE];
#endif				/* not NEW_FORM */
static int form_sp = 0;

static int current_content_length;

static int cur_hseq;

#define MAX_UL_LEVEL 9
#ifdef KANJI_SYMBOLS
char *ullevel[MAX_UL_LEVEL] =
{
    "", "", "", "", "", "", "", "", ""
};
#define HR_RULE ""
#define HR_RULE_WIDTH 2
#else				/* not KANJI_SYMBOLS */
char *ullevel[MAX_UL_LEVEL] =
{
    "&nbsp;*", "&nbsp;+", "&nbsp;o", "&nbsp;#", "&nbsp;@", "&nbsp;-", "&nbsp;=",
    "**", "--"
};
#define HR_RULE "-"
#define HR_RULE_WIDTH 1
#endif				/* not KANJI_SYMBOLS */

#ifndef STRCHR
char *
strchr(char *s, char c)
{
    while (*s) {
	if (*s == c)
	    return s;
	s++;
    }
    return NULL;
}
#endif				/* not STRCHR */

static MySignalHandler
KeyAbort(SIGNAL_ARG)
{
    LONGJMP(AbortLoading, 1);
    SIGNAL_RETURN;
}

int
currentLn(Buffer * buf)
{
    if (buf->currentLine)
	return buf->currentLine->real_linenumber + 1;
    else
	return 1;
}

static Buffer *
loadSomething(URLFile * f,
	      char *path,
	      Buffer * (*loadproc) (URLFile *, Buffer *),
	      Buffer * defaultbuf)
{
    Buffer *buf;

    if ((buf = loadproc(f, defaultbuf)) == NULL)
	return NULL;

    buf->filename = path;
    if (buf->buffername == NULL || buf->buffername[0] == '\0')
	buf->buffername = lastFileName(path);
    if (buf->currentURL.scheme == SCM_UNKNOWN)
	buf->currentURL.scheme = f->scheme;
    buf->real_scheme = f->scheme;
    if (f->scheme == SCM_LOCAL && buf->sourcefile == NULL)
	buf->sourcefile = path;
    UFclose(f);
    f->stream.f = NULL;
    return buf;
}

int
dir_exist(char *path)
{
    struct stat stbuf;

    if (path == NULL || *path == '\0')
	return 0;
    if (stat(path, &stbuf) == -1)
	return 0;
    return IS_DIRECTORY(stbuf.st_mode);
}

FILE *
examineFile(char *path, void (**close_rout) ())
{
    struct stat stbuf;
    int cmpst = CMP_NOCOMPRESS;		/* Compression status */
    int len, slen;

    if (close_rout)
	*close_rout = (void (*)()) fclose;
    if (path == NULL || *path == '\0')
	return NULL;
    if (stat(path, &stbuf) == -1 || NOT_REGULAR(stbuf.st_mode))
	return NULL;
    if (!do_download) {
	len = strlen(path);
	if (len > 2 && strcasecmp(&path[len - 2], ".Z") == 0) {
	    cmpst = CMP_COMPRESS;
	    slen = 2;
	} else if (len > 3 && strcasecmp(&path[len - 3], ".gz") == 0) {
	    cmpst = CMP_GZIP;
	    slen = 3;
	} else if (len > 4 && strcasecmp(&path[len - 4], ".bz2") == 0) {
	    cmpst = CMP_BZIP2;
	    slen = 4;
	}
	if (cmpst != CMP_NOCOMPRESS) {
	    FILE *fp;
	    Str fn = Strnew_charp(path);
	    char *t0;

	    Strshrink(fn, slen);
	    t0 = guessContentType(fn->ptr);
	    if (t0 == NULL)
		t0 = "text/plain";
	    if (strncasecmp(t0, "application/", 12) == 0) {
		return fopen(path, "r");
	    }
	    fp = fopen(path, "r");
	    if (close_rout)
		*close_rout = (void (*)()) pclose;
	    return gunzip_stream(fp, cmpst);
	}
	if (getenv("LESSOPEN") != NULL) {
	    FILE *fp = lessopen_stream(path);
	    if (fp != NULL) {
		return fp;
	    }
	}
    }
    return fopen(path, "r");
}

/* 
 * convert line
 */
Str
convertLine(URLFile * uf, Str line, char *code)
{
#ifdef JP_CHARSET
    char ic;
#endif
    char *l = line->ptr;
    if (uf->encoding != ENC_7BIT) {
	switch (uf->encoding) {
	case ENC_BASE64:
	    Strchop(line);
	    line = decodeB(&l);
	    break;
	case ENC_QUOTE:
	    line = decodeQP(&l);
	    break;
	}
    }
#ifdef JP_CHARSET
    if ((ic = checkShiftCode(line->ptr, *code)) != '\0')
	line = conv(line->ptr, (*code = ic), InnerCode);
#endif				/* JP_CHARSET */
#ifdef USE_NNTP
    if (uf->scheme == SCM_NEWS)
	Strchop(line);
#endif				/* USE_NNTP */
    return line;
}

/* 
 * loadFile: load file to buffer
 */
Buffer *
loadFile(char *path)
{
    URLFile uf;
    uf.compression = 0;
    uf.stream.f = examineFile(path, &uf.close);
    uf.stream_type = SMT_FILE;
    if (uf.stream.f == NULL)
	return NULL;
    uf.scheme = SCM_LOCAL;
    uf.iseof = FALSE;
    uf.encoding = ENC_7BIT;
    /* uf.close = (void(*)())fclose; */
    current_content_length = 0;
    return loadSomething(&uf, path, loadBuffer, NULL);
}

#ifdef USE_COOKIE
static int
matchattr(char *p, char *attr, int len, Str * value)
{
    int quoted;
    char *q = NULL;

    if (strncasecmp(p, attr, len) == 0) {
	p += len;
	SKIP_BLANKS(p);
	if (value) {
	    *value = Strnew();
	    if (*p == '=') {
		p++;
		SKIP_BLANKS(p);
		quoted = 0;
		while (!IS_ENDL(*p) && (quoted || *p != ';')) {
		    if (!IS_SPACE(*p))
			q = p;
		    if (*p == '"')
			quoted = (quoted) ? 0 : 1;
		    else
			Strcat_char(*value, *p);
		    p++;
		}
		if (q)
		    Strshrink(*value, p - q - 1);
	    }
	    return 1;
	}
	else {
	    if (IS_ENDT(*p)) {
		return 1;
	    }
	}
    }
    return 0;
}
#endif				/* USE_COOKIE */

void
readHeader(URLFile * uf,
	   Buffer * newBuf,
	   int thru,
	   ParsedURL * pu)
{
    char *p, *q;
    char c;
    Str lineBuf2 = NULL;
    Str tmp;
    TextList *headerlist;
#ifdef JP_CHARSET
    char code = '\0', ic;
#endif
    extern int w3m_dump_head;

    headerlist = newBuf->document_header = newTextList();
    if (uf->scheme == SCM_HTTP
#ifdef USE_SSL
	|| uf->scheme == SCM_HTTPS
#endif				/* USE_SSL */
	)
	http_response_code = -1;
    else
	http_response_code = 0;

    while (!uf->iseof) {
	tmp = StrmyUFgets(uf);
#ifdef HTTP_DEBUG
	{
	    FILE *ff;
	    ff = fopen("zzrequest", "a");
	    Strfputs(tmp, ff);
	    fclose(ff);
	}
#endif				/* HTTP_DEBUG */
	if ((tmp->ptr[0] == '\n' ||
	     tmp->ptr[0] == '\r' ||
	     tmp->ptr[0] == '\0')
#ifdef USE_NNTP
	    ||
	    (uf->scheme == SCM_NEWS &&
	     Str_news_endline(tmp) &&
	     (uf->iseof = TRUE))
#endif				/* USE_NNTP */
	    ) {
	    if (!lineBuf2)
		/* there is no header */
		break;
	    /* last header */
	}
	else if (!w3m_dump_head) {
	    if (lineBuf2) {
		Strcat(lineBuf2, tmp);
	    }
	    else {
		lineBuf2 = tmp;
	    }
	    c = UFgetc(uf);
	    UFundogetc(uf);
	    if (c == ' ' || c == '\t')
		/* header line is continued */
		continue;
	    lineBuf2 = decodeMIME(lineBuf2->ptr);
#ifdef JP_CHARSET
	    if ((ic = checkShiftCode(lineBuf2->ptr, code)) != '\0')
		lineBuf2 = conv(lineBuf2->ptr, (code = ic), InnerCode);
#endif				/* JP_CHARSET */
	    /* separated with line and stored */
	    tmp = Strnew_size(lineBuf2->length);
	    for (p = lineBuf2->ptr; *p; p = q) {
		for (q = p; *q && *q != '\r' && *q != '\n'; q++);
		lineBuf2 = checkType(p, propBuffer, min(LINELEN, q - p));
		Strcat(tmp, lineBuf2);
		if (thru)
		    addnewline(newBuf, p, propBuffer, q - p, -1);
		for (; *q && (*q == '\r' || *q == '\n'); q++);
	    }
	    lineBuf2 = tmp;
	}
	else {
	    lineBuf2 = tmp;
	}
	if ((uf->scheme == SCM_HTTP
#ifdef USE_SSL
	     || uf->scheme == SCM_HTTPS
#endif				/* USE_SSL */
	    ) && http_response_code == -1) {
	    p = lineBuf2->ptr;
	    while (*p && !IS_SPACE(*p))
		p++;
	    while (*p && IS_SPACE(*p))
		p++;
	    http_response_code = atoi(p);
	    if (fmInitialized) {
		message(lineBuf2->ptr, 0, 0);
		refresh();
	    }
	}
	if (!strncasecmp(lineBuf2->ptr, "content-transfer-encoding:", 26)) {
	    p = lineBuf2->ptr + 26;
	    while (IS_SPACE(*p))
		p++;
	    if (!strncasecmp(p, "base64", 6))
		uf->encoding = ENC_BASE64;
	    else if (!strncasecmp(p, "quoted-printable", 16))
		uf->encoding = ENC_QUOTE;
	    else
		uf->encoding = ENC_7BIT;
	}
	else if (!strncasecmp(lineBuf2->ptr, "content-encoding:", 17)) {
	    p = lineBuf2->ptr + 17;
	    while (IS_SPACE(*p))
		p++;
	    if ((!strncasecmp(p, "x-gzip", 6) || !strncasecmp(p, "gzip", 4)) ||
		(!strncasecmp(p, "x-compress", 10) || !strncasecmp(p, "compress", 8))) {
		uf->compression = CMP_GZIP;
	    }
	    else if (!strncasecmp(p, "x-bzip", 6) ||
		     !strncasecmp(p, "bzip", 4) ||
		     !strncasecmp(p, "bzip2", 5)) {
		uf->compression = CMP_BZIP2;
	    }

	}
#ifdef USE_COOKIE
	else if (use_cookie && accept_cookie &&
		 (!strncasecmp(lineBuf2->ptr, "Set-Cookie:", 11) ||
		  !strncasecmp(lineBuf2->ptr, "Set-Cookie2:", 12))) {
	    Str name = Strnew(), value = Strnew(), domain = NULL, path = NULL,
	     comment = NULL, commentURL = NULL, port = NULL, tmp;
	    int version, quoted, flag = 0;
	    time_t expires = (time_t) - 1;

	    q = NULL;
	    if (lineBuf2->ptr[10] == '2') {
		p = lineBuf2->ptr + 12;
		version = 1;
	    }
	    else {
		p = lineBuf2->ptr + 11;
		version = 0;
	    }
#ifdef DEBUG
	    fprintf(stderr, "Set-Cookie: [%s]\n", p);
#endif				/* DEBUG */
	    SKIP_BLANKS(p);
	    while (*p != '=' && !IS_ENDT(*p))
		Strcat_char(name, *(p++));
	    while (name->length > 0 && IS_SPACE(Strlastchar(name)))
		Strshrink(name, 1);
	    if (*p == '=') {
		p++;
		SKIP_BLANKS(p);
		quoted = 0;
		while (!IS_ENDL(*p) && (quoted || *p != ';')) {
		    if (!IS_SPACE(*p))
			q = p;
		    if (*p == '"')
			quoted = (quoted) ? 0 : 1;
		    Strcat_char(value, *(p++));
		}
		if (q)
		    Strshrink(value, p - q - 1);
	    }
	    while (*p == ';') {
		p++;
		SKIP_BLANKS(p);
		if (matchattr(p, "expires", 7, &tmp)) {
		    expires = mymktime(tmp->ptr);
		}
		else if (matchattr(p, "max-age", 7, &tmp)) {
		    expires = time(NULL) + atol(tmp->ptr);
		}
		else if (matchattr(p, "domain", 6, &tmp)) {
		    domain = tmp;
		}
		else if (matchattr(p, "path", 4, &tmp)) {
		    path = tmp;
		}
		else if (matchattr(p, "secure", 6, NULL)) {
		    flag |= COO_SECURE;
		}
		else if (matchattr(p, "comment", 7, &tmp)) {
		    comment = tmp;
		}
		else if (matchattr(p, "version", 7, &tmp)) {
		    version = atoi(tmp->ptr);
		}
		else if (matchattr(p, "port", 4, &tmp)) {
		    port = tmp;
		}
		else if (matchattr(p, "commentURL", 10, &tmp)) {
		    commentURL = tmp;
		}
		else if (matchattr(p, "discard", 7, NULL)) {
		    flag |= COO_DISCARD;
		}
		quoted = 0;
		while (!IS_ENDL(*p) && (quoted || *p != ';')) {
		    if (*p == '"')
			quoted = (quoted) ? 0 : 1;
		    p++;
		}
	    }
	    if (pu && name->length > 0) {
		if (flag & COO_SECURE)
		    disp_message_nsec("Received a secured cookie", FALSE, 1, TRUE, FALSE);
		else
		    disp_message_nsec(Sprintf("Received cookie: %s=%s",
		     name->ptr, value->ptr)->ptr, FALSE, 1, TRUE, FALSE);
		if (add_cookie(pu, name, value, expires, domain, path, flag,
			       comment, version, port, commentURL))
		    disp_message_nsec("This cookie was rejected "
				      "to prevent security violation.", FALSE, 10, TRUE, FALSE);
	    }
	}
#endif				/* USE_COOKIE */
	else if (!strncasecmp(lineBuf2->ptr, "w3m-control:", 12) &&
		 uf->scheme == SCM_LOCAL_CGI) {
	    Str funcname = Strnew();
	    int f;
	    extern int w3mNFuncList;

	    p = lineBuf2->ptr + 12;
	    SKIP_BLANKS(p);
	    while (*p && !IS_SPACE(*p))
		Strcat_char(funcname, *(p++));
	    SKIP_BLANKS(p);
	    f = getFuncList(funcname->ptr, w3mFuncList, w3mNFuncList);
	    if (f >= 0) {
		tmp = Strnew_charp(p);
		Strchop(tmp);
		pushEvent(f, tmp->ptr);
	    }
	}
	if (headerlist)
	    pushText(headerlist, lineBuf2->ptr);
	Strfree(lineBuf2);
	lineBuf2 = NULL;
    }
    if (thru)
	addnewline(newBuf, "\n", propBuffer, 1, -1);
}

char *
checkHeader(Buffer * buf, char *field)
{
    int len = strlen(field);
    TextListItem *i;
    char *p;

    if (buf == NULL || field == NULL)
	return NULL;
    for (i = buf->document_header->first; i != NULL; i = i->next) {
	if (!strncasecmp(i->ptr, field, len)) {
	    p = i->ptr + len;
	    SKIP_BLANKS(p);
	    return p;
	}
    }
    return NULL;
}

char *
checkContentType(Buffer * buf)
{
    char *p;
    Str r;
    p = checkHeader(buf, "Content-Type:");
    if (p == NULL)
	return NULL;
    r = Strnew();
    while (*p && *p != ';' && !IS_SPACE(*p))
	Strcat_char(r, *p++);
#ifdef JP_CHARSET
    if ((strcasestr(p, "charset")) != NULL) {
	p += 7;
	SKIP_BLANKS(p);
	if (*p == '=')
	    p++;
	SKIP_BLANKS(p);
	content_charset = guess_charset(p);
    }
    else {
	content_charset = '\0';
    }
#endif
    return r->ptr;
}

static Str
extractRealm(char *q)
{
    Str p = Strnew();
    char c;

    SKIP_BLANKS(q);
    if (strncasecmp(q, "Basic ", 6) != 0) {
	/* complicated authentication... not implemented */
	return NULL;
    }
    q += 6;
    SKIP_BLANKS(q);
    if (strncasecmp(q, "realm=", 6) != 0) {
	/* no realm attribute... get confused */
	return NULL;
    }
    q += 6;
    SKIP_BLANKS(q);
    c = '\0';
    if (*q == '"')
	c = *q++;
    while (*q != '\0' && *q != c)
	Strcat_char(p, *q++);
    return p;
}

static Str
getAuthCookie(char *realm, char *auth_header, TextList * extra_header, ParsedURL * pu)
{
    Str ss;
    Str uname, pwd;
    Str tmp;
    TextListItem *i, **i0;
    int a_found;
    int auth_header_len = strlen(auth_header);

    a_found = FALSE;
    for (i0 = &(extra_header->first), i = *i0; i != NULL; i0 = &(i->next), i = *i0) {
	if (!strncasecmp(i->ptr, auth_header, auth_header_len)) {
	    a_found = TRUE;
	    break;
	}
    }
    if (a_found) {
	/* This means that *-Authenticate: header is received after *
	 * Authorization: header is sent to the server. */
	if (fmInitialized) {
	    message("Wrong username or password", 0, 0);
	    refresh();
	}
	else
	    fprintf(stderr, "Wrong username or password\n");
	sleep(1);
	ss = NULL;
	*i0 = i->next;		/* delete Authenticate: header from *
				 * extra_header */
    }
    else
	ss = find_auth_cookie(pu->host, realm);
    if (ss == NULL) {
	/* input username and password */
	if (fmInitialized) {
	    char *pp;
	    term_raw();
	    if ((pp = inputStr("Username: ", NULL)) == NULL)
		return NULL;
	    uname = Strnew_charp(pp);
	    if ((pp = inputLine("Password: ", NULL, IN_PASSWORD)) == NULL)
		return NULL;
	    pwd = Strnew_charp(pp);
	    term_cbreak();
	}
	else {
	    printf("Username: ");
	    fflush(stdout);
	    uname = Strfgets(stdin);
	    Strchop(uname);
	    pwd = Strnew_charp((char *) getpass("Password: "));
	}
	Strcat_char(uname, ':');
	Strcat(uname, pwd);
	ss = encodeB(uname->ptr);
    }
    tmp = Strnew_charp(auth_header);
    Strcat_charp(tmp, " Basic ");
    Strcat(tmp, ss);
    Strcat_charp(tmp, "\r\n");
    pushText(extra_header, tmp->ptr);
    return ss;
}

/* 
 * loadGeneralFile: load file to buffer
 */
Buffer *
loadGeneralFile(char *path, ParsedURL * current, char *referer, int flag, FormList * request)
{
    URLFile f, *of = NULL;
    ParsedURL pu;
    Buffer *b = NULL, *(*proc) ();
    void (*closep) () = (void (*)()) fclose;
    char *tpath;
    char *extviewer;
    char *t, *p;
    Buffer *t_buf = NULL;
    int searchHeader = SearchHeader;
    int searchHeader_through = TRUE;
    MySignalHandler(*prevtrap) ();
    TextList *extra_header = newTextList();
    Str ss;
    Str realm;
    int add_auth_cookie_flag;
    char status = HTST_NORMAL;
    URLOption url_option;
    Str tmp;
    extern int w3m_dump;

    tpath = path;
    prevtrap = NULL;
    add_auth_cookie_flag = 0;

    if (proxy_auth_cookie != NULL) {
	pushText(extra_header, Sprintf("Proxy-Authorization: Basic %s\r\n",
				       proxy_auth_cookie->ptr)->ptr);
    }
  load_doc:
    url_option.referer = referer;
    url_option.flag = flag;
    f = openURL(tpath, &pu, current, &url_option, request, extra_header, of, &status);
#ifdef JP_CHARSET
    content_charset = '\0';
#endif
    if (f.stream.f == NULL) {
        /* openURL failure: it means either (1) the requested URL is a directory name
         * on an FTP server, or (2) is a local directory name. 
         */
	extern Str FTPDIRtmp;
	if (fmInitialized && prevtrap) {
	    term_raw();
	    signal(SIGINT, prevtrap);
	}
	switch (f.scheme) {
	case SCM_FTPDIR:
	    if (FTPDIRtmp->length > 0) {
		b = loadHTMLString(FTPDIRtmp->ptr);
		if (b) {
		    if (b->currentURL.host == NULL && b->currentURL.file == NULL)
			copyParsedURL(&b->currentURL, &pu);
		    b->real_scheme = pu.scheme;
		}
		return b;
	    }
	    break;
	case SCM_LOCAL:
	    {
		struct stat st;
		if (stat(pu.file, &st) < 0)
		    return NULL;
		if (S_ISDIR(st.st_mode)) {
		    if (UseExternalDirBuffer) {
			Str tmp = Strnew_charp(DirBufferCommand);
			Strcat_m_charp(tmp, "?",
				       pu.file,
				       "#current",
				       NULL);
			return loadGeneralFile(tmp->ptr, NULL, NO_REFERER, 0, NULL);
		    }
		    else {
			b = dirBuffer(pu.file);
			if (b == NULL)
			    return NULL;
			t = "text/html";
			b->real_scheme = pu.scheme;
			goto loaded;
		    }
		}
	    }
	}
	return NULL;
    }

    /* openURL() succeeded */
    if (SETJMP(AbortLoading) != 0) {
        /* transfer interrupted */
	if (fmInitialized) {
	    term_raw();
	    signal(SIGINT, prevtrap);
	}
	if (b)
	    discardBuffer(b);
	return NULL;
    }

    b = NULL;
    if (f.is_cgi) {
	/* local CGI */
	searchHeader = TRUE;
	searchHeader_through = FALSE;
    }
    if (fmInitialized) {
	prevtrap = signal(SIGINT, KeyAbort);
	term_cbreak();
    }
    if (pu.scheme == SCM_HTTP ||
#ifdef USE_SSL
	pu.scheme == SCM_HTTPS ||
#endif				/* USE_SSL */
	((
#ifdef USE_GOPHER
	  (pu.scheme == SCM_GOPHER && non_null(GOPHER_proxy)) ||
#endif				/* USE_GOPHER */
	  (pu.scheme == SCM_FTP && non_null(FTP_proxy))
	 ) && !Do_not_use_proxy && !check_no_proxy(pu.host))) {

	if (fmInitialized) {
	    message(Sprintf("%s contacted. Waiting for reply...", pu.host)->ptr, 0, 0);
	    refresh();
	}
	if (t_buf == NULL)
	    t_buf = newBuffer(INIT_BUFFER_WIDTH);
	readHeader(&f, t_buf, FALSE, &pu);
	t = checkContentType(t_buf);
	if (t == NULL)
	    t = "text/plain";
	if ((p = checkHeader(t_buf, "Location:")) != NULL) {
	    /* document moved */
	    tmp = Strnew_charp(p);
	    Strchop(tmp);
	    tpath = tmp->ptr;
	    request = NULL;
	    UFclose(&f);
	    add_auth_cookie_flag = 0;
	    current = New(ParsedURL);
	    copyParsedURL(current, &pu);
	    t_buf->bufferprop |= BP_REDIRECTED;
	    goto load_doc;
	}
	if ((p = checkHeader(t_buf, "WWW-Authenticate:")) != NULL &&
	    http_response_code == 401) {
	    /* Authentication needed */
	    realm = extractRealm(p);
	    if (realm != NULL) {
		ss = getAuthCookie(realm->ptr, "Authorization:", extra_header, &pu);
		if (ss == NULL) {
		    /* abort */
		    UFclose(&f);
		    signal(SIGINT, prevtrap);
		    return NULL;
		}
		UFclose(&f);
		add_auth_cookie_flag = 1;
		goto load_doc;
	    }
	}
	if ((p = checkHeader(t_buf, "Proxy-Authenticate:")) != NULL &&
	    http_response_code == 407) {
	    /* Authentication needed */
	    realm = extractRealm(p);
	    if (realm != NULL) {
		ss = getAuthCookie(realm->ptr,
				   "Proxy-Authorization:",
				   extra_header,
				   &HTTP_proxy_parsed);
		proxy_auth_cookie = ss;
		if (ss == NULL) {
		    /* abort */
		    UFclose(&f);
		    signal(SIGINT, prevtrap);
		    return NULL;
		}
		UFclose(&f);
		goto load_doc;
	    }
	}
	if (add_auth_cookie_flag)
	    /* If authorization is required and passed */
	    add_auth_cookie(pu.host, realm->ptr, ss);
	if (status == HTST_CONNECT) {
	    of = &f;
	    goto load_doc;
	}
    }
#ifdef USE_NNTP
    else if (pu.scheme == SCM_NEWS) {
	t_buf = newBuffer(INIT_BUFFER_WIDTH);
	readHeader(&f, t_buf, TRUE, &pu);
	t = checkContentType(t_buf);
	if (t == NULL)
	    t = "text/plain";
    }
#endif				/* USE_NNTP */
#ifdef USE_GOPHER
    else if (pu.scheme == SCM_GOPHER) {
	switch (*pu.file) {
	case '0':
	    t = "text/plain";
	    break;
	case '1':
	    t = "gopher:directory";
	    break;
	case 'm':
	    t = "gopher:directory";
	    break;
	case 's':
	    t = "audio/basic";
	    break;
	case 'g':
	    t = "image/gif";
	    break;
	case 'h':
	    t = "text/html";
	    break;
	}
    }
#endif				/* USE_GOPHER */
    else if (pu.scheme == SCM_FTP) {
	    t = guessContentType(pu.file);
	    closep = (void (*)()) closeFTP;
	    if (t == NULL)
		t = "text/plain";
	    else if (!strncasecmp(t, "application/", 12)) {
		char *tmpf;
		current_content_length = 0;
		tmpf = FTP2tmp(f.stream.f);
		if (fmInitialized) {
		    term_raw();
		    signal(SIGINT, prevtrap);
		}
		doFileMove(tmpf, guess_save_name(pu.file));
		return NO_BUFFER;
	    }
    }
    else if (searchHeader) {
	t_buf = newBuffer(INIT_BUFFER_WIDTH);
	readHeader(&f, t_buf, searchHeader_through, &pu);
	t = checkContentType(t_buf);
	if (t == NULL)
	    t = "text/plain";
	searchHeader = SearchHeader = FALSE;
    }
    else if (DefaultType) {
	t = DefaultType;
	DefaultType = NULL;
    }
    else {
	t = guessContentType(pu.file);
	if (t == NULL)
	    t = "text/plain";
	if (strcasecmp(t, "application/x-gzip") == 0 ||
	    strcasecmp(t, "application/x-compress") == 0 ||
	    strcasecmp(t, "application/x-bzip") == 0) {
	    Str fn = Strnew_charp(pu.file);
	    char *t0;
	    if (strcasecmp(t, "application/x-gzip") == 0) {
		Strshrink(fn, 3);
	    }
	    else if (strcasecmp(t, "application/x-bzip") == 0) {
		Strshrink(fn, 4);
	    }
	    else {
		Strshrink(fn, 2);
	    }
	    t0 = guessContentType(fn->ptr);
	    if (t0 == NULL) {
		t = "text/plain";
	    }
	    else {
		if (strncasecmp(t0, "application/", 12) != 0) {
		    t = t0;
		}
	    }
	}
    }
    proc = loadBuffer;

    if (do_download) {
	/* download only */
	if (fmInitialized) {
	    term_raw();
	    signal(SIGINT, prevtrap);
	}
	doFileSave(f, guess_save_name(pu.file));
	UFclose0(&f, closep);
	return NO_BUFFER;
    }
    if (!strcasecmp(t, "text/plain") || *t == '\0')
	proc = loadBuffer;
    else if (!strcasecmp(t, "text/html"))
	proc = loadHTMLBuffer;
#ifdef USE_GOPHER
    else if (!strcasecmp(t, "gopher:directory")) {
	proc = loadGopherDir;
    }
#endif				/* USE_GOPHER */
    else if (!w3m_dump) {
	extviewer = searchExtViewer(t);
	if (extviewer && !do_download) {
	    if (f.compression != CMP_NOCOMPRESS) {
		FILE *f2 = f.stream.f;
		f.stream.f = gunzip_stream(f2, f.compression);
		f.close = (void (*)()) pclose;
	    }
	    doExternal(f, extviewer);
	    if (f.stream.f) {
		if (f.compression != CMP_NOCOMPRESS) {
		    f.close(f.stream.f);
		}
		else {
		    UFclose0(&f, closep);
		}
		f.stream.f = NULL;
	    }
	    f.compression = CMP_NOCOMPRESS;
	    if (fmInitialized) {
		term_raw();
		signal(SIGINT, prevtrap);
	    }
	    return NO_BUFFER;
	}
	else {
	    f.compression = CMP_NOCOMPRESS;
	    if (fmInitialized) {
		term_raw();
		signal(SIGINT, prevtrap);
	    }
	    doFileSave(f, guess_save_name(pu.file));
	    UFclose0(&f, closep);
	    return NO_BUFFER;
	}
    }

    current_content_length = 0;
    if ((p = checkHeader(t_buf, "Content-Length:")) != NULL)
	current_content_length = atoi(p);

    if (f.compression != CMP_NOCOMPRESS) {
	FILE *f2 = f.stream.f;
	f.stream.f = gunzip_stream(f2, f.compression);
	f.close = (void (*)()) pclose;
    }
    b = loadSomething(&f, pu.file, proc, t_buf);
    if (f.stream.f) {
	if (f.compression != CMP_NOCOMPRESS) {
	    f.close(f.stream.f);
	}
	else {
	    UFclose0(&f, closep);
	}
	f.stream.f = NULL;
    }
    f.compression = CMP_NOCOMPRESS;
    if (b) {
	b->real_scheme = f.scheme;
      loaded:
	if (b->currentURL.host == NULL && b->currentURL.file == NULL)
	    copyParsedURL(&b->currentURL, &pu);
	if (!strcmp(t, "text/html"))
	    b->type = "text/html";
	else
	    b->type = "text/plain";
	if (proc == loadHTMLBuffer && pu.label) {
	    Anchor *a;
#ifdef JP_CHARSET
	    a = searchURLLabel(b, conv(pu.label, b->document_code, InnerCode)->ptr);
#else				/* not JP_CHARSET */
	    a = searchURLLabel(b, pu.label);
#endif				/* not JP_CHARSET */
	    if (a != NULL) {
		gotoLine(b, a->start.line);
		b->pos = a->start.pos;
		arrangeCursor(b);
	    }
	}
    }
    if (fmInitialized) {
	term_raw();
	signal(SIGINT, prevtrap);
    }
    return b;
}

#define TAG_IS(s,tag,len)\
  (strncasecmp(s,tag,len)==0&&(s[len] == '>' || IS_SPACE((int)s[len])))

static char *
has_hidden_link(struct readbuffer *obuf, int cmd)
{
    Str line = obuf->line;
    struct link_stack *p;

    if (Strlastchar(line) != '>')
	return NULL;

    for (p = link_stack; p; p = p->next)
	if (p->cmd == cmd)
	    break;
    if (!p)
	return NULL;

    if (obuf->pos == p->pos)
	return line->ptr + p->offset;

    return NULL;
}

static void
push_link(int cmd, int offset, int pos)
{
    struct link_stack *p;
    p = New(struct link_stack);
    p->cmd = cmd;
    p->offset = offset;
    p->pos = pos;
    p->next = link_stack;
    link_stack = p;
}

static int
is_period_char(char ch, Lineprop mode)
{
    if (mode != PC_ASCII)
	return 0;

    switch (ch) {
    case ',':
    case '.':
    case ':':
    case ';':
    case '?':
    case '!':
    case ')':
    case ']':
    case '}':
	return 1;
    default:
	return 0;
    }
}

static int
is_beginning_char(char ch, Lineprop mode)
{
    if (mode != PC_ASCII)
	return 0;

    switch (ch) {
    case '(':
    case '[':
    case '{':
    case '`':
	return 1;
    default:
	return 0;
    }
}

static int
is_word_char(int ch, Lineprop mode)
{
    if (mode != PC_ASCII)
	return 0;

    if (isalnum(ch))
	return 1;

    switch (ch) {
    case ',':
    case '.':
    case '\"':			/* " */
    case '\'':
    case '$':
    case '%':
    case '+':
    case '-':
    case '@':
    case '~':
    case '_':
	return 1;
    }
    /* ISO-8859-1 alphabet characters */
    if (ch < 0)
	ch += 256;
    if (ch == 128 + 87 /* times */  || ch == 128 + 119 /* divide */ )
	return 0;
    if (128 + 64 <= ch || ch == 128 + 32 /* no-break space */ )
	return 1;
    return 0;
}

int
is_boundary(char ch1, Lineprop mode1, char ch2, Lineprop mode2)
{
    if (!ch1 || !ch2)
	return 1;

    if (ch1 == ' ' && ch2 == ' ')
	return 0;

#ifdef JP_CHARSET
    if (mode1 == PC_KANJI1)
	return 0;

    if ((mode1 == PC_KANJI2 || (mode1 == PC_ASCII && !IS_SPACE(ch1))) &&
	is_period_char(ch2, mode2))
	return 0;

    if ((mode2 == PC_KANJI1 || (mode2 == PC_ASCII && !IS_SPACE(ch2))) &&
	is_beginning_char(ch1, mode1))
	return 0;
#else				/* not JP_CHARSET */
    if (mode1 == PC_ASCII && !IS_SPACE(ch1) &&
	is_period_char(ch2, mode2))
	return 0;

    if (mode2 == PC_ASCII && !IS_SPACE(ch2) &&
	is_beginning_char(ch1, mode2))
	return 0;
#endif				/* not JP_CHARSET */

    if (is_word_char(ch1, mode1) &&
	is_word_char(ch2, mode2))
	return 0;

    return 1;
}


static void
set_breakpoint(struct readbuffer *obuf, int tag_length)
{
    obuf->bp.len = obuf->line->length;
    obuf->bp.pos = obuf->pos;
    obuf->bp.tlen = tag_length;

    if (!obuf->bp.init_flag)
	return;

    obuf->bp.flag = obuf->flag;
#ifdef FORMAT_NICE
    obuf->bp.flag &= ~RB_FILL;
#endif				/* FORMAT_NICE */
    obuf->bp.anchor = obuf->anchor;
    obuf->bp.anchor_target = obuf->anchor_target;
    obuf->bp.anchor_hseq = obuf->anchor_hseq;
    obuf->bp.img_alt = obuf->img_alt;
    obuf->bp.in_bold = obuf->in_bold;
    obuf->bp.in_under = obuf->in_under;
    obuf->bp.nobr_level = obuf->nobr_level;
    obuf->bp.prev_ctype = obuf->prev_ctype;
    obuf->bp.init_flag = 0;
}

static void
back_to_breakpoint(struct readbuffer *obuf)
{
    obuf->flag = obuf->bp.flag;
    obuf->anchor = obuf->bp.anchor;
    obuf->anchor_target = obuf->bp.anchor_target;
    obuf->anchor_hseq = obuf->bp.anchor_hseq;
    obuf->img_alt = obuf->bp.img_alt;
    obuf->in_bold = obuf->bp.in_bold;
    obuf->in_under = obuf->bp.in_under;
    obuf->prev_ctype = obuf->bp.prev_ctype;
    obuf->pos = obuf->bp.pos;
    if (obuf->flag & RB_NOBR)
	obuf->nobr_level = obuf->bp.nobr_level;
}

static void
append_tags(struct readbuffer *obuf)
{
    int i;
    int len = obuf->line->length;

    for (i = 0; i < obuf->tag_sp; i++) {
	switch (obuf->tag_stack[i]->cmd) {
	case HTML_A:
	case HTML_IMG_ALT:
	case HTML_B:
	case HTML_U:
	    push_link(obuf->tag_stack[i]->cmd, obuf->line->length, obuf->pos);
	    break;
	}
	Strcat_charp(obuf->line, obuf->tag_stack[i]->cmdname);
	switch (obuf->tag_stack[i]->cmd) {
	case HTML_NOBR:
	    if (obuf->nobr_level > 1)
		break;
	case HTML_WBR:
	    set_breakpoint(obuf, obuf->line->length - len);
	    break;
	}
    }
    obuf->tag_sp = 0;
}

static void
push_tag(struct readbuffer *obuf, char *cmdname, int cmd)
{
    obuf->tag_stack[obuf->tag_sp] = New(struct cmdtable);
    obuf->tag_stack[obuf->tag_sp]->cmdname = allocStr(cmdname, 0);
    obuf->tag_stack[obuf->tag_sp]->cmd = cmd;
    obuf->tag_sp++;
    if (obuf->tag_sp >= TAG_STACK_SIZE ||
	obuf->flag & (RB_SPECIAL & ~RB_NOBR))
	append_tags(obuf);
}

static void
push_nchars(struct readbuffer *obuf, int width,
	    char *str, int len, Lineprop mode)
{
    append_tags(obuf);
    Strcat_charp_n(obuf->line, str, len);
    obuf->pos += width;
    if (width > 0) {
	obuf->prevchar = Strlastchar(obuf->line);
	obuf->prev_ctype = mode;
    }
}

#define push_charp(obuf, width, str, mode)\
push_nchars(obuf, width, str, strlen(str), mode)

#define push_str(obuf, width, str, mode)\
push_nchars(obuf, width, str->ptr, str->length, mode)

#define push_kanji(obuf, kanji)\
push_nchars(obuf, 2, kanji, 2, PC_KANJI2)

static void
push_char(struct readbuffer *obuf, int pre_mode,
	  int width, char ch, Lineprop mode)
{
    int tlen, len = obuf->line->length;
    Lineprop pmode = obuf->prev_ctype;
    char pch = obuf->prevchar;

    append_tags(obuf);

    tlen = obuf->line->length - len;

    if (pch == ' ')
	pmode = PC_ASCII;

    if (tlen > 0) {
	pch = '\0';
	pmode = PC_CTRL;
    }

    if (!pre_mode && is_boundary(pch, pmode, ch, mode))
	set_breakpoint(obuf, tlen);

    Strcat_char(obuf->line, ch);
    obuf->pos += width;
    if (width > 0) {
	obuf->prevchar = ch;
	if (ch != ' ')
	    obuf->prev_ctype = mode;
    }
}

#define PUSH(c) push_char(obuf, obuf->flag & RB_SPECIAL, 1, c, PC_ASCII)

static void
passthrough(struct readbuffer *obuf, char *str, int back)
{
    Str tok = Strnew();
    int status = R_ST_NORMAL, cmd;

    if (back) {
	Str str_save = Strnew_charp(str);
	Strshrink(obuf->line, obuf->line->ptr + obuf->line->length - str);
	str = str_save->ptr;
    }
    while (read_token(tok, &str, &status, 0, 0)) {
	char *p = tok->ptr;
	if (*p == '<') {
	    cmd = gethtmlcmd(&p, &status);
	    if (back) {
		struct link_stack *p;
		for (p = link_stack; p; p = p->next) {
		    if (p->cmd == cmd) {
			link_stack = p->next;
			break;
		    }
		}
		back = 0;
	    }
	    else {
		push_tag(obuf, tok->ptr, cmd);
	    }
	}
	else {
	    push_str(obuf, 0, tok, obuf->prev_ctype);
	}
    }
}

int
is_blank_line(char *line, int indent)
{
    int i, is_blank = 0;

    for (i = 0; i < indent; i++) {
	if (line[i] == '\0') {
	    is_blank = 1;
	}
	else if (line[i] != ' ') {
	    break;
	}
    }
    if (i == indent && line[i] == '\0')
	is_blank = 1;
    return is_blank;
}

void
flushline(struct html_feed_environ *h_env, struct readbuffer *obuf, int indent, int force, int width)
{
    TextList *buf = h_env->buf;
    FILE *f = h_env->f;
    int i;
    Str line = obuf->line, pass;
    char *hidden_anchor = NULL, *hidden_img = NULL, *hidden_bold = NULL,
    *hidden_under = NULL, *hidden = NULL;

    if (w3m_debug) {
	FILE *f = fopen("zzzproc1", "a");
	fprintf(f, "flushline(%s,%d,%d,%d)\n", obuf->line->ptr, indent, force, width);
	if (buf) {
	    TextListItem *p;
	    for (p = buf->first; p; p = p->next)
		fprintf(f, "buf=\"%s\"\n", p->ptr);
	}
	fclose(f);
    }

    if ((!(obuf->flag & (RB_SPECIAL & ~RB_NOBR)) && Strlastchar(obuf->line) == ' ')
#ifdef JP_CHARSET
	|| obuf->prev_ctype == PC_KANJI1
#endif				/* JP_CHARSET */
	) {
	Strshrink(obuf->line, 1);
	obuf->pos--;
    }

    append_tags(obuf);

    if (obuf->anchor)
	hidden = hidden_anchor = has_hidden_link(obuf, HTML_A);
    if (obuf->img_alt) {
	if ((hidden_img = has_hidden_link(obuf, HTML_IMG_ALT)) != NULL) {
	    if (!hidden || hidden_img < hidden)
		hidden = hidden_img;
	}
    }
    if (obuf->in_bold) {
	if ((hidden_bold = has_hidden_link(obuf, HTML_B)) != NULL) {
	    if (!hidden || hidden_bold < hidden)
		hidden = hidden_bold;
	}
    }
    if (obuf->in_under) {
	if ((hidden_under = has_hidden_link(obuf, HTML_U)) != NULL) {
	    if (!hidden || hidden_under < hidden)
		hidden = hidden_under;
	}
    }
    if (hidden) {
	pass = Strnew_charp(hidden);
	Strshrink(line, line->ptr + line->length - hidden);
    }

    if (!(obuf->flag & (RB_SPECIAL & ~RB_NOBR)) && obuf->pos > width) {
	char *tp = &obuf->line->ptr[obuf->bp.len - obuf->bp.tlen];
	char *ep = &obuf->line->ptr[obuf->line->length];

	if (obuf->bp.pos == obuf->pos && tp <= ep &&
	    tp > obuf->line->ptr && tp[-1] == ' ') {
	    bcopy(tp, tp - 1, ep - tp + 1);
	    obuf->line->length--;
	    obuf->pos--;
	}
    }

    if (obuf->anchor && !hidden_anchor)
	Strcat_charp(line, "</a>");
    if (obuf->img_alt && !hidden_img)
	Strcat_charp(line, "</img_alt>");
    if (obuf->in_bold && !hidden_bold)
	Strcat_charp(line, "</b>");
    if (obuf->in_under && !hidden_under)
	Strcat_charp(line, "</u>");

    if (RB_GET_ALIGN(obuf) == RB_CENTER) {
	line = Strnew_charp(align(line->ptr, width, ALIGN_CENTER));
    }
    else if (RB_GET_ALIGN(obuf) == RB_RIGHT) {
	line = Strnew_charp(align(line->ptr, width, ALIGN_RIGHT));
    }
#ifdef FORMAT_NICE
    else if (obuf->flag & RB_FILL) {
	char *p;
	int rest, rrest;
	int nspace, d, i;

	Strremovetrailingspaces(line);
	rest = width - line->length;
	if (rest > 1) {
	    nspace = 0;
	    for (p = line->ptr + indent; *p; p++) {
		if (*p == ' ')
		    nspace++;
	    }
	    if (nspace > 0) {
		int indent_here = 0;
		d = rest / nspace;
		p = line->ptr;
		while (IS_SPACE(*p)) {
		    p++;
		    indent_here++;
		}
		rrest = rest - d * nspace;
		line = Strnew_size(width + 1);
		for (i = 0; i < indent_here; i++)
		    Strcat_char(line, ' ');
		for (; *p; p++) {
		    Strcat_char(line, *p);
		    if (*p == ' ') {
			for (i = 0; i < d; i++)
			    Strcat_char(line, ' ');
			if (rrest > 0) {
			    Strcat_char(line, ' ');
			    rrest--;
			}
		    }
		}
	    }
	}
    }
#endif				/* FORMAT_NICE */
    if (force ||
	(obuf->pos > 0 && !is_blank_line(obuf->line->ptr, indent))) {
	if (buf)
	    pushText(buf, line->ptr);
	else
	    fprintf(f, "%s\n", line->ptr);
    }
    else {
	char *p = line->ptr;
	Str tmp = Strnew();
	int status, pre;

#define APPEND(str) (buf?(void)appendText(buf,str):(void)fputs(str,f))

	status = R_ST_NORMAL;
	pre = 0;
	while (read_token(tmp, &p, &status, pre, 0)) {
	    if (tmp->ptr[0] == '<')
		APPEND(tmp->ptr);
	}
    }
    obuf->line = Strnew_size(256);
    obuf->pos = 0;
    obuf->prevchar = ' ';
    obuf->bp.init_flag = 1;
    set_breakpoint(obuf, 0);
    obuf->prev_ctype = PC_ASCII;
    link_stack = NULL;
    for (i = 0; i < indent; i++)
	PUSH(' ');
    if (hidden)
	passthrough(obuf, pass->ptr, 0);
    if (!hidden_anchor && obuf->anchor) {
	Str tmp;
	if (obuf->anchor_hseq > 0)
	    obuf->anchor_hseq = -obuf->anchor_hseq;
	tmp = Sprintf("<A HSEQ=\"%d\" HREF=\"", obuf->anchor_hseq);
	Strcat(tmp, obuf->anchor);
	if (obuf->anchor_target) {
	    Strcat_charp(tmp, "\" TARGET=\"");
	    Strcat(tmp, obuf->anchor_target);
	}
	Strcat_charp(tmp, "\">");
	push_tag(obuf, tmp->ptr, HTML_A);
    }
    if (!hidden_img && obuf->img_alt) {
	Str tmp = Strnew_charp("<IMG_ALT SRC=\"");
	Strcat(tmp, obuf->img_alt);
	Strcat_charp(tmp, "\">");
	push_tag(obuf, tmp->ptr, HTML_IMG_ALT);
    }
    if (!hidden_bold && obuf->in_bold)
	push_tag(obuf, "<B>", HTML_B);
    if (!hidden_under && obuf->in_under)
	push_tag(obuf, "<U>", HTML_U);

}

static void
discardline(struct readbuffer *obuf, int indent)
{
    append_tags(obuf);
    Strclear(obuf->line);
    obuf->pos = 0;
    obuf->prevchar = ' ';
    obuf->bp.init_flag = 1;
    set_breakpoint(obuf, 0);
    obuf->prev_ctype = PC_ASCII;
    for (; indent; indent--) {
	PUSH(' ');
    }
}

void
do_blankline(struct html_feed_environ *h_env, struct readbuffer *obuf, int indent, int indent_incr, int width)
{
    TextList *buf = h_env->buf;
    FILE *f = h_env->f;

    if (buf && (buf->last == NULL || !is_blank_line(buf->last->ptr, indent + indent_incr)))
	flushline(h_env, obuf, indent, 1, width);
    else if (f)
	flushline(h_env, obuf, indent, 1, width);
}

void
fillline(struct html_feed_environ *h_env, struct readbuffer *obuf, int indent)
{
    int i;
    for (i = obuf->pos; i < indent; i++)
	PUSH(' ');
}

static int
close_effect0(struct readbuffer *obuf, int cmd)
{
    int i;
    char *p;

    for (i = obuf->tag_sp - 1; i >= 0; i--) {
	if (obuf->tag_stack[i]->cmd == cmd)
	    break;
    }
    if (i >= 0) {
	obuf->tag_sp--;
	bcopy(&obuf->tag_stack[i + 1], &obuf->tag_stack[i],
	      (obuf->tag_sp - i) * sizeof(struct cmdtable *));
	return 1;
    }
    else if ((p = has_hidden_link(obuf, cmd)) != NULL) {
	passthrough(obuf, p, 1);
	return 1;
    }
    return 0;
}

static void
close_anchor0(struct html_feed_environ *h_env, struct readbuffer *obuf)
{
    int i;
    char *p = NULL;

    if (obuf->anchor) {
	for (i = obuf->tag_sp - 1; i >= 0; i--) {
	    if (obuf->tag_stack[i]->cmd == HTML_A)
		break;
	}
	if (i >= 0 || (p = has_hidden_link(obuf, HTML_A))) {
	    if (obuf->anchor_hseq > 0) {
		HTMLlineproc1("&nbsp;", h_env);
		obuf->prevchar = ' ';
	    }
	    else {
		if (i >= 0) {
		    obuf->tag_sp--;
		    bcopy(&obuf->tag_stack[i + 1], &obuf->tag_stack[i],
			  (obuf->tag_sp - i) * sizeof(struct cmdtable *));
		}
		else {
		    passthrough(obuf, p, 1);
		}
		obuf->anchor = NULL;
		obuf->anchor_target = NULL;
	    }
	}
    }
}

void
save_fonteffect(struct html_feed_environ *h_env, struct readbuffer *obuf)
{
    if (obuf->fontstat_sp < FONT_STACK_SIZE)
	bcopy(obuf->fontstat, obuf->fontstat_stack[obuf->fontstat_sp],
	      FONTSTAT_SIZE);
    obuf->fontstat_sp++;
    if (obuf->in_bold)
	push_tag(obuf, "</b>", HTML_N_B);
    if (obuf->in_under)
	push_tag(obuf, "</u>", HTML_N_U);
    bzero(obuf->fontstat, FONTSTAT_SIZE);
}

void
restore_fonteffect(struct html_feed_environ *h_env, struct readbuffer *obuf)
{
    if (obuf->fontstat_sp > 0)
	obuf->fontstat_sp--;
    if (obuf->fontstat_sp < FONT_STACK_SIZE)
	bcopy(obuf->fontstat_stack[obuf->fontstat_sp], obuf->fontstat,
	      FONTSTAT_SIZE);
    if (obuf->in_bold)
	push_tag(obuf, "<b>", HTML_B);
    if (obuf->in_under)
	push_tag(obuf, "<u>", HTML_U);
}


Str
process_img(struct parsed_tagarg *targ)
{
    char *p, *q, *r, *r2;
    int w, i;
    struct parsed_tagarg *t;
    Str tmp = Strnew();

    p = q = r = NULL;
    w = i = -1;
    for (t = targ; t; t = t->next) {
	if (strcasecmp(t->arg, "src") == 0 && t->value)
	    p = t->value;
	else if (strcasecmp(t->arg, "alt") == 0 && t->value)
	    q = t->value;
	else if (strcasecmp(t->arg, "width") == 0 && t->value)
	    w = atoi(t->value);
	else if (strcasecmp(t->arg, "height") == 0 && t->value)
	    i = atoi(t->value);
	else if (strcasecmp(t->arg, "usemap") == 0 && t->value)
	    r = t->value;
    }
    if (p == NULL)
	return tmp;
    tmp = Strnew_size(128);
    if (r) {
	r2 = strchr(r, '#');
#ifdef NEW_FORM
	process_form(parse_tag("<form_int method=internal action=map>"));
	Strcat(tmp, Sprintf("<pre_int><input_alt fid=\"%d\" "
			    "type=hidden name=link value=\"",
			    cur_form_id));
	Strcat_charp(tmp, (r2) ? r2 + 1 : r);
	Strcat(tmp, Sprintf("\"><input_alt hseq=\"%d\" fid=\"%d\" "
			    "type=submit no_effect=true>",
			    cur_hseq++, cur_form_id));
#else				/* not NEW_FORM */
	Strcat_charp(tmp, "<form_int method=internal action=map>"
		   "<pre_int><input_alt type=hidden name=link value=\"");
	Strcat_charp(tmp, (r2) ? r2 + 1 : r);
	Strcat(tmp, Sprintf("\"><input_alt hseq=\"%d\" type=submit "
			    "no_effect=true>", cur_hseq++));
#endif				/* not NEW_FORM */
    }
    if ((q != NULL && *q != '\0') ||
	r != NULL) {
	Strcat_charp(tmp, "<img_alt src=\"");
    }
    else
	Strcat_charp(tmp, "<nobr><img_alt src=\"");
    Strcat_charp(tmp, p);
    Strcat_charp(tmp, "\">");
    if (q != NULL && *q != '\0') {
	Strcat_charp(tmp, htmlquote_str(q));
	Strcat_charp(tmp, "</img_alt> ");
	goto img_end2;
    }
    if (w > 0 && i > 0) {
	/* guess what the image is! */
	if (w < 32 && i < 48) {
	    /* must be an icon or space */
	    if (strcasestr(p, "space") || strcasestr(p, "blank"))
		Strcat_charp(tmp, "_</img_alt>");
	    else {
		if (w * i < 8 * 16)
		    Strcat_charp(tmp, "*</img_alt>");
		else {
#ifdef KANJI_SYMBOLS
		    Strcat_charp(tmp, "</img_alt>");
#else				/* not KANJI_SYMBOLS */
		    Strcat_charp(tmp, "#</img_alt>");
#endif				/* not KANJI_SYMBOLS */
		}
	    }
	    goto img_end1;
	}
	if (w > 200 && i < 13) {
	    /* must be a horizontal line */
	    Strcat_charp(tmp, "<hr></img_alt>");
	    goto img_end1;
	}
    }
    if (!ignore_null_img_alt) {
	/* XXX */
	Strcat_charp(tmp, "</img_alt>");
	goto img_end1;
    }
    for (q = p; *q; q++);
    while (q > p && *q != '/')
	q--;
    if (*q == '/')
	q++;
    Strcat_char(tmp, '[');
    p = q;
    for (; *q; q++) {
	if (!IS_ALNUM(*q) && *q != '_' && *q != '-') {
	    break;
	}
	else if (w > 0 && !IS_ALNUM(*q) && q - p + 2 > w / PIXEL_PER_CHAR) {
	    Strcat_charp(tmp, "..");
	    break;
	}
	Strcat_char(tmp, *q);
    }
    Strcat_charp(tmp, "]</img_alt>");
  img_end1:
    if (r == NULL)
	Strcat_charp(tmp, "</nobr>");
  img_end2:
    if (r) {
#ifdef NEW_FORM
	Strcat_charp(tmp, "</input_alt></pre_int>");
	process_n_form();
#else				/* not NEW_FORM */
	Strcat_charp(tmp, "</input_alt></pre_int></form_int>");
#endif				/* not NEW_FORM */
    }
    return tmp;
}

Str
process_anchor(char *tagbuf)
{
    Str tmp = Sprintf("<a hseq=\"%d\"", cur_hseq++);

    Strcat_charp(tmp, tagbuf + 2);

    return tmp;
}

Str
process_input(struct parsed_tagarg * targ)
{
    int i, w, v, x, y;
    char *q = NULL, *p = "text", *r = "", *p2 = NULL, *q2 = NULL;
    Str tmp;
    struct parsed_tagarg *t;

    w = 20;			/* default width */
    i = 20;
    x = y = 0;
    for (t = targ; t; t = t->next) {
	if (!strcasecmp(t->arg, "type") && t->value)
	    p = t->value;
	else if (!strcasecmp(t->arg, "value") && t->value)
	    q = t->value;
	else if (!strcasecmp(t->arg, "name") && t->value)
	    r = t->value;
	else if (!strcasecmp(t->arg, "checked"))
	    x = 1;
	else if (!strcasecmp(t->arg, "accept"))
	    y = 1;
	else if (!strcasecmp(t->arg, "size") && t->value)
	    w = atoi(t->value);
	else if (!strcasecmp(t->arg, "maxlength") && t->value)
	    i = atoi(t->value);
	else if (!strcasecmp(t->arg, "alt") && t->value)
	    p2 = t->value;
    }
    v = formtype(p);
    if (v == FORM_UNKNOWN)
	return NULL;

    if (!q) {
	switch (v) {
	case FORM_INPUT_IMAGE:
	case FORM_INPUT_SUBMIT:
	case FORM_INPUT_BUTTON:
	    q = "SUBMIT";
	    break;
	case FORM_INPUT_RESET:
	    q = "RESET";
	    break;
	    /* if no VALUE attribute is specified in * <INPUT
	     * TYPE=CHECHBOX> tag, then the value "on" is used * as a
	     * default value. It is not a part of HTML4.0 * specification, 
	     * but an imitation of Netscape * behaviour. */
	case FORM_INPUT_CHECKBOX:
	    q = "on";
	}
    }
    /* VALUE attribute is not allowed in <INPUT TYPE=FILE> tag. */
    if (v == FORM_INPUT_FILE)
	q = NULL;

    tmp = Strnew_charp("<pre_int>");
    switch (v) {
    case FORM_INPUT_PASSWORD:
    case FORM_INPUT_TEXT:
    case FORM_INPUT_FILE:
    case FORM_INPUT_CHECKBOX:
	Strcat_char(tmp, '[');
	break;
    case FORM_INPUT_RADIO:
	Strcat_char(tmp, '(');
    }
#ifdef NEW_FORM
    Strcat(tmp, Sprintf("<input_alt hseq=\"%d\" fid=\"%d\" type=%s "
			"name=\"%s\" width=%d maxlength=%d value=\"%s\"",
			cur_hseq++, cur_form_id,
		p, htmlquote_str(r), w, i, (q ? htmlquote_str(q) : "")));
#else				/* not NEW_FORM */
    Strcat(tmp, Sprintf("<input_alt hseq=\"%d\" type=%s "
			"name=\"%s\" width=%d maxlength=%d value=\"%s\"",
    cur_hseq++, p, htmlquote_str(r), w, i, (q ? htmlquote_str(q) : "")));
#endif				/* not NEW_FORM */
    if (x)
	Strcat_charp(tmp, " checked");
    if (y)
	Strcat_charp(tmp, " accept");
    Strcat_char(tmp, '>');

    if (v == FORM_INPUT_HIDDEN)
	Strcat_charp(tmp, "</input_alt></pre_int>");
    else {
	switch (v) {
	case FORM_INPUT_PASSWORD:
	case FORM_INPUT_TEXT:
	case FORM_INPUT_FILE:
	    Strcat_charp(tmp, "<u>");
	    break;
	case FORM_INPUT_IMAGE:
	case FORM_INPUT_SUBMIT:
	case FORM_INPUT_BUTTON:
	case FORM_INPUT_RESET:
	    Strcat_charp(tmp, "[");
	    break;
	}
	if (q) {
	    q2 = q;
	    q = htmlquote_str(q);
	}
	switch (v) {
	case FORM_INPUT_PASSWORD:
	    i = 0;
	    if (q) {
		for (; i < strlen(q) && i < w; i++)
		    Strcat_char(tmp, '*');
	    }
	    for (; i < w; i++)
		Strcat_char(tmp, ' ');
	    break;
	case FORM_INPUT_TEXT:
	case FORM_INPUT_FILE:
	    if (q)
		Strcat(tmp, textfieldrep(Strnew_charp(q2), w));
	    else {
		for (i = 0; i < w; i++)
		    Strcat_char(tmp, ' ');
	    }
	    break;
	case FORM_INPUT_IMAGE:
	case FORM_INPUT_SUBMIT:
	case FORM_INPUT_BUTTON:
	    if (p2) {
		Strcat_charp(tmp, p2);
		i = strlen(p2);
	    }
	    else {
		Strcat_charp(tmp, q);
		i = strlen(q);
	    }
	    break;
	case FORM_INPUT_RESET:
	    Strcat_charp(tmp, q);
	    i = strlen(q);
	    break;
	case FORM_INPUT_RADIO:
	case FORM_INPUT_CHECKBOX:
	    if (x)
		Strcat_char(tmp, '*');
	    else
		Strcat_char(tmp, ' ');
	    break;
	}
	switch (v) {
	case FORM_INPUT_PASSWORD:
	case FORM_INPUT_TEXT:
	case FORM_INPUT_FILE:
	    Strcat_charp(tmp, "</u>");
	    break;
	case FORM_INPUT_IMAGE:
	case FORM_INPUT_SUBMIT:
	case FORM_INPUT_BUTTON:
	case FORM_INPUT_RESET:
	    Strcat_charp(tmp, "]");
	}
	Strcat_charp(tmp, "</input_alt>");
	switch (v) {
	case FORM_INPUT_PASSWORD:
	case FORM_INPUT_TEXT:
	case FORM_INPUT_FILE:
	case FORM_INPUT_CHECKBOX:
	    Strcat_char(tmp, ']');
	    break;
	case FORM_INPUT_RADIO:
	    Strcat_char(tmp, ')');
	}
	Strcat_charp(tmp, "</pre_int>");
    }
    return tmp;
}

Str
process_select(struct parsed_tagarg * targ)
{
    char *p;
    struct parsed_tagarg *t;
#ifdef MENU_SELECT
    Str tmp;
#endif				/* MENU_SELECT */

    p = "default";
    select_is_multiple = 0;

    for (t = targ; t; t = t->next) {
	if (!strcasecmp(t->arg, "name") && t->value)
	    p = t->value;
	else if (!strcasecmp(t->arg, "multiple"))
	    select_is_multiple = 1;
    }

#ifdef MENU_SELECT
    if (!select_is_multiple) {
#ifdef NEW_FORM
	tmp = Sprintf("<pre_int>[<input_alt hseq=\"%d\" fid=\"%d\" type=select "
		      "name=\"%s\" selectnumber=%d",
		      cur_hseq++, cur_form_id, p, n_select);
#else				/* not NEW_FORM */
	tmp = Sprintf("<pre_int><input_alt hseq=\"%d\" type=select "
		      "name=\"%s\" selectnumber=%d",
		      cur_hseq++, p, n_select);
#endif				/* not NEW_FORM */
	Strcat_charp(tmp, ">");
	cur_option = Strnew();
	cur_option_value = Strnew();
	cur_option_selected = 0;
	select_option[n_select].first = NULL;
	select_option[n_select].last = NULL;
	just_after_select = TRUE;
	cur_option_maxwidth = 0;
	cur_status = R_ST_NORMAL;
	return tmp;
    }
#endif				/* MENU_SELECT */
    cur_select = Strnew_charp(p);
    n_selectitem = 0;
    return NULL;
}

Str
process_n_select(void)
{
#ifdef MENU_SELECT
    Str tmp;
    if (cur_select == NULL && cur_option != NULL) {
	/* single select */
	while (cur_option->length > 0 &&
	       IS_SPACE(Strlastchar(cur_option)))
	    Strshrink(cur_option, 1);

	if (cur_option->length > cur_option_maxwidth)
	    cur_option_maxwidth = cur_option->length;
	addSelectOption(&select_option[n_select],
			cur_option_value,
			cur_option,
			cur_option_selected);
	tmp = textfieldrep(chooseSelectOption(select_option[n_select].first,
				    CHOOSE_OPTION), cur_option_maxwidth);
	Strcat_charp(tmp, "</input_alt>]</pre_int>");
	n_select++;
	return tmp;
    }
#endif				/* MENU_SELECT */
    cur_select = NULL;
    n_selectitem = 0;
    return Strnew_charp("<br>");
}

#ifdef MENU_SELECT
void
feed_select(char *str)
{
    Str tmp = Strnew();
    int prev_status = cur_status;
    static int prev_spaces = -1;

    while (read_token(tmp, &str, &cur_status, 0, 0)) {
	if (cur_status != R_ST_NORMAL ||
	    prev_status != R_ST_NORMAL)
	    continue;
	if (TAG_IS(tmp->ptr, "<option", 7)) {
	    struct parsed_tagarg *t_arg;
	    if (just_after_select)
		just_after_select = FALSE;
	    else if (cur_option != NULL) {
		while (cur_option->length > 0 &&
		       IS_SPACE(Strlastchar(cur_option)))
		    Strshrink(cur_option, 1);
		addSelectOption(&select_option[n_select],
				cur_option_value,
				cur_option,
				cur_option_selected);
		if (cur_option->length > cur_option_maxwidth)
		    cur_option_maxwidth = cur_option->length;
	    }
	    cur_option_value = NULL;
	    cur_option = Strnew();
	    cur_option_selected = 0;
	    for (t_arg = parse_tag(tmp->ptr); t_arg != NULL; t_arg = t_arg->next) {
		if (!strcasecmp(t_arg->arg, "value") && t_arg->value)
		    cur_option_value = Strnew_charp(t_arg->value);
		else if (!strcasecmp(t_arg->arg, "selected"))
		    cur_option_selected = 1;
	    }
	    prev_spaces = -1;
	}
	else if (TAG_IS(tmp->ptr, "</option", 8)) {
	    /* do nothing */
	}
	else if (tmp->ptr[0] == '<' && Strlastchar(tmp) == '>') {
	    /* never happen */
	}
	else {
	    char *p = tmp->ptr;
	    while (*p) {
		if (IS_SPACE(*p) && prev_spaces != 0) {
		    p++;
		    if (prev_spaces > 0)
			prev_spaces++;
		}
		else {
		    if (IS_SPACE(*p))
			prev_spaces = 1;
		    else
			prev_spaces = 0;
		    if (*p == '&')
			Strcat_charp(cur_option, getescapecmd(&p));
		    else
			Strcat_char(cur_option, *(p++));
		}
	    }
	}
    }
}

#endif				/* MENU_SELECT */

Str
process_option(struct parsed_tagarg *targ)
{
    char *p;
    struct parsed_tagarg *t;
    Str tmp;
    char begin_char = '[', end_char = ']';

    if (cur_select == NULL)
	return NULL;
    p = "default";
    for (t = targ; t; t = t->next) {
	if (!strcasecmp(t->arg, "value") && t->value)
	    p = t->value;
    }
#ifdef NEW_FORM
    if (!select_is_multiple) {
	begin_char = '(';
	end_char = ')';
    }
    tmp = Sprintf("<br><pre_int>%c<input_alt hseq=\"%d\" fid=\"%d\" type=%s "
		  "name=\"%s\" value=\"%s\"", begin_char,
      cur_hseq++, cur_form_id, select_is_multiple ? "checkbox" : "radio",
		  cur_select->ptr, htmlquote_str(p));
#else				/* not NEW_FORM */
    tmp = Sprintf("<br><pre_int><input_alt hseq=\"%d\" type=%s name=\"%s\" value=\"%s\"",
		  cur_hseq++, select_is_multiple ? "checkbox" : "radio",
		  cur_select->ptr, htmlquote_str(p));
#endif				/* not NEW_FORM */
    if (n_selectitem == 0)
	Strcat_charp(tmp, " checked>*</input_alt>");
    else
	Strcat_charp(tmp, "> </input_alt>");
    Strcat_char(tmp, end_char);
    Strcat_charp(tmp, "</pre_int>");
    n_selectitem++;

    return tmp;
}

Str
process_textarea(struct parsed_tagarg * targ, int width)
{
    char *p, *q, *r;
    struct parsed_tagarg *t;

    p = "40";
    q = "";
    r = "10";
    for (t = targ; t; t = t->next) {
	if (!strcasecmp(t->arg, "cols") && t->value)
	    p = t->value;
	else if (!strcasecmp(t->arg, "name") && t->value)
	    q = t->value;
	else if (!strcasecmp(t->arg, "rows") && t->value)
	    r = t->value;
    }
    cur_textarea = Strnew_charp(q);
    cur_textarea_size = atoi(p);
    if (p[strlen(p) - 1] == '%') {
	cur_textarea_size = width * cur_textarea_size / 100 - 2;
    }
    if (cur_textarea_size <= 0)
	cur_textarea_size = 40;

    cur_textarea_rows = atoi(r);
    if (n_textarea < MAX_TEXTAREA)
	textarea_str[n_textarea] = Strnew();

    return NULL;
}

Str
process_n_textarea(void)
{
    Str tmp;

    if (cur_textarea == NULL)
	return NULL;

#ifdef NEW_FORM
    tmp = Sprintf("<pre_int>[<input_alt hseq=\"%d\" fid=\"%d\" type=textarea "
		  "name=\"%s\" size=%d rows=%d textareanumber=%d><u>",
	   cur_hseq++, cur_form_id, cur_textarea->ptr, cur_textarea_size,
		  cur_textarea_rows, n_textarea);
#else				/* not NEW_FORM */
    tmp = Sprintf("<pre_int>[<input_alt hseq=\"%d\" type=textarea "
		  "name=\"%s\" size=%d rows=%d textareanumber=%d><u>",
		  cur_hseq++, cur_textarea->ptr, cur_textarea_size,
		  cur_textarea_rows, n_textarea);
#endif				/* not NEW_FORM */
    Strcat(tmp, textfieldrep(textarea_str[n_textarea], cur_textarea_size));
    Strcat_charp(tmp, "</u></input_alt>]</pre_int>");
    n_textarea++;
    if (n_textarea == MAX_TEXTAREA) {
	disp_message("Too many textarea in one page", FALSE);
    }
    else
	textarea_str[n_textarea] = Strnew();

    return tmp;
}

void
feed_textarea(char *str)
{
    if (n_textarea < MAX_TEXTAREA) {
	while (*str) {
	    if (*str == '&')
		Strcat_charp(textarea_str[n_textarea], getescapecmd(&str));
	    else if (*str == '\n' || *str == '\r') {
		Strcat_charp(textarea_str[n_textarea], "\r\n");
		if (*(str++) == '\r' && *str == '\n')
		    str++;
	    }
	    else
		Strcat_char(textarea_str[n_textarea], *(str++));
	}
    }
}

#ifdef NEW_FORM
Str
process_form(struct parsed_tagarg *targ)
{
    char *p, *q, *r, *s, *tg;
    struct parsed_tagarg *t;

    p = "get";
    q = "!CURRENT_URL!";
    r = NULL;
    s = NULL;
    tg = NULL;
    for (t = targ; t; t = t->next) {
	if (strcasecmp(t->arg, "method") == 0 && t->value)
	    p = t->value;
	else if (strcasecmp(t->arg, "action") == 0 && t->value)
	    q = t->value;
	else if (strcasecmp(t->arg, "charset") == 0 && t->value)
	    r = t->value;
	else if (strcasecmp(t->arg, "enctype") == 0 && t->value)
	    s = t->value;
	else if (strcasecmp(t->arg, "target") == 0 && t->value)
	    tg = t->value;
    }
    form_max++;
    form_sp++;
    if (forms_size == 0) {
	forms_size = INITIAL_FORM_SIZE;
	forms = New_N(FormList *, forms_size);
    }
    else if (forms_size <= form_max) {
	forms_size += form_max;
	forms = New_Reuse(FormList *, forms, forms_size);
    }
    forms[form_max] =
	newFormList(q, p, r, s, tg, (form_max > 0) ? forms[form_max - 1] : NULL);
    form_stack[form_sp] = form_max;

    return NULL;
}

Str
process_n_form(void)
{
    if (form_sp >= 0)
	form_sp--;
    return NULL;
}
#endif				/* NEW_FORM */

static void
clear_ignore_p_flag(int cmd, struct readbuffer *obuf)
{
    static int clear_flag_cmd[] =
    {
	HTML_UNKNOWN
    };
    int i;

    for (i = 0; clear_flag_cmd[i] != HTML_UNKNOWN; i++) {
	if (cmd == clear_flag_cmd[i]) {
	    obuf->flag &= ~RB_IGNORE_P;
	    return;
	}
    }
}

static void
set_alignment(struct readbuffer *obuf, struct parsed_tagarg *t)
{
    long align = -1;
    for (; t; t = t->next) {
	if (!strcasecmp(t->arg, "align") && t->value) {
	    if (!strcasecmp(t->value, "center"))
		align = RB_CENTER;
	    else if (!strcasecmp(t->value, "right"))
		align = RB_RIGHT;
	    else if (!strcasecmp(t->value, "left"))
		align = RB_LEFT;
	}
    }
    RB_SAVE_FLAG(obuf);
    if (align != -1) {
	RB_SET_ALIGN(obuf, align);
    }
}

#ifdef ID_EXT
static void
process_idattr(struct readbuffer *obuf, int cmd, struct parsed_tagarg *t)
{
    char *id = NULL, *framename = NULL;
    Str idtag = NULL;

    /* 
     * HTML_TABLE is handled by the other process.
     */
    if (cmd == HTML_TABLE)
	return;

    for (; t; t = t->next) {
	if (!t->value)
	    continue;
	else if (!strcasecmp(t->arg, "id"))
	    id = t->value;
	else if (!strcasecmp(t->arg, "framename"))
	    framename = t->value;
    }
    if (id == NULL)
	return;
    if (framename)
	idtag = Sprintf("<_id id=\"%s\" framename=\"%s\">", id, framename);
    else
	idtag = Sprintf("<_id id=\"%s\">", id);
    push_tag(obuf, idtag->ptr, HTML_NOP);
}
#endif				/* ID_EXT */

#define CLOSE_ANCHOR { \
    close_anchor0(h_env, obuf); \
    if (obuf->anchor) { \
	push_tag(obuf, "</a>", HTML_N_A); \
	hseq = 0; \
      obuf->anchor = NULL; \
    } \
    obuf->anchor_target = NULL; \
}

#define CLOSE_P if (obuf->flag & RB_P) { \
      flushline(h_env, obuf, envs[h_env->envc].indent,0,h_env->limit);\
      RB_RESTORE_FLAG(obuf);\
      CLOSE_ANCHOR;\
      obuf->flag &= ~RB_P;\
    }

#define CLOSE_DT \
    if (obuf->flag & RB_IN_DT) { \
      obuf->flag &= ~RB_IN_DT; \
      HTMLlineproc1("</b>", h_env); \
    }

#define PUSH_ENV(cmd) \
    if (++h_env->envc_real < h_env->nenv) { \
      ++h_env->envc; \
      envs[h_env->envc].env = cmd; \
      envs[h_env->envc].count = 0; \
      if (h_env->envc <= MAX_INDENT_LEVEL) \
        envs[h_env->envc].indent = envs[h_env->envc - 1].indent + INDENT_INCR; \
      else \
        envs[h_env->envc].indent = envs[h_env->envc - 1].indent; \
    }

#define POP_ENV \
    if (h_env->envc_real-- < h_env->nenv) \
      h_env->envc--;

static int
ul_type(struct parsed_tagarg *targ, int default_type)
{
    char *p;
    if ((p = tag_get_value(targ, "type")) != NULL) {
	if (!strcasecmp(p, "disc"))
	    return (int) 'd';
	else if (!strcasecmp(p, "circle"))
	    return (int) 'c';
	else if (!strcasecmp(p, "square"))
	    return (int) 's';
    }
    return default_type;
}

int
#ifdef ID_EXT
HTMLtagproc1(int cmd, struct parsed_tagarg *targ, struct html_feed_environ *h_env)
#else
HTMLtagproc1(int cmd, struct html_feed_environ *h_env)
#endif				/* ID_EXT */
{
    char *p, *q, *r;
    int i, w, x, y, type, count;
#ifdef ID_EXT
    struct parsed_tagarg *t;
#else
    struct parsed_tagarg *targ, *t;
#endif				/* ID_EXT */
    struct readbuffer *obuf = h_env->obuf;
    struct environment *envs = h_env->envs;
    Str tmp = Strnew();
    int hseq;
#ifdef TABLE_EXPAND
    int ppc = PIXEL_PER_CHAR;
#endif				/* TABLE_EXPAND */
#ifdef ID_EXT
    Str id = NULL;
#endif				/* ID_EXT */

    if (obuf->flag & RB_PRE) {
	switch (cmd) {
	case HTML_NOBR:
	case HTML_N_NOBR:
	case HTML_PRE_INT:
	case HTML_N_PRE_INT:
	    return 1;
	}
    }

    switch (cmd) {
    case HTML_B:
	obuf->in_bold++;
	if (obuf->in_bold > 1)
	    return 1;
	return 0;
    case HTML_N_B:
	if (obuf->in_bold == 1 && close_effect0(obuf, HTML_B))
	    obuf->in_bold = 0;
	if (obuf->in_bold > 0) {
	    obuf->in_bold--;
	    if (obuf->in_bold == 0)
		return 0;
	}
	return 1;
    case HTML_U:
	obuf->in_under++;
	if (obuf->in_under > 1)
	    return 1;
	return 0;
    case HTML_N_U:
	if (obuf->in_under == 1 && close_effect0(obuf, HTML_U))
	    obuf->in_under = 0;
	if (obuf->in_under > 0) {
	    obuf->in_under--;
	    if (obuf->in_under == 0)
		return 0;
	}
	return 1;
    case HTML_EM:
	HTMLlineproc1("<b>", h_env);
	return 1;
    case HTML_N_EM:
	HTMLlineproc1("</b>", h_env);
	return 1;
    case HTML_P:
	CLOSE_P;
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (!(obuf->flag & RB_IGNORE_P)) {
	    flushline(h_env, obuf, envs[h_env->envc].indent, 1, h_env->limit);
	    do_blankline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	set_alignment(obuf, targ);
	obuf->flag |= (RB_P | RB_IGNORE_P);
	return 1;
    case HTML_N_P:
	CLOSE_P;
	return 1;
    case HTML_BR:
	flushline(h_env, obuf, envs[h_env->envc].indent, 1, h_env->limit);
	return 1;
    case HTML_EOL:
	if ((obuf->flag & RB_PREMODE) && obuf->pos > envs[h_env->envc].indent)
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	return 1;
    case HTML_H:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (!(obuf->flag & (RB_PREMODE | RB_IGNORE_P))) {
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	    do_blankline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	HTMLlineproc1("<b>", h_env);
	set_alignment(obuf, targ);
	return 1;
    case HTML_N_H:
	HTMLlineproc1("</b>", h_env);
	if (!(obuf->flag & RB_PREMODE)) {
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	do_blankline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	RB_RESTORE_FLAG(obuf);
	CLOSE_ANCHOR;
	obuf->flag |= RB_IGNORE_P;
	return 1;
    case HTML_UL:
    case HTML_OL:
    case HTML_BLQ:
	CLOSE_P;
	if (!(obuf->flag & RB_IGNORE_P)) {
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	    if (!(obuf->flag & RB_PREMODE) && h_env->envc == 0)
		do_blankline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	PUSH_ENV(cmd);
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (cmd == HTML_UL || cmd == HTML_OL) {
	    if ((p = tag_get_value(targ, "start")) != NULL) {
		count = atoi(p);
		if (count > 0)
		    envs[h_env->envc].count = count - 1;
	    }
	}
	if (cmd == HTML_OL) {
	    envs[h_env->envc].type = (int) '1';
	    if ((p = tag_get_value(targ, "type")) != NULL) {
		envs[h_env->envc].type = (int) *p;
	    }
	}
	if (cmd == HTML_UL)
	    envs[h_env->envc].type = ul_type(targ, 0);
	if (cmd == HTML_BLQ)
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	return 1;
    case HTML_N_UL:
    case HTML_N_OL:
    case HTML_N_DL:
    case HTML_N_BLQ:
	if (h_env->envc && envs[h_env->envc].env == HTML_DT) {
	    POP_ENV;
	}
	CLOSE_DT;
	CLOSE_P;
	if (h_env->envc > 0) {
	    flushline(h_env, obuf, envs[h_env->envc - 1].indent, 0, h_env->limit);
	    POP_ENV;
	    if (!(obuf->flag & RB_PREMODE) &&
		(h_env->envc == 0 || cmd == HTML_N_DL)) {
		do_blankline(h_env, obuf,
			     envs[h_env->envc].indent,
			     INDENT_INCR,
			     h_env->limit);
		obuf->flag |= RB_IGNORE_P;
	    }
	}
	CLOSE_ANCHOR;
	return 1;
    case HTML_DL:
	CLOSE_P;
	if (!(obuf->flag & RB_IGNORE_P)) {
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	    if (!(obuf->flag & RB_PREMODE))
		do_blankline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	PUSH_ENV(cmd);
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (tag_exists(targ, "compact"))
	    envs[h_env->envc].env = HTML_DL_COMPACT;
	obuf->flag |= RB_IGNORE_P;
	return 1;
    case HTML_LI:
	CLOSE_P;
	if (h_env->envc && envs[h_env->envc].env == HTML_DT) {
	    POP_ENV;
	    CLOSE_DT;
	}
	if (h_env->envc > 0) {
	    Str num;
	    flushline(h_env, obuf,
		      envs[h_env->envc - 1].indent, 0, h_env->limit);
	    envs[h_env->envc].count++;
#ifndef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	    if ((p = tag_get_value(targ, "value")) != NULL) {
		count = atoi(p);
		if (count > 0)
		    envs[h_env->envc].count = count;
	    }
	    switch (envs[h_env->envc].env) {
	    case HTML_UL:
		type = ul_type(targ, envs[h_env->envc].type);
		for (i = 0; i < INDENT_INCR - 3; i++)
		    push_charp(obuf, 1, "&nbsp;", PC_ASCII);
		switch (type) {
#ifdef KANJI_SYMBOLS
		case 'd':
		    push_charp(obuf, 2, "", PC_ASCII);
		    break;
		case 'c':
		    push_charp(obuf, 2, "", PC_ASCII);
		    break;
		case 's':
		    push_charp(obuf, 2, "", PC_ASCII);
		    break;
#endif				/* KANJI_SYMBOLS */
		default:
		    push_charp(obuf, 2, ullevel[(h_env->envc_real - 1) % MAX_UL_LEVEL], PC_ASCII);
		    break;
		}
		push_charp(obuf, 1, "&nbsp;", PC_ASCII);
		obuf->prevchar = ' ';
		break;
	    case HTML_OL:
		type = envs[h_env->envc].type;
		if ((p = tag_get_value(targ, "type")) != NULL)
		    type = (int) *p;
		switch (type) {
		case 'i':
		    num = romanNumeral(envs[h_env->envc].count);
		    break;
		case 'I':
		    num = romanNumeral(envs[h_env->envc].count);
		    Strupper(num);
		    break;
		case 'a':
		    num = romanAlphabet(envs[h_env->envc].count);
		    break;
		case 'A':
		    num = romanAlphabet(envs[h_env->envc].count);
		    Strupper(num);
		    break;
		default:
		    num = Sprintf("%d", envs[h_env->envc].count);
		    break;
		}
#if INDENT_INCR >= 4
		Strcat_charp(num, ". ");
#else				/* INDENT_INCR < 4 */
		Strcat_char(num, '.');
#endif				/* INDENT_INCR < 4 */
		for (i = 0; i < INDENT_INCR - num->length; i++)
		    push_char(obuf, 1, 1, ' ', PC_ASCII);
		push_str(obuf, num->length, num, PC_ASCII);
		break;
	    default:
		for (i = 0; i < INDENT_INCR; i++)
		    push_char(obuf, 1, 1, ' ', PC_ASCII);
		break;
	    }
	}
	else {
	    flushline(h_env, obuf, 0, 0, h_env->limit);
	}
	obuf->flag |= RB_IGNORE_P;
	return 1;
    case HTML_DT:
	CLOSE_P;
	if (h_env->envc == 0 ||
	    (h_env->envc_real < h_env->nenv &&
	     envs[h_env->envc].env != HTML_DL &&
	     envs[h_env->envc].env != HTML_DL_COMPACT &&
	     envs[h_env->envc].env != HTML_DT)) {
	    PUSH_ENV(cmd);
	}
	if (h_env->envc > 0) {
	    flushline(h_env, obuf,
		      envs[h_env->envc - 1].indent, 0, h_env->limit);
	}
	if (!(obuf->flag & RB_IN_DT)) {
	    HTMLlineproc1("<b>", h_env);
	    obuf->flag |= RB_IN_DT;
	}
	obuf->flag |= RB_IGNORE_P;
	return 1;
    case HTML_DD:
	CLOSE_P;
	CLOSE_DT;
	if (envs[h_env->envc].env == HTML_DL_COMPACT) {
	    if (obuf->pos > envs[h_env->envc].indent)
		flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	    else
		while (obuf->pos < envs[h_env->envc].indent) {
		    push_char(obuf, 1, 1, ' ', PC_ASCII);
		}
	}
	else
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag |= RB_IGNORE_P;
	return 1;
    case HTML_TITLE:
	append_tags(obuf);
	save_line = obuf->line;
	save_prevchar = obuf->prevchar;
	set_breakpoint(obuf, 0);
	obuf->line = Strnew();
	discardline(obuf, 0);
	obuf->flag |= (RB_NOBR | RB_TITLE);
	return 1;
    case HTML_N_TITLE:
	if (!(obuf->flag & RB_TITLE))
	    return 1;
	obuf->flag &= ~(RB_NOBR | RB_TITLE);
	append_tags(obuf);
	h_env->title = allocStr(obuf->line->ptr, 0);
	obuf->line = save_line;
	obuf->prevchar = save_prevchar;
	back_to_breakpoint(obuf);
	Strcat_charp(tmp, "<title_alt title=\"");
	Strcat_charp(tmp, htmlquote_str(h_env->title));
	Strcat_charp(tmp, "\">");
	push_tag(obuf, tmp->ptr, HTML_TITLE_ALT);
	return 1;
    case HTML_FRAMESET:
	PUSH_ENV(cmd);
	push_charp(obuf, 9, "--FRAME--", PC_ASCII);
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	return 0;
    case HTML_N_FRAMESET:
	if (h_env->envc > 0) {
	    POP_ENV;
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	}
	return 0;
    case HTML_FRAME:
	q = r = NULL;
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	for (t = targ; t; t = t->next) {
	    if (!strcasecmp(t->arg, "src") && t->value) {
		q = t->value;
	    }
	    else if (!strcasecmp(t->arg, "name") && t->value) {
		r = t->value;
	    }
	}
	if (q) {
	    push_tag(obuf, Sprintf("<a hseq=\"%d\" href=\"%s\">",
				   cur_hseq++, q)->ptr, HTML_A);
	    if (r) {
		push_charp(obuf, strlen(r), r, PC_ASCII);
	    }
	    else {
		push_charp(obuf, strlen(q), q, PC_ASCII);
	    }
	    push_tag(obuf, "</a>", HTML_N_A);
	}
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	return 0;
    case HTML_HR:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	/* flushline(h_env, obuf, 0, 1, h_env->limit); */
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	w = 0;
	p = NULL;
	for (t = targ; t; t = t->next) {
	    if (!strcasecmp(t->arg, "width") && t->value) {
		if (t->value[strlen(t->value) - 1] == '%') {
		    w = atoi(t->value) * h_env->limit / 100;
		}
		else {
		    w = atoi(t->value) / PIXEL_PER_CHAR;
		}
		if (w > h_env->limit) {
		    w = h_env->limit;
		}
	    }
	    /* 
	     * else if (!strcasecmp(t->arg,"size") && t->value) { w =
	     * atoi(t->value)/PIXEL_PER_CHAR; if (w > h_env->limit) { w =
	     * h_env->limit; } } */
	    else if (!strcasecmp(t->arg, "align") && t->value) {
		p = t->value;
	    }
	}
	if (w == 0)
	    w = h_env->limit;
	if (w > envs[h_env->envc].indent)
	    w -= envs[h_env->envc].indent;
#ifndef KANJI_SYMBOLS
	push_charp(obuf, 0, "<_RULE TYPE=10>", PC_ASCII);
#endif				/* not KANJI_SYMBOLS */
	for (i = 0; i < w - (HR_RULE_WIDTH - 1); i += HR_RULE_WIDTH) {
	    push_nchars(obuf, HR_RULE_WIDTH, HR_RULE, HR_RULE_WIDTH, PC_ASCII);
	}
#ifndef KANJI_SYMBOLS
	push_charp(obuf, 0, "</_RULE>", PC_ASCII);
#endif				/* not KANJI_SYMBOLS */
	if (p == NULL || !strcasecmp(p, "center")) {
	    obuf->line = Stralign_center(obuf->line, h_env->limit);
	}
	else if (!strcasecmp(p, "right")) {
	    obuf->line = Stralign_right(obuf->line, h_env->limit);
	}
	obuf->pos = obuf->line->length;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->prevchar = ' ';
	CLOSE_ANCHOR;
	return 1;
    case HTML_PRE:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	i = 0;
	for (t = targ; t; t = t->next) {
	    if (!strcasecmp(t->arg, "for_table")) {
		i = 1;
		break;
	    }
	}
	if (i == 0)
	    CLOSE_P;
	if (!(obuf->flag & RB_IGNORE_P))
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	else
	    fillline(h_env, obuf, envs[h_env->envc].indent);
	obuf->flag |= (RB_PRE | RB_IGNORE_P);
	/* istr = str; */
	return 1;
    case HTML_N_PRE:
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag &= ~RB_PRE;
	CLOSE_ANCHOR
	    return 1;
    case HTML_PRE_INT:
	i = obuf->line->length;
	append_tags(obuf);
	if (!(obuf->flag & RB_SPECIAL)) {
	    set_breakpoint(obuf, obuf->line->length - i);
	}
	obuf->flag |= RB_PRE_INT;
	return 0;
    case HTML_N_PRE_INT:
	push_tag(obuf, "</pre_int>", HTML_N_PRE_INT);
	obuf->flag &= ~RB_PRE_INT;
	if (!(obuf->flag & RB_SPECIAL) && obuf->pos > obuf->bp.pos) {
	    obuf->prevchar = '\0';
	    obuf->prev_ctype = PC_CTRL;
	}
	return 1;
    case HTML_NOBR:
	obuf->flag |= RB_NOBR;
	obuf->nobr_level++;
	return 0;
    case HTML_N_NOBR:
	if (obuf->nobr_level > 0)
	    obuf->nobr_level--;
	if (obuf->nobr_level == 0)
	    obuf->flag &= ~RB_NOBR;
	return 0;
    case HTML_LISTING:
	CLOSE_P;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag |= (RB_LSTMODE | RB_IGNORE_P);
	/* istr = str; */
	return 1;
    case HTML_N_LISTING:
	CLOSE_P;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag &= ~RB_LSTMODE;
	return 1;
    case HTML_XMP:
	CLOSE_P;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag |= (RB_XMPMODE | RB_IGNORE_P);
	/* istr = str; */
	return 1;
    case HTML_N_XMP:
	CLOSE_P;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag &= ~RB_XMPMODE;
	return 1;
    case HTML_SCRIPT:
	obuf->flag |= RB_IGNORE;
	obuf->ignore_tag = Strnew_charp("</script>");
	return 1;
    case HTML_N_SCRIPT:
	/* should not be reached */
	return 1;
    case HTML_STYLE:
	obuf->flag |= RB_IGNORE;
	obuf->ignore_tag = Strnew_charp("</style>");
	return 1;
    case HTML_N_STYLE:
	/* should not be reached */
	return 1;
    case HTML_PLAINTEXT:
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	obuf->flag |= RB_PLAIN;
	/* istr = str; */
	return 1;
    case HTML_A:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (obuf->anchor) {
	    CLOSE_ANCHOR
	}
	obuf->anchor = NULL;
	hseq = 0;

	for (t = targ; t; t = t->next) {
	    if (strcasecmp(t->arg, "href") == 0 && t->value) {
		obuf->anchor = Strnew_charp(t->value);
	    }
	    else if (strcasecmp(t->arg, "target") == 0 && t->value) {
		obuf->anchor_target = Strnew_charp(t->value);
	    }
	    else if (strcasecmp(t->arg, "hseq") == 0 && t->value) {
		hseq = atoi(t->value);
		obuf->anchor_hseq = hseq;
	    }
	}

	if (hseq == 0 && obuf->anchor) {
	    obuf->anchor_hseq = cur_hseq;
	    tmp = process_anchor(h_env->tagbuf->ptr);
	    push_tag(obuf, tmp->ptr, HTML_A);
	    return 1;
	}
	return 0;
    case HTML_N_A:
	CLOSE_ANCHOR
	    return 1;
    case HTML_IMG:
	tmp = process_img(parse_tag(h_env->tagbuf->ptr));
	HTMLlineproc1(tmp->ptr, h_env);
	return 1;
    case HTML_IMG_ALT:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	for (t = targ; t; t = t->next) {
	    if (strcasecmp(t->arg, "src") == 0 && t->value) {
		obuf->img_alt = Strnew_charp(t->value);
	    }
	}
	return 0;
    case HTML_N_IMG_ALT:
	if (obuf->img_alt) {
	    if (!close_effect0(obuf, HTML_IMG_ALT))
		push_tag(obuf, "</img_alt>", HTML_N_IMG_ALT);
	    obuf->img_alt = NULL;
	}
	return 1;
    case HTML_TABLE:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	w = BORDER_NONE;
	/* x: cellspacing, y: cellpadding */
	x = 1;
	y = -1;
	table_width[obuf->table_level] = 0;
	for (t = targ; t; t = t->next) {
	    if (strcasecmp(t->arg, "border") == 0) {
		if (t->value) {
		    w = atoi(t->value);
		    if (w > 2)
			w = BORDER_THICK;
		    else if (w < 0) {	/* weird */
			w = BORDER_THIN;
		    }
		}
		else
		    w = BORDER_THIN;
	    }
	    else if (strcasecmp(t->arg, "width") == 0 && t->value) {
		i = atoi(t->value);
		if (i <= 0)
		    continue;
		if (t->value[strlen(t->value) - 1] == '%') {
		    if (obuf->table_level == 0) {
			table_width[obuf->table_level] =
			    (h_env->limit - envs[h_env->envc].indent) * i / 100;
		    }
		    else {
			table_width[obuf->table_level] = -i;
		    }
		}
		else {
#ifndef TABLE_EXPAND
		    table_width[obuf->table_level] = i / PIXEL_PER_CHAR;
#else				/* TABLE_EXPAND */
		    if (obuf->table_level == 0) {
			int v = h_env->limit - envs[h_env->envc].indent;
			ppc = i / v;
			if (i % v > 0)
			    ppc++;
			if (ppc < 2)
			    ppc = 2;
			if (ppc > PIXEL_PER_CHAR) {
			    ppc = PIXEL_PER_CHAR;
			    table_width[0] = i / ppc;
			}
			else
			    table_width[0] = v;
		    }
		    else if (table_width[0] > 0)
			table_width[obuf->table_level] = i / tables[0]->ppc;
		    else
			table_width[obuf->table_level] = 0;
#endif				/* TABLE_EXPAND */
		}
	    }
	    else if (!strcasecmp(t->arg, "hborder"))
		w = BORDER_NOWIN;
	    else if (strcasecmp(t->arg, "cellspacing") == 0 && t->value) {
		x = atoi(t->value);
		if (x >= PIXEL_PER_CHAR)
		    x /= PIXEL_PER_CHAR;
		else if (x > 2)
		    x = 1;
		else
		    x = 0;
	    }
	    else if (strcasecmp(t->arg, "cellpadding") == 0 && t->value) {
		y = atoi(t->value);
		if (y >= PIXEL_PER_CHAR)
		    y /= PIXEL_PER_CHAR;
		else if (y > 2)
		    y = 1;
		else
		    y = 0;
#ifdef ID_EXT
	    }
	    else if (strcasecmp(t->arg, "id") == 0 && t->value) {
		id = Strnew_charp(t->value);
#endif				/* ID_EXT */
	    }
	}
	tables[obuf->table_level] = begin_table(w, x, y);
#ifdef ID_EXT
	if (id != NULL)
	    tables[obuf->table_level]->id = Strdup(id);
#endif				/* ID_EXT */
#ifdef TABLE_EXPAND
	if (obuf->table_level == 0)
	    tables[0]->ppc = ppc;
	else
	    tables[obuf->table_level]->ppc = tables[0]->ppc;
#endif				/* TABLE_EXPAND */
	table_mode[obuf->table_level].pre_mode = 0;
	table_mode[obuf->table_level].indent_level = 0;
	table_mode[obuf->table_level].nobr_level = 0;
	table_mode[obuf->table_level].caption = 0;
	tables[obuf->table_level]->total_width = table_width[obuf->table_level];
	if (table_width[obuf->table_level] == 0) {
	    if (obuf->table_level == 0)
		table_width[0] = h_env->limit - envs[h_env->envc].indent;
	}
	obuf->table_level++;
	return 1;
    case HTML_N_TABLE:
	/* should be processed in HTMLlineproc() */
	return 1;
    case HTML_CENTER:
	CLOSE_P;
	if (!(obuf->flag & (RB_PREMODE | RB_IGNORE_P)))
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	RB_SAVE_FLAG(obuf);
	RB_SET_ALIGN(obuf, RB_CENTER);
	return 1;
    case HTML_N_CENTER:
	CLOSE_P;
	if (!(obuf->flag & RB_PREMODE))
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	RB_RESTORE_FLAG(obuf);
	return 1;
    case HTML_DIV:
	CLOSE_P;
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	if (!(obuf->flag & RB_IGNORE_P))
	    flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	set_alignment(obuf, targ);
	return 1;
    case HTML_N_DIV:
	CLOSE_P;
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	RB_RESTORE_FLAG(obuf);
	return 1;
    case HTML_FORM:
#ifdef NEW_FORM
    case HTML_FORM_INT:
	process_form(parse_tag(h_env->tagbuf->ptr));
	return 1;
#endif				/* NEW_FORM */
    case HTML_N_FORM:
#ifdef NEW_FORM
    case HTML_N_FORM_INT:
	process_n_form();
	return 1;
#else				/* not NEW_FORM */
	flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
	return 0;
#endif				/* not NEW_FORM */
    case HTML_INPUT:
	tmp = process_input(parse_tag(h_env->tagbuf->ptr));
	if (tmp) {
	    HTMLlineproc1(tmp->ptr, h_env);
	    return 1;
	}
	return 0;
    case HTML_SELECT:
	tmp = process_select(parse_tag(h_env->tagbuf->ptr));
#ifdef MENU_SELECT
	if (cur_select == NULL) {
	    /* not multiple */
	    HTMLlineproc1(tmp->ptr, h_env);
	    obuf->flag |= RB_INSELECT;
	}
#endif				/* MENU_SELECT */
	return 1;
    case HTML_N_SELECT:
#ifdef MENU_SELECT
	obuf->flag &= ~RB_INSELECT;
#endif				/* MENU_SELECT */
	tmp = process_n_select();
	if (tmp)
	    HTMLlineproc1(tmp->ptr, h_env);
	return 1;
    case HTML_OPTION:
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	tmp = process_option(parse_tag(h_env->tagbuf->ptr));
	if (tmp)
	    HTMLlineproc1(tmp->ptr, h_env);
	return 1;
    case HTML_TEXTAREA:
	process_textarea(parse_tag(h_env->tagbuf->ptr), h_env->limit);
	obuf->flag |= RB_INTXTA;
	return 1;
    case HTML_N_TEXTAREA:
	close_textarea(h_env);
	return 1;
    case HTML_ISINDEX:
	targ = parse_tag(h_env->tagbuf->ptr);
	p = "";
	q = NULL;
	for (t = targ; t; t = t->next) {
	    if (!strcasecmp(t->arg,"action") && t->value)
		q = t->value;
	    else if (!strcasecmp(t->arg,"prompt") && t->value)
		p = t->value;
	}
	if (q == NULL)
	    q = "!CURRENT_URL!";
	tmp = Strnew_m_charp("<form method=get action=\"",
			     q,
			     "\">",
			     p,
			     "<input type=text name=\"\" accept></form>",
			     NULL);
	HTMLlineproc1(tmp->ptr, h_env);
	return 1;
    case HTML_META:
	p = q = NULL;
#ifndef ID_EXT
	targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	for (t = targ; t; t = t->next) {
	    if (!strcasecmp(t->arg, "http-equiv") && t->value)
		p = t->value;
	    else if (!strcasecmp(t->arg, "content") && t->value)
		q = t->value;
	}
#ifdef JP_CHARSET
	if (p && q && !strcasecmp(p, "Content-Type") &&
	    (q = strcasestr(q, "charset")) != NULL) {
	    q += 7;
	    SKIP_BLANKS(q);
	    if (*q == '=')
		q++;
	    SKIP_BLANKS(q);
	    content_charset = guess_charset(q);
	}
	else
#endif
	if (p && q && !strcasecmp(p, "refresh")) {
	    int refresh = atoi(q);
	    Str s_tmp = NULL;

	    while (*q) {
		if (!strncasecmp(q, "url=", 4)) {
		    q += 4;
		    if (*q == '\"')	/* " */
			q++;
		    r = q;
		    while (*r && !IS_SPACE(*r) && *r != ';')
			r++;
		    s_tmp = Strnew_charp_n(q, r - q);

		    if (s_tmp->ptr[s_tmp->length - 1] == '\"') {	/* " 
									 */
			s_tmp->length--;
			s_tmp->ptr[s_tmp->length] = '\0';
		    }
		    q = r;
		}
		while (*q && *q != ';')
		    q++;
		if (*q == ';')
		    q++;
		while (*q && *q == ' ')
		    q++;
	    }
	    if (s_tmp) {
		q = htmlquote_str(s_tmp->ptr);
		tmp = Sprintf("Refresh (%d sec) <a hseq=\"%d\" href=\"%s\">%s</a>",
			      refresh, cur_hseq++, q, q);
		push_str(obuf, s_tmp->length, tmp, PC_ASCII);
		flushline(h_env, obuf, envs[h_env->envc].indent, 0, h_env->limit);
		if (!is_redisplay && refresh == 0) {
		    pushEvent(FUNCNAME_goURL, s_tmp->ptr);
		    /* pushEvent(deletePrevBuf,NULL); */
		}
	    }
	}
	return 1;
    case HTML_BASE:
	return 0;
    case HTML_DEL:
	HTMLlineproc1("<U>[DEL:</U>", h_env);
	return 1;
    case HTML_N_DEL:
	HTMLlineproc1("<U>:DEL]</U>", h_env);
	return 1;
    case HTML_INS:
	HTMLlineproc1("<U>[INS:</U>", h_env);
	return 1;
    case HTML_N_INS:
	HTMLlineproc1("<U>:INS]</U>", h_env);
	return 1;
    case HTML_FONT:
    case HTML_N_FONT:
    case HTML_NOP:
	return 1;
#ifdef VIEW_UNSEENOBJECTS
    case HTML_BGSOUND:
	if (view_unseenobject) {
#ifndef ID_EXT
	    struct parsed_tagarg *targ, *t;
#endif				/* !ID_EXT */
	    Str s;

#ifndef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	    for (t = targ; t; t = t->next) {
		if (strcasecmp(t->arg, "src") == 0 && t->value) {
		    s = Sprintf("<A HREF=\"%s\">bgsound(%s)</A>", t->value, t->value);
		    HTMLlineproc1(s->ptr, h_env);
		}
	    }
	}
	return 1;
    case HTML_EMBED:
	if (view_unseenobject) {
#ifndef ID_EXT
	    struct parsed_tagarg *targ, *t;
#endif				/* !ID_EXT */
	    Str s;

#ifndef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	    for (t = targ; t; t = t->next) {
		if (strcasecmp(t->arg, "src") == 0 && t->value) {
		    s = Sprintf("<A HREF=\"%s\">embed(%s)</A>", t->value, t->value);
		    HTMLlineproc1(s->ptr, h_env);
		}
	    }
	}
	return 1;
    case HTML_APPLET:
	if (view_unseenobject) {
#ifndef ID_EXT
	    struct parsed_tagarg *targ, *t;
#endif				/* !ID_EXT */
	    Str s;

#ifndef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */
	    for (t = targ; t; t = t->next) {
		if (strcasecmp(t->arg, "archive") == 0 && t->value) {
		    s = Sprintf("<A HREF=\"%s\">applet archive(%s)</A>", t->value, t->value);
		    HTMLlineproc1(s->ptr, h_env);
		}
	    }
	}
	return 1;
#endif				/* VIEW_UNSEENOBJECTS */
    case HTML_BODY:
#ifdef VIEW_UNSEENOBJECTS
	if (view_unseenobject) {
#ifndef ID_EXT
	    struct parsed_tagarg *targ, *t;
#endif				/* !ID_EXT */
	    Str s;

#ifndef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
#endif				/* !ID_EXT */

	    for (t = targ; t; t = t->next) {
		if (strcasecmp(t->arg, "background") == 0 && t->value) {
		    s = Sprintf("<IMG SRC=\"%s\" ALT=\"bg image(%s)\"><BR>", t->value, t->value);
		    HTMLlineproc1(s->ptr, h_env);
		}
	    }
	}
#endif				/* VIEW_UNSEENOBJECTS */
    case HTML_N_BODY:
	obuf->flag |= RB_IGNORE_P;
	return 1;
    default:
/* obuf->prevchar = '\0'; */
	return 0;
    }
    /* not reached */
    return 0;
}

#define PPUSH(p,c) {outp[pos]=(p);outc[pos]=(c);pos++;}

static TextListItem *_tl_lp2;

static char *
textlist_feed()
{
    char *p;
    if (_tl_lp2 != NULL) {
	p = _tl_lp2->ptr;
	_tl_lp2 = _tl_lp2->next;
	return p;
    }
    return NULL;
}

static void
HTMLlineproc2body(Buffer * buf, char *(*feed) (), int llimit)
{
    Anchor *a_href = NULL, *a_img = NULL, *a_form = NULL;
    int status;
    char outc[LINELEN];
    char *p, *q, *r, *str, *istr;
    Lineprop outp[LINELEN], mode, effect, prev_mode;
    int pos;
    int nlines;
    FILE *debug;
    struct frameset *frameset_s[FRAMESTACK_SIZE];
    int frameset_sp = -1;
    union frameset_element *idFrame = NULL;
    char *id = NULL;
    Str tmp;
    int hseq;

    if (w3m_debug)
	debug = fopen("zzzerr", "a");

    mode = PC_ASCII;
    effect = 0;
    nlines = 0;
#ifdef NEW_FORM
    buf->formlist = (form_max >= 0) ? forms[form_max] : NULL;
#endif				/* NEW_FORM */
    while ((istr = feed()) != NULL) {
	if (w3m_debug)
	    fprintf(debug, "%s\n", istr);
      proc_again:
	if (++nlines == llimit)
	    break;
	pos = 0;
	if (showLineNum) {
	    tmp = Sprintf("%4d:", nlines);
	    for (p = tmp->ptr; *p; p++) {
		PPUSH(PC_ASCII, *p);
	    }
	}
	for (str = istr; *str != '\0' && pos < LINELEN; str++) {
	    prev_mode = mode;
	    mode = get_ctype((unsigned char) *str, prev_mode);
#ifdef JP_CHARSET
	    if (prev_mode == PC_KANJI1 && mode != PC_KANJI2) {
		outp[pos - 1] &= ~P_CHARTYPE;
		outp[pos - 1] |= PC_ASCII;
	    }
	    if (mode == PC_KANJI1 || mode == PC_KANJI2 ||
		(mode == PC_ASCII && *str != '<' && *str != '&')) {
		PPUSH(mode | effect, *str);
	    }
	    else if (mode == PC_CTRL) {
		PPUSH(PC_ASCII | effect, ' ');
	    }
	    else if (*str == '&' && mode != PC_KANJI1) {
		/* 
		 * & escape processing
		 */
		int emode = PC_ASCII;
		p = getescapecmd(&str);
		while (*p) {
		    if (emode == PC_KANJI1)
			emode = PC_KANJI2;
		    else if (*p & 0x80)
			emode = PC_KANJI1;
		    else
			emode = PC_ASCII;
		    PPUSH(emode | effect, *(p++));
		}
		str--;
	    }
#else				/* not JP_CHARSET */
	    if (mode == PC_ASCII && *str != '<' && *str != '&') {
		PPUSH(mode | effect, *str);
	    }
	    else if (mode == PC_CTRL) {
		PPUSH(PC_ASCII | effect, ' ');
	    }
	    else if (*str == '&') {
		/* 
		 * & escape processing
		 */
		p = getescapecmd(&str);
		while (*p) {
		    PPUSH(PC_ASCII | effect, *(p++));
		}
		str--;
	    }
#endif				/* not JP_CHARSET */
	    else {
		/* tag processing */
		int cmd;
		Str tagbuf = Strnew();
		struct parsed_tagarg *t_arg, *t;

		status = R_ST_NORMAL;
		read_token(tagbuf, &str, &status, 0, 0);
		t_arg = parse_tag(tagbuf->ptr);
		str--;
		q = tagbuf->ptr;
		cmd = gethtmlcmd(&q, &status);
		switch (cmd) {
		case HTML_B:
		    effect |= PE_BOLD;
		    break;
		case HTML_N_B:
		    effect &= ~PE_BOLD;
		    break;
		case HTML_U:
		    effect |= PE_UNDER;
		    break;
		case HTML_N_U:
		    effect &= ~PE_UNDER;
		    break;
		case HTML_A:
		    p = r = NULL;
		    q = buf->baseTarget;
		    hseq = 0;
		    id = NULL;
		    for (t = t_arg; t; t = t->next) {
			if (!t->value)
			    continue;
			else if (!strcasecmp(t->arg, "name")) {
			    id = t->value;
			    (void) registerName(buf, id, currentLn(buf), pos);
			}
			else if (!strcasecmp(t->arg, "href")) {
			    p = t->value;
			}
			else if (!strcasecmp(t->arg, "target")) {
			    q = t->value;
			}
			else if (!strcasecmp(t->arg, "referer")) {
			    r = t->value;
			}
			else if (!strcasecmp(t->arg, "hseq")) {
			    hseq = atoi(t->value);
			}
			else if (renderFrameSet &&
				 !strcasecmp(t->arg, "framename")) {
			    if (!idFrame ||
				strcmp(idFrame->body->name, t->value)) {
				idFrame = search_frame(renderFrameSet,
						       t->value);
				if (idFrame && idFrame->body->attr != F_BODY)
				    idFrame = NULL;
			    }
			}
		    }
		    if (hseq > 0)
			buf->hmarklist =
			    putHmarker(buf->hmarklist, currentLn(buf), pos, hseq - 1);
		    if (id && idFrame)
			idFrame->body->nameList =
			    putAnchor(idFrame->body->nameList,
				      id,
				      NULL,
				      (Anchor **) NULL,
				      NULL,
				      currentLn(buf),
				      pos);
		    if (p) {
			effect |= PE_ANCHOR;
			a_href = registerHref(buf, remove_space(p), q, r, currentLn(buf), pos);
			a_href->hseq = ((hseq > 0) ? hseq : -hseq) - 1;
		    }
		    break;
		case HTML_N_A:
		    effect &= ~PE_ANCHOR;
		    if (a_href) {
			a_href->end.line = currentLn(buf);
			a_href->end.pos = pos;
			if (a_href->start.line == a_href->end.line &&
			    a_href->start.pos == a_href->end.pos)
			    a_href->hseq = -1;
			a_href = NULL;
		    }
		    break;
		case HTML_IMG_ALT:
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "src") && t->value) {
			    a_img = registerImg(buf, t->value, currentLn(buf), pos);
			}
		    }
		    effect |= PE_IMAGE;
		    break;
		case HTML_N_IMG_ALT:
		    effect &= ~PE_IMAGE;
		    if (a_img) {
			a_img->end.line = currentLn(buf);
			a_img->end.pos = pos;
		    }
		    a_img = NULL;
		    break;
		case HTML_INPUT_ALT:
		    {
			FormList *form;
#ifdef NEW_FORM
			int form_id = -1;
#endif				/* NEW_FORM */

#ifndef NEW_FORM
			if (form_sp < 0)
			    break;	/* outside of <form>..</form> */
#endif				/* not NEW_FORM */
			hseq = 0;
			for (t = t_arg; t; t = t->next) {
			    if (!strcasecmp(t->arg, "hseq") && t->value) {
				hseq = atoi(t->value);
			    }
#ifdef NEW_FORM
			    else if (!strcasecmp(t->arg, "fid") && t->value) {
				form_id = atoi(t->value);
			    }
#endif				/* NEW_FORM */
			}
#ifdef NEW_FORM
			if (form_id < 0 || forms == NULL)
			    break;	/* outside of <form>..</form> */
			form = forms[form_id];
#else				/* not NEW_FORM */
			form = form_stack[form_sp];
#endif				/* not NEW_FORM */
			if (hseq > 0) {
			    int hpos = pos;
			    if (str[1] == '[')
				hpos++;
			    buf->hmarklist =
				putHmarker(buf->hmarklist, currentLn(buf), hpos, hseq - 1);
			}
			if (!form->target)
			    form->target = buf->baseTarget;
			a_form = registerForm(buf, form, t_arg, currentLn(buf), pos);
			if (a_form) {
			    a_form->hseq = hseq - 1;
			    if (!tag_get_value(t_arg, "no_effect"))
				effect |= PE_FORM;
			    break;
			}
		    }
		case HTML_N_INPUT_ALT:
		    effect &= ~PE_FORM;
		    if (a_form) {
			a_form->end.line = currentLn(buf);
			a_form->end.pos = pos;
			if (a_form->start.line == a_form->end.line &&
			    a_form->start.pos == a_form->end.pos)
			    a_form->hseq = -1;
		    }
		    a_form = NULL;
		    break;
#ifndef NEW_FORM
		case HTML_FORM:
		case HTML_FORM_INT:
		    p = "get";
		    q = "/";
		    r = NULL;
		    s = NULL;
		    for (t = t_arg; t; t = t->next) {
			if (strcasecmp(t->arg, "method") == 0 && t->value)
			    p = t->value;
			else if (strcasecmp(t->arg, "action") == 0 && t->value)
			    q = t->value;
			else if (strcasecmp(t->arg, "charset") == 0 && t->value)
			    r = t->value;
			else if (strcasecmp(t->arg, "enctype") == 0 && t->value)
			    s = t->value;
		    }
		    buf->formlist = newFormList(q, p, r, s, buf->formlist);
		    form_sp++;
		    form_stack[form_sp] = buf->formlist;
		    break;
		case HTML_N_FORM:
		case HTML_N_FORM_INT:
		    if (form_sp >= 0)
			form_sp--;
		    break;
#endif				/* not NEW_FORM */
		case HTML_MAP:
		    p = NULL;
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "name") && t->value)
			    p = t->value;
		    }
		    if (p) {
			MapList *m = New(MapList);
			m->name = Strnew_charp(p);
			m->next = buf->maplist;
			m->urls = newTextList();
			buf->maplist = m;
		    }
		    break;
		case HTML_N_MAP:
		    /* nothing to do */
		    break;
		case HTML_AREA:
		    if (buf->maplist == NULL)	/* outside of *
						 * <map>..</map> */
			break;
		    p = NULL;
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "href") && t->value)
			    p = t->value;
		    }
		    if (p) {
			pushText(buf->maplist->urls, p);
		    }
		    break;
		case HTML_FRAMESET:
		    frameset_sp++;
		    if (frameset_sp >= FRAMESTACK_SIZE)
			break;
		    frameset_s[frameset_sp] = newFrameSet(t_arg);
		    if (frameset_s[frameset_sp] == NULL)
			break;
		    if (frameset_sp == 0) {
			if (buf->frameset == NULL) {
			    buf->frameset = frameset_s[frameset_sp];
			}
			else
			    pushFrameTree(&(buf->frameQ), frameset_s[frameset_sp], 0, 0);
		    }
		    else
			addFrameSetElement(frameset_s[frameset_sp - 1],
					   *(union frameset_element *) &frameset_s[frameset_sp]);
		    break;
		case HTML_N_FRAMESET:
		    if (frameset_sp >= 0)
			frameset_sp--;
		    break;
		case HTML_FRAME:
		    if (frameset_sp >= 0 && frameset_sp < FRAMESTACK_SIZE) {
			union frameset_element element;

			element.body = newFrame(t_arg, buf->baseURL);
			addFrameSetElement(frameset_s[frameset_sp], element);
		    }
		    break;
		case HTML_BASE:
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "href") && t->value) {
			    if (!buf->baseURL)
				buf->baseURL = New(ParsedURL);
			    parseURL(t->value, buf->baseURL, NULL);
			}
			else if (!strcasecmp(t->arg, "target") && t->value)
			    buf->baseTarget = t->value;
		    }
		    break;
		case HTML_TITLE_ALT:
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "title") && t->value) {
			    buf->buffername = t->value;
			}
		    }
		    break;
#ifndef KANJI_SYMBOLS
		case HTML_RULE:
		    for (t = t_arg; t; t = t->next) {
			if (!strcasecmp(t->arg, "type") && t->value) {
			    effect |= (PC_ISRULE | PC_RULE_FLAG(atoi(t->value)));
			    break;
			}
		    }
		    break;
		case HTML_N_RULE:
		    effect &= ~(PC_ISRULE | PC_RULE);
		    break;
#endif				/* not KANJI_SYMBOLS */
		}
#ifdef	ID_EXT
		id = NULL;
		for (t = t_arg; t; t = t->next) {
		    if (!t->value)
			continue;
		    else if (!strcasecmp(t->arg, "id")) {
			id = t->value;
			(void) registerName(buf, id, currentLn(buf), pos);
		    }
		    else if (renderFrameSet &&
			     !strcasecmp(t->arg, "framename")) {
			if (!idFrame ||
			    strcmp(idFrame->body->name, t->value)) {
			    idFrame = search_frame(renderFrameSet, t->value);
			    if (idFrame && idFrame->body->attr != F_BODY)
				idFrame = NULL;
			}
		    }
		}
		if (id && idFrame)
		    idFrame->body->nameList =
			putAnchor(idFrame->body->nameList,
				  id,
				  NULL,
				  (Anchor **) NULL,
				  NULL,
				  currentLn(buf), pos);
#endif				/* ID_EXT */
	    }
	}
	/* end of processing for one line */
	addnewline(buf, outc, outp, pos, nlines);
	if (*str != '\0') {
	    istr = str;
	    goto proc_again;
	}
    }
    if (w3m_debug)
	fclose(debug);
}

void
HTMLlineproc2(Buffer * buf, TextList * tl)
{
    _tl_lp2 = tl->first;
    HTMLlineproc2body(buf, textlist_feed, -1);
}

static FILE *_file_lp2;

static char *
file_feed()
{
    Str s;
    s = Strfgets(_file_lp2);
    if (s->length == 0) {
	fclose(_file_lp2);
	return NULL;
    }
    return s->ptr;
}

void
HTMLlineproc3(Buffer * buf, FILE * f)
{
    _file_lp2 = f;
    HTMLlineproc2body(buf, file_feed, -1);
}

static void
proc_escape(struct readbuffer *obuf, char **str_return)
{
    char *str = *str_return, *estr;
    int ech = getescapechar(str_return);
    int width, n_add = *str_return - str;
    int tlen, len = obuf->line->length;
    Lineprop pmode = obuf->prev_ctype, mode;
    char pch = obuf->prevchar;

    if (!ech) {
	push_char(obuf, obuf->flag & RB_SPECIAL, 1, *str, PC_ASCII);
	*str_return = str + 1;
	return;
    }

    estr = conv_latin1(ech);
    width = strlen(estr);
    if (IS_CNTRL(ech))
	mode = PC_CTRL;
    else
	mode = PC_ASCII;

    append_tags(obuf);

    tlen = obuf->line->length - len;

    if (pch == ' ')
	pmode = PC_ASCII;

    if (tlen > 0) {
	pch = '\0';
	pmode = PC_CTRL;
    }

    if (!(obuf->flag & RB_SPECIAL) && is_boundary(pch, pmode, ech, mode))
	set_breakpoint(obuf, tlen);

    if (width == 1 && ech == (unsigned char) *estr &&
	ech != '&' && ech != '<' && ech != '>')
	push_charp(obuf, width, estr, mode);
    else
	push_nchars(obuf, width, str, n_add, mode);
    obuf->prevchar = ech;
    obuf->prev_ctype = mode;
}


static int
need_flushline(struct html_feed_environ *h_env, struct readbuffer *obuf,
	       Lineprop mode)
{
    char ch = Strlastchar(obuf->line);

    if (obuf->flag & RB_PRE_INT) {
	if (obuf->pos > h_env->limit)
	    return 1;
	else
	    return 0;
    }

    /* if (ch == ' ' && obuf->tag_sp > 0) */
    if (ch == ' ')
	return 0;

    if (obuf->pos > h_env->limit)
	return 1;

    return 0;
}

/* HTML processing first pass */
void
HTMLlineproc1(char *istr, struct html_feed_environ *h_env)
{
    Lineprop mode = PC_ASCII, prev_mode;
    char *str = istr, *q, *str_bak;
    int cmd;
    int status;
    struct readbuffer *obuf = h_env->obuf;
    int indent;
#ifdef ID_EXT
    struct parsed_tagarg *targ;
#endif				/* ID_EXT */

    if (w3m_debug) {
	FILE *f = fopen("zzzproc1", "a");
	fprintf(f, "%c%c%c%c",
		(obuf->flag & RB_PREMODE) ? 'P' : ' ',
		(obuf->table_level > 0) ? 'T' : ' ',
		(obuf->flag & RB_INTXTA) ? 'X' : ' ',
		(obuf->flag & RB_IGNORE) ? 'I' : ' ');
	fprintf(f, "HTMLlineproc1(\"%s\",%d,%lx)\n", istr, h_env->limit, (unsigned long) h_env);
	fclose(f);
    }

  beginning:
    /* comment processing */
    if (obuf->status == R_ST_CMNT || obuf->status == R_ST_NCMNT3 ||
	obuf->status == R_ST_IRRTAG) {
	while (*str != '\0' && obuf->status != R_ST_NORMAL) {
	    next_status(*str, &obuf->status);
	    str++;
	}
	if (obuf->status != R_ST_NORMAL)
	    return;
    }

    if (obuf->flag & (RB_INTXTA
#ifdef MENU_SELECT
		      | RB_INSELECT
#endif
		      | RB_IGNORE)) {
	Str tok = Strnew(), tmp;
	if (obuf->status != R_ST_NORMAL && h_env->tagbuf->length > 0) {
	    tmp = Strdup(h_env->tagbuf);
	    Strcat_charp(tmp, str);
	    str = tmp->ptr;
	    obuf->status = R_ST_NORMAL;
	}
	while (str_bak = str,
	       read_token(tok, &str, &obuf->status,
			  (obuf->flag & RB_INTXTA) ? 1 : 0, 0)) {
	    char *p = tok->ptr;
	    int status, cmd = -1;
	    if (ST_IS_COMMENT(obuf->status))
		goto beginning;
	    if (obuf->status != R_ST_NORMAL) {
		h_env->tagbuf = tok;
		return;
	    }
	    if (*p == '<')
		cmd = gethtmlcmd(&p, &status);
	    /* textarea */
	    if (obuf->flag & RB_INTXTA) {
		if (cmd == HTML_N_TEXTAREA) {
		    close_textarea(h_env);
		    break;
		}
		feed_textarea(tok->ptr);
	    }
#ifdef MENU_SELECT
	    else if (obuf->flag & RB_INSELECT) {
		if (cmd == HTML_N_SELECT || cmd == HTML_N_FORM) {
		    obuf->flag &= ~RB_INSELECT;
		    if (cmd == HTML_N_FORM)
			str = str_bak;
		    tmp = process_n_select();
		    if (tmp)
			HTMLlineproc1(tmp->ptr, h_env);
		    break;
		}
		feed_select(tok->ptr);
	    }
#endif
	    /* script */
	    else if (obuf->flag & RB_IGNORE) {
		if (TAG_IS(tok->ptr, obuf->ignore_tag->ptr,
			   obuf->ignore_tag->length - 1)) {
		    obuf->flag &= ~RB_IGNORE;
		    break;
		}
	    }
	}
    }

    while (*str != '\0') {
	if (obuf->table_level > 0 && obuf->status == R_ST_NORMAL) {
	    /* 
	     * within table: in <table>..</table>, all input tokens
	     * are fed to the table renderer, and then the renderer
	     * makes HTML output.
	     */
	  check_table_tag:
	    if (*str == '\0')
		return;
	    switch (feed_table(tables[obuf->table_level - 1], &str,
			       &table_mode[obuf->table_level - 1],
			       table_width[obuf->table_level - 1])) {
	    case 0:
		/* </table> tag */
		obuf->table_level--;
		obuf->prevchar = ' ';
		if (obuf->table_level > 0) {
		    Str tmp;
		    if (table_width[obuf->table_level] > 0)
			tmp = Sprintf("<dummy_table id=%d width=%d>",
				   tables[obuf->table_level - 1]->ntable,
				      table_width[obuf->table_level]);
		    else
			tmp = Sprintf("<dummy_table id=%d>",
				  tables[obuf->table_level - 1]->ntable);
		    pushTable(tables[obuf->table_level - 1],
			      tables[obuf->table_level]);
		    feed_table1(tables[obuf->table_level - 1], tmp,
				&table_mode[obuf->table_level - 1],
				table_width[obuf->table_level - 1]);
		    goto check_table_tag;
		    /* continue to the next */
		}
		if (obuf->table_level == 0) {
		    save_fonteffect(h_env, obuf);
		    renderTable(tables[0], table_width[0], h_env);
		    restore_fonteffect(h_env, obuf);
		    mode = PC_ASCII;
		}
	    case 1:
		/* <table> tag */
		goto proc_normal;
	    case 2:
		/* comment */
		obuf->status = tables[obuf->table_level - 1]->status;
		tables[obuf->table_level - 1]->status = R_ST_NORMAL;
		return;
	    default:
		goto check_table_tag;
	    }
	}
      proc_normal:
	if (*str == '\0')
	    break;
#ifdef MENU
	if (obuf->flag & (RB_INTXTA | RB_INSELECT | RB_IGNORE))
	    goto beginning;
#else				/* not MENU */
	if (obuf->flag & (RB_INTXTA | RB_IGNORE))
	    goto beginning;
#endif				/* not MENU */
	if ((*str == '<'
#ifdef JP_CHARSET
	     && mode != PC_KANJI1
#endif				/* JP_CHARSET */
	    ) || ST_IS_TAG(obuf->status)) {
	    /* 
	     * Tag processing
	     */
	    if (ST_IS_TAG(obuf->status)) {
/*** continuation of a tag ***/
		read_token(h_env->tagbuf, &str, &obuf->status,
			   obuf->flag & (RB_XMPMODE | RB_LSTMODE), 1);
	    }
	    else {
		if (!REALLY_THE_BEGINNING_OF_A_TAG(str)) {
		    /* this is NOT a beginning of a tag */
		    obuf->status = R_ST_NORMAL;
		    HTMLlineproc1("&lt;", h_env);
		    str++;
		    continue;
		}
		read_token(h_env->tagbuf, &str, &obuf->status,
			   obuf->flag & (RB_XMPMODE | RB_LSTMODE), 0);
	    }
	    if (ST_IS_COMMENT(obuf->status)) {
		if (obuf->flag & RB_IGNORE)
		    /* within ignored tag, such as *
		     * <script>..</script>, don't process comment.  */
		    obuf->status = R_ST_NORMAL;
		return;
	    }
	    if (h_env->tagbuf->length == 0)
		continue;
/*** Beginning of a new tag ***/
	    if (obuf->flag & RB_PLAIN)
		goto read_as_plain;		/* don't process tag */
	    if (*str == '\0' && obuf->status != R_ST_NORMAL) {
		if (!(obuf->flag & (RB_XMPMODE | RB_LSTMODE))) {
		    if (obuf->status == R_ST_DQUOTE &&
			Strlastchar(h_env->tagbuf) == '\n')
			Strchop(h_env->tagbuf);
		    else if (str[-1] != '\n')
			Strcat_char(h_env->tagbuf, '\n');
		}
		return;
	    }
	    q = h_env->tagbuf->ptr;
	    cmd = gethtmlcmd(&q, &status);
	    if (obuf->flag & RB_XMPMODE && cmd != HTML_N_XMP ||
		obuf->flag & RB_LSTMODE && cmd != HTML_N_LISTING) {
		Str tmp = Strdup(h_env->tagbuf);
		Strcat_charp(tmp, str);
		str = tmp->ptr;
		goto read_as_plain;
	    }
#ifdef ID_EXT
	    targ = parse_tag(h_env->tagbuf->ptr);
	    /* process tags */
	    if (HTMLtagproc1(cmd, targ, h_env) == 0)
#else
	    /* process tags */
	    if (HTMLtagproc1(cmd, h_env) == 0)
#endif				/* ID_EXT */
	    {
		/* preserve the tag for second-stage processing */
		push_tag(obuf, h_env->tagbuf->ptr, cmd);
	    }
#ifdef ID_EXT
	    else {
		process_idattr(obuf, cmd, targ);
	    }
#endif				/* ID_EXT */
	    obuf->bp.init_flag = 1;
	    clear_ignore_p_flag(cmd, obuf);
	    continue;
	}
      read_as_plain:
	prev_mode = mode;
	mode = get_ctype((unsigned char) *str, prev_mode);
#ifdef JP_CHARSET
	if (prev_mode == PC_KANJI1 && mode != PC_KANJI2) {
	    Strshrink(obuf->line, 1);
	    push_char(obuf, 1, 0, ' ', PC_ASCII);
	}
#endif				/* JP_CHARSET */
	if (obuf->flag & (RB_SPECIAL & ~RB_NOBR)) {
	    if (*str != '\n' && *str != '\r')
		obuf->flag &= ~RB_IGNORE_P;
	    if (*str == '\n' || *str == '\r') {
		if (*str == '\r' && *(str + 1) == '\n')
		    str += 2;
		else
		    str++;
		if (obuf->flag & RB_IGNORE_P) {
		    obuf->flag &= ~RB_IGNORE_P;
		    continue;
		}
		if (obuf->flag & RB_PRE_INT)
		    PUSH(' ');
		else
		    flushline(h_env, obuf, h_env->envs[h_env->envc].indent, 1, h_env->limit);
	    }
	    else if (*str == '\t') {
		do {
		    PUSH(' ');
		} while (obuf->pos % Tabstop != 0);
		str++;
	    }
	    else if (obuf->flag & (RB_XMPMODE | RB_LSTMODE)) {
		char *p = htmlquote_char(*str);
		if (p) {
		    while (*p) {
			PUSH(*p++);
		    }
		    str++;
		}
		else {
		    push_char(obuf, 1, 1, *str++, mode);
		}
	    }
	    else {
		if (*str == '&')
		    proc_escape(obuf, &str);
		else
		    push_char(obuf, 1, 1, *str++, mode);
	    }
	    if (obuf->flag & (RB_SPECIAL & ~RB_PRE_INT))
		continue;
	}
	else {
	    if (!IS_SPACE(*str))
		obuf->flag &= ~RB_IGNORE_P;
	    if ((mode == PC_ASCII || mode == PC_CTRL) && IS_SPACE(*str)) {
		if (obuf->prevchar != ' ') {
		    PUSH(' ');
		}
		str++;
	    }
	    else {
#ifdef JP_CHARSET
		if (mode == PC_KANJI1 &&
		    obuf->pos > h_env->envs[h_env->envc].indent &&
		    Strlastchar(obuf->line) == ' ') {
		    while (obuf->line->length >= 2 &&
			   !strncmp(obuf->line->ptr + obuf->line->length - 2, "  ", 2) &&
			   obuf->pos >= h_env->envs[h_env->envc].indent) {
			Strshrink(obuf->line, 1);
			obuf->pos--;
		    }
		    if (obuf->line->length >= 3 &&
			obuf->prev_ctype == PC_KANJI2 &&
			Strlastchar(obuf->line) == ' ' &&
			obuf->pos >= h_env->envs[h_env->envc].indent) {
			Strshrink(obuf->line, 1);
			obuf->pos--;
		    }
		}
#endif				/* JP_CHARSET */
		if (*str == '&')
		    proc_escape(obuf, &str);
		else
		    push_char(obuf, obuf->flag & RB_SPECIAL, 1, *str++, mode);
	    }
	}
	if (need_flushline(h_env, obuf, mode)
#ifdef JP_CHARSET
	    && mode != PC_KANJI1
#endif				/* JP_CHARSET */
	    ) {
	    char *bp = obuf->line->ptr + obuf->bp.len;
	    char *tp = bp - obuf->bp.tlen;
	    int i = 0;

	    if (tp > obuf->line->ptr && tp[-1] == ' ')
		i = 1;

	    indent = h_env->envs[h_env->envc].indent;
	    if (obuf->bp.pos - i > indent) {
		Str line;
		append_tags(obuf);
		line = Strnew_charp(bp);
		Strshrink(obuf->line, obuf->line->length - obuf->bp.len);
#ifdef FORMAT_NICE
		if (obuf->pos - i > h_env->limit)
		    obuf->flag |= RB_FILL;
#endif				/* FORMAT_NICE */
		back_to_breakpoint(obuf);
		flushline(h_env, obuf, indent, 0, h_env->limit);
#ifdef FORMAT_NICE
		obuf->flag &= ~RB_FILL;
#endif				/* FORMAT_NICE */
		HTMLlineproc1(line->ptr, h_env);
	    }
	}
    }
    if (!(obuf->flag & (RB_PREMODE | RB_NOBR | RB_INTXTA
#ifdef MENU_SELECT
			| RB_INSELECT
#endif
			| RB_XMPMODE | RB_LSTMODE | RB_IGNORE))) {
	char *tp;
	int i = 0;

	if (obuf->bp.pos == obuf->pos) {
	    tp = &obuf->line->ptr[obuf->bp.len - obuf->bp.tlen];
	}
	else {
	    tp = &obuf->line->ptr[obuf->line->length];
	}

	if (tp > obuf->line->ptr && tp[-1] == ' ')
	    i = 1;
	indent = h_env->envs[h_env->envc].indent;
	if (obuf->pos - i > h_env->limit) {
#ifdef FORMAT_NICE
	    obuf->flag |= RB_FILL;
#endif				/* FORMAT_NICE */
	    flushline(h_env, obuf, indent, 0, h_env->limit);
#ifdef FORMAT_NICE
	    obuf->flag &= ~RB_FILL;
#endif				/* FORMAT_NICE */
	}
    }
}

static void
close_textarea(struct html_feed_environ *h_env)
{
    Str tmp;

    if (!(tmp = process_n_textarea()))
	return;

    h_env->obuf->flag &= ~RB_INTXTA;
    HTMLlineproc1(tmp->ptr, h_env);
}

extern char *NullLine;
extern Lineprop NullProp[];

static void
addnewline(Buffer * buf, char *line, Lineprop * prop, int pos, int nlines)
{
    Line *l;
    l = New(Line);
    l->next = NULL;
    if (pos > 0) {
	l->lineBuf = allocStr(line, pos);
	l->propBuf = New_N(Lineprop, pos);
    }
    else {
	l->lineBuf = NullLine;
	l->propBuf = NullProp;
    }
    bcopy((void *) prop, (void *) l->propBuf, pos * sizeof(Lineprop));
    l->len = pos;
    l->prev = buf->currentLine;
    if (buf->currentLine) {
	l->next = buf->currentLine->next;
	buf->currentLine->next = l;
    }
    else
	l->next = NULL;
    if (buf->lastLine == NULL || buf->lastLine == buf->currentLine)
	buf->lastLine = l;
    buf->currentLine = l;
    if (buf->firstLine == NULL)
	buf->firstLine = l;
    l->linenumber = ++buf->allLine;
    if (nlines < 0) {
	l->real_linenumber = l->linenumber;
    }
    else {
	l->real_linenumber = nlines;
    }
    l = NULL;
}

/* 
 * loadHTMLBuffer: read file and make new buffer
 */
Buffer *
loadHTMLBuffer(URLFile * f, Buffer * newBuf)
{
    FILE *src = NULL;
    Str tmp;

    if (newBuf == NULL)
	newBuf = newBuffer(INIT_BUFFER_WIDTH);
    if (newBuf->sourcefile == NULL && f->scheme != SCM_LOCAL) {
	tmp = Sprintf("%s/w3msrc%d.%lx", rc_dir, getpid(), (unsigned long) newBuf);
	src = fopen(tmp->ptr, "w");
	if (src)
	    newBuf->sourcefile = tmp->ptr;
    }

    loadHTMLstream(f, newBuf, src);

    newBuf->topLine = newBuf->firstLine;
    newBuf->lastLine = newBuf->currentLine;
    newBuf->currentLine = newBuf->firstLine;
    if (src)
	fclose(src);

    return newBuf;
}

static char *_size_unit[] =
{"b", "kb", "Mb", "Gb", "Tb",
 "Pb", "Eb", "Zb", "Bb", "Yb", NULL};

char *
convert_size(int size, int usefloat)
{
    float csize;
    int sizepos = 0;
    char **sizes = _size_unit;

    csize = (float) size;
    while (csize > 1024.0 && sizes[sizepos + 1]) {
	csize = csize / 1024.0;
	sizepos++;
    }
    return Sprintf(usefloat ? "%.1f%s" : "%.0f%s",
		   csize, sizes[sizepos])->ptr;
}

char *
convert_size2(int size1, int size2, int usefloat)
{
    char **sizes = _size_unit;
    float csize, factor = 1;
    int sizepos = 0;

    csize = (size1 > size2) ? size1 : size2;

    while (csize / factor > 1024.0 && sizes[sizepos + 1]) {
	factor *= 1024.0;
	sizepos++;
    }

    return Sprintf(usefloat ? "%.1f/%.1f%s" : "%.0f/%.0f%s",
		   size1 / factor, size2 / factor, sizes[sizepos])->ptr;
}

void
showProgress(int *linelen, int *trbyte)
{
    int i, j, rate, duration, eta, pos;
    static time_t last_time, start_time;
    time_t cur_time = time(0);

    if (!fmInitialized)
	return;

    if (current_content_length > 0) {
	if (cur_time == last_time)
	    return;
	last_time = cur_time;
	if (*trbyte == 0) {
	    move(LASTLINE, 0);
	    clrtoeolx();
	    start_time = time(NULL);
	}
	*trbyte += *linelen;
	*linelen = 0;
	move(LASTLINE, 0);
	duration = time(NULL) - start_time;
	rate = duration ? *trbyte / duration : 0;
	eta = rate ? (current_content_length - *trbyte) / rate : 0;
	addstr(Sprintf("%11s %3.0f%% %7s/s eta %02d:%02d:%02d     ",
		       convert_size2(*trbyte, current_content_length, 0),
	100.0 * (*trbyte) / current_content_length, convert_size(rate, 1),
		       eta / (60 * 60), (eta / 60) % 60, eta % 60)->ptr);
	pos = 42;
	i = pos + (COLS - pos - 1) * (*trbyte) / current_content_length;
	move(LASTLINE, pos);
#if 0				/* def KANJI_SYMBOLS */
	for (j = pos; j <= i; j += 2)
	    addstr("");
#else				/* not 0 */
	standout();
	addch(' ');
	for (j = pos + 1; j <= i; j++)
	    addch('|');
	standend();
#endif				/* not 0 */
	/* no_clrtoeol(); */
	refresh();
    }
    else if (*linelen > 1000) {
	if (cur_time == last_time)
	    return;
	last_time = cur_time;
	if (*trbyte == 0) {
	    move(LASTLINE, 0);
	    clrtoeolx();
	    start_time = time(NULL);
	}
	*trbyte += *linelen;
	*linelen = 0;
	move(LASTLINE, 0);
	duration = time(NULL) - start_time;
	rate = duration ? *trbyte / duration : 0;
	message(Sprintf("%7s loaded %7s/s\n",
	    convert_size(*trbyte, 1), convert_size(rate, 1))->ptr, 0, 0);
	refresh();
    }
}

void
init_henv(struct html_feed_environ *h_env, struct readbuffer *obuf,
	  struct environment *envs, int nenv, TextList * buf,
	  int limit, int indent)
{
    envs[0].indent = indent;

    obuf->line = Strnew();
    obuf->cprop = 0;
    obuf->pos = 0;
    obuf->prevchar = ' ';
    obuf->flag = RB_IGNORE_P;
    obuf->flag_sp = 0;
    obuf->status = R_ST_NORMAL;
    obuf->table_level = 0;
    obuf->nobr_level = 0;
    obuf->anchor = 0;
    obuf->anchor_target = 0;
    obuf->anchor_hseq = 0;
    obuf->img_alt = 0;
    obuf->in_bold = 0;
    obuf->in_under = 0;
    obuf->prev_ctype = PC_ASCII;
    obuf->tag_sp = 0;
    obuf->fontstat_sp = 0;
    obuf->bp.init_flag = 1;
    set_breakpoint(obuf, 0);

    h_env->buf = buf;
    h_env->f = NULL;
    h_env->obuf = obuf;
    h_env->tagbuf = Strnew();
    h_env->limit = limit;
    h_env->envs = envs;
    h_env->nenv = nenv;
    h_env->envc = 0;
    h_env->envc_real = 0;
    h_env->title = NULL;
}

void
loadHTMLstream(URLFile * f, Buffer * newBuf, FILE * src)
{
    struct environment envs[MAX_ENV_LEVEL];
    int linelen = 0;
    int trbyte = 0;
    Str lineBuf2 = Strnew();
    Str qp_lbuf = NULL;
    char code;
    struct html_feed_environ htmlenv1;
    struct readbuffer obuf;
    MySignalHandler(*prevtrap) ();

    if (SETJMP(AbortLoading) != 0) {
	HTMLlineproc1("<br>Transfer Interrupted!<br>", &htmlenv1);
	goto phase2;
    }
    if (fmInitialized) {
	prevtrap = signal(SIGINT, KeyAbort);
	term_cbreak();
    }

    n_textarea = 0;
#ifdef MENU_SELECT
    n_select = 0;
#endif				/* MENU_SELECT */
    form_sp = -1;
#ifdef NEW_FORM
    form_max = -1;
    forms_size = 0;
    forms = NULL;
#endif				/* NEW_FORM */

    cur_hseq = 1;

    if (w3m_halfload) {
	newBuf->buffername = "---";
#ifdef JP_CHARSET
	newBuf->document_code = '\0';
#endif				/* JP_CHARSET */
	HTMLlineproc3(newBuf, f->stream.f);
	w3m_halfload = FALSE;
	if (fmInitialized) {
	    term_raw();
	    signal(SIGINT, prevtrap);
	}
	return;
    }

    init_henv(&htmlenv1, &obuf, envs, MAX_ENV_LEVEL, NULL, newBuf->width, 0);

    if (w3m_halfdump)
	htmlenv1.f = stdout;
    else
	htmlenv1.buf = newTextList();

#ifdef JP_CHARSET
    if (newBuf != NULL && newBuf->document_code != '\0')
	code = newBuf->document_code;
    else
	code = content_charset;
    content_charset = '\0';
#endif
#if	0
    do_blankline(&htmlenv1, &obuf, 0, 0, htmlenv1.limit);
    obuf.flag = RB_IGNORE_P;
#endif
    while (!f->iseof) {
	lineBuf2 = StrmyUFgets(f);
	if (lineBuf2->length == 0) {
	    if (qp_lbuf == NULL)
		break;
	}
	else {
	    if (src)
		Strfputs(lineBuf2, src);
	}
	linelen += lineBuf2->length;
	showProgress(&linelen, &trbyte);
	if (f->encoding == ENC_QUOTE) {
	    char *p;
	    if (qp_lbuf != NULL)
		Strcat(qp_lbuf, lineBuf2);
	    else
		qp_lbuf = lineBuf2;
	    p = lineBuf2->ptr;
	    while ((p = strchr(p, '=')) != NULL) {
		++p;
		if (IS_SPACE(*p))
		    break;
	    }
	    if (p != NULL)
		continue;
	    lineBuf2 = qp_lbuf;
	    qp_lbuf = NULL;
	}
#ifdef JP_CHARSET
	if (content_charset != '\0') {	/* <META> */
	    code = content_charset;
	    content_charset = '\0';
	}
#endif
	lineBuf2 = convertLine(f, lineBuf2, &code);
#ifdef USE_NNTP
	if (f->scheme == SCM_NEWS) {
	    if (Str_news_endline(lineBuf2)) {
		f->iseof = TRUE;
		break;
	    }
	}
#endif				/* USE_NNTP */
	HTMLlineproc1(lineBuf2->ptr, &htmlenv1);
    }
    if (obuf.status == R_ST_CMNT)
	HTMLlineproc1("-->", &htmlenv1);
    else if (obuf.status == R_ST_TAG)
	HTMLlineproc1(">", &htmlenv1);
    obuf.status = R_ST_NORMAL;
#ifdef MENU_SELECT
    /* for unbalanced select tag */
    if (obuf.flag & RB_INSELECT)
	HTMLlineproc1("</select>", &htmlenv1);
#endif
    /* for unbalanced table tag */
    while (obuf.table_level > 0) {
	table_mode[obuf.table_level -1].pre_mode
	    &= ~(TBLM_IGNORE | TBLM_XMP | TBLM_LST);
	HTMLlineproc1("</table>", &htmlenv1);
    }

    flushline(&htmlenv1, &obuf, 0, 0, htmlenv1.limit);
    if (htmlenv1.title)
	newBuf->buffername = htmlenv1.title;
    if (w3m_halfdump) {
	if (fmInitialized) {
	    term_raw();
	    signal(SIGINT, prevtrap);
	}
	return;
    }
  phase2:
    newBuf->trbyte = trbyte + linelen;
    if (fmInitialized) {
	term_raw();
	signal(SIGINT, prevtrap);
    }
    HTMLlineproc2(newBuf, htmlenv1.buf);
#ifdef JP_CHARSET
    newBuf->document_code = code;
#endif				/* JP_CHARSET */
}

/* 
 * loadHTMLString: read string and make new buffer
 */
Buffer *
loadHTMLString(char *page)
{
    URLFile f;
    MySignalHandler(*prevtrap) ();
    Buffer *newBuf;

    newBuf = newBuffer(INIT_BUFFER_WIDTH);
    if (SETJMP(AbortLoading) != 0) {
	discardBuffer(newBuf);
	return NULL;
    }
    bzero((void*)&f,sizeof f);
    f.scheme = SCM_LOCAL;
    f.iseof = CMP_NOCOMPRESS;
    f.encoding = ENC_7BIT;
    f.stream.is = page;
    f.stream_type = SMT_STRING;
    f.close = nulcmd;

    if (fmInitialized) {
	prevtrap = signal(SIGINT, KeyAbort);
	term_cbreak();
    }

    loadHTMLstream(&f, newBuf, NULL);

    if (fmInitialized) {
	term_raw();
	signal(SIGINT, prevtrap);
    }
    newBuf->topLine = newBuf->firstLine;
    newBuf->lastLine = newBuf->currentLine;
    newBuf->currentLine = newBuf->firstLine;
#ifdef JP_CHARSET
    newBuf->document_code = InnerCode;
#endif				/* JP_CHARSET */

    return newBuf;
}

#ifdef USE_GOPHER

/* 
 * loadGopherDir: get gopher directory
 */
Buffer *
loadGopherDir(URLFile * uf, Buffer * newBuf)
{
    FILE *f = uf->stream.f;
#ifdef JP_CHARSET
    char code, ic;
#endif
    Str name, file, host, port;
    char type;
    char *p;
    TextList *tl = newTextList();
    Str lbuf;
    int hseq = 1;

    if (newBuf == NULL)
	newBuf = newBuffer(INIT_BUFFER_WIDTH);
#ifdef JP_CHARSET
    if (newBuf->document_code != '\0')
	code = newBuf->document_code;
    else
	code = content_charset;
    content_charset = '\0';
#endif
    while (1) {
	if (lbuf = Strmyfgets(f), lbuf->length == 0)
	    break;
	if (lbuf->ptr[0] == '.' &&
	    (lbuf->ptr[1] == '\n' || lbuf->ptr[1] == '\r'))
	    break;
#ifdef JP_CHARSET
	if ((ic = checkShiftCode(lbuf->ptr, code)) != '\0')
	    lbuf = conv(lbuf->ptr, (code = ic), InnerCode);
#endif				/* JP_CHARSET */

	p = lbuf->ptr;
	for (name = Strnew(); *p && *p != '\t'; p++)
	    Strcat_char(name, *p);
	p++;
	for (file = Strnew(); *p && *p != '\t'; p++)
	    Strcat_char(file, *p);
	p++;
	for (host = Strnew(); *p && *p != '\t'; p++)
	    Strcat_char(host, *p);
	p++;
	for (port = Strnew(); *p &&
	     *p != '\t' && *p != '\r' && *p != '\n';
	     p++)
	    Strcat_char(port, *p);
	p++;
	type = name->ptr[0];
	switch (type) {
	case '0':
	    p = "[text file]  ";
	    break;
	case '1':
	    p = "[directory]  ";
	    break;
	case 'm':
	    p = "[message]    ";
	    break;
	case 's':
	    p = "[sound]      ";
	    break;
	case 'g':
	    p = "[gif]        ";
	    break;
	case 'h':
	    p = "[HTML]       ";
	    break;
	default:
	    p = "[unsupported]";
	    break;
	}
	lbuf = Sprintf("<A HSEQ=\"%d\" HREF=\"gopher://", hseq++);
	Strcat(lbuf, host);
	Strcat_char(lbuf, ':');
	Strcat(lbuf, port);
	Strcat_char(lbuf, '/');
	Strcat(lbuf, file);
	Strcat_charp(lbuf, "\">");
	Strcat_charp(lbuf, p);
	Strcat_charp(lbuf, name->ptr + 1);
	pushText(tl, lbuf->ptr);
    }
    HTMLlineproc2(newBuf, tl);
    newBuf->topLine = newBuf->firstLine;
    newBuf->lastLine = newBuf->currentLine;
    newBuf->currentLine = newBuf->firstLine;

    return newBuf;
}
#endif				/* USE_GOPHER */

/* 
 * loadBuffer: read file and make new buffer
 */
Buffer *
loadBuffer(URLFile * uf, Buffer * newBuf)
{
    FILE *src = NULL;
    char code;
    Str lineBuf2, qp_lbuf = NULL;
    char pre_lbuf = '\0';
    int i, j, nlines;
    Str tmpf;
    Str(*gets_rout) (URLFile *);
    int linelen = 0, trbyte = 0;
    MySignalHandler(*prevtrap) ();

    if (newBuf == NULL)
	newBuf = newBuffer(INIT_BUFFER_WIDTH);
    lineBuf2 = Strnew();

    if (SETJMP(AbortLoading) != 0) {
	goto _end;
    }
    if (fmInitialized) {
	prevtrap = signal(SIGINT, KeyAbort);
	term_cbreak();
    }

    if (newBuf->sourcefile == NULL && uf->scheme != SCM_LOCAL) {
	tmpf = Sprintf("%s/w3msrc%d.%lx", rc_dir, getpid(), (unsigned long) newBuf);
	src = fopen(tmpf->ptr, "w");
	if (src)
	    newBuf->sourcefile = tmpf->ptr;
    }
#ifdef JP_CHARSET
    if (newBuf->document_code != '\0')
	code = newBuf->document_code;
    else
	code = content_charset;
    content_charset = '\0';
#endif
    if (do_download)
	gets_rout = StrUFgets;	/* Don't touch terminal character */
    else
	gets_rout = StrmyUFgets;	/* Convert \r\n into \n */

    nlines = 0;
    while (!uf->iseof) {
	lineBuf2 = gets_rout(uf);
	if (lineBuf2->length == 0) {
	    if (qp_lbuf == NULL)
		break;
	}
	else {
	    if (src)
		Strfputs(lineBuf2, src);
	}
	linelen += lineBuf2->length;
	showProgress(&linelen, &trbyte);
	if (squeezeBlankLine) {
	    if (lineBuf2->ptr[0] == '\n' && pre_lbuf == '\n') {
		++nlines;
		continue;
	    }
	    pre_lbuf = lineBuf2->ptr[0];
	}
	if (uf->encoding == ENC_QUOTE) {
	    char *p;
	    if (qp_lbuf != NULL)
		Strcat(qp_lbuf, lineBuf2);
	    else
		qp_lbuf = lineBuf2;
	    p = lineBuf2->ptr;
	    while ((p = strchr(p, '=')) != NULL) {
		++p;
		if (IS_SPACE(*p))
		    break;
	    }
	    if (p != NULL)
		continue;
	    lineBuf2 = qp_lbuf;
	    qp_lbuf = NULL;
	}
	++nlines;
	if (showLineNum) {
	    Str tmp = Sprintf("%4d:", nlines);
	    Strcat(tmp, lineBuf2);
	    lineBuf2 = tmp;
	}
	lineBuf2 = convertLine(uf, lineBuf2, &code);
#ifdef USE_NNTP
	if (uf->scheme == SCM_NEWS) {
	    if (Str_news_endline(lineBuf2)) {
		uf->iseof = TRUE;
		break;
	    }
	}
#endif				/* USE_NNTP */
	lineBuf2 = checkType(lineBuf2->ptr, propBuffer, LINELEN);
	j = 0;
	for (i = 0; lineBuf2->ptr[i]; i++) {
	    if (lineBuf2->ptr[i] == '\r') {
		addnewline(newBuf, &lineBuf2->ptr[j], &propBuffer[j], i - j, nlines);
		if (lineBuf2->ptr[i + 1] == '\n')
		    i++;
		j = i + 1;
	    }
	    else if (lineBuf2->ptr[i] == '\n') {
		addnewline(newBuf, &lineBuf2->ptr[j], &propBuffer[j], i - j, nlines);
		j = i + 1;
	    }
	}
	if (lineBuf2->ptr[i - 1] != '\n' && lineBuf2->ptr[i - 1] != '\r')
	    addnewline(newBuf, &lineBuf2->ptr[j], &propBuffer[j], i - j, nlines);
    }
  _end:
    if (fmInitialized) {
	signal(SIGINT, prevtrap);
	term_raw();
    }
    newBuf->topLine = newBuf->firstLine;
    newBuf->currentLine = newBuf->firstLine;
    newBuf->trbyte = trbyte + linelen;
#ifdef JP_CHARSET
    newBuf->document_code = code;
#endif				/* JP_CHARSET */
    if (src)
	fclose(src);

    return newBuf;
}

/* 
 * saveBuffer: write buffer to file
 */

void
saveBuffer(Buffer * buf, FILE * f)
{
    saveBufferDelNum(buf, f, FALSE);
}

void
saveBufferDelNum(Buffer * buf, FILE * f, int del)
{
    Line *l = buf->firstLine;
    Str tmp;
    char *p;

  pager_next:
    for (; l != NULL; l = l->next) {
#ifdef JP_CHARSET
	tmp = conv(l->lineBuf, InnerCode, DisplayCode);
#else				/* not JP_CHARSET */
	tmp = Strnew_charp(l->lineBuf);
#endif				/* not JP_CHARSET */
	if (del) {
	    if ((p = strchr(tmp->ptr, ':')) != NULL)
		Strcopy_charp(tmp, p + 1);
	}
	Strfputs(tmp, f);
	if (Strlastchar(tmp) != '\n')
	    putc('\n', f);
    }
    if (buf->pagerSource &&
    strncmp(buf->buffername, CPIPEBUFFERNAME, strlen(CPIPEBUFFERNAME))) {
	l = getNextPage(buf, PagerMax);
	goto pager_next;
    }
}

/* 
 * getshell: execute shell command and get the result into a buffer
 */
Buffer *
getshell(char *cmd)
{
    FILE *f, *popen(const char *, const char *);
    Buffer *buf;
    URLFile uf;
    Str bn;

    uf.scheme = SCM_UNKNOWN;
    if (cmd == NULL || *cmd == '\0')
	return NULL;
    f = popen(cmd, "r");
    if (f == NULL)
	return NULL;
    uf.stream.f = f;
    uf.stream_type = SMT_FILE;
    uf.encoding = ENC_7BIT;
    uf.iseof = FALSE;
    buf = loadBuffer(&uf, NULL);
    pclose(f);
    if (buf == NULL)
	return NULL;
    buf->filename = cmd;
    bn = Sprintf("%s %s", SHELLBUFFERNAME, cmd);
    buf->buffername = bn->ptr;
    return buf;
}

/* 
 * getpipe: execute shell command and connect pipe to the buffer
 */
Buffer *
getpipe(char *cmd)
{
    FILE *f, *popen(const char *, const char *);
    Buffer *buf;
    Str bn;

    if (cmd == NULL || *cmd == '\0')
	return NULL;
    f = popen(cmd, "r");
    if (f == NULL)
	return NULL;
    buf = newBuffer(INIT_BUFFER_WIDTH);
    buf->pagerSource = f;
    buf->filename = cmd;
    bn = Sprintf("%s %s", PIPEBUFFERNAME, cmd);
    buf->buffername = bn->ptr;
    buf->bufferprop |= BP_PIPE;
    return buf;
}

/* 
 * Open pager buffer
 */
Buffer *
openPagerBuffer(FILE * f, Buffer * buf)
{

    if (buf == NULL)
	buf = newBuffer(INIT_BUFFER_WIDTH);
    buf->pagerSource = f;
    buf->buffername = PIPEBUFFERNAME;
    buf->bufferprop |= BP_PIPE;

    buf->currentLine = buf->firstLine;

    return buf;
}

Buffer *
openGeneralPagerBuffer(FILE * f)
{
    Buffer *buf;
    char *extviewer;
    char *t = "text/plain";
    Buffer *t_buf = NULL;
    URLFile uf;

    uf.scheme = SCM_UNKNOWN;
    uf.stream.f = f;
    uf.stream_type = SMT_FILE;
    uf.iseof = FALSE;
    uf.encoding = ENC_7BIT;

#ifdef JP_CHARSET
    content_charset = '\0';
#endif
    if (SearchHeader) {
	t_buf = newBuffer(INIT_BUFFER_WIDTH);
	readHeader(&uf, t_buf, TRUE, NULL);
	t = checkContentType(t_buf);
	if (t == NULL)
	    t = "text/plain";
	if (t_buf) {
	    t_buf->topLine = t_buf->firstLine;
	    t_buf->currentLine = t_buf->lastLine;
	}
	SearchHeader = FALSE;
    }
    else if (DefaultType) {
	t = DefaultType;
	DefaultType = NULL;
    }
    if (!strcmp(t, "text/plain"))
	buf = openPagerBuffer(f, t_buf);
    else if (!strcmp(t, "text/html")) {
	buf = loadHTMLBuffer(&uf, t_buf);
    }
    else {
	extviewer = searchExtViewer(t);
	if (extviewer) {
	    URLFile uf;
	    uf.scheme = SCM_UNKNOWN;
	    uf.stream.f = f;
	    uf.encoding = ENC_7BIT;
	    doExternal(uf, extviewer);
	    return NO_BUFFER;
	}
	else {			/* unknown type is regarded as text/plain */
	    buf = openPagerBuffer(f, t_buf);
	}
    }
    buf->type = t;
    buf->encoding = uf.encoding;
    buf->currentURL.scheme = SCM_LOCAL;
    buf->currentURL.file = "-";
    return buf;
}

Line *
getNextPage(Buffer * buf, int plen)
{
    Line *l, *fl, *pl = buf->lastLine;
    Line *rl = NULL;
    int len, i, nlines = 0;
    int linelen = buf->linelen, trbyte = buf->trbyte;
    Str lineBuf2, qp_lbuf = NULL;
    char pre_lbuf = '\0';
    URLFile uf;
#ifdef JP_CHARSET
    char code = buf->document_code, ic;
#endif
    int squeeze_flag = 0;

    if (buf->pagerSource == NULL)
	return NULL;

    if (fmInitialized)
	crmode();
    if (pl != NULL) {
	nlines = pl->real_linenumber;
	pre_lbuf = *(pl->lineBuf);
	if (showLineNum) {
	    char *p;
	    if ((p = strchr(pl->lineBuf, ':')) != NULL)
		pre_lbuf = *(p + 1);
	}
	if (pre_lbuf == '\0')
	    pre_lbuf = '\n';
    }

    uf.scheme = SCM_UNKNOWN;
    uf.encoding = buf->encoding;
    for (i = 0; i < plen; i++) {
	lineBuf2 = Strmyfgets(buf->pagerSource);
	if (lineBuf2->length == 0 && qp_lbuf == NULL) {
	    /* Assume that `cmd == buf->filename' */
	    if (buf->filename)
		buf->buffername = Sprintf("%s %s",
		    CPIPEBUFFERNAME, buf->filename)->ptr;
	    else
		buf->buffername = CPIPEBUFFERNAME;
	    trbyte += linelen;
	    linelen = 0;
	    break;
	}
        linelen += lineBuf2->length;
        showProgress(&linelen, &trbyte);
	if (squeezeBlankLine) {
	    squeeze_flag = 0;
	    if (lineBuf2->ptr[0] == '\n' && pre_lbuf == '\n') {
		++nlines;
		--i;
		squeeze_flag = 1;
		continue;
	    }
	    pre_lbuf = lineBuf2->ptr[0];
	}
	if (uf.encoding == ENC_QUOTE) {
	    char *p;
	    if (qp_lbuf != NULL)
		Strcat(qp_lbuf, lineBuf2);
	    else
		qp_lbuf = lineBuf2;
	    p = lineBuf2->ptr;
	    while ((p = strchr(p, '=')) != NULL) {
		++p;
		if (IS_SPACE(*p))
		    break;
	    }
	    if (p != NULL)
		continue;
	    lineBuf2 = qp_lbuf;
	    qp_lbuf = NULL;
	}
	++nlines;
	if (showLineNum) {
	    Str tmp = Sprintf("%4d:", nlines);
	    Strcat(tmp, lineBuf2);
	    lineBuf2 = tmp;
	}
	lineBuf2 = convertLine(&uf, lineBuf2, &code);
	lineBuf2 = checkType(lineBuf2->ptr, propBuffer, LINELEN);
	len = lineBuf2->length;
	l = New(Line);
	l->lineBuf = lineBuf2->ptr;
	l->propBuf = New_N(Lineprop, len);
	bcopy((void *) propBuffer, (void *) l->propBuf, len * sizeof(Lineprop));
	l->len = len;
	l->prev = pl;
	if (squeezeBlankLine) {
	    l->real_linenumber = nlines;
	    l->linenumber = (pl == NULL ? nlines : pl->linenumber + 1);
	}
	else {
	    l->real_linenumber = l->linenumber = nlines;
	}
	if (pl == NULL) {
	    pl = l;
	    buf->firstLine = buf->topLine = buf->currentLine = l;
	}
	else {
	    pl->next = l;
	    pl = l;
	}
	if (rl == NULL)
	    rl = l;
	if (nlines > PagerMax) {
	    fl = buf->firstLine;
	    buf->firstLine = fl->next;
	    fl->next->prev = NULL;
	    if (buf->topLine == fl)
		buf->topLine = fl->next;
	    if (buf->currentLine == fl)
		buf->currentLine = fl->next;
	}
    }
    if (pl != NULL)
	pl->next = NULL;
    buf->lastLine = pl;
    if (rl == NULL && squeeze_flag) {
	rl = pl;
    }
    if (fmInitialized)
	term_raw();
    buf->linelen = linelen;
    buf->trbyte = trbyte;
#ifdef JP_CHARSET
    buf->document_code = code;
#endif
    return rl;
}

int
save2tmp(URLFile uf, char *tmpf)
{
    FILE *f = uf.stream.f;
    FILE *ff;
    char c;
    int check;
    int linelen = 0, trbyte = 0;
    MySignalHandler(*prevtrap) ();

    ff = fopen(tmpf, "wb");
    if (ff == NULL) {
	/* fclose(f); */
	return -1;
    }
    if (SETJMP(AbortLoading) != 0) {
	goto _end;
    }
    if (fmInitialized) {
	prevtrap = signal(SIGINT, KeyAbort);
	term_cbreak();
    }
    check = 0;
    current_content_length = 0;
    while (c = getc(f), !feof(f)) {
#ifdef USE_NNTP
	if (uf.scheme == SCM_NEWS) {
	    if (c == '\n') {
		if (check == 0)
		    check++;
		else if (check == 3)
		    break;
	    }
	    else if (c == '.' && check == 1)
		check++;
	    else if (c == '\r' && check == 2)
		check++;
	    else
		check = 0;
	}
#endif				/* USE_NNTP */
	putc(c, ff);
	linelen += sizeof(c);
	showProgress(&linelen, &trbyte);
    }
  _end:
    if (fmInitialized) {
	term_raw();
	signal(SIGINT, prevtrap);
    }
    fclose(ff);
    return 0;
}

static int external_seq = 0;

void
doExternal(URLFile uf, char *view)
{
    Str tmpf;
    Str tmp;

    tmpf = Sprintf("%s/w3mv%d-%d", rc_dir, (int) getpid(), external_seq++);

    if (uf.ext && *uf.ext) {
	Strcat_charp(tmpf, uf.ext);
    }
    if (save2tmp(uf, tmpf->ptr) < 0)
	return;
    tmp = Sprintf(view, tmpf->ptr);
    Strchop(tmp);
    mySystem(tmp->ptr, BackgroundExtViewer);
    pushText(fileToDelete, tmpf->ptr);
}

static int
_MoveFile(char *path1, char *path2)
{
    FILE *f1, *f2;
    char c;
    int is_pipe;
    int linelen = 0, trbyte = 0;

    f1 = fopen(path1, "rb");
    if (f1 == NULL)
	return -1;
    if (*path2 == '|' && PermitSaveToPipe) {
	is_pipe = TRUE;
	f2 = popen(path2 + 1, "w");
    }
    else {
	is_pipe = FALSE;
	f2 = fopen(path2, "wb");
    }
    if (f2 == NULL) {
	fclose(f1);
	return -1;
    }
    current_content_length = 0;
    while (c = getc(f1), !feof(f1)) {
	putc(c, f2);
	linelen += sizeof(c);
	showProgress(&linelen, &trbyte);
    }
    fclose(f1);
    if (is_pipe)
	pclose(f2);
    else
	fclose(f2);
    return 0;
}

void
doFileCopy(char *tmpf, char *defstr)
{
    char filen[256], msg[LINELEN];
    char *p;

    if (fmInitialized) {
	p = inputLineHist("(Download)Save file to: ", defstr, IN_COMMAND, SaveHist);
	if (p == NULL)
	    return;
	if (*p != '|' || !PermitSaveToPipe) {
	    p = expandName(p);
	    if (checkOverWrite(p) < 0)
		return;
	}
	if (checkCopyFile(tmpf, p) < 0) {
	    sprintf(msg, "Can't copy. %s and %s are identical.", tmpf, p);
	    disp_message(msg, FALSE);
	    return;
	}
	if (_MoveFile(tmpf, p) < 0) {
	    sprintf(msg, "Can't save to %s", p);
	    disp_message(msg, FALSE);
	}
    }
    else {
	printf("(Download)Save file to: ");
	fflush(stdout);
	p = fgets(filen, sizeof(filen), stdin);
	if (p == NULL || *filen == '\0')
	    return;
	for (p = filen + strlen(filen) - 1; IS_SPACE(*p); p--);
	*(p + 1) = '\0';
	if (*filen == '\0')
	    return;
	p = filen;
	if (*p != '|' || !PermitSaveToPipe) {
	    p = expandName(p);
	    if (checkOverWrite(p) < 0)
		return;
	}
	if (checkCopyFile(tmpf, p) < 0) {
	    printf("Can't copy. %s and %s are identical.", tmpf, p);
	    return;
	}
	if (_MoveFile(tmpf, p) < 0) {
	    printf("Can't save to %s\n", p);
	}
    }
}

void
doFileMove(char *tmpf, char *defstr)
{
    doFileCopy(tmpf, defstr);
    unlink(tmpf);
}

void
doFileSave(URLFile uf, char *defstr)
{
    char filen[256], msg[LINELEN];
    char *p;
    if (fmInitialized) {
	p = inputLineHist("(Download)Save file to: ", defstr, IN_FILENAME, SaveHist);
	if (p == NULL || *p == '\0')
	    return;
	if (checkOverWrite(p) < 0)
	    return;
	if (checkSaveFile(uf.stream.f, p) < 0) {
	    sprintf(msg, "Can't save. Load file and %s are identical.", p);
	    disp_message(msg, FALSE);
	    return;
	}
	if (save2tmp(uf, p) < 0) {
	    sprintf(msg, "Can't save to %s", p);
	    disp_message(msg, FALSE);
	}
    }
    else {
	printf("(Download)Save file to: ");
	fflush(stdout);
	p = fgets(filen, sizeof(filen), stdin);
	if (p == NULL || *filen == '\0')
	    return;
	for (p = filen + strlen(filen) - 1; IS_SPACE(*p); p--);
	*(p + 1) = '\0';
	if (*filen == '\0')
	    return;
	p = expandName(filen);
	if (checkOverWrite(p) < 0)
	    return;
	if (checkSaveFile(uf.stream.f, p) < 0) {
	    printf("Can't save. Load file and %s are identical.", p);
	    return;
	}
	if (save2tmp(uf, p) < 0) {
	    printf("Can't save to %s\n", p);
	}
    }
}

int
checkCopyFile(char *path1, char *path2)
{
    struct stat st1, st2;

    if (*path2 == '|' && PermitSaveToPipe)
	return 0;
    if ((stat(path1, &st1) == 0) && (stat(path2, &st2) == 0))
	if (st1.st_ino == st2.st_ino)
	    return -1;
    return 0;
}

int
checkSaveFile(FILE * f, char *path2)
{
    struct stat st1, st2;

    if (*path2 == '|' && PermitSaveToPipe)
	return 0;
    if ((fstat(fileno(f), &st1) == 0) && (stat(path2, &st2) == 0))
	if (st1.st_ino == st2.st_ino)
	    return -1;
    return 0;
}

int
checkOverWrite(char *path)
{
    struct stat st;
    char buf[2];
    char *ans = NULL;

    if (stat(path, &st) < 0)
	return 0;
    if (fmInitialized) {
	ans = inputStr("File exists. Overwrite? (y or n)", "");
    }
    else {
	printf("File exists. Overwrite? (y or n)");
	ans = fgets(buf, 2, stdin);
    }
    if (ans != NULL && (*ans == '\0' || tolower(*ans) == 'y'))
	return 0;
    else
	return -1;
}

static void
sig_chld(int signo)
{
    int stat;
#ifdef HAVE_WAITPID
    pid_t pid;

    while ((pid = waitpid(-1, &stat, WNOHANG)) > 0) {
	;
    }
#elsif HAVE_WAIT3
    int pid;

    while ((pid = wait3(&stat, WNOHANG, NULL)) > 0) {
	;
    }
#else
    wait(&stat);
#endif
    return;
}

#ifdef __EMX__
#define GUNZIP_CMD  "gzip"
#define BUNZIP2_CMD "bzip2"
#else				/* not __EMX__ */
#define GUNZIP_CMD  "gunzip"
#define BUNZIP2_CMD "bunzip2"
#endif				/* not __EMX__ */
#define GUNZIP_NAME  "gunzip"
#define BUNZIP2_NAME "bunzip2"

static FILE *
gunzip_stream(FILE * infp, int compressor)
{
    int pid1;
    int fd1[2];
    char *expand_cmd = GUNZIP_CMD;
    char *expand_name = GUNZIP_NAME;

    switch (compressor) {
    case CMP_COMPRESS:
    case CMP_GZIP:
	expand_cmd = GUNZIP_CMD;
	expand_name = GUNZIP_NAME;
	break;
    case CMP_BZIP2:
	expand_cmd = BUNZIP2_CMD;
	expand_name = BUNZIP2_NAME;
	break;
    }

    if (pipe(fd1) < 0) {
	fclose(infp);
	return NULL;
    }
#ifdef	SIGCHLD
    signal(SIGCHLD, sig_chld);
#endif
    flush_tty();
    /* fd1[0]: read, fd1[1]: write */
    if ((pid1 = fork()) == 0) {
	/* child */
	int pid2;
	int fd2[2];
#ifdef	SIGCHLD
	signal(SIGCHLD, sig_chld);
#endif
	close(fd1[0]);
	if (pipe(fd2) < 0) {
	    close(fd1[1]);
	    fclose(infp);
	    exit(1);
	}
	if ((pid2 = fork()) == 0) {
	    /* child */
	    int c;
	    char buf[1];
	    close(fd2[0]);
	    while ((c = fgetc(infp)) != EOF) {
		buf[0] = c;
		if (write(fd2[1], buf, 1) < 0) {
		    close(fd2[1]);
		}
	    }
	    close(fd2[1]);
	    exit(0);
	}
	close(fd2[1]);
	dup2(fd2[0], 0);
	dup2(fd1[1], 1);
	execlp(expand_cmd, expand_name, NULL);
	exit(0);
    }
    close(fd1[1]);
    fclose(infp);
    return fdopen(fd1[0], "rb");
}

static FILE *
lessopen_stream(char *path)
{
    char *lessopen;
    FILE *fp;

    lessopen = getenv("LESSOPEN");
    if (lessopen == NULL) {
	return NULL;
    }
    if (lessopen[0] == '\0') {
	return NULL;
    }

    if (lessopen[0] == '|') {
	/* pipe mode */
	Str tmpf;
	int c;

	++lessopen;
	tmpf = Sprintf(lessopen, path);
	fp = popen(tmpf->ptr, "r");
	if (fp == NULL) {
	    return NULL;
	}
	c = getc(fp);
	if (c == EOF) {
	    fclose(fp);
	    return NULL;
	}
	ungetc(c, fp);
    }
    else {
	/* filename mode */
	/* not supported m(__)m */
	fp = NULL;
    }
    return fp;
}

#if 0
void
reloadBuffer(Buffer * buf)
{
    URLFile uf;

    if (buf->sourcefile == NULL ||
	buf->pagerSource != NULL)
	return;
    uf.scheme = SCM_UNKNOWN;
    uf.stream.f = examineFile(buf->sourcefile, &uf.close);
    uf.stream_type = SMT_FILE;
    uf.iseof = FALSE;
    uf.encoding = ENC_7BIT;
    if (uf.stream.f == NULL)
	return;
    is_redisplay = TRUE;
    buf->allLine = 0;
    buf->href = NULL;
    buf->name = NULL;
    buf->img = NULL;
    buf->formitem = NULL;
    if (!strcasecmp(buf->type, "text/html"))
	loadHTMLBuffer(&uf, buf);
    else
	loadBuffer(&uf, buf);
    UFclose(&uf);
    is_redisplay = FALSE;
}
#endif

#ifdef JP_CHARSET
static char
guess_charset(char *p)
{
    Str c = Strnew_size(strlen(p));
    if (strncasecmp(p, "x-", 2) == 0)
	p += 2;
    while (*p != '\0') {
	if (*p != '-' && *p != '_')
	    Strcat_char(c, tolower(*p));
	p++;
    }
    if (strncmp(c->ptr, "euc", 3) == 0)
	return 'E';
    if (strncmp(c->ptr, "shiftjis", 8) == 0 ||
	strncmp(c->ptr, "sjis", 4) == 0)
	return 'S';
    if (strncmp(c->ptr, "iso2022jp", 9) == 0 ||
	strncmp(c->ptr, "jis", 3) == 0)
	return 'n';
    return '\0';
}
#endif

char *
guess_save_name(char *file)
{
    char *p = NULL, *s;

    if (file != NULL)
	p = mybasename(file);
    if (p == NULL || *p == '\0')
	return DEF_SAVE_FILE;
    s = p;
    if (*p == '#')
	p++;
    while (*p != '\0') {
	if ((*p == '#' && *(p + 1) != '\0') || *p == '?') {
	    *p = '\0';
	    break;
	}
	p++;
    }
    return s;
}
