/* Copyright (C) 1991, 1992, 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifdef DEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <wchar.h>

extern char *prembstowcs_s;
extern char *prembstowcs_w;
static char *prewcstombs_s = NULL;

extern mbstate_t __no_r_state;	/* Defined in mbtowc.c.  */

/* Convert the `wchar_t' string in PWCS to a multibyte character string
   in S, writing no more than N characters.  Return the number of bytes
   written, or (size_t) -1 if an invalid `wchar_t' was found.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `wcsrtombs'.  */
size_t
wcstombs (char *s, const wchar_t *pwcs, size_t n)
{
  mbstate_t save_shift = __no_r_state;
  size_t written;
  int status = 0;

#ifdef DEBUG
  fprintf(stderr, "begin: wcstombs\n");
  fprintf(stderr, "info: char  s    = [%s]\n", s ? "(something)" : "(null)");
  fprintf(stderr, "info: char  s(p) = [%p]\n", s);
  fprintf(stderr, "info: wchar pwcs = [%p]\n", pwcs);
  fprintf(stderr, "info: size  n    = [%d]\n", n);
#endif

  if (NULL != prembstowcs_s && pwcs ==  prembstowcs_s) {
#ifdef DEBUG
    fprintf(stderr, "info: *** I'll call mbstowcs ***\n");
    fprintf(stderr, "info: char s = [%s]\n", pwcs);
#endif
    status = 1;
  }
  prembstowcs_s = NULL;

  if (pwcs == prewcstombs_s) {
#ifdef DEBUG
    fprintf(stderr, "info: *** I'll call mbstowcs(2) ***\n");
    fprintf(stderr, "info: char s = [%s]\n", pwcs);
#endif
    status = 1;
  }

  if (prembstowcs_w == pwcs) {
    prembstowcs_w = NULL;
    prewcstombs_s = s;
  } else {
    prembstowcs_w = NULL;
    prewcstombs_s = NULL;
  }

  if (status) {
#ifdef DEBUG
    fprintf(stderr, "info: *** I use strncpy ***\n");
#endif
    strncpy(s, (char *)pwcs, n);
    written = s[n - 1]? n: strlen(s);
  } else {
    written = wcsrtombs (s, &pwcs, n, &__no_r_state);
    if ( -1 == written ) {
#ifdef DEBUG
      fprintf(stderr, "info: *** failed wcsrtombs ***\n");
#endif
    }
  }

  /* Restore the old shift state.  */
  __no_r_state = save_shift;

  /* Return how many we wrote (or maybe an error).  */
#ifdef DEBUG
  fprintf(stderr, "info: char  s    = [%s](after)\n", s ? s : "(null)");
  fprintf(stderr, "info: return %d(wcstombs)\n", written);
#endif
  return written;
}
