/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.1, (the "License"); you may not use this file except in
 * compliance with the License. You should have received a copy of the
 * Erlang Public License along with this software. If not, it can be
 * retrieved via the world wide web at http://www.erlang.org/.
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Original Code is Ericsson Utvecklings AB.
 * Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
 * AB. All Rights Reserved.''
 * 
 *     $Id$
 */
package com.ericsson.otp.erlang;

/**
 * Provides a Java representation of Erlang floats and doubles.
**/
public class OtpErlangFloat extends OtpErlangDouble {

  /**
   * Create an Erlang float from the given float value.
   **/
  public OtpErlangFloat(float f) {
    super(f);
  }


  /**
   * Create an Erlang float from a stream containing a float encoded
   * in Erlang external format.
   *
   * @param buf the stream containing the encoded value.
   * 
   * @exception OtpErlangDecodeException if the buffer does not
   * contain a valid external representation of an Erlang float.
   *
   * @exception OtpErlangRangeException if the value cannot be
   * represented as a Java float.
   **/
  public OtpErlangFloat(OtpInputStream buf) 
    throws OtpErlangDecodeException, OtpErlangRangeException {
    super(buf);

    float f = floatValue();
  }
}



