# created 09-2000, by Kevin Hanser, by taking the create script for MySQL
# and modifying it to work w/Oracle datatypes... using the oracle_create
# as a guide
# tested with IMP 2.2.x, Oracle 8i (8.1.5, 8.1.6)

CREATE TABLE active_sessions (
    sid varchar2(32) NOT NULL,
    name varchar2(32) NOT NULL,
    val varchar2(4000) NULL,
    changed varchar2(14) NOT NULL,
    constraint PK_ACTIVE_SESSIONS primary key (NAME, SID)
);

create index CHANGED on ACTIVE_SESSIONS (CHANGED asc);


# create the address table
CREATE TABLE imp_addr (
    username varchar2(255) NOT NULL,
    address varchar2(255) NOT NULL,
    nickname varchar2(255) NULL,
    fullname varchar2(255) NULL
);


# now create the pref table
CREATE TABLE imp_pref (
    username varchar2(255) NOT NULL,
    sig varchar2(2000) NULL,
    fullname varchar2(70) NULL,
    replyto varchar2(70) NULL,
    lang varchar2(30) NULL
);

# added 11-2000, after Hernan Morales pointed out that I forgot these
# (theyre in the original oracle_create.sql script)

ALTER TABLE IMP_ADDR ADD (
      CONSTRAINT PK_IMP_ADDR
      PRIMARY KEY (USERNAME,
                   ADDRESS)
);

ALTER TABLE IMP_PREF ADD (
      CONSTRAINT PK_IMP_PREF
      PRIMARY KEY (USERNAME)
);
