/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.Utility;
import java.util.Locale;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras;
    String[] months;
    String[] shortMonths;
    String[] weekdays;
    String[] shortWeekdays;
    String[] ampms;
    String[][] zoneStrings;
    static final String patternChars = "GyMdkHmsSEDFwWahKz";
    String localPatternChars;
    static final int millisPerHour = 3600000;

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public String[] getEras() {
        return this.duplicate(this.eras);
    }

    public void setEras(String[] stringArray) {
        this.eras = this.duplicate(stringArray);
    }

    public String[] getMonths() {
        return this.duplicate(this.months);
    }

    public void setMonths(String[] stringArray) {
        this.months = this.duplicate(stringArray);
    }

    public String[] getShortMonths() {
        return this.duplicate(this.shortMonths);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = this.duplicate(stringArray);
    }

    public String[] getWeekdays() {
        return this.duplicate(this.weekdays);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = this.duplicate(stringArray);
    }

    public String[] getShortWeekdays() {
        return this.duplicate(this.shortWeekdays);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = this.duplicate(stringArray);
    }

    public String[] getAmPmStrings() {
        return this.duplicate(this.ampms);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = this.duplicate(stringArray);
    }

    public String[][] getZoneStrings() {
        String[][] stringArray = new String[this.zoneStrings.length][];
        int n = 0;
        while (n < this.zoneStrings.length) {
            stringArray[n] = this.duplicate(this.zoneStrings[n]);
            ++n;
        }
        return stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = this.duplicate(stringArray[n]);
            ++n;
        }
        this.zoneStrings = stringArray2;
    }

    public String getLocalPatternChars() {
        return new String(this.localPatternChars);
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = new String(string);
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.zoneStrings[0].length) {
            n ^= this.zoneStrings[0][n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return Utility.arrayEquals(this.eras, (Object)dateFormatSymbols.eras) && Utility.arrayEquals(this.months, (Object)dateFormatSymbols.months) && Utility.arrayEquals(this.shortMonths, (Object)dateFormatSymbols.shortMonths) && Utility.arrayEquals(this.weekdays, (Object)dateFormatSymbols.weekdays) && Utility.arrayEquals(this.shortWeekdays, (Object)dateFormatSymbols.shortWeekdays) && Utility.arrayEquals(this.ampms, (Object)dateFormatSymbols.ampms) && Utility.arrayEquals((Object[])this.zoneStrings, (Object)dateFormatSymbols.zoneStrings) && Utility.arrayEquals(this.localPatternChars, (Object)dateFormatSymbols.localPatternChars);
    }

    private void initializeData(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("java.text.resources.DateFormatZoneData", locale);
        this.eras = (String[])resourceBundle.getObject("Eras");
        this.months = resourceBundle.getStringArray("MonthNames");
        this.shortMonths = resourceBundle.getStringArray("MonthAbbreviations");
        String[] stringArray = resourceBundle.getStringArray("DayNames");
        this.weekdays = new String[8];
        this.weekdays[0] = "";
        int n = 0;
        while (n < stringArray.length) {
            this.weekdays[n + 1] = stringArray[n];
            ++n;
        }
        String[] stringArray2 = resourceBundle.getStringArray("DayAbbreviations");
        this.shortWeekdays = new String[8];
        this.shortWeekdays[0] = "";
        n = 0;
        while (n < stringArray2.length) {
            this.shortWeekdays[n + 1] = stringArray2[n];
            ++n;
        }
        this.ampms = resourceBundle.getStringArray("AmPmMarkers");
        this.zoneStrings = (String[][])resourceBundle2.getObject("zoneStrings");
        this.localPatternChars = (String)resourceBundle2.getObject("localPatternChars");
    }

    final int getZoneIndex(String string) {
        int n = 0;
        while (n < this.zoneStrings.length) {
            if (string.regionMatches(true, 0, this.zoneStrings[n][2], 0, this.zoneStrings[n][2].length())) break;
            ++n;
        }
        if (n < this.zoneStrings.length) {
            return n;
        }
        n = 0;
        while (n < this.zoneStrings.length) {
            if (string.regionMatches(true, 0, this.zoneStrings[n][4], 0, this.zoneStrings[n][4].length())) break;
            ++n;
        }
        if (n < this.zoneStrings.length) {
            return n;
        }
        return -1;
    }

    private final String[] duplicate(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.eras = this.duplicate(dateFormatSymbols.eras);
        dateFormatSymbols2.months = this.duplicate(dateFormatSymbols.months);
        dateFormatSymbols2.shortMonths = this.duplicate(dateFormatSymbols.shortMonths);
        dateFormatSymbols2.weekdays = this.duplicate(dateFormatSymbols.weekdays);
        dateFormatSymbols2.shortWeekdays = this.duplicate(dateFormatSymbols.shortWeekdays);
        dateFormatSymbols2.ampms = this.duplicate(dateFormatSymbols.ampms);
        int n = 0;
        while (n < dateFormatSymbols2.zoneStrings.length) {
            dateFormatSymbols2.zoneStrings[n] = this.duplicate(dateFormatSymbols.zoneStrings[n]);
            ++n;
        }
        dateFormatSymbols2.localPatternChars = new String(dateFormatSymbols.localPatternChars);
    }

    private final boolean equals(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!stringArray[n2].equals(stringArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

