/* daemon.c
 * Main code for the biddaemon software.
 * Hey you with your bug report ready, DO NOT EXPECT THIS TO WORK YET.
 * ;)  -kdwyer
 */

/* bidwatcher
   copyright (c) 1999, 2000, 2001, 2002
   Trent McNair (trent@rmci.net)
   Tom McNair  (tmcnair@cyberhighway.net)
   Wayne Schlitt (wayne@midwestcs.com)
   Ben Byer (bushing@users.sourceforge.net)
   Kevin Dwyer (kevin@pheared.net)
 
   use of this code is restricted to the terms
   of the GNU GPL, which should have been included in this
   distribution. If not, see www.gnu.org/copyleft/gpl.html.
   Here is the short version:

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include "daemon.h"

#define MAXMSG sizeof(struct bidmessage)
#define MAXCLIENTS 100

typedef struct {
  int sd;
  char inbuf[MAXMSG];
  char outbuf[MAXMSG];
  struct sockaddr_in addr;
  int closed;
  int pending;
  int welcome;
} users;

/*typedef struct users U;*/

typedef void (*sighandler_t)(int);

int write_pending(users *);
int read_pending(users *);
int parse_input(users);
sighandler_t got_sig(int);

int main (int argc, char *argv[])
{
  int sd=0, ret=0, len=0, i=0, stoploop=0;
  char *port="4221";

  users c[MAXCLIENTS];

  struct sockaddr_in sin;
  struct sockaddr_in sintmp;

  signal(SIGINT, got_sig(sd));

  memset(&sin,0,sizeof(sin));
  memset(&sin,0,sizeof(sintmp));
  memset(&c,0,sizeof(c));

  /* setting up our daemon, sin_port = port to listen on
     and sin_addr.saddr is source address to listen on.
  */

  sin.sin_family = AF_INET;
  sin.sin_port = htons(atoi(port));
  /* Listen on all addresses */
  sin.sin_addr.s_addr = inet_addr("0.0.0.0");

  /* procedure is socket, bind, listen, accept in loop. */

  sd = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);

  ret = bind(sd, (struct sockaddr *)&sin, sizeof(sin));

  if (ret == -1)
    {
      perror("bind()");
      exit(0);
    }

  ret = listen(sd, 5);

  if (ret == -1)
    {
      perror("listen()");
      exit(0);
    }

  ret = fcntl(sd, F_SETFL, O_NONBLOCK);

  if (ret == -1)
    {
      perror("fcntl()");
      exit(0);
    }

  while (!stoploop)
    {
      len = sizeof(c[i].addr);
      ret = accept(sd, (struct sockaddr *)&c[i].addr, &len);
      if (ret != -1)
	{
	  c[i].sd = ret;
	  c[i].pending = 1;
	  c[i].closed = 0;

	  /* Should make this quieter later. */
	  write(c[i].sd, "biddaemon v1.0\n", 15);

	  printf("accept():Got connect from %s source port %i\n",
		 inet_ntoa(c[i].addr.sin_addr), 
		 ntohs(c[i].addr.sin_port));

	  ret = fcntl(c[i].sd, F_SETFL, O_NONBLOCK);

	  if (ret == -1)
	    {
	      perror("fcntl()");
	      exit(0);
	    }

	  printf("i=%i/sd=%i/pend=%i/closed=%i\n", i,c[i].sd,c[i].pending,c[i].closed);
	  i++;
	}

      
      write_pending(c);

      read_pending(c);

      usleep(1);

    }

  return 0;
}

int write_pending(users c[MAXCLIENTS])
{
  int i=0,ret=0;

  while (i < MAXCLIENTS)
    {

      if (c[i].pending == 1) {
	      if (ret == -1) {
		      perror("write()");
		      close(c[i].sd);
		      c[i].closed = 1;
	      }

	      if (strlen(c[i].outbuf) > 0) {
		      ret = write(c[i].sd, c[i].outbuf, strlen(c[i].outbuf));

		      if (ret == -1) {
			      perror("write()");
			      close(c[i].sd);
			      c[i].closed = 1;
			      c[i].sd = -1;
		      }

		      memset(&c[i].outbuf, 0, sizeof(c[i].outbuf));
	      }

	      c[i].pending = 0;
	      
      }

      i = i + 1;

    }
  return 0;
}

int parse_input(users c)
{	
	struct bidmessage bm;

	printf("DEBUG: Parsing a message\n");

	memset(&bm, 0, sizeof(bm));
	memcpy(&bm, c.inbuf, sizeof(bm));

	if (bm.type == 0) {
		printf("Got 0\n");
		return MSG_PING;
	}
	if (bm.type == 1)
		return MSG_ADD;
}

int read_pending(users c[MAXCLIENTS])
{
  int i=0, ret=0, x=0;
  /*  char inbuf[MAXMSG];*/

  while(i < MAXCLIENTS) {
	if (c[i].sd > 0) {
	ret = read(c[i].sd, c[i].inbuf, sizeof(c[i].inbuf));

	if (ret >= 0) {
		printf("%s --- %i bytes \n", c[i].inbuf, ret);

		switch(parse_input(c[i])) {
		case MSG_DETACH:
			printf("Closing sd %i!\n", i);
			write(c[i].sd,"Closing connection...\n",22);
			close(c[i].sd);
			c[i].closed = 1;
			c[i].sd = -1;
			break;
		case MSG_ADD:
			printf("got add on sd %i\n", i);
			break;
		}
	}
	else {
		if (errno != EAGAIN) {
			perror("write()");
			close(c[i].sd);
			c[i].closed = 1;
			c[i].sd = -1;
		}
	}
	memset(&c[i].inbuf,0,sizeof(c[i].inbuf));
	}
	i++;
  }
  return 0;
}

sighandler_t got_sig(int sd)
{
	// This is broken right now.
	//  printf("Got Signal !\n");

  //  if (i == SIGINT)
  //{
  //      printf("Shutting down daemon! %i\n", sd);
  //      close(sd);
      // }

  return 0;
}






