<?/* 
+-------------------------------------------------------------------------+
| Copyright (C) 2002 Ian Berry                                            |
|                                                                         |
| This program is free software; you can redistribute it and/or           |
| modify it under the terms of the GNU General Public License             |
| as published by the Free Software Foundation; either version 2          |
| of the License, or (at your option) any later version.                  |
|                                                                         |
| This program is distributed in the hope that it will be useful,         |
| but WITHOUT ANY WARRANTY; without even the implied warranty of          |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
| GNU General Public License for more details.                            |
+-------------------------------------------------------------------------+
| cacti: the rrdtool frontend [php-auth, php-tree, php-form]              |
+-------------------------------------------------------------------------+
| This code is currently maintained and debugged by Ian Berry, any        |
| questions or comments regarding this code should be directed to:        |
| - iberry@raxnet.net                                                     |
+-------------------------------------------------------------------------+
| - raXnet - http://www.raxnet.net/                                       |
+-------------------------------------------------------------------------+
*/?>
<? 	$section = "Add/Edit Data Sources"; include ('auth/include/auth.php');
	header("Cache-control: no-cache");
	include_once ('include/functions.php');
	include ('include/database.php');
	include ('include/config.php');
	include_once ('include/form.php');

switch ($action) {
	case 'duplicate':
		include_once ('include/utility_functions.php');
		
		$id = DuplicateDataSource($id);
		
		header ("Location: ds.php?action=edit&id=$id");
		break;
	case 'save':
		/* do some error checking here */
		if ($dsname != "") {
			if (CleanUpName($dsname) != $dsname) {
				header ("Location: ds.php?action=edit&id=$id&error=1");
				exit;
			}
		}
		
		/* take care of renaming ds in the .rrd if the user wants it */
		if ($update_rrd == "on") {
			include_once ('include/rrd_functions.php');
			
			$rrd_tune_array["data_source_id"] = $id;
			$rrd_tune_array["heartbeat"] = $heartbeat;
			$rrd_tune_array["minimum"] = $minvalue;
			$rrd_tune_array["maximum"] = $maxvalue;
			$rrd_tune_array["data-source-type"] = $datasourcetypeid;
			$rrd_tune_array["data-source-rename"] = $dsname;
			
			rrdtool_function_tune($rrd_tune_array);
		}
		
		$sql_id = mysql_query("replace into rrd_ds (id,name,datasourcetypeid,heartbeat,
			minvalue,maxvalue,srcid,active,dsname,dspath,step,subdsid,subfieldid,isparent) 
			values ($id,\"$name\",$datasourcetypeid,$heartbeat,$minvalue,$maxvalue,$srcid,
			\"$active\",\"$dsname\",\"$dspath\",$step,$subdsid_old,$subfieldid,$isparent)",$cnn_id);
		
		if ($id == 0) {
			/* get dsid if this is a new save */
			$sql_id = mysql_query("select LAST_INSERT_ID()",$cnn_id);
			
			if (mysql_result($sql_id,"",0) != 0) {
				$id = mysql_result($sql_id,"",0);
			}
		}
		
		/* update table with rra info */
		$sql_id = mysql_query("delete from lnk_ds_rra where dsid=$id",$cnn_id); 
		
		for ($i = 0; $i < count($rraid); $i++) {
			mysql_query("insert into lnk_ds_rra (dsid,rraid) values ($id,$rraid[$i])",$cnn_id);
		}
		
		/* NEW: If this data source uses a data input source that has multiple outputs
		we must create the appropriate cacti data sources here! The following settings will
		be copied from the settings just entered to each data source we have to create:
		
		- Data Source Type
		- Heartbeat
		- Minimum Value
		- Maximum Value
		
		Additionally, to get the 'Name' field, we will append the data input source field
		name to the current 'Name' field. The 'Internal Data Source Name' will simply by
		default be the data input source field name.
		
		*/
		
		if ($srcid != $srcid_old) {
			/* ------------------ CLEANUP ------------------ */
			/* if the data input source changed, make sure to delete any children this
			ds has */
			mysql_query("delete from rrd_ds where subdsid=$id",$cnn_id);
			
			/* ... same goes for the items in src_data */
			mysql_query("delete from src_data where dsid=$id",$cnn_id);
			
			/* we have to make sure to kill the children's DS's in src_data */
			$sql_id = mysql_query("select id from rrd_ds where subdsid=$id", $cnn_id);
			
			for ($i = 0; $i < mysql_num_rows($sql_id); $i++) {
				mysql_query("delete from src_data where dsid=" . mysql_result($sql_id, $i, "id"),$cnn_id);
			}
			
			/* ------------------ CLEANUP ------------------ */
			
			/* Test if the current data input source has more than one output */
			$sql_id = mysql_query("select id,dataname 
				from src_fields 
				where srcid=$srcid 
				and inputoutput=\"out\"
				order by id",$cnn_id);
			$rows = mysql_num_rows($sql_id); $i = 0;
			
			if ($rows > 1) {
				/* Yes, it has more than one output.... */
				$data_source_is_parent = "1";
				
				/* Loop through each output and create a sub-data source for the data 
				source that has just been created */
				while ($i < $rows) {
					mysql_query("replace into rrd_ds 
						(id,subdsid,subfieldid,name,datasourcetypeid,heartbeat,minvalue,maxvalue,srcid,active,
						dsname,dspath,step) 
						values (0,$id," . mysql_result($sql_id, $i, "id") . ",\"$name" . 
						"_" . mysql_result($sql_id, $i, "dataname") . "\",
						$datasourcetypeid,$heartbeat,$minvalue,$maxvalue,0,\"on\",\"" . 
						CheckDataSourceName(mysql_result($sql_id, $i, "dataname")) . "\",
						\"\",0)",$cnn_id);
					$i++;
				}
			}else{
				$data_source_is_parent = "0";
			}
			
			mysql_query("update rrd_ds set isparent=$data_source_is_parent where id=$id", $cnn_id);
		}
		
		/* this will do any of the cleanup that is required on the data source name to make
		sure rrdtool is ok with it. */
		SyncDataSourceName($id, $dsname, $dspath);
		
		header ("Location: ds.php");
		break;
	case 'remove':
		mysql_query("delete from rrd_ds where id=$id",$cnn_id);
		mysql_query("delete from rrd_ds where subdsid=$id",$cnn_id);
		mysql_query("delete from lnk_ds_rra where dsid=$id",$cnn_id);
		mysql_query("delete from src_data where dsid=$id",$cnn_id);
		
		/* we have to make sure to kill the children's DS's in src_data */
		$sql_id = mysql_query("select id from rrd_ds where subdsid=$id", $cnn_id);
		
		for ($i = 0; $i < mysql_num_rows($sql_id); $i++) {
			mysql_query("delete from src_data where dsid=" . mysql_result($sql_id, $i, "id"),$cnn_id);
		}
		
		header ("Location: ds.php");
		break;
	case 'edit':
		include_once ('include/rrd_functions.php');
		include_once ('include/top_header.php');
		
		if ($id != "") {
			$sql_id = mysql_query("select * from rrd_ds where id=$id", $cnn_id);
			
			$srcid_old = mysql_result($sql_id, 0, "srcid");
			$sub_data_source_id = mysql_result($sql_id, 0, "subdsid");
		}
		
		DrawFormHeader("rrdtool Data Source Configuration","",false);
		
		if ($id != "") {
			switch ($error) {
				case '1':
					$dsname_error .= "<font color=\"red\">YOU HAVE ENTERED AN INVALID NAME!</font>\n\n";
					break;
			}
			
			/* check to see if the current data source exists */
			$data_source_path = GetDataSourcePath($id, true);
			
			if (file_exists($data_source_path) == false) {
				$warning_text .= "<font color=\"red\">CANNOT FIND DATA SOURCE: $data_source_path</font>\n\n";
			}
			
			/* see if the data source has any rra's */
			$sql_id_rra = mysql_query("select * from lnk_ds_rra where dsid=$id", $cnn_id);
			
			if (mysql_num_rows($sql_id_rra) == 0) {
				$warning_text .= "<font color=\"red\">THIS DATA SOURCE NEEDS TO HAVE AT LEAST ONE RRA ASSOCIATED WITH IT!</font>\n\n";
			}
			
			if ($sub_data_source_id == 0) {
				DrawFormPreformatedText($color_panel, $warning_text . rrdtool_function_create($id, true));
			}
		}
		
		DrawFormItem("Name","The name used for RRA files, among other things; no spaces or strange characters.");
		DrawFormItemTextBox("name",$sql_id,"","255");
		
		DrawFormItem("$dsname_error (Optional) Internal Data Source Name","The name of the data source used by rrdtool, by default this name is the same as the Data Source Name. However it may need to be changed for compatability with other RRA's.");
		DrawFormItemTextBox("dsname",$sql_id,"","19");
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("(Optional) Data Source Path","Used only if the data source lies in a different directory; you must include_once the full path to the RRA file.");
			DrawFormItemTextBox("dspath",$sql_id,"","");
		}else{
			DrawFormItemHiddenTextBox("dspath","","");
		}
		
		if ($sub_data_source_id == 0) {
			DrawFormItemHiddenTextBox("subfieldid","0","0");
		}else{
			DrawFormItem("Output Field","Which output value is associated with this data 
				source.");
			
			$sql_id_parent = mysql_query("select srcid from rrd_ds where id=$sub_data_source_id", $cnn_id);
			DrawFormItemDropdownFromSQL("subfieldid",$cnn_id,"select id,concat(name,' (',dataname,')') as name from src_fields where
				srcid=" . mysql_result($sql_id_parent, 0, "srcid") . " and inputoutput=\"out\"",
				"name","id",$sql_id,"","");
		}
		
		DrawFormItem("Data Source Type","The type of data that is being represented.");
		DrawFormItemDropdownFromSQL("datasourcetypeid",$cnn_id,"select * from def_ds order by name",
			"name","id",$sql_id,"","");
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("Data Input Type","What is used to gather the data for use in RRA files and on graphs.");
			DrawFormItemDropdownFromSQL("srcid",$cnn_id,"select * from src order by name",
				"name","id",$sql_id,"None","");
		}else{
			DrawFormItemHiddenTextBox("srcid","0","0");
		}
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("Associated RRA's","Which RRA's to use when entering data. (It is recommended that you select all of these values)");
			DrawFormItemMultipleList("rraid",$cnn_id,"select name,id from rrd_rra","name","id",
				"select * from lnk_ds_rra where dsid=$id","rraid");
		}else{
			/* nothing */
		}
		
		DrawFormItem("Heartbeat","The maximum amount of time that can pass before data is entered as \"unknown\". (Usually 600)");
		DrawFormItemTextBox("heartbeat",$sql_id,"600","");
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("Step","Specifies the base interval in seconds with which data will be fed into the .rrd file. (Usually 300)");
			DrawFormItemTextBox("step",$sql_id,"300","");
		}else{
			DrawFormItemHiddenTextBox("step","0","0");
		}
		
		DrawFormItem("Minimum Value","The minimum value of data that is allowed to be collected.");
		DrawFormItemTextBox("minvalue",$sql_id,"0","");
		
		DrawFormItem("Maximum Value","The maximum value of data that is allowed to be collected (number must be smaller than max value).");
		DrawFormItemTextBox("maxvalue",$sql_id,"1","");
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("Update .rrd File","Update the .rrd file in addition the cacti's database when saving these changes.");
			DrawFormItemCheckBox("update_rrd","","Update Changes in .rrd File","");
		}else{
			DrawFormItemHiddenTextBox("update_rrd","","");
		}
		
		if ($sub_data_source_id == 0) {
			DrawFormItem("Active","Whether data is currently be collected for this data source.");
			DrawFormItemCheckBox("active",$sql_id,"Data Source Currently Active","on");
		}else{
			DrawFormItemHiddenTextBox("active","on","on");
		}
		
		DrawFormSaveButton();
		DrawFormItemHiddenTextBox("srcid_old",$srcid_old,"0");
		DrawFormItemHiddenTextBox("subdsid_old",$sub_data_source_id,"0");
		DrawFormItemHiddenIDField("isparent",$sql_id);
		DrawFormItemHiddenIDField("id",$id);
		DrawFormFooter();
		
		include_once ("include/bottom_footer.php");
		
		break;
	default:
		include_once ('include/top_header.php');
		
		DrawMatrixTableBegin("97%");
		DrawMatrixRowBegin();
			DrawMatrixHeaderTop("Current Data Sources",$color_dark_bar,"","4");
			DrawMatrixHeaderAdd($color_dark_bar,"","ds.php?action=edit");
		DrawMatrixRowEnd();
		
		DrawMatrixRowBegin();
			DrawMatrixHeaderItem("Name",$color_panel,$color_panel_text);
			DrawMatrixHeaderItem("Data Input Type",$color_panel,$color_panel_text);
			DrawMatrixHeaderItem("Duplicate",$color_panel,$color_panel_text);
			DrawMatrixHeaderItem("Active",$color_panel,$color_panel_text);
			DrawMatrixHeaderItem("",$color_panel,$color_panel_text);
		DrawMatrixRowEnd();
		
		$sql_id = mysql_query("select 
			d.id,d.name,d.datasourcetypeid,d.srcid,d.active,d.subdsid,d.isparent,
			(d.id=d.subdsid) as sortstr,
			s.id as sid,s.name as sname 
			from rrd_ds d left join src s on (d.srcid=s.id)
			order by sortstr,name", $cnn_id);
		$rows = mysql_num_rows($sql_id); $i = 0;
		
		while ($i < $rows) { 
			DrawMatrixRowAlternateColorBegin($color_alternate,$color_light,$i);
				if (mysql_result($sql_id, $i, "subdsid") != 0) {
					$matrix_title = "<img src=\"images/gray_line.gif\" width=\"7\" height=\"1\" border=\"0\"> " . mysql_result($sql_id, $i, "name");
				}else{
					$matrix_title = mysql_result($sql_id, $i, "name");
				}
				
				DrawMatrixLoopItem($matrix_title,"","",html_boolean($config["vis_main_column_bold"]["value"]),"ds.php?action=edit&id=" . mysql_result($sql_id, $i, "id"));
				
				if (mysql_result($sql_id, $i, "srcid") == 0) {
					$matrix_title = "None";
				}else{
					$matrix_title = mysql_result($sql_id, $i, "sname") . " [<a href=\"ds_data_config.php?id=" . mysql_result($sql_id, $i, "id") . "&did=" . mysql_result($sql_id, $i, "srcid") . "\">Edit Data</a>]";
				}
				
				DrawMatrixLoopItem($matrix_title,"","",false,"");
				
				if (mysql_result($sql_id, $i, "subdsid") != 0) {
					$matrix_title = "N/A";
				}else{
					if (mysql_result($sql_id, $i, "active") == "on") {
						$matrix_title = "Currently Active";
					}else{
						$matrix_title = "<font color=\"#FF0000\">Not Active</font>";
					}
				}
				
				if (mysql_result($sql_id, $i, "subdsid") != 0) {
					$matrix_url = "";
				}else{
					if (mysql_result($sql_id, $i, "isparent") != 0) {
						$matrix_url = "";
					}else{
						$matrix_url = "ds.php?id=" . mysql_result($sql_id, $i, "id") . "&action=duplicate";
					}
				}
				
				DrawMatrixLoopItem("Duplicate","",$i,false,$matrix_url);
				DrawMatrixLoopItem($matrix_title,"","",false,"");
				
				if (mysql_result($sql_id, $i, "subdsid") != 0) {
					$matrix_url = "";
				}else{
					$matrix_url = "ds.php?action=remove&id=" . mysql_result($sql_id, $i, "id");
				}
				
				DrawMatrixLoopItemAction("Remove",$color_panel,"",false,$matrix_url);
			DrawMatrixRowEnd();
			$i++;
		}
		
		DrawMatrixTableEnd();
		include_once ("include/bottom_footer.php");
		
		break;
} ?>