// Copyright (c) 2010 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var make_browsertest_proceed = function() {
  if (!chrome.extension.lastError) {
    chrome.test.sendMessage("created items");
  }
};

var patterns = ["http://*.google.com/*", "https://*.google.com/*"];

window.onload = function() {
  // Create one item that does have a documentUrlPattern and targetUrlPattern.
  var properties1 = {
    "title": "test_item1", "documentUrlPatterns": patterns,
    "targetUrlPatterns": patterns
  };
  chrome.contextMenus.create(properties1);

  // Create an item that initially doesn't have a documentUrlPattern and
  // targetUrlPattern, then update it, and trigger the rest of the c++ code in
  // the browser test by navigating the tab.
  var properties2 = { "title": "test_item2" };

  var id2;
  id2 = chrome.contextMenus.create(properties2,
                                                function() {
    var update_properties = { "documentUrlPatterns": patterns,
                              "targetUrlPatterns": patterns };
    chrome.contextMenus.update(id2, update_properties,
                               make_browsertest_proceed);
  });
};
