/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
#include "config.h"

/*
 * ifdefs, used for portability
 */

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
/* An ANSI string.h and pre-ANSI memory.h might conflict */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif /* not STDC_HEADERS && HAVE_MEMORY_H */
#ifndef	RINDEX_DEFINED
#define index strchr
#define rindex strrchr
#endif
#define bcopy(s, d, n) memcpy((d), (s), (n))
#define bcmp(s1, s2, n) memcmp((s1), (s2), (n))
#define bzero(s, n) memset((s), 0, (n))
#else /* not STDC_HEADERS and not HAVE_STRING_H */
#include <strings.h>
/* memory.h and strings.h conflict on some systems */
#endif /* not STDC_HEADERS and not HAVE_STRING_H */

#ifdef HAVE_SYSEXITS_H
#include <sysexits.h>
#else  
#define EX_OK     0
#define EX_NOINPUT 66
#define EX_UNAVAILABLE 69
#define EX_SOFTWARE 70
#define EX_OSERR 71
#define EX_OSFILE 72
#define EX_CANTCREAT 73
#define EX_IOERR 74
#define EX_TEMPFAIL 75
#define EX_NOHOST 76
#define EX_NOPERM 77
#define EX_NOUSER 78
#define EX_USAGE 79
#endif

#ifndef	__P
#if defined(__STDC__)
#define __P(protos) protos   /* Full-blown ANSI C */
#else
#define __P(protos) ()       /* Traditional C preprocessor */
#endif /* !__STDC__ */
#endif




/*
 * Standard includes
 */
#include <stdio.h>
#include <sys/types.h>
#include <syslog.h>
#include <stdlib.h>
#include <ctype.h> 
#ifdef	HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <assert.h>
#include <fcntl.h>
  
/*
 * C function definitions
*/

#ifndef	STRCASECMP_DEFINED
int	strcasecmp(char *, char *);
#endif
#ifndef	STRNCASECMP_DEFINED
int	strncasecmp(char *, char *, int);
#endif


#ifdef NAMED_BIND
#ifdef USE_MX
struct mxlist {
  char *host;
  int preference;
  struct mxlist *next;
};
#endif
#endif

/*
 * Configuration parameters
*/

struct	config_struct {
	struct	config_struct * gg;
	char	* name,
		* charset,
	        * appletype,
		* format,
 	        * text,
                * header,
		* bin;
	int     iformat,
	        ibin,
	        itext,
	        iapple,
	        htext;
};

/*
 * Macros
 */

#define APPEND_LINE(L1, L2) strcat(L1, L2)
#define NEWSTR(S) S!=NULL?strcpy((char *)malloc(strlen(S) + 1), S):NULL


/*
 * Defines
 */

/* General status */
#define OK 0
#define NOK -1
#define TRUE 1
#define FALSE 0
#define FAIL -1
#define SKIP -2
#define DONE -3
#define CONT -4

/* Used for delimiter matches */
#define E7BIT     0x001
#define E8BIT     0x002
#define EBINARY   0x004
#define EBINHEX   0x008
#define EUUENCODE 0x010
#define EMULTI    0x020
#define EBASE64   0x040
#define EQP       0x080
#define ESE       0x100


/* Applefile type specifications */
#define ABINHEX   0x001  /* BinHexed applefile */
#define AMDOUBLE  0x002  /* Multipart Appledouble */
#define ADOUBLE   0x004  /* Appledouble */
#define ASINGLE   0x008  /* Applesingle */
#define AFILE     0x010  /* Applefile */
#define AMFILE    0x020  /* Multipart Applefile */
#define ARESOURCE 0x040  /* Resource fork */

/* Main types */
#define RFC822 0      /* Default */
#define MIME 1
#define MAILTOOL 2
#define TRANSPARENT 3 /* Transparent delivery (no conversion) */

/*
 * Sizes
 */

#define HDRLEN 2048
#define MIMEBOUNDLEN 60
#define HEAD_BUF 16
#define MED_BUF 256

/* Pseudos */
#define UNQUOTE 1
#define UNSPACE 2

/* Header fields */
#define UNKNOWN    0
#define COMMENT    1
#define HQSTRING   2
#define DLITERAL   4
#define RADDR      8
#define RFC1522   16
#define ATOM      32
#define DELIMITER 64
#define TEXT     128
#define TOP      256
/*
 * Externals
 */
extern long alloc_total;
extern int want_unix_from;
extern off_t pz;
extern char ebuf[1024];
extern char *sender;
extern char *hostname;
extern char *recipient;
extern char *rmx;
extern short det_sket_sig;
extern struct body *currbody;
extern struct message *rootmess;
extern struct config_struct *source;
extern struct config_struct *target;
extern char **mailer;
extern int process;
#ifdef DEBUG
extern int edebug;
#endif
#include "attr.h"
#include "func.h"
#ifdef	hpux
/* pagesize if a bit uncertain */
#define	getpagesize()	4096
#else
#ifdef	aix
size_t	getpagesize();	/* Should really be in unistd.h */
#endif
#endif

