/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "menubar.h"
#include "bookmarks.h"

#include <libgnomeui/gnome-stock.h>
#include <libgnome/gnome-i18n.h>
#include <gdk/gdkkeysyms.h>

/* 
 * a nonsense needed to get some of the GNOMEUINFO defined strings translated 
 * blame xgettext 
 */
#if 0
static char *ugh[] = {
	/* File */
		N_("_Open..."), N_("Open a file"),
		N_("E_xit"), N_("Exit the program"),
	/* Edit */
		N_("C_ut"), N_("Cut the selection"),
		N_("_Copy"), N_("Copy the selection"),
		N_("_Paste"), N_("Paste the clipboard"),
	/* Settings */
		N_("_Preferences..."), N_("Configure the application"),
	/* Help */
		N_("_About..."), N_("About this application")
}
#endif

/* The menubar GnomeUIInfo structs */ 
GnomeUIInfo file_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_New window"), N_("Create a new window"),
	  window_menu_new_window_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_n, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("New _tab"), N_("Create a new tab"),
	  window_menu_new_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_T, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_OPEN_ITEM (window_menu_open_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Open _URL..."), N_("Open a URL"),
	  window_menu_open_url_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  GDK_o, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Save _as..."),
	  N_("Save the current page"),
	  window_menu_save_as_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
	  GDK_S, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Send link to..."),
	  N_("Send the current URL by email"),
	  window_menu_send_to_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_MAIL_NEW, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Print..."), N_("Print the current page"),
	  window_menu_print_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
	  GDK_P, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Sa_ve session as..."),
	  N_("Save the current session to a file"),
	  window_menu_save_session_as_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Op_en session..."),
	  N_("Restore a previous session from a file"),
	  window_menu_open_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Recent sessions"),
	  N_("Restore a recently-opened or -saved session"),
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Close"),
	  N_("Close the current tab or window"),
	  window_menu_close_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	  GDK_w, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Exit with _session"),
	  N_("Exit the program, saving the current session"),
	  window_menu_exit_with_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, GDK_Q,
	  GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	GNOMEUIINFO_MENU_EXIT_ITEM (window_menu_exit_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo edit_menu_uiinfo[] =
{
	GNOMEUIINFO_MENU_CUT_ITEM (window_menu_edit_cut_cb, NULL),
	GNOMEUIINFO_MENU_COPY_ITEM (window_menu_edit_copy_cb, NULL),
	GNOMEUIINFO_MENU_PASTE_ITEM (window_menu_edit_paste_cb, NULL),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("_Find..."),
	  N_("Search for a word or phrase in the current page"),
	  window_menu_find_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	  GDK_F, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Find _next"),
	  N_("Search for the next occurrence of a word or phrase in the current page"),
	  window_menu_find_next_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	  GDK_G, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Find pre_vious"),
	  N_("Search for the previous occurrence of a word or phrase in the current page"),
	  window_menu_find_previous_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	  GDK_G, GDK_SHIFT_MASK|GDK_CONTROL_MASK, NULL },
	  
	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("_Select all"),
	  N_("Select all text in the current page"),
	  window_menu_select_all_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_A, GDK_CONTROL_MASK, NULL },
	
	GNOMEUIINFO_END
};

GnomeUIInfo zoom_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_In"), N_("Zoom in"),
	  window_menu_zoom_in_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_8, GDK_CONTROL_MASK, NULL },
	  /* xgettext:no-c-format */
	{ GNOME_APP_UI_ITEM, N_("_100%"),
	  /* xgettext:no-c-format */
	  N_("Reset zoom level to 100%"),
	  window_menu_zoom_100_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_9, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Out"), N_("Zoom out"),
	  window_menu_zoom_out_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_0, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo view_menu_uiinfo[] =
{
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Menubar"),
	  N_("Toggle menubar visibility"),
	  window_menu_menubar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_M, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Toolbar"),
	  N_("Toggle toolbar visibility"),
	  window_menu_toolbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Bookmarks toolbars"),
	  N_("Toggle bookmark toolbars visibility"),
	  window_menu_bookmarks_toolbars_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_B, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Statusbar"),
	  N_("Toggle statusbar visiblity"),
	  window_menu_statusbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_S, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Full screen"),
	  N_("Toggle full screen mode"),
	  window_menu_fullscreen_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_F11, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_SUBTREE, N_("_Zoom"),
	  N_("Use a different font size"),
	  zoom_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Encoding"),
	  N_("Use a different character encoding"),
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("St_ylesheet"),
	  N_("Specify stylesheet settings for the current page"),
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Page i_nformation..."),
	  N_("Show information about the current site"),
	  window_menu_show_page_info_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Page source"),
	  N_("View the source code of the current page"),
	  window_menu_view_source_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_U, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo tab_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Detach tab"),
	  N_("Move the current tab to a new window"),
	  window_menu_detach_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_I, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Move tab to another window"),
	  N_("Move the current tab to a different window"),
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Previous tab"),
	  N_("Switch to the previous tab"),
	  window_menu_prev_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	  GDK_Page_Up, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Next tab"),
	  N_("Switch to the next tab"),
	  window_menu_next_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	  GDK_Page_Down, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Move tab _left / up"),
	  N_("Move the current tab left / up"),
	  window_menu_shift_tab_left_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UNDO, GDK_Page_Up,
	  GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Move tab _right / down"),
	  N_("Move the current tab right / down"),
	  window_menu_shift_tab_right_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REDO, GDK_Page_Down,
	  GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Always"), N_("Load all images"),
	  window_menu_images_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_From current server only"),
	  N_("Load images from current server only"),
	  window_menu_images_current_server_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"), N_("Don't load any images"),
	  window_menu_images_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, load_images_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Continuously"),
	  N_("Animate images continuously"),
	  window_menu_animate_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Once"),
	  N_("Animate images once through"),
	  window_menu_animate_once_through_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"),
	  N_("Never animate images"),
	  window_menu_animate_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, animate_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo cookies_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Block cookies from this site"),
	  N_("Block cookies from this site"),
	  window_block_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Allow cookies from this site"),
	  N_("Allow cookies from this site"),
	  window_allow_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("View _cookies..."),
	  N_("View stored cookies"),
	  window_view_cookies_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View cookie _sites..."),
	  N_("View sites from which cookies will be accepted or rejected"),
	  window_view_cookie_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_END
};

GnomeUIInfo block_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Block images from this site"),
	  N_("Block images from this site from being loaded"),
	  window_block_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Allow images from this site"),
	  N_("Allow images from this site to be loaded"),
	  window_allow_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, N_("_View image sites..."),
	  N_("View sites for which images will not be loaded"),
	  window_view_image_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_END
};

GnomeUIInfo passwords_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("View _passwords..."),
	  N_("View stored passwords"),
	  window_view_passwords_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View password _sites..."),
	  N_("View sites for which passwords will not be stored"),
	  window_view_password_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo proxies_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Disabled"),
	  N_("Never use proxies"),
	  window_menu_no_proxies_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Manual"),
	  N_("Use manual proxy configuration"),
	  window_menu_manual_proxies_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Auto"),
	  N_("Use automatic proxy configuration"),
	  window_menu_automatic_proxies_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo proxies_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, proxies_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Settings..."),
	  N_("Detailed proxy configuration"),
	  window_menu_proxy_settings_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo settings_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("_Load images"),
	  N_("Control whether images are displayed"),
	  load_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("A_nimate images"),
	  N_("Control whether images are animated "),
	  animate_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("Pro_xy"),
	  N_("Control how proxies should be used"),
	  proxies_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own _fonts"),
	  N_("Use default fonts instead of page-requested fonts"),
	  window_menu_own_fonts_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own _colors"),
	  N_("Use default colors instead of page-requested colors"),
	  window_menu_own_colors_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Allow _Java"),
	  N_("Allow Java code to be executed"),
	  window_menu_allow_java_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Allow Java_Script"),
	  N_("Allow JavaScript code to be executed"),
	  window_menu_allow_javascript_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Allow popups"),
	  N_("Allow pages to create popup windows"),
	  window_menu_allow_popups_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Work offline"),
	  N_("Load pages from the cache instead of over the network"),
	  window_menu_offline_mode_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (window_menu_prefs_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo bookmarks_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Add _bookmark"),
	  N_("Add a bookmark for the current page to the default folder"),
	  window_menu_add_bookmark_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_D, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Add bookmark to"),
	  N_("Add a bookmark for the current page to a specified folder"),
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Edit bookmarks..."),
	  N_("Open the bookmarks editor"),
	  window_menu_bookmarks_edit_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
	  GDK_B, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo go_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Back"),
	  N_("Go back in history"),
	  window_menu_back_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	  GDK_Left, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Forward"),
	  N_("Go forward in history"),
	  window_menu_forward_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	  GDK_Right, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Up"),
	  N_("Go up a level from the current location"),
	  window_menu_up_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UP,
	  GDK_Up, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Reload"),
	  N_("Reload the current page"),
	  window_menu_reload_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
	  GDK_r, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("H_ome page"), N_("Go to your home page"),
	  window_menu_home_page_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  GDK_Home, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Stop"),
	  N_("Stop the loading of the current page"),
	  window_menu_stop_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
	  GDK_Escape, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Related _links"),
	  N_("Open the related links menu"),
	  window_menu_related_links_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL},
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo tools_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("_Cookies"), N_("Cookie management"),
	  cookies_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Images"), N_("Image blocking management"),
	  block_images_menu_uiinfo, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
 	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Passwords"), N_("Password management"),
	  passwords_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_History..."),
	  N_("Log of visited pages"),
	  window_menu_history_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_H, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR, 
	{ GNOME_APP_UI_ITEM, N_("_Java console..."),
	  N_("Open the Java console"),
	  window_menu_show_java_console_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Java_Script console..."),
	  N_("Open the JavaScript console"),
	  window_menu_show_javascript_console_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Autoreload..."),
	  N_("Automatically reload the current site every so often"),
	  window_menu_show_autoreload_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR, 
	{ GNOME_APP_UI_ITEM, N_("_Rerun first time druid..."),
	  N_("Run the first time druid again"),
	  window_run_first_time_druid_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};	

GnomeUIInfo help_menu_uiinfo[] =
{
        { GNOME_APP_UI_ITEM, N_("Galeon _FAQ"),
          N_("Open the Galeon FAQ (Frequently Asked Questions)"),
          window_menu_help_faq_activate_cb, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Galeon _manual"), 
	  N_("Open the Galeon manual"),
	  window_menu_help_manual_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Galeon _home page"),
	  N_("Go to the Galeon homepage"),
	  window_menu_help_homepage_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Report a bug"),
	  N_("Report a bug in Galeon"),
	  window_menu_help_bugreport_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("About _plugins"),
	  N_("Show information about the currently installed plugins"),
	  window_menu_help_about_plugins_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_ABOUT_ITEM (window_menu_help_about_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo menubar_uiinfo[] =
{
	GNOMEUIINFO_SUBTREE (N_("_File"), file_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Edit"), edit_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_View"), view_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Tab"), tab_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Settings"), settings_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Go"), go_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Bookmarks"), bookmarks_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("T_ools"), tools_menu_uiinfo),
	GNOMEUIINFO_SUBTREE (N_("_Help"), help_menu_uiinfo),
	GNOMEUIINFO_END
};

GnomeUIInfo *all_menus[] =
{
	file_menu_uiinfo,
	edit_menu_uiinfo,
	zoom_menu_uiinfo,
	view_menu_uiinfo,
	tab_menu_uiinfo,
	load_images_always_uiinfo,
	load_images_menu_uiinfo,
	animate_always_uiinfo,
	animate_images_menu_uiinfo,
	cookies_menu_uiinfo,
	passwords_menu_uiinfo,
	block_images_menu_uiinfo,
	proxies_always_uiinfo,
	proxies_menu_uiinfo,
	settings_menu_uiinfo,
	bookmarks_menu_uiinfo,
	go_menu_uiinfo,
	tools_menu_uiinfo,
	help_menu_uiinfo
};

gint menus_num_items[] =
{
	sizeof(file_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(edit_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(zoom_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(view_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(tab_menu_uiinfo)            / sizeof(GnomeUIInfo),
	sizeof(load_images_always_uiinfo)  / sizeof(GnomeUIInfo),
	sizeof(load_images_menu_uiinfo)    / sizeof(GnomeUIInfo),
	sizeof(animate_always_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(animate_images_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(cookies_menu_uiinfo)        / sizeof(GnomeUIInfo),
	sizeof(passwords_menu_uiinfo)	   / sizeof(GnomeUIInfo),
	sizeof(block_images_menu_uiinfo)   / sizeof(GnomeUIInfo),
	sizeof(proxies_always_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(proxies_menu_uiinfo)        / sizeof(GnomeUIInfo),
	sizeof(settings_menu_uiinfo)       / sizeof(GnomeUIInfo),
	sizeof(bookmarks_menu_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(go_menu_uiinfo)             / sizeof(GnomeUIInfo),
	sizeof(tools_menu_uiinfo)          / sizeof(GnomeUIInfo),
	sizeof(help_menu_uiinfo)           / sizeof(GnomeUIInfo)
};

gint num_menus = sizeof(all_menus) / sizeof(GnomeUIInfo *);

