/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include <config.h>
#include <gnome.h>
#include <glade/glade.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "gfax.h"
#include "setup.h"

/* #include "messages.h" */

Setup *prop = NULL;
MgettyConfigData *mgetty = NULL;
HylafaxConfigData *hylafax = NULL;

gint changed = FALSE;
gboolean mgettyChanged = FALSE;		/* flaged if user sets any mgetty items */
gboolean hylafaxChanged = FALSE;	/* flaged if user sets any hylafax items */



/*=========================================================================
 * setup(void)
 *
 *  Called from: gfax_setup() - gfax.c
 *  Returns    : If setup was changed (TRUE)
 *
 *	Run the setup dialog
 *
 *-----------------------------------------------------------------------*/
gint setup(void)
{

	GladeXML *window;	/* The main window */

	/* GnomePropertyBox *setup; */
	prop = (Setup*)malloc(sizeof(Setup));
	mgetty = (MgettyConfigData*)malloc(sizeof(MgettyConfigData));
	hylafax = (HylafaxConfigData*)malloc(sizeof(HylafaxConfigData));
	if (prop == NULL || mgetty == NULL || hylafax == NULL ) {
		perror("Gfax couldn't allocate memory....exiting\n");
		exit(1);
	}
	
	window = glade_xml_new(GLADEDIR "/setup.glade", "setup");

	/* get the widgets */
	prop->setup = (GnomePropertyBox *)glade_xml_get_widget(window, "setup");
	prop->emailNotifyCheckButton = (GtkCheckButton *)glade_xml_get_widget(window, "emailNotifyCheckButton");
	prop->sendNowCheckButton = (GtkCheckButton *)glade_xml_get_widget(window, "sendNowCheckButton");
	prop->coverPageCheckButton = (GtkCheckButton *)glade_xml_get_widget(window, "coverPageCheckButton");	
	prop->resolutionCheckButton = (GtkCheckButton *)glade_xml_get_widget(window, "resolutionCheckButton");
	prop->emailAddressEntry = (GtkEntry *)glade_xml_get_widget(window, "emailAddressEntry");
	prop->phonePrefixEntry = (GtkEntry *)glade_xml_get_widget(window, "phonePrefixEntry");
	prop->hylafaxRadioButton = (GtkRadioButton *)glade_xml_get_widget(window, "hylafaxRadioButton");	
	prop->mgettyRadioButton = (GtkRadioButton *)glade_xml_get_widget(window, "mgettyRadioButton");	
	prop->hylafaxTab = gtk_notebook_get_nth_page ((GtkNotebook *)prop->setup->notebook, 1);
	prop->mgettyTab = gtk_notebook_get_nth_page ((GtkNotebook *)prop->setup->notebook, 2);
	prop->ourFaxNumberEntry = (GtkEntry *)glade_xml_get_widget(window, "ourFaxNumberEntry");

	/* mgetty specific widgets */
	prop->mgettyTable = (GtkTable *)glade_xml_get_widget(window, "mgettyTable");
	prop->mgettyModemInitEntry = (GtkEntry *)glade_xml_get_widget(window, "mgettyModemInitEntry");
	prop->mgettyModemPortCombo = (GtkEntry *)glade_xml_get_widget(window, "mgettyModemPortCombo");
	prop->mgettyMaxTriesOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyMaxTriesOptionmenu");
	prop->mgettyIgnoreCarrierOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyIgnoreCarrierOptionmenu");
	prop->mgettyModemSpeedOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyModemSpeedOptionmenu");
	prop->mgettyModemTypeOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyModemTypeOptionmenu");
	prop->mgettySetupDruidButton = (GtkButton *)glade_xml_get_widget(window, "mgettySetupDruidButton");
	prop->mgettyConfigControlCheckButton = (GtkCheckButton *)glade_xml_get_widget(window, "mgettyConfigControlCheckButton");
	prop->mgettyFileEntry = (GnomeFileEntry *)glade_xml_get_widget(window, "mgettyFileEntry");
 	prop->mgettySendfaxConfigFileEntry = (GtkEntry *)glade_xml_get_widget(window, "mgettySendfaxConfigFileEntry");
	prop->mgettyModemHandshakeEntry = (GtkEntry *)glade_xml_get_widget(window, "mgettyModemHandshakeEntry");
	prop->mgettyModemQuirksEntry = (GtkEntry *)glade_xml_get_widget(window, "mgettyModemQuirksEntry");
	prop->mgettyDialCommandEntry = (GtkEntry *)glade_xml_get_widget(window, "mgettyDialCommandEntry");
	prop->mgettyMaxTriesContOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyMaxTriesContOptionmenu");
	prop->mgettyModemSwitchSpeedOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyModemSwitchSpeedOptionmenu");
	prop->mgettyDebugLevelOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyDebugLevelOptionmenu");
	prop->mgettyOpenDelayOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgettyOpenDelayOptionmenu");
	prop->mgRunQueueOptionmenu = (GtkOptionMenu *)glade_xml_get_widget(window, "mgRunQueueOptionmenu");
	prop->mgUserAllowText = (GtkText *)glade_xml_get_widget(window, "mgUserAllowText");
	prop->mgUserDenyText = (GtkText *)glade_xml_get_widget(window, "mgUserDenyText");
	
	
	/* hylafax specific widgets */
	prop->hylafaxServerNameEntry = (GtkEntry *)glade_xml_get_widget(window, "hylafaxServerNameEntry");
	prop->hylafaxServerPortEntry = (GtkEntry *)glade_xml_get_widget(window, "hylafaxServerPortEntry");
	prop->hylafaxServerInternalSendfax = (GtkCheckButton *)glade_xml_get_widget(window, "hylafaxInternalSendfax");
	
	/* we have to call this before we set the signal handlers because they
	   always cause a signal to be issued :-( */
	get_config(!CALL_FROM_MAIN);
		
	gtk_window_set_title(GTK_WINDOW(prop->setup), "Gfax - Setup");
	
	/* Set widgets to saved settings */
 	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->emailNotifyCheckButton), emailNotify_state);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->resolutionCheckButton), resolution_state);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->coverPageCheckButton), coverPage_state);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->sendNowCheckButton), sendNow_state);
 	gtk_entry_set_text(GTK_ENTRY(prop->emailAddressEntry), emailAddress);
	gtk_entry_set_text(GTK_ENTRY(prop->phonePrefixEntry), phonePrefix);
	gtk_entry_set_text(GTK_ENTRY(prop->ourFaxNumberEntry), ourFaxNumber);

	/* Hide the pages that aren't required */	
 	if ( g_strcasecmp(transmitAgent, "mgetty") == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->mgettyRadioButton), 1);
		gtk_widget_hide(prop->hylafaxTab);
		gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
	}
	if ( g_strcasecmp(transmitAgent, "hylafax") == 0) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop->hylafaxRadioButton), 1);
		gtk_widget_hide(prop->mgettyTab);
		gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
	}
		
	/* if we're not root then forget changing the mgetty config file*/
 	if (g_strcasecmp(g_get_user_name(), "root") != 0) {
		/* all widgets in the table go sensitive */
		gtk_widget_set_sensitive(GTK_WIDGET(prop->mgettyTable), FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(prop->mgettyConfigControlCheckButton), FALSE);

		gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
	}
	
	/* turn off "apply" button, it gets set when we set states above */
	gnome_property_box_set_modified(GNOME_PROPERTY_BOX(prop->setup), 0);

	/* connect the signals */		
	glade_xml_signal_autoconnect(window);

	gnome_dialog_run(GNOME_DIALOG(prop->setup));
	return(changed);
}	


/*=========================================================================
 * void get_config(gboolean calledFromMain)
 *
 *  Called from: main(), gfax_setup() - gfax.c
 *  Returns    : void
 *	
 *	If calledFromMain is true then we only load the main settings not
 *  any of the fax agent settings like mgetty or hylafax
 *
 *-----------------------------------------------------------------------*/
void get_config(gboolean calledFromMain)
{

		
	gboolean is_default;	/* Indicates if default item returned from config file */

 	gnome_config_push_prefix("/Gfax/Settings/");
	
	sendNow_state = gnome_config_get_bool_with_default("SendNow=TRUE", &is_default);
	phonePrefix = g_strdup(gnome_config_get_string_with_default("PhonePrefix=", &is_default));
	ourFaxNumber = g_strdup(gnome_config_get_string_with_default("OurFaxNumber=", &is_default));
	emailNotify_state = gnome_config_get_bool_with_default("EmailNotify=TRUE", &is_default);
	emailAddress = g_strdup(gnome_config_get_string_with_default("EmailAddress=", &is_default));
	coverPage_state = gnome_config_get_bool_with_default("CoverPage=FALSE", &is_default);
	resolution_state = gnome_config_get_bool_with_default("Resolution=TRUE", &is_default);
	transmitAgent = g_strdup(gnome_config_get_string_with_default("TransmitAgent=mgetty", &is_default));

 	gnome_config_pop_prefix();

        /* if we have mgetty configured */
        if (g_strcasecmp(transmitAgent, "mgetty") == 0) {
                mgetty_get_config(calledFromMain, prop, mgetty);
        }
        
        if (g_strcasecmp(transmitAgent, "hylafax") == 0) {
                hylafax_get_config(calledFromMain, prop, hylafax);
        }
	
	
	return;
}


/*=========================================================================
 * set_config(GtkWidget *propertybox, gint pageNumber, gpointer data)
 *
 *  *propertybox: gtk widget pointer of the propertybox
 *  pageNumber  : the page number that we're currently on
 *  data        : not used
 *  Called from : glade - OK, Apply Button
 *  Returns     : void
 *
 *	write the config data out.
 *
 *-----------------------------------------------------------------------*/
void set_config(GtkWidget *propertybox, gint pageNumber, gpointer data)
{
	
	if (pageNumber != -1)
		return;
		
	gnome_config_push_prefix("/Gfax/Settings/");
	
	/* send now, send the fax right away or not. */
	gnome_config_set_bool("SendNow", sendNow_state);
	gnome_config_set_string("PhonePrefix", phonePrefix);
	gnome_config_set_string("OurFaxNumber", ourFaxNumber);
	gnome_config_set_bool("EmailNotify", emailNotify_state);
	gnome_config_set_string("EmailAddress", emailAddress);
	gnome_config_set_bool("CoverPage", coverPage_state);
	gnome_config_set_bool("Resolution", resolution_state);
	gnome_config_set_string("TransmitAgent", transmitAgent);

	gnome_config_pop_prefix();

	/* if any of the settings for mgetty have been changed then we go here */
	if (mgettyChanged) {
		mgetty_set_config(prop, mgetty);
	}

	if (hylafaxChanged) {
		hylafax_set_config(prop, hylafax);
	}

	gnome_config_sync();	/* write to file */
	
}


/*=========================================================================
 * static void setup_changed(GtkWidget *widget)()
 *
 *  *widget     : gtk widget pointer of the propertybox
 *  Called from : glade - Any widget that can change state
 *  Returns     : void
 *	
 *  This sets the widget states and the "changed" variable
 *-----------------------------------------------------------------------*/
void setup_changed(GtkWidget *widget, gpointer data)
{
	changed = TRUE;
	
	gnome_property_box_changed(GNOME_PROPERTY_BOX(prop->setup));	

	if (widget == (GtkWidget *)prop->emailNotifyCheckButton) {
		emailNotify_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		return;
	}
	if (widget == (GtkWidget *)prop->sendNowCheckButton) {
		sendNow_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		return;
	}
	if (widget == (GtkWidget *)prop->coverPageCheckButton) {
		coverPage_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		return;
	}
	if (widget == (GtkWidget *)prop->resolutionCheckButton) {
		resolution_state = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
		return;
	}
	if (widget == (GtkWidget *)prop->emailAddressEntry) {
		emailAddress = g_strdup(gtk_entry_get_text((GtkEntry *)prop->emailAddressEntry));
		return;
	}
	if (widget == (GtkWidget *)prop->phonePrefixEntry) {
		phonePrefix = g_strdup(gtk_entry_get_text((GtkEntry *)prop->phonePrefixEntry));
		return;
	}
	if (widget == (GtkWidget *)prop->ourFaxNumberEntry) {
		ourFaxNumber = g_strdup(gtk_entry_get_text((GtkEntry *)prop->ourFaxNumberEntry));
		return;
	}
	if (widget == (GtkWidget *)prop->hylafaxRadioButton) {
		gtk_widget_show(prop->hylafaxTab);
		gtk_widget_hide(prop->mgettyTab);
		gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
		transmitAgent = g_strdup("hylafax");
		return;
	}
	if (widget == (GtkWidget *)prop->mgettyRadioButton) {
		gtk_widget_show(prop->mgettyTab);
		gtk_widget_hide(prop->hylafaxTab);
		gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);
		transmitAgent = g_strdup("mgetty");
		return;
	}

}


/*=========================================================================
 * void mgetty_setup_changed(GtkWidget *widget)()
 *
 *  *widget     : gtk widget pointer of changed mgetty setup widget
 *  Called from : glade - Any widget that can change state
 *  Returns     : void
 *	
 *  This sets the widget states and the "changed" variable
 *-----------------------------------------------------------------------*/
void mgetty_setup_changed(GtkWidget *widget, gpointer data)
{

	/* can't really go past here unless we're root because the config file is in /etc */
	/* and we need to write to it */
 	if (g_strcasecmp(g_get_user_name(), "root") != 0) {
		return;
	}
			
	gnome_property_box_changed(GNOME_PROPERTY_BOX(prop->setup));	

	mgetty->disabledConfig = gtk_toggle_button_get_active(
				GTK_TOGGLE_BUTTON(prop->mgettyConfigControlCheckButton));

	if (widget == (GtkWidget *)prop->mgettyConfigControlCheckButton) {
		if (mgetty->disabledConfig) {
	
			GString *tmpstr;

			tmpstr = g_string_new(NULL);
	
			/* clean the Mgetty section */
 			g_string_sprintf(tmpstr, "=%s/%s=/Mgetty", GFAX_DATADIR, "Config");
			gnome_config_clean_section(tmpstr->str);
	
			/* lets save this first so we always have it */
 			g_string_sprintf(tmpstr, "=%s/%s=/Mgetty/DisabledConfig", GFAX_DATADIR, "Config");
			gnome_config_set_bool(tmpstr->str, mgetty->disabledConfig);

			g_string_free(tmpstr, TRUE);
			
			/* all widgets in the table go !sensitive */
			gtk_widget_set_sensitive(GTK_WIDGET(prop->mgettyTable), FALSE);	
			gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);

			return;
	
		}else {

			GString *tmpstr;

			tmpstr = g_string_new(NULL);

			/* lets save this first so we always have it */
 			g_string_sprintf(tmpstr, "=%s/%s=/Mgetty/DisabledConfig", GFAX_DATADIR, "Config");
			gnome_config_set_bool(tmpstr->str, mgetty->disabledConfig);
	
			g_string_free(tmpstr, TRUE);

			/* all widgets in the table go sensitive */
			gtk_widget_set_sensitive(GTK_WIDGET(prop->mgettyTable), TRUE);
			gtk_widget_draw(GTK_WIDGET(prop->setup), NULL);

			get_config(!CALL_FROM_MAIN);	/* we're not called from main() */
			return;
		}
	}
	mgettyChanged = TRUE;
	changed = TRUE;
	
	return;
}


/*=========================================================================
 * void hylafax_setup_changed(GtkWidget *widget)()
 *
 *  *widget     : gtk widget pointer of changed hylfax setup widget
 *  Called from : glade - Any widget that can change state
 *  Returns     : void
 *	
 *  This sets the widget states and the "changed" variable
 *-----------------------------------------------------------------------*/
void hylafax_setup_changed(GtkWidget *widget, gpointer data)
{

	gnome_property_box_changed(GNOME_PROPERTY_BOX(prop->setup));	

	hylafaxChanged = TRUE;
	changed = TRUE;
}


/*=========================================================================
 * void setup_help(GtkWidget *propertybox, gint pageNumber, gpointer data)
 *	
 *  Called from the setup Help button
 *-----------------------------------------------------------------------*/
void setup_help(GtkWidget *propertybox, gint pageNumber, gpointer data)
{
	if (pageNumber == 2) {
	 	if (g_strcasecmp(g_get_user_name(), "root") != 0) {
			do_message(_("\nYou must be root to change the mgetty configuration file.\n\n\
							Once you are logged in as root this help button will display\n\
							the Mgetty+Sendfax help page.\n"));
			return;
		}
 		system("gnome-help-browser info:mgetty#runtime-sendfax &");
	}
	return;
}


/* These are Emacs variables to use a common "Gfax" coding style:
 * ;;; Local Variables: ***
 * ;;; mode:C ***
 * ;;; c-basic-offset:8 ***
 * ;;; indent-tabs-mode:t ***
 * ;;; End: ***
 */

