/* $Id: Transform.h,v 1.7 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef Transform_h
#define Transform_h

#include "common/Geometry.h"
// dynagraph uses dimensionless up-positive coords, but not everyone else does!
// so when it reads or writes .dot files or talks over a pipe, it uses one of these:
// multiplies by relevant ratios on read, divides on write
class Transform {
	Coord nodeRatio, // for node size
		coordRatio; // for node position, edge coords, and bounding box
public:
	Coord ll; // lower left corner
	Transform(Coord nr,Coord cr) : nodeRatio(nr),coordRatio(cr) {}

	Coord inSize(Coord c) {
		return Coord(c.x*nodeRatio.x,c.y*nodeRatio.y);
	}
	Coord outSize(Coord c) {
		return Coord(c.x/nodeRatio.x,c.y/nodeRatio.y);
	}
	Coord in(Coord c) {
		return Coord((c+ll).x*coordRatio.x,(c+ll).y*coordRatio.y);
	}
	Coord out(Coord c) {
		return Coord(c.x/coordRatio.x-ll.x,c.y/coordRatio.y-ll.y);
	}
	Rect in(Rect r) {
		Coord ul = in(Coord(r.l,r.t)),
			lr = in(Coord(r.r,r.b));
		return Rect(ul.x,ul.y,lr.x,lr.y);
	}
	Rect out(Rect r) {
		Coord ul = out(Coord(r.l,r.t)),
			lr = out(Coord(r.r,r.b));
		return Rect(ul.x,ul.y,lr.x,lr.y);
	}
};
// dot transform: node size in inches, coords in down-positive points
// (dynagraph will do calcs in up-positive points)
extern Transform g_dotRatios;

#endif // Transform_h
