/* $Id: voronoi.h,v 1.8 2005/04/05 12:02:56 ellson Exp $ $Revision: 1.8 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef VORONOI_H
#define VORONOI_H

#include "voronoi/site.h"
#include "voronoi/info.h"
#include "voronoi/edges.h"
#include "voronoi/hedges.h"

namespace Voronoi {

struct VoronoiServer : Server {
	double margin;     /* Create initial bounding box by adding
                        * margin * dimension around box enclosing
                        * nodes.
                        */
	double incr;       /* Increase bounding box by adding
                        * incr * dimension around box.
                        */
	double pmargin;  /* Margin around polygons, in inches */
	int iterations;  /* Number of iterations */
	bool useIter;   /* Use specified number of iterations */

	bool doAll;  /* Move all nodes, regardless of overlap */
	Bounds bounds;     

	const int N;

	VoronoiServer(Layout *client, Layout *current) : 
		Server(client,current),margin(0.05),incr(0.025),pmargin(5.0/72),iterations(-1),useIter(false),
		N(400), infos(N),sites(N),edges(sites,infos,bounds,N),hedges(sites,N) {}


	// Server
	void Process(ChangeQueue &changeQ);

private:
	Infos infos;
	Sites sites;
	Edges edges;
	Halfedges hedges;

	void chkBoundBox();
	void makeInfo();
	void sortSites(std::vector<Site*> &sort);
	void geomUpdate(std::vector<Site*> &sort);
	int countOverlap(int iter);
	void increaseBoundBox();
	bool isInterior (Info* ip);
	void newpos(Info* ip);
	void addCorners();
	void newPos();
	bool vAdjust();
	void updateLayout(ChangeQueue &Q);

	void voronoi(const std::vector<Site*> &order);
};

} // namespace Voronoi

#endif // VORONOI_H
