/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: chxelst.cpp,v 1.3.2.1 2004/07/09 02:05:57 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hxtypes.h"
#include "hxresult.h"
#include "hxcom.h"
#include "ihxpckts.h"
#include "hxfiles.h"
#include "hxcore.h"

#include "chxeven.h"
#include "chxelst.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif


HX_RESULT CHXEventList::InsertEvent(CHXEvent*	pEvent)
{
    HX_RESULT theErr = HXR_OK;

    // enqueue the event into event queue
    CHXEvent*		event = NULL;
    BOOL		earlierPacketFound = FALSE;
    UINT32		currentPos = 0;
    UINT32		startPos = pEvent->GetTimeStartPos();

    // Loop we are done or we find an event that is after this
    // time stamp...
    LISTPOSITION	position = GetTailPosition();
    while (position != NULL && !earlierPacketFound && theErr == HXR_OK )
    {
	event = GetPrev(position);

	// This event must be valid or else it shouldn't be
	// in this list!
	HX_ASSERT_VALID_PTR(event);

	currentPos = event->GetTimeStartPos();
	// either   a) 0xFA 0xFB 0xFC (0xFD)
	// or	    b) 0xFA .. 0xFF [roll over] (0x01)
	if ((currentPos <= startPos && (startPos - currentPos) < MAX_TIMESTAMP_GAP) ||
	    (currentPos > startPos && (currentPos - startPos) > MAX_TIMESTAMP_GAP))
	{
	    // Remember that we found an earlier packet...
	    earlierPacketFound = TRUE;

	    // If the position is null, then event was the first
	    // item in the list, and we need to do some fancy footwork...
	    if (!position)
	    {
		POSITION theHead = GetHeadPosition();
		LISTPOSITION listRet = InsertAfter(theHead,pEvent);
                if( listRet == NULL )
                {
                    theErr = HXR_OUTOFMEMORY;
                }
	    }
	    // otherwise, roll ahead one...
	    else
	    {
		GetNext(position);
		// Now if the position is null, then event was the last
		// item in the list, and we need to do some more fancy footwork...
		if (!position)
		{
		    AddTail(pEvent);
		}
		else
		// otherwise, we have a normal case and we want to insert
		// right after the position of event
		{
		    LISTPOSITION listRet = InsertAfter(position,pEvent);
                    if( listRet == NULL )
                    {
                        theErr = HXR_OUTOFMEMORY;
		    }
		}
	    }

	    // We don't need to search any more...
	    break; // while
	}
    } // end while...

    // If we didn't find an earlier packet, then we should insert at
    // the head of the event list...
    if (!theErr && !earlierPacketFound)
    {
	AddHead(pEvent);
    }

    return theErr;
}
