/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcolor.h,v 1.2.16.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PXCOLOR_H
#define _PXCOLOR_H

class PXColor : public CHXBaseCountingObject,
                public CUnknownIMP
{
    DECLARE_UNKNOWN(PXColor)
public:
    PXColor();
    PXColor(const PXColor &rColor);
    PXColor(BYTE ucR, BYTE ucG, BYTE ucB, BYTE ucA = 0);
    ~PXColor() {};

    const PXColor& operator=  (const PXColor& rColor);
    BOOL           operator== (const PXColor& rColor) const;
    BOOL           operator!= (const PXColor& rColor) const;

    BYTE      GetRed()   const { return m_ucRed;   };
    BYTE      GetGreen() const { return m_ucGreen; };
    BYTE      GetBlue()  const { return m_ucBlue;  };
    BYTE      GetAlpha() const { return m_ucAlpha; };
    void      SetRed(BYTE ucRed)     { m_ucRed   = ucRed;   };
    void      SetGreen(BYTE ucGreen) { m_ucGreen = ucGreen; };
    void      SetBlue(BYTE ucBlue)   { m_ucBlue  = ucBlue;  };
    void      SetAlpha(BYTE ucAlpha) { m_ucAlpha = ucAlpha; };
    void      Set(BYTE ucR, BYTE ucG, BYTE ucB, BYTE ucA = 0);
    void      Set(UINT32 ulColor);

    void      Pack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);
    void      UnPack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);
    HX_RESULT InitFromString(const char *pszStr);
private:
    BYTE m_ucRed;
    BYTE m_ucGreen;
    BYTE m_ucBlue;
    BYTE m_ucAlpha;

    enum {kNumPredefinedColors = 16};

    static const UINT32      m_pulPredefinedColor[kNumPredefinedColors];
    static const char* const m_ppPredefinedColorName[kNumPredefinedColors];
};

inline void PXColor::Set(BYTE ucR, BYTE ucG, BYTE ucB, BYTE ucA)
{
    m_ucRed   = ucR;
    m_ucGreen = ucG;
    m_ucBlue  = ucB;
    m_ucAlpha = ucA;
};

inline PXColor::PXColor()
{
    Set(0, 0, 0, 0);
};

inline PXColor::PXColor(const PXColor &rColor)
{
    m_ucRed   = rColor.m_ucRed;
    m_ucGreen = rColor.m_ucGreen;
    m_ucBlue  = rColor.m_ucBlue;
    m_ucAlpha = rColor.m_ucAlpha;
};

inline PXColor::PXColor(BYTE ucR, BYTE ucG, BYTE ucB, BYTE ucA)
{
    Set(ucR, ucG, ucB, ucA);
};

inline const PXColor& PXColor::operator= (const PXColor& rColor)
{
    m_ucRed   = rColor.m_ucRed;
    m_ucGreen = rColor.m_ucGreen;
    m_ucBlue  = rColor.m_ucBlue;
    m_ucAlpha = rColor.m_ucAlpha;
    return *this;
};

inline BOOL PXColor::operator== (const PXColor& rColor) const
{
    BOOL bRet = TRUE;
    if (m_ucRed   != rColor.m_ucRed   ||
        m_ucGreen != rColor.m_ucGreen ||
        m_ucBlue  != rColor.m_ucBlue  ||
        m_ucAlpha != rColor.m_ucAlpha)
    {
        bRet = FALSE;
    }
    return bRet;
}

inline BOOL PXColor::operator!= (const PXColor& rColor) const
{
    BOOL bRet = FALSE;
    if (m_ucRed   != rColor.m_ucRed   ||
        m_ucGreen != rColor.m_ucGreen ||
        m_ucBlue  != rColor.m_ucBlue  ||
        m_ucAlpha != rColor.m_ucAlpha)
    {
        bRet = TRUE;
    }
    return bRet;
}

inline void PXColor::Set(UINT32 ulColor)
{
    m_ucRed   = (BYTE) ((ulColor >> 16) && 0x000000FF);
    m_ucGreen = (BYTE) ((ulColor >>  8) && 0x000000FF);
    m_ucBlue  = (BYTE) ( ulColor        && 0x000000FF);
    m_ucAlpha = (BYTE) ((ulColor >> 24) && 0x000000FF);
}

#endif


