; NSIS installer script for helix plugins

!define VERSION "0.5"
!define BASE_REG_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\Helix Xiph Plugins ${VERSION}"

OutFile "xiph_player_plugins_${VERSION}.exe"
Name "Helix Xiph Plugins ${VERSION}"

Function .onInit
  IfFileExists $COMMONFILES\Real\Plugins NoAbort 0 
    MessageBox MB_OK "RealPlayer is not installed"
    Abort ; causes installer to quit.
  NoAbort:
FunctionEnd

Section
  StrCpy $INSTDIR $COMMONFILES\Real\Plugins
  SetOutPath $INSTDIR
  File oggfformat.dll  
  File vorbisrend.dll
  File theorarend.dll
  WriteUninstaller $INSTDIR\uninstall_xiph_plugins.exe

  WriteRegStr HKLM "${BASE_REG_KEY}" "DisplayName" "Helix Xiph Plugins ${VERSION}"
  WriteRegStr HKLM "${BASE_REG_KEY}" "UninstallString" "$\"$INSTDIR\uninstall_xiph_plugins.exe$\""
SectionEnd

Section "Uninstall"
  Delete $INSTDIR\uninstall_xiph_plugins.exe
  Delete $INSTDIR\oggfformat.dll
  Delete $INSTDIR\vorbisrend.dll
  Delete $INSTDIR\theorarend.dll

  DeleteRegKey HKLM "${BASE_REG_KEY}"
SectionEnd