/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sdprendr.h,v 1.2.10.1 2004/07/19 21:04:17 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SDPRENDR_H_
#define _SDPRENDR_H_

class CSDPRenderer :    public IHXPlugin
		     ,  public IHXRenderer
{
public:
    CSDPRenderer();
    virtual ~CSDPRenderer();

    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    // IHXPlugin methods
    STDMETHOD(GetPluginInfo) (THIS_ REF(BOOL)        bLoadMultiple,
                                    REF(const char*) pDescription,
                                    REF(const char*) pCopyright,
                                    REF(const char*) pMoreInfoURL,
                                    REF(ULONG32)     ulVersionNumber);
    STDMETHOD(InitPlugin)    (THIS_ IUnknown* pContext);

    // IHXRenderer methods
    STDMETHOD(GetRendererInfo) (THIS_ REF(const char**) pStreamMimeTypes,
                                      REF(UINT32)       unInitialGranularity);
    STDMETHOD(StartStream)     (THIS_ IHXStream* pStream, IHXPlayer* pPlayer);
    STDMETHOD(EndStream)       (THIS);
    STDMETHOD(OnHeader)        (THIS_ IHXValues* pHeader);
    STDMETHOD(OnPacket)        (THIS_ IHXPacket* pPacket, LONG32 lTimeOffset);
    STDMETHOD(OnTimeSync)      (THIS_ ULONG32 ulTime);
    STDMETHOD(OnPreSeek)       (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPostSeek)      (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPause)         (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBegin)         (THIS_ ULONG32 ulTime);
    STDMETHOD(OnBuffering)     (THIS_ ULONG32 ulFlags, UINT16 unPercentComplete);
    STDMETHOD(GetDisplayType)  (THIS_ REF(HX_DISPLAY_TYPE) ulFlags,
                                      REF(IHXBuffer*)      pBuffer);
    STDMETHOD(OnEndofPackets)  (THIS);

    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);

protected:

    LONG32                  m_lRefCount;
    UINT16		    m_uGroupIndex;
    IUnknown*               m_pContext;
    IHXStream*              m_pStream;
    IHXPlayer*              m_pPlayer;

    static const char* const     zm_pName;
    static const char* const     zm_pDescription;
    static const char* const     zm_pCopyright;
    static const char* const     zm_pMoreInfoURL;
    static const char* const     zm_pStreamMimeTypes[];

    HX_RESULT		    ProcessSDP(IHXBuffer* pBuffer);
    void		    Cleanup(void);
};

#endif // _SDPRENDR_H_

