/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smltime.cpp,v 1.2.12.1 2004/07/09 01:57:38 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

#include "hxtypes.h"
#include "hxresult.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "ihxpckts.h"
#include "hxfiles.h"
#include "hxformt.h"
#include "hxengin.h"
#include "hxplugn.h"
#include "hxpends.h"
#include "hxasm.h"
#include "hxprefs.h"
#include "hxassert.h"
#include "chxpckts.h"
#include "nptime.h"
#include "smpte.h"
#include "debug.h"
#include "hxstrutl.h"
#include "hxstring.h"
#include "cbqueue.h"
#include "hxslist.h"
#include "hxmap.h"
#include "hxstack.h"
#include "hxwintyp.h"
#include "chxxtype.h"

#include "hxxml.h"
#include "hxxmlprs.h"
#include "xmlreslt.h"

#include "looseprs.h"

#include "sm1elem.h"
#include "sm1parse.h"
#include "sm1time.h"


/*
 * CSmil1TimelineElementManager methods
 */

CSmil1TimelineElementManager::CSmil1TimelineElementManager():
    m_pElementMap(NULL),
    m_pNotifierMap(NULL)
{
}

CSmil1TimelineElementManager::~CSmil1TimelineElementManager()
{
    HX_DELETE(m_pElementMap);
    if(m_pNotifierMap)
    {
	CHXMapStringToOb::Iterator i = m_pNotifierMap->Begin();
	for(; i != m_pNotifierMap->End(); ++i)
	{
	    CHXSimpleList* pList = (CHXSimpleList*)(*i);
	    delete pList;
	}
	HX_DELETE(m_pNotifierMap);
    }
}

void
CSmil1TimelineElementManager::addTimelineElement(CSmil1TimelineElement* pElement)
{
    if(!m_pElementMap)
    {
	m_pElementMap = new CHXMapStringToOb;
    }
    (*m_pElementMap)[pElement->m_pID] = pElement;
}

CSmil1TimelineElement*
CSmil1TimelineElementManager::getTimelineElement(const char* pID)
{
    CSmil1TimelineElement* pElement = NULL;
    if(m_pElementMap)
    {
	m_pElementMap->Lookup(pID, (void*&)pElement);
    }
    return pElement;
}

void
CSmil1TimelineElementManager::addNotification(const char* pID,
					     CSmil1TimelineElement* pElement)
{
    if(!m_pNotifierMap)
    {
	m_pNotifierMap = new CHXMapStringToOb;
    }

    CHXSimpleList* pNotifyList = NULL;
    if(!m_pNotifierMap->Lookup(pID, (void*&)pNotifyList))
    {
	pNotifyList = new CHXSimpleList;
	(*m_pNotifierMap)[pID] = pNotifyList;
    }
    pNotifyList->AddTail(pElement);
}

void
CSmil1TimelineElementManager::notify(const char* pID)
{
    CHXSimpleList* pNotifyList = NULL;
    if(m_pNotifierMap)
    {
	if(m_pNotifierMap->Lookup(pID, (void*&)pNotifyList))
	{
	    CSmil1TimelineElement* pDependentElement = NULL;
	    if(m_pElementMap->Lookup(pID, (void*&)pDependentElement))
	    {
		CHXSimpleList::Iterator i = pNotifyList->Begin();
		for(; i != pNotifyList->End(); ++i)
		{
		    CSmil1TimelineElement* pElement = 
			(CSmil1TimelineElement*)(*i);
		    pElement->elementResolved(pDependentElement);
		}
	    }
	}
    }
}

void
CSmil1TimelineElementManager::resetTimeline()
{
    if(m_pElementMap)
    {
	CHXMapStringToOb::Iterator i = m_pElementMap->Begin();
	for(; i != m_pElementMap->End(); ++i)
	{
	    CSmil1TimelineElement* pElement = 
		(CSmil1TimelineElement*)(*i);
	    pElement->reset();
	}
    }
}	
/*
 * CSmil1TimelineElement methods
 */

CSmil1TimelineElement::CSmil1TimelineElement(CSmil1Element* pSourceElement,
					   CSmil1Parser* pParser):
    m_pSourceElement(pSourceElement),
    m_pParser(pParser),
    m_bDurationSet(FALSE),
    m_bMaxDurationSet(FALSE),
    m_bDelaySet(FALSE),
    m_bDontResetDuration(FALSE),
    m_bNonEventDelaySet(FALSE),
    m_bDelayEvent(FALSE),
    m_bDurationEvent(FALSE),
    m_pParent(NULL),
    m_pChildren(NULL),
    m_pDependent(NULL)
{
    m_pID = new char[pSourceElement->m_pNode->m_id.GetLength() + 1];
    strcpy(m_pID, (const char*)m_pSourceElement->m_pNode->m_id); /* Flawfinder: ignore */

    if (m_pParser && m_pParser->m_pTimelineElementManager)
    {
        m_pParser->m_pTimelineElementManager->addTimelineElement(this);

        if(pSourceElement->m_nBeginEventSourceTag == SMILEventSourceBegin ||
	    pSourceElement->m_nBeginEventSourceTag == SMILEventSourceEnd ||
	    pSourceElement->m_nBeginEventSourceTag == SMILEventSourceClock)
        {
	    m_pParser->m_pTimelineElementManager->addNotification(pSourceElement->m_BeginEventSourceID,
	        this);
	    m_bDelayEvent = TRUE;
        }

        if(pSourceElement->m_nEndEventSourceTag == SMILEventSourceBegin ||
	    pSourceElement->m_nEndEventSourceTag == SMILEventSourceEnd ||
	    pSourceElement->m_nEndEventSourceTag == SMILEventSourceClock)
        {
	    m_pParser->m_pTimelineElementManager->addNotification(pSourceElement->m_EndEventSourceID,
	        this);
	    m_bDurationEvent = TRUE;
        }

        if(pSourceElement->m_nEndsyncEventSourceTag == SMILEventSourceID)
        {
	    m_pParser->m_pTimelineElementManager->addNotification(pSourceElement->m_EndsyncEventSourceID,
	        this);
	    m_bDurationEvent = TRUE;
        }
    }

}

CSmil1TimelineElement::~CSmil1TimelineElement()
{
    delete m_pChildren;
    delete[] m_pID;
}

void
CSmil1TimelineElement::reset()
{
    m_bDelaySet = FALSE;
    m_bNonEventDelaySet = FALSE;
    m_bDurationSet = FALSE;
    m_bMaxDurationSet = FALSE;
}

void 
CSmil1TimelineElement::setDelay(UINT32 ulDelay)
{
    if(!m_bDelaySet)
    {
	if(!m_bDelayEvent)
	{
	    if(m_pSourceElement->m_ulBeginOffset != (UINT32)-1)
	    {
		m_pSourceElement->m_ulDelay = ulDelay + 
		    m_pSourceElement->m_ulBeginOffset;
	    }
	    else
	    {
		m_pSourceElement->m_ulDelay = ulDelay;
	    }
	    m_bDelaySet = TRUE;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
    else
    {
	if(m_pSourceElement->m_ulBeginOffset != (UINT32)-1)
	{
	    m_pSourceElement->m_ulDelay = ulDelay + 
		m_pSourceElement->m_ulBeginOffset;
	}
	else
	{
	    m_pSourceElement->m_ulDelay = ulDelay;
	}
    }
}

void 
CSmil1TimelineElement::setDuration(UINT32 ulDuration, BOOL bSetFromParent)
{
    if(bSetFromParent)
    {
	m_pSourceElement->m_ulDuration = ulDuration;
	m_bDurationSet = m_bDontResetDuration = TRUE;
	m_pParser->resetTimelineElementDuration(m_pID,
	    m_pSourceElement->m_ulDuration);
    }
    else
    {
	if(!m_bDurationSet)
	{
	    if(m_pSourceElement->m_ulBeginOffset != (UINT32)-1)
	    {
		m_pSourceElement->m_ulDuration = ulDuration + 
		    m_pSourceElement->m_ulBeginOffset;
	    }
	    else
	    {
		m_pSourceElement->m_ulDuration = ulDuration;
	    }
	    m_bDurationSet = TRUE;
	    if(m_pParent)
	    {
		m_pParent->addDuration(m_pSourceElement->m_ulDuration, 
		    m_pSourceElement->m_ulDelay, m_pID);
	    }
	}
	else if(!m_bDontResetDuration)
	{
	    m_pSourceElement->m_ulDuration = ulDuration;
	    m_pParser->resetTimelineElementDuration(m_pID,
		m_pSourceElement->m_ulDuration);
	}
    }
    if(m_pDependent)
    {
	//Removed the addition of m_pSourceElement->m_ulDelay from the
	// source's duration because the source's duration already includes
	// its delay; we don't want to count the delay twice. Fixes PR 13983:
	// /*XXXEH- UNFIXES 13983 by adding back in the ...m_ulDelay addition;
	// the full fix for 13983 requires keeping track of begin=... delay
	// (as opposed to seq-related delay) and then subtracting that begin
	// delay from the m_ulDelay below:
	adjustDependentDuration(m_pDependent);
	m_pDependent->setDelay(m_pSourceElement->m_ulDelay + m_pSourceElement->m_ulDuration);
    }

    if (m_pParser && m_pParser->m_pTimelineElementManager)
    {
        m_pParser->m_pTimelineElementManager->notify(m_pID);
    }
}

void
CSmil1TimelineElement::setMaxDuration(UINT32 ulMaxDuration)
{
    m_bMaxDurationSet = TRUE;
    m_pSourceElement->m_ulMaxDuration = ulMaxDuration;
}

void 
CSmil1TimelineElement::adjustDependentDuration(CSmil1TimelineElement* pDependent)
{
    if (m_pParent)
    {
	m_pParent->adjustDependentDuration(m_pDependent);
    }
}

void
CSmil1TimelineElement::elementResolved(CSmil1TimelineElement* pEventElement)
{
    //First, let's see if we have a begin event to resolve:
    if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    m_bDelaySet = TRUE;
	    m_pSourceElement->m_ulDelay = 
		pEventElement->m_pSourceElement->m_ulDelay;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    m_bDelaySet = TRUE;
	    m_pSourceElement->m_ulDelay = 
		pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceClock)
    {
	//We want event *BEGIN* plus clock therefor check for m_bDelaySet not
	// m_bDurationSet; after all, it's the eventElement's m_ulDelay
	// that's used, below:
	if(pEventElement->m_bDelaySet)
	{
	    m_bDelaySet = TRUE;
	    m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDelay;
	    //[SMIL 1.0 compliance] helps fix 23025:
	    // Rather than putting all the offset into m_ulDelay,
	    // we want to put the event element's delay into our
	    // delay and then put the event clock value into our
	    // m_ulBeginOffset so that we can properly adjust
	    // for any timing imposed on us later by our container
	    // (parent):
	    HX_ASSERT(m_pSourceElement->m_ulBeginOffset == UINT32(-1));
	    m_pSourceElement->m_ulBeginOffset =
		    m_pSourceElement->m_ulBeginEventClockValue;
            m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay +
		//Allows SYMM 3/13/2000 test case 1.13 to work again
		// while allowing 23025 to keep working:
		m_pSourceElement->m_ulBeginOffset);
	}
    }

    //[SMIL 1.0 compliance] Fixes PR 16629:
    //Next, let's see if we have an end event to resolve:
    if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    m_bDurationSet = TRUE;
	    m_pSourceElement->m_ulDuration = 
		pEventElement->m_pSourceElement->m_ulDelay;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    m_bDurationSet = TRUE;
	    m_pSourceElement->m_ulDuration = 
		pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
    //[SMIL 1.0 compliance] Fixes PR 16629; we need to set our duration
    // to the event element's end time plus the clock offset:
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceClock)
    {
	if(pEventElement->m_bDelaySet)
	{
	    m_bDurationSet = TRUE;
	    m_pSourceElement->m_ulDuration = 
		    pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulEndEventClockValue;
	    m_pParser->insertTimelineElement(m_pID, 
		m_pSourceElement->m_ulDelay);
	}
    }
}

#if 0
void
CSmil1TimelineElement::setEvent(SMILEventSourceTag eTag,
				SMILSyncAttributeTag aTag,
				const char* pEventSourceID,
				UINT32 ulEventClockValue)
{
    m_eEventSourceTag = eTag;
    m_eSyncAttributeTag = aTag;
    if(pEventSourceID)
    {
	m_pEventSourceID = new char[strlen(pEventSourceID)+1];
	strcpy(m_pEventSourceID, pEventSourceID); /* Flawfinder: ignore */
        if (m_pParser && m_pParser->m_pTimelineElementManager)
        {
            m_pParser->m_pTimelineElementManager->addNotification(pEventSourceID, this);
        }
    }
    m_ulEventClockValue = ulEventClockValue;
}
#endif


void 
CSmil1TimelineElement::addChild(CSmil1TimelineElement* pChild)
{
    if(!m_pChildren)
    {
	m_pChildren = new CHXSimpleList;
    }
    m_pChildren->AddTail(pChild);
    pChild->setParent(this);
}

UINT32
CSmil1TimelineElement::getDuration()
{
    return m_pSourceElement->m_ulDuration;
}

UINT32
CSmil1TimelineElement::getDelay()
{
    return m_pSourceElement->m_ulDelay;
}

void 
CSmil1TimelineElement::dump()
{
}


/*
 * CSmil1TimelinePar methods
 */

CSmil1TimelinePar::CSmil1TimelinePar(CSmil1Element* pSourceElement,
				   CSmil1Parser* pParser):
    CSmil1TimelineElement(pSourceElement, pParser),
    m_nDurationAdded(0),
    m_ulFirstDuration(0),
    m_ulLastDuration(0)
{
}

CSmil1TimelinePar::~CSmil1TimelinePar()
{
}

void 
CSmil1TimelinePar::setDelay(UINT32 ulDelay)
{
    if(m_pSourceElement->m_ulBeginOffset != (UINT32)-1)
    {
	m_pSourceElement->m_ulDelay = ulDelay + 
	    m_pSourceElement->m_ulBeginOffset;
    }
    else
    {
	m_pSourceElement->m_ulDelay = ulDelay;
    }
    if (!m_bDelayEvent) //[SMIL 1.0 compliance] helps fix PR 14420.
    {
	m_bDelaySet = TRUE;
	if(m_pChildren)
	{
	    CHXSimpleList::Iterator i = m_pChildren->Begin();
	    for(; i != m_pChildren->End(); ++i)
	    {
		CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);
		pElement->setDelay(m_pSourceElement->m_ulDelay);
	    }
	}

	if (m_pSourceElement->m_ulDuration != (UINT32)-1)
	{
	    setDuration(m_pSourceElement->m_ulDuration);
	}
    }
    else //[SMIL 1.0 compliance] for PR 14420:
	// let's not claim that the delay is set when we still
	// are awaiting a delay (begin) event; we *do* need to
	// add the delay of this to the event's begin offset.
	// This is done by setting the new "m_bNonEventDelaySet"
	// variable to TRUE and leaving m_bDelaySet to FALSE
	// until the ElementResolved() call sets it to true:
    {
	//Parent calls setDelay before we get to ElementResolved,
	// thus m_bDelaySet should never be TRUE if we have a
	// delay event:
	HX_ASSERT(!m_bDelaySet);
	m_bNonEventDelaySet = TRUE; //ElementResolved will look at this.
    }
}

void
CSmil1TimelinePar::setDuration(UINT32 ulDuration, BOOL bSetFromParent)
{
    m_pSourceElement->m_ulDuration = ulDuration;
    m_bDurationSet = TRUE;
    if(m_pChildren)
    {
	CHXSimpleList::Iterator i = m_pChildren->Begin();
	for(; i != m_pChildren->End(); ++i)
	{
	    CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);
	    pElement->setDuration(m_pSourceElement->m_ulDuration, TRUE);
        }
    }
    
    if(m_pDependent)
    {
	adjustDependentDuration(m_pDependent);
	m_pDependent->setDelay(m_pSourceElement->m_ulDelay + m_pSourceElement->m_ulDuration);
    }

    //[SMIL 1.0 comliance] Helps fix PR 14420 and 23025:
    if (m_pParser && m_pParser->m_pTimelineElementManager)
    {
        m_pParser->m_pTimelineElementManager->notify(m_pID);
    }
}

void
CSmil1TimelinePar::setMaxDuration(UINT32 ulMaxDuration)
{
    HX_ASSERT(m_pChildren);
    m_bMaxDurationSet = TRUE;
    m_pSourceElement->m_ulMaxDuration = ulMaxDuration;

    if (m_pChildren)
    {
	CHXSimpleList::Iterator i = m_pChildren->Begin();
	for(; i != m_pChildren->End(); ++i)
	{
	    CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);
	    pElement->setMaxDuration(ulMaxDuration);
	}
    }
}

void 
CSmil1TimelinePar::adjustDependentDuration(CSmil1TimelineElement* pDependent)
{
    if (m_pParent)
    {
	m_pParent->adjustDependentDuration(pDependent);
    }

    return;
}

void 
CSmil1TimelinePar::addDuration(UINT32 ulDuration,
			      UINT32 ulDelay,
			      const char* pElementID)
{
    if(m_pSourceElement->m_ulDuration == (UINT32)-1)
    {
	m_pSourceElement->m_ulDuration = ulDuration;
	m_ulFirstDuration = ulDuration;
	m_ulLastDuration = ulDuration;
    }
    else
    {
	m_pSourceElement->m_ulDuration = 
	    (ulDuration > m_pSourceElement->m_ulDuration) ?
	    ulDuration : m_pSourceElement->m_ulDuration;
	if(ulDuration < m_ulFirstDuration)
	{
	    m_ulFirstDuration = ulDuration;
	}
	if(ulDuration > m_ulLastDuration)
	{
	    m_ulLastDuration = ulDuration;
	}
    }

    m_nDurationAdded++;
    if(m_nDurationAdded == m_pChildren->GetCount() &&
	!m_bDurationEvent)
    {
	if(m_pSourceElement->m_nEndsyncEventSourceTag == 
	    SMILEventSourceFirst)
	{
	    durationResolved(m_ulFirstDuration, TRUE);
	}
	else if(m_pSourceElement->m_nEndsyncEventSourceTag == 
	    SMILEventSourceLast)
	{
	    durationResolved(m_ulLastDuration, TRUE);
	}
	else
	{
	    durationResolved(m_pSourceElement->m_ulDuration, FALSE);
	}
    }
}

void
CSmil1TimelinePar::elementResolved(CSmil1TimelineElement* pEventElement)
{
//XXXEH: do we really want to check m_bDurationSet and m_bDelaySet...etc.
// first???? (as in old version)

//XXXEH: also, shouldn't we be making sure the pEventElement's id
// matches the m_[XXX]EventSourceID?  Otherwise, a begin event on one id
// and an end event on another may cause problems...

    //First, let's see if we have a begin event to resolve:
    if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    //[SMIL 1.0 Compliance] Helps fix 14420:
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDelay;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDelay;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    //[SMIL 1.0 Compliance] Helps fix 14420:
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceClock)
    {
	//We want event *BEGIN* plus clock therefor check for m_bDelaySet not
	// m_bDurationSet; after all, it's the eventElement's m_ulDelay
	// that's used, below:
	if(pEventElement->m_bDelaySet)
	{
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay + clock val:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulBeginEventClockValue;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulBeginEventClockValue;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }

    
//XXXEH: shouldn't we be making sure the pEventElement's id
// matches the m_[XXX]EventSourceID, otherwise a begin event on one id
// and an end event on another will cause problems.
#if defined(XXXEH_UNTESTED_AND_NOT_EXAMINED_WELL)
    if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    durationResolved(pEventElement->m_pSourceElement->m_ulDelay,
		    TRUE);
	}
    }
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    durationResolved(pEventElement->getDuration(), TRUE);
	}
    }
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceClock)
    {
	if(pEventElement->m_bDelaySet)
	{
	    durationResolved(pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulEndEventClockValue, TRUE);
	}
    }
#endif // defined(XXXEH_UNTESTED_AND_NOT_EXAMINED_WELL).
    //[SMIL 1.0 compliance] Helps fix PR 32578:
    if (m_pSourceElement->m_nEndsyncEventSourceTag == SMILEventSourceID)
    {
	if(pEventElement->m_bDurationSet)
	{
	    durationResolved(pEventElement->getDuration(), TRUE);
	}
    }
}

void
CSmil1TimelinePar::durationResolved(UINT32 ulDuration, BOOL bUpdateChildren)
{
    if(!m_bDurationSet)
    {
	m_bDurationSet = TRUE;
	m_pSourceElement->m_ulDuration = ulDuration;
	if(m_pParent)
	{
	    m_pParent->addDuration(ulDuration, 
		m_pSourceElement->m_ulDelay, m_pID);
	}
	if(m_pDependent)
	{
	    //XXXEH- should "m_pSourceElement->m_ulDelay +" be removed, too?
	    // I can't get any content to hit this line so I'm not going to
	    // change it.  See fix for PR SMIL/13983:
	    adjustDependentDuration(m_pDependent);
	    m_pDependent->setDelay(m_pSourceElement->m_ulDelay +
		m_pSourceElement->m_ulDuration);	    
	}
	if(bUpdateChildren)
	{
	    CHXSimpleList::Iterator i = m_pChildren->Begin();
	    for(; i != m_pChildren->End(); ++i)
	    {
		CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);
		pElement->setDuration(m_pSourceElement->m_ulDuration, TRUE);
	    }
	}
    }
}

#if 0
void 
CSmil1TimelinePar::setEndsync(EndsyncType eType, 
			     const char* pEndsyncID,
			     UINT32 ulEndsyncClockValue)
{
    m_eEndsyncType = eType;
    m_ulEndsyncClockValue = ulEndsyncClockValue;
    if(pEndsyncID)
    {
	m_pEndsyncID = new char[strlen(pEndsyncID)+1];
	strcpy(m_pEndsyncID, pEndsyncID); /* Flawfinder: ignore */
    }
}
#endif

/*
 * CSmil1TimelineSeq methods
 */
CSmil1TimelineSeq::CSmil1TimelineSeq(CSmil1Element* pSourceElement,
				   CSmil1Parser* pParser):
    CSmil1TimelineElement(pSourceElement, pParser),
    m_nDurationAdded(0)
{
}

void 
CSmil1TimelineSeq::addDuration(UINT32 ulDuration, 
			      UINT32 ulDelay,
			      const char* pID)
{
    ASSERT(m_pChildren);

    if(!m_bDurationSet)
    {
	if(m_pSourceElement->m_ulDuration == (UINT32)-1)
	{
	    m_pSourceElement->m_ulDuration = ulDuration;
	}
	else
	{
	    m_pSourceElement->m_ulDuration += ulDuration;
	}
    }

    m_nDurationAdded++;
    if(m_nDurationAdded == m_pChildren->GetCount())
    {
	m_bDurationSet = TRUE;
	if(m_pParent)
	{
	    m_pParent->addDuration(
		m_pSourceElement->m_ulDuration, 
		m_pSourceElement->m_ulDelay, m_pID);
	}
	if(m_pDependent)
	{
	    //XXXEH- should "m_pSourceElement->m_ulDelay +" be removed, too?
	    // I can't get any content to hit this line so I'm not going to
	    // change it.  See fix for PR SMIL/13983:
	    adjustDependentDuration(m_pDependent);
	    m_pDependent->setDelay(m_pSourceElement->m_ulDelay +
		m_pSourceElement->m_ulDuration);	    
	}
	// /[SMIL 1.0 Compliance] Fixes PR 23779:
	// if a source has event-based timing based on this seq's
	// duration, then we need to notify that source that we've
	// resolved this value:
        if (m_pParser && m_pParser->m_pTimelineElementManager)
        {
            m_pParser->m_pTimelineElementManager->notify(m_pID);
        }
    }
}

void 
CSmil1TimelineSeq::setDelay(UINT32 ulDelay)
{
    if(m_pSourceElement->m_ulBeginOffset != (UINT32)-1)
    {
	m_pSourceElement->m_ulDelay = ulDelay + 
	    m_pSourceElement->m_ulBeginOffset;
    }
    else
    {
	m_pSourceElement->m_ulDelay = ulDelay;
    }
    //XXXJHUG - we need to prevent overwriting the delay when
    // setInitalDelay is called on THIS element, changing this
    // bool causes initialDelaySet to return TRUE.
    m_bDelaySet = TRUE;
    if(m_pChildren && m_pChildren->GetCount() > 0)
    {
	// set delay on first child of seq
	CSmil1TimelineElement* pElement = 
	    (CSmil1TimelineElement*)m_pChildren->GetHead();
	pElement->setDelay(m_pSourceElement->m_ulDelay);
    }

    if (m_pSourceElement->m_ulDuration != (UINT32)-1)
    {
	setDuration(m_pSourceElement->m_ulDuration);
    }

    //[SMIL 1.0 Compliance] Helps fix PR 14420 and 23025:
    // if a source has event-based timing based on this seq's
    // begin time (delay) then we need to notify that source
    // that we've resolved this value:
    if (m_pParser && m_pParser->m_pTimelineElementManager)
    {
        m_pParser->m_pTimelineElementManager->notify(m_pID);
    }
}

void
CSmil1TimelineSeq::setDuration(UINT32 ulDuration, BOOL bSetFromParent)
{
    ASSERT(m_pChildren);

    if(!m_bDurationSet)
    {
	m_pSourceElement->m_ulDuration = ulDuration;
	m_bDurationSet = TRUE;
    }

    UINT32	ulDurationLeft = m_pSourceElement->m_ulDuration;
    RepeatTag	repeatTag = RepeatUnknown;

    CHXSimpleList::Iterator i = m_pChildren->Begin();
    for(; i != m_pChildren->End(); ++i)
    {
	CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);

	if (!setElementDuration(ulDurationLeft, pElement))
	{
	    break;
	}
    }

    if(m_pDependent)
    {
	adjustDependentDuration(m_pDependent);	
	m_pDependent->setDelay(m_pSourceElement->m_ulDelay + m_pSourceElement->m_ulDuration);	
    }

    //[SMIL 1.0 comliance] Helps fix PR 14420 and 23025:
    if (m_pParser && m_pParser->m_pTimelineElementManager)
    {
        m_pParser->m_pTimelineElementManager->notify(m_pID);
    }
}

void
CSmil1TimelineSeq::setMaxDuration(UINT32 ulMaxDuration)
{
    HX_ASSERT(m_pChildren);
    m_bMaxDurationSet = TRUE;
    m_pSourceElement->m_ulMaxDuration = ulMaxDuration;

    if (m_pChildren)
    {
	CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)m_pChildren->GetHead();
	pElement->setMaxDuration(ulMaxDuration);
    }
}

void 
CSmil1TimelineSeq::adjustDependentDuration(CSmil1TimelineElement* pDependent)
{
    if(m_bDurationSet || m_bMaxDurationSet)
    {
	UINT32	    ulDurationLeft = m_bDurationSet?m_pSourceElement->m_ulDuration:
						    m_pSourceElement->m_ulMaxDuration;
	BOOL	    bAdjusted = FALSE;
	RepeatTag   repeatTag = RepeatUnknown;

	CHXSimpleList::Iterator i = m_pChildren->Begin();
	for(; i != m_pChildren->End(); ++i)
	{
	    CSmil1TimelineElement* pElement = (CSmil1TimelineElement*)(*i);
	    UINT32 ulChildDuration = pElement->getDuration();

	    if (pElement == pDependent)
	    {
		bAdjusted = TRUE;
	    }

	    if (bAdjusted)
	    {
		if (!setElementDuration(ulDurationLeft, pElement))
		{
		    break;
		}
	    }
	    else
	    {
		if(ulDurationLeft >= ulChildDuration)
		{
		    ulDurationLeft -= ulChildDuration;
		}
		else
		{
		    ulDurationLeft = 0;
		}	    
	    }
	}

	if (!bAdjusted && m_pParent)
	{
	    m_pParent->adjustDependentDuration(pDependent);
	}
    }
}

BOOL
CSmil1TimelineSeq::setElementDuration(UINT32& ulDurationLeft, CSmil1TimelineElement* pElement)
{
    BOOL	bContinue = TRUE;
    UINT32	ulChildDuration = pElement->getDuration();	
    RepeatTag   repeatTag = pElement->m_pSourceElement->m_pNode->m_repeatTag;
	
    if (repeatTag == RepeatIndefiniteOnMe)
    {
	pElement->setMaxDuration(ulDurationLeft);
	ulDurationLeft = 0;
	goto cleanup;
    }
    else if (repeatTag == RepeatIndefiniteOnGroup)
    {
	pElement->setMaxDuration(ulDurationLeft);
	bContinue = FALSE;
	goto cleanup;
    }

    // no more duration left, take care of the duration of the rest of 
    // the elements
    if (0 == ulDurationLeft)
    {
	pElement->setDuration(ulDurationLeft, TRUE);
    }
    // if this is the last child, then enforce the duration whatever
    // left
    else if (pElement == m_pChildren->GetTail())
    {
	pElement->setDuration(ulDurationLeft, TRUE);
	bContinue = FALSE;
    }
    // unknown duration, so we apply max. duration here
    else if (ulChildDuration == (UINT32)-1)
    {
	pElement->setMaxDuration(ulDurationLeft);
	bContinue = FALSE;
    }
    else	
    {
	if(ulDurationLeft >= ulChildDuration)
	{
	    ulDurationLeft -= ulChildDuration;
	}
	else
	{
	    pElement->setDuration(ulDurationLeft, TRUE);
	    ulDurationLeft = 0;
	}
    }

cleanup:

    return bContinue;
}

/*
 * CSmil1TimelineAnchor methods
 */

CSmil1TimelineAnchor::CSmil1TimelineAnchor(CSmil1Element* pSourceElement,
				   CSmil1Parser* pParser):
    CSmil1TimelineElement(pSourceElement, pParser)
    , m_nDurationAdded(0)
{
}

CSmil1TimelineAnchor::~CSmil1TimelineAnchor()
{
}

void
CSmil1TimelineAnchor::elementResolved(CSmil1TimelineElement* pEventElement)
{
//XXXEH: shouldn't we be making sure the pEventElement's id
// matches the m_[XXX]EventSourceID?  Otherwise, a begin event on one id
// and an end event on another may cause problems...

    //First, let's see if we have a begin event to resolve:
    if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    //[SMIL 1.0 Compliance] Helps fix 14420:
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDelay;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDelay;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    //[SMIL 1.0 Compliance] Helps fix 14420:
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDuration +
		    pEventElement->m_pSourceElement->m_ulDelay;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }
    else if(m_pSourceElement->m_nBeginEventSourceTag == SMILEventSourceClock)
    {
	//We want event *BEGIN* plus clock therefor check for m_bDelaySet not
	// m_bDurationSet; after all, it's the eventElement's m_ulDelay
	// that's used, below:
	if(pEventElement->m_bDelaySet)
	{
	    if (m_bNonEventDelaySet)
	    {
		//Add non-event delay to begin event delay + clock val:
		m_pSourceElement->m_ulDelay += 
		    pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulBeginEventClockValue;
	    }
	    else
	    {
		//Just set delay to event delay:
		m_pSourceElement->m_ulDelay = 
		    pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulBeginEventClockValue;

	    }
	    m_bNonEventDelaySet = m_bDelaySet = TRUE;
	    if(m_pChildren)
	    {
		CHXSimpleList::Iterator i = m_pChildren->Begin();
		for(; i != m_pChildren->End(); ++i)
		{
		    CSmil1TimelineElement* pElement =
			    (CSmil1TimelineElement*)(*i);
		    pElement->setDelay(m_pSourceElement->m_ulDelay);
		}
	    }
	}
    }

    
//XXXEH: shouldn't we be making sure the pEventElement's id
// matches the m_[XXX]EventSourceID, otherwise a begin event on one id
// and an end event on another will cause problems.
#if defined(XXXEH_UNTESTED_AND_NOT_EXAMINED_WELL)
    if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceBegin)
    {
	if(pEventElement->m_bDelaySet)
	{
	    durationResolved(pEventElement->m_pSourceElement->m_ulDelay);
	}
    }
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceEnd)
    {
	if(pEventElement->m_bDurationSet)
	{
	    durationResolved(pEventElement->getDuration());
	}
    }
    else if(m_pSourceElement->m_nEndEventSourceTag == SMILEventSourceClock)
    {
	if(pEventElement->m_bDelaySet)
	{
	    durationResolved(pEventElement->m_pSourceElement->m_ulDelay +
		    m_pSourceElement->m_ulEndEventClockValue);
	}
    }
#endif // defined(XXXEH_UNTESTED_AND_NOT_EXAMINED_WELL).
}

void
CSmil1TimelineAnchor::durationResolved(UINT32 ulDuration)
{
    if(!m_bDurationSet)
    {
	m_bDurationSet = TRUE;
	m_pSourceElement->m_ulDuration = ulDuration;
    }
}

