/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: passwdtool.cpp,v 1.1.2.1 2004/07/09 02:03:17 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
/************************************************************************
 * instlib.cpp - Post-install setup program utilities.
 */


/***********************************************************************
 * includes
 */

#include "hxtypes.h"

// system includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <time.h>

#ifdef _UNIX
#define _CONSOLE
#include <termios.h>
#include <unistd.h>
#include <sys/ioctl.h>
#else
#ifdef _WIN32
#include <winsock2.h>
#include <windows.h>
#include <direct.h>
#ifndef mkdir
#define mkdir(n,p) mkdir(n)    
#endif // mkdir
#ifndef random
#define random() rand()
#endif // random
#define PATH_MAX MAX_PATH
#endif // _WIN32
#endif // _UNIX

#include <sys/stat.h>
#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#if defined _AIX43
#include <strings.h>
#endif
#include <ctype.h>

//hxmisc
#include "md5.h"
#ifdef _WIN32
#include "hxstrutl.h" //strcasecmp
#endif // _WIN32


//#include "package_info.h"
#include "consoleui.h"
//#include "servinstlib.h"
#include "passwdtool.h"

/***********************************************************************
 * PasswordTool
 */
PasswordTool::PasswordTool()
{
}

PasswordTool::~PasswordTool()
{
}


/************************************************************************
 * MakePasswordEntry - create the MD5 hash for a password db entry.
 */
void
PasswordTool::MakePasswordEntry(const char* szUsername,
                                const char* szRealm,
                                const char* szPassword,
                                      char* szMD5Buf)
{
    char szBuf[4096];
    //char szMD5buf[64];

    sprintf(szBuf, "%s:%s:%s", szUsername, szRealm, szPassword);
    MD5Data((char*)szMD5Buf, (const unsigned char*)szBuf,
            (unsigned int)strlen(szBuf));
    //printf("%s:%s\n", szUsername, szMD5Buf);
}


/************************************************************************
 * PasswordIsOK - Validate that a given password is "ok".
 *
 * For now this means non-null.  Later this will be more sophisticated.
 */
BOOL
PasswordTool::PasswordIsOK(const char* szUsername, const char* szPassword)
{
    if (szPassword == NULL || strlen(szPassword) == 0)
        return FALSE;
    return TRUE;
}


/************************************************************************
 * GenerateRandomPassword
 *
 * Used for non-interactive install.
 */
char*
PasswordTool::GenerateRandomPassword(void)
{
    char* pPass = new char[16];
    int i;
    for (i=0; i < 6; ++i)
    {
        pPass[i] = GenerateRandomPasswordChar();
    }
    pPass[i] = '\0';
    return pPass;
}


/************************************************************************
 * GenerateRandomPasswordChar - generate a single random password character
 *
 * Used for non-interactive install.
 */
char
PasswordTool::GenerateRandomPasswordChar(void)
{
    char ch='\0';
    while (1)
    {
        ch = random() % 127;
        if ( !(ch >= 'a' && ch <= 'z') && !(ch >= '0' && ch <= '9'))
        {
           continue;
        }

        // 1 and l are too alike visually
        // 0 looks too much like an O
        if (ch == '1' || ch == 'l' || ch == '0')
        {
           continue;
        }
        

        break;

    }
    return ch;
}


/************************************************************************
 * AddPasswordFileEntry
 *
 * Note: assumes szDir database already exists.
 */
int
PasswordTool::AddPasswordFileEntry(const char* szDir,  const char* szUser,
                                   const char* szPass, const char* szRealm)
{
    char szFile[1024];
    char szMD5Buf[64];
    FILE* fp=0;

    sprintf (szFile, "%s/users/%s", szDir, szUser);
    unlink (szFile);
    fp = fopen (szFile, "w");
    if (fp)
    {
        if (szRealm && strlen(szRealm))
        {
            MakePasswordEntry(szUser, szRealm, szPass, szMD5Buf);
            fprintf (fp, "%s;*;1\n", szMD5Buf);
        }
        else
        {
            fprintf (fp, "%s;*;1\n", szPass);
        }
        fclose(fp);
        return 0;
    }
    else
    {
        //ShowErrorMessage("Error creating %s (%s)\n", szFile, strerror(errno));
        return -1;
    }
}



