/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientEngine.cpp,v 1.3.2.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "CHXClientEngine.h"
#include "CHXClientDebug.h"

#include "enter_hx_headers.h"
#include "hxcore.h"

#include "hxsmartptr.h"
HX_SMART_POINTER_INLINE( SPIHXClientEngineSetup, IHXClientEngineSetup );
#include "exit_hx_headers.h"

#include "CHXClientEngineContext.h"

#ifndef HELIX_CONFIG_NOSTATICS
CHXClientEngine* CHXClientEngine::m_SharedClientEngine = NULL;
const HXClientEngineCallbacks* CHXClientEngine::m_pClientEngineCallbacks = NULL;
#endif

CHXClientEngine::CHXClientEngine( void )
	: m_lCount( 0 )
{
}

CHXClientEngine::~CHXClientEngine( void )
{
#ifndef HELIX_CONFIG_NOSTATICS
	if ( m_SharedClientEngine == this )
	{
		m_SharedClientEngine = NULL;
	}
#endif
}

bool
CHXClientEngine::GetEngine( IHXClientEngine** ppIClientEngine )
{
#ifndef HELIX_CONFIG_NOSTATICS
	if ( m_SharedClientEngine )
	{
		m_SharedClientEngine->AddRef();
		*ppIClientEngine = m_SharedClientEngine;
		return true;
	}
#else
	CHXASSERT( !"CHXClientEngine::GetEngine() called and HELIX_CONFIG_NOSTATICS defined. Will always return false." );
#endif
	return false;
}

bool
CHXClientEngine::CreateEngine( IHXClientEngine** ppIClientEngine )
{
#ifndef HELIX_CONFIG_NOSTATICS
	if ( !m_SharedClientEngine )
	{
		m_SharedClientEngine = CreatePlatformClientEngine();
	}
	return GetEngine( ppIClientEngine );
#else
	*ppIClientEngine = CreatePlatformClientEngine();
	if ( !*ppIClientEngine ) return false;
	
	( *ppIClientEngine )->AddRef();
	return true;
#endif
}

void
CHXClientEngine::SetClientEngineCallbacks( const HXClientEngineCallbacks* pClientEngineCallbacks )
{
#ifndef HELIX_CONFIG_NOSTATICS
	m_pClientEngineCallbacks = pClientEngineCallbacks;
#else
	CHXASSERT( !"CHXClientEngine::SetClientEngineCallbacks() called and HELIX_CONFIG_NOSTATICS defined. Not currently supported." );
#endif
}

const HXClientEngineCallbacks*
CHXClientEngine::GetClientEngineCallbacks( void )
{
#ifndef HELIX_CONFIG_NOSTATICS
	return m_pClientEngineCallbacks;
#else
	return NULL;
#endif
}

BEGIN_SINGLE_INTERFACE_COMPONENT( CHXClientEngine, IHXClientEngine, m_lCount )
	INTERFACE_LIST_ENTRY_DELEGATE_BLIND( ClientEngineQI )
END_SINGLE_INTERFACE_COMPONENT

IHXClientEngine*
CHXClientEngine::CreateClientEngine( HX_RESULT* pResult )
{
	*pResult = HXR_OK;
	IHXClientEngine* pIClientEngine = GetClientEngine();
	if ( pIClientEngine ) return pIClientEngine;
	
	pIClientEngine = OnCreateClientEngine( pResult );
	if ( pIClientEngine )
	{
		// Calling Setup forces initialization of the engine. Creating a Player also initializes the engine.
		// Without this, ReloadPlugins() would crash if called before a Player was created.
		SPIHXClientEngineSetup spClientEngineSetup = pIClientEngine;
		if ( spClientEngineSetup.IsValid() )
		{
			CHXClientEngineContext* pEngineContext = new CHXClientEngineContext( GetClientEngineCallbacks() );
			SPIUnknown spIUnkEngineContext = pEngineContext->GetUnknown();
			spClientEngineSetup->Setup( spIUnkEngineContext.Ptr() );
		}
	}
	return pIClientEngine;
}

HX_RESULT
CHXClientEngine::ClientEngineQI( REFIID riid, void** ppvObj )
{
	HX_RESULT outResult = HXR_FAIL;
	IHXClientEngine* pIClientEngine = CreateClientEngine( &outResult );
	if ( pIClientEngine )
	{
		outResult = pIClientEngine->QueryInterface( riid, ppvObj );
	}
	return outResult;
}

STDMETHODIMP
CHXClientEngine::CreatePlayer( REF( IHXPlayer* ) pPlayer )
{
	HX_RESULT outResult = HXR_FAIL;
	IHXClientEngine* pIClientEngine = CreateClientEngine( &outResult );
	if ( pIClientEngine )
	{
		outResult = pIClientEngine->CreatePlayer( pPlayer );
	}
	return outResult;
}

STDMETHODIMP
CHXClientEngine::ClosePlayer( IHXPlayer* pPlayer )
{
	IHXClientEngine* pIClientEngine = GetClientEngine();
	if ( !pIClientEngine ) return HXR_UNEXPECTED;
	
	// XXXSEH: If this is successful and the subsequent player count is 0, should we call CloseClientEngine();
	return pIClientEngine->ClosePlayer( pPlayer );
}

STDMETHODIMP_( UINT16 )
CHXClientEngine::GetPlayerCount( void )
{
	IHXClientEngine* pIClientEngine = GetClientEngine();
	if ( !pIClientEngine ) return 0;

	return pIClientEngine->GetPlayerCount();
}

STDMETHODIMP
CHXClientEngine::GetPlayer( UINT16 nPlayerNumber, REF( IUnknown* ) pUnknown )
{
	IHXClientEngine* pIClientEngine = GetClientEngine();
	if ( !pIClientEngine ) return HXR_FAIL;

	return pIClientEngine->GetPlayer( nPlayerNumber, pUnknown );
}

STDMETHODIMP
CHXClientEngine::EventOccurred( HXxEvent* pEvent )
{
	IHXClientEngine* pIClientEngine = GetClientEngine();
	if ( !pIClientEngine ) return HXR_OK; // XXXSEH: Should this fail?
	
	return pIClientEngine->EventOccurred( pEvent );
}
