#ifndef SEEN_MENUS_SKELETON_H
#define SEEN_MENUS_SKELETON_H

#include <inkscape_version.h>

#ifdef __cplusplus
#undef N_
#define N_(x) x
#endif

static char const menus_skeleton[] =
"<inkscape version=\"" INKSCAPE_VERSION "\"\n"
"  xmlns:sodipodi=\"http://inkscape.sourceforge.net/DTD/sodipodi-0.dtd\"\n"
"  xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\">\n"
"\n"
"   <submenu name=\"" N_("_File") "\">\n"
"       <submenu name=\"" N_("_New") "\">\n"
"           <verb verb-id=\"FileNew\" />\n"
"           <template-list/>\n"
"       </submenu>\n"
"       <verb verb-id=\"FileOpen\" />\n"
"       <submenu name=\"" N_("Open _Recent") "\">\n"
"           <recent-file-list/>\n"
"       </submenu>\n"
"       <verb verb-id=\"FileRevert\" />\n"
"       <verb verb-id=\"FileSave\" />\n"
"       <verb verb-id=\"FileSaveAs\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"FileImport\" />\n"
"       <verb verb-id=\"FileExport\" />\n"
"       <seperator/>\n"
/* These are ugly, but what needs to happen here is allowing users
   to use the native PS support if they are using another print driver.
   This is done through the "Print Direct" command.  Which is inserted
   here based on if those other drivers are being built. */
#ifdef WITH_GNOME_PRINT
"       <verb verb-id=\"FilePrintDirect\" />\n"
#endif
#ifdef WIN32
"       <verb verb-id=\"FilePrintDirect\" />\n"
#endif
"       <verb verb-id=\"FilePrint\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"FileVacuum\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"DialogNamedview\" />\n"
"       <verb verb-id=\"DialogDisplay\" />\n"
"       <verb verb-id=\"DialogInput\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"FileCloseView\" />\n"
"       <verb verb-id=\"FileQuit\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_Edit") "\">\n"
"       <verb verb-id=\"EditUndo\" />\n"
"       <verb verb-id=\"EditRedo\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"EditCut\" />\n"
"       <verb verb-id=\"EditCopy\" />\n"
"       <verb verb-id=\"EditPaste\" />\n"
"       <verb verb-id=\"EditPasteInPlace\" />\n"
"       <verb verb-id=\"EditPasteStyle\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"DialogFind\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"EditDuplicate\" />\n"
"       <verb verb-id=\"EditClone\" />\n"
"       <verb verb-id=\"DialogsClonetiler\" />\n"
"       <verb verb-id=\"EditUnlinkClone\" />\n"
"       <verb verb-id=\"EditCloneOriginal\" />\n"
"       <verb verb-id=\"SelectionCreateBitmap\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"EditTile\" />\n"
"       <verb verb-id=\"EditUnTile\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"EditDelete\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"EditSelectAll\" />\n"
"       <verb verb-id=\"EditSelectAllInAllLayers\" />\n"
"       <verb verb-id=\"EditInvert\" />\n"
"       <verb verb-id=\"EditDeselect\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"DialogXMLEditor\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_View") "\">\n"
"       <verb verb-id=\"Zoom1:0\" />\n"
"       <verb verb-id=\"Zoom1:2\" />\n"
"       <verb verb-id=\"Zoom2:1\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ZoomSelection\" />\n"
"       <verb verb-id=\"ZoomDrawing\" />\n"
"       <verb verb-id=\"ZoomPage\" />\n"
"       <verb verb-id=\"ZoomPageWidth\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ZoomPrev\" />\n"
"       <verb verb-id=\"ZoomNext\" />\n"
"       <seperator/>\n"
"       <submenu name=\"" N_("Show/Hide") "\">\n"
"           <objects-checkboxes/>\n"
"       </submenu>\n"
"       <verb verb-id=\"DialogsToggle\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ToggleGrid\" />\n"
"       <verb verb-id=\"ToggleGuides\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"FullScreen\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"DialogDebug\" />\n"
"       <verb verb-id=\"DialogScript\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"FilePrevDesktop\" />\n"
"       <verb verb-id=\"FileNextDesktop\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ViewNew\" />\n"
"       <verb verb-id=\"ViewIconPreview\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_Layer") "\">\n"
"       <verb verb-id=\"LayerNew\" />\n"
"       <verb verb-id=\"LayerRename\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"LayerNext\" />\n"
"       <verb verb-id=\"LayerPrev\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"LayerMoveToNext\" />\n"
"       <verb verb-id=\"LayerMoveToPrev\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"LayerRaise\" />\n"
"       <verb verb-id=\"LayerLower\" />\n"
"       <verb verb-id=\"LayerToTop\" />\n"
"       <verb verb-id=\"LayerToBottom\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"LayerDelete\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_Object") "\">\n"
"       <verb verb-id=\"DialogFillStroke\" />\n"
"       <verb verb-id=\"DialogSwatches\" />\n"
"       <verb verb-id=\"DialogItem\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionGroup\" />\n"
"       <verb verb-id=\"SelectionUnGroup\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionRaise\" />\n"
"       <verb verb-id=\"SelectionLower\" />\n"
"       <verb verb-id=\"SelectionToFront\" />\n"
"       <verb verb-id=\"SelectionToBack\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ObjectRotate90\" />\n"
"       <verb verb-id=\"ObjectRotate90CCW\" />\n"
"       <verb verb-id=\"ObjectFlipHorizontally\" />\n"
"       <verb verb-id=\"ObjectFlipVertically\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"DialogTransform\" />\n"
"       <verb verb-id=\"DialogAlignDistribute\" />\n"
"       <verb verb-id=\"SelectionGridTile\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_Path") "\">\n"
"       <verb verb-id=\"ObjectToCurve\" />\n"
"       <verb verb-id=\"SelectionOutline\" />\n"
"       <verb verb-id=\"SelectionTrace\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionUnion\" />\n"
"       <verb verb-id=\"SelectionDiff\" />\n"
"       <verb verb-id=\"SelectionIntersect\" />\n"
"       <verb verb-id=\"SelectionSymDiff\" />\n"
"       <verb verb-id=\"SelectionDivide\" />\n"
"       <verb verb-id=\"SelectionCutPath\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionCombine\" />\n"
"       <verb verb-id=\"SelectionBreakApart\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionInset\" />\n"
"       <verb verb-id=\"SelectionOffset\" />\n"
"       <verb verb-id=\"SelectionDynOffset\" />\n"
"       <verb verb-id=\"SelectionLinkedOffset\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionSimplify\" />\n"
"       <verb verb-id=\"SelectionReverse\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("_Text") "\">\n"
"       <verb verb-id=\"Dialogtext\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionTextFromPath\" />\n"
"       <verb verb-id=\"SelectionTextToPath\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"ObjectFlowText\" />\n"
"       <verb verb-id=\"ObjectUnFlowText\" />\n"
"       <verb verb-id=\"ObjectFlowtextToText\" />\n"
"       <seperator/>\n"
"       <verb verb-id=\"SelectionTextRemoveKerns\" />\n"
"   </submenu>\n"
"   <submenu name=\"" N_("Effects") "\">\n"
"       <verb verb-id=\"EffectLast\" />\n"
"       <verb verb-id=\"EffectLastPref\" />\n"
"       <seperator/>\n"
"       <effects-list/>\n"
"   </submenu>\n"
#ifdef WITH_INKBOARD
"	<submenu name=\"" N_("Whiteboa_rd") "\">\n"
"		<verb verb-id=\"DialogWhiteboardConnect\" />\n"
"		<verb verb-id=\"DialogWhiteboardDisconnectSession\" />\n"
"		<verb verb-id=\"DialogWhiteboardDisconnectServer\" />\n"
"		<seperator/>\n"
"		<verb verb-id=\"DialogWhiteboardShareWithUser\" />\n"
"		<verb verb-id=\"DialogWhiteboardShareWithChat\" />\n"
"		<seperator/>\n"
"		<verb verb-id=\"DialogWhiteboardOpenSessionFile\" />\n"
"		<seperator/>\n"
"		<verb verb-id=\"DialogWhiteboardDumpXMLTracker\" />\n"
"	</submenu>\n"
#endif
"   <submenu name=\"" N_("_Help") "\">\n"
"       <verb verb-id=\"HelpKeys\" />\n"
"       <submenu name=\"" N_("Tutorials") "\">\n"
"           <verb verb-id=\"TutorialsBasic\" />\n"
"           <verb verb-id=\"TutorialsShapes\" />\n"
"           <verb verb-id=\"TutorialsAdvanced\" />\n"
"           <verb verb-id=\"TutorialsTracing\" />\n"
"           <verb verb-id=\"TutorialsCalligraphy\" />\n"
"           <verb verb-id=\"TutorialsDesign\" />\n"
"           <verb verb-id=\"TutorialsTips\" />\n"
"       </submenu>\n"
"       <verb verb-id=\"HelpAboutMemory\" />\n"
"       <verb verb-id=\"HelpAbout\" />\n"
//"       <verb verb-id=\"ShowLicense\" />\n"
"   </submenu>\n"
"</inkscape>\n";

#define MENUS_SKELETON_SIZE (sizeof(menus_skeleton) - 1)


#endif /* !SEEN_MENUS_SKELETON_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=c++:expandtab:shiftwidth=4:tabstop=8:softtabstop=4 :
