/***************************************************************************
 *   Copyright (C) 2004-2005 by Jürgen Kofler                                   *
 *   kaffeine@gmx.net                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 /*
  * Last modified: $Date: 2005/02/02 10:08:17 $ by $Author: juergenk $
  */
 
#ifndef _KAFFEINEIFACE_H_
#define _KAFFEINEIFACE_H_

#include <dcopobject.h>

class KaffeineIface : virtual public DCOPObject
{
  K_DCOP
public:

k_dcop:
 /*
  * Add url to playlist and play it
  */
  virtual void openURL(QString url) = 0;
  /*
  * Append url to playlist
  */
  virtual void appendURL(QString url) = 0; 
  
  /*
   * Play next in playlist
   */
  virtual void play() = 0;
  
  /*
   * Start playing Audio CD
   */
  virtual void playAudioCD() = 0;
  
  /*
   * Start playing Video CD
   */
  virtual void playVCD() = 0;
  
  /*
   * Start playing DVD
   */
  virtual void playDVD() = 0;
  
  /* 
   * Toggle pause/play
   */ 
  virtual void pause() = 0;
  
  /*
   * Stop playback.
   */
  virtual void stop() = 0;
  
  /*
   * Play next in playlist
   */
  virtual void next() = 0;
  
  /*
   * Play previous in playlist
   */
  virtual void previous() = 0;
  
  /*
   * Is currently playback in progress?
   */
  virtual bool isPlaying() = 0;
   
  /*
   * Returns current track title
   */
  virtual QString title() = 0;
  
  /*
   * Returns current track file (media) name
   */
  virtual QString getFileName() = 0;
  
  /*
   * Toggle random play
   */
  virtual void random() = 0;
  
  /*
   * Toggle fullscreen/windowed mode
   */
  virtual void fullscreen() = 0;
  
  /*
   * Returns current track length in seconds
   */
  virtual int getLength() = 0;
  
  /*
   * Returns current track position is seconds
   */
  virtual int getTimePos() = 0; 
  
  /*
   * Increase stream position
   */
  virtual void posPlus() = 0;
  
  /*
   * Decrease stream position
   */
  virtual void posMinus() = 0;
  
  /*
   * Volume up
   */
  virtual void volUp() = 0;
  
  /*
   * Volume down
   */
  virtual void volDown() = 0;
  
  /*
   * Toggle mute
   */
  virtual void mute() = 0;
  
  /*
   * Quit Kaffeine
   */
  virtual void quit() = 0;
  
  virtual void dvbSetChannelNumber( int num ) =0;
  virtual void dvbNext() =0;
  virtual void dvbPrevious() =0;
  virtual void dvbOSD() =0;
};

#endif // _KAFFEINEIFACE_H_
