#! /usr/bin/perl -w

use strict;

my $LINTIAN_ROOT = $ARGV[0];

require "$LINTIAN_ROOT/lib/util.pl";

my $problems = 0;

for my $f (<$LINTIAN_ROOT/checks/*.desc>) {
    my @sections = read_dpkg_control($f);
    for (my $i = 0; $i <= $#sections; $i++) {
	if (exists $sections[$i]->{'tag'}) {
	    if (not exists $sections[$i]->{'info'}) {
		print "E: no info for $sections[$i]->{'tag'} in $f\n";
		$problems++;
	    }
	}
    }
}

if ($problems) {
    print "Found $problems missing info section(s)\n";
    exit(-1);
}
