.TH "ZIP_SOURCE" "3" "October 24, 2015" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source\fR
\- zip data source structure
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *zs\fR;
.SH "DESCRIPTION"
A
\fIstruct zip_source\fR
is a data source used by
libzip(3)
for adding or replacing file contents for a file in a zip archive.
If the source supports seeking, it can also be used to open zip archives from.
It is created by calling one of
zip_source_buffer(3),
zip_source_buffer_create(3),
zip_source_file(3),
zip_source_file_create(3),
zip_source_filep(3),
zip_source_filep_create(3),
zip_source_function(3),
zip_source_function_create(3),
or
zip_source_zip(3).
\fIzip_source_t\fR
is reference counted, and created with a reference count of 1.
zip_open_from_source(3),
zip_file_add(3),
and
zip_file_replace(3)
will decrement the reference count of the
\fIzip_source_t\fR
when they are done using it, so
zip_source_free(3)
only needs to be called when these functions return an error.
Use
zip_source_keep(3)
to increase the reference count, for example if you need the source after
zip_close(3).
.SH "SEE ALSO"
libzip(3),
zip_source_buffer(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
