/*!
  @file           SQLMan_Test.cpp
  @ingroup		  SQLMan
  @author         DirkT

\if EMIT_LICENCE
    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
\endif
*/

#include "SAPDBCommon/SAPDB_Types.hpp"

#include "SQLManager/SQLMan_Test.hpp"

#include "SAPDBCommon/MemoryManagement/SAPDBMem_IRawAllocator.hpp"

#include "RunTime/RTE_Message.hpp"

#include "ggg00.h"
#include "gsp00.h"
#include "heo52.h"

/* --------------------------------------------------------------------------- */

bool SQLMan_SharedSQLTest(tgg00_TransContext& TransContext, SAPDBErr_MessageList& errList)
{
    SAPDBMem_IRawAllocator& Allocator = *( REINTERPRET_CAST(SAPDBMem_IRawAllocator*, TransContext.trAllocator_gg00) );
    return true;
}


/* --------------------------------------------------------------------------- */
externCpp void SQLMan_Test (tgg00_TransContext& Trans)
{
    SAPDBErr_MessageList                  errlist;

    Trans.trError_gg00 = e_ok;
    if ( !SQLMan_SharedSQLTest(Trans, errlist) )
    {
        RTE_Message(errlist);
        errlist.ClearMessageList();
    }
}
