/****************************************************************************

  module      : hbd93.h

  -------------------------------------------------------------------------

  responsible : AlexanderK

  special area: logging ...
  description : description ...


  version     : 7.2.0.0
  last changed: 1999-06-24  18:57
  see also    : example.html ...

  -------------------------------------------------------------------------

  copyright:    (c) 1998-2004 SAP AG



    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/

#ifndef HBD93_H
#define HBD93_H

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "gbd900.h"
#include "gbd910.h"

#include "Logging/Log_Types.hpp"

/*===========================================================================*
 *  FUNCTION PROTOTYPES                                                      *
 *===========================================================================*/

externCpp void
bd93InitContObjPage (tbd_current_tree    &Current,
					 tbd_node_ptrs       &NptrsPage,
					 tsp00_Int4           ContObjDistance);

/*---------------------------------------------------------------------------*/

externCpp void
bd93GetContObjFileStatistics (
							  tbd_current_tree  &Current,
							  tsp00_Int4        &NumAllContPages,
							  tsp00_Int4        &NumFreeContPages,
							  tsp00_Int4        &NumEmptyContPages
							  );

/*---------------------------------------------------------------------------*/

externCpp void
bd93GetVarObjBody (
				   tbd_current_tree       &Current,            //[inp\out] 
				   const tgg92_KernelOid  &OId,                //[inp] 
				   tsp00_Int4              ExtObjBodySize,     //[inp]
				   void                   *pExtObjBody,        //[inp]
				   tbd900_ObjFrame        *pObjFrame           //[inp]
				   );

/*---------------------------------------------------------------------------*/

externCpp void  
bd93LogDelVarObj (tbd_current_tree  &Current,
				  tgg92_KernelOid    OId, 
				  tgg91_PageRef      WantedObjVers,      //[inp]
				  tbd_nodeptr        pPage, 
				  tbd900_ObjFrame   *pObjFrame);

/*---------------------------------------------------------------------------*/

externCpp bool
bd93NextContObjBodyLen (tsp00_Int4   &ObjBodyLen);       // [inp/out]

/*---------------------------------------------------------------------------*/


externCpp void
bd93RemoveContObj (tbd_current_tree       &Current,        //[inp]
				   tgg92_KernelOid        &OId,            //[inp]    
				   const tsp00_Int4        ContObjFileNo,  //[inp]     
				   const tsp00_PageNo      ContObjPno,     //[inp] 
				   const tgg00_ObjPagePos  ContObjPos);    //[inp]

/*---------------------------------------------------------------------------*/

externCpp void
bd93UpdateVarObjBody (tbd_current_tree        &Current,
					  tgg92_KernelOid          OId,
					  tgg91_PageRef	           ObjVers,
					  cbd910_PrimObjDataNode  &NptrsAnchor,
					  tbd900_ObjFrame        *&pObjFrame, 
					  tsp00_Int4               NewObjBodySize,
					  void                    *pNewObjBody,
					  bool                     bRollBack,
					  bool                    &bNewContFileWasCreated,
					  bool                    &bTooManyEmptyPagesInContFile,
					  tsp00_Int4              &NewContObjFileNo,
					  tsp00_Int4              &ContObjFileNo,
					  tsp00_Int4              &ContObjChainNo,
					  const Log_EntrySequence &RedoEntrySequence,
			          const tgg91_TransNo     &RedoUpdTransNo);

/*---------------------------------------------------------------------------*/

#endif  /* HBD93_H */
