/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.DeleteFromDrawingVisitor;
import org.jhotdraw.standard.StandardFigureSelection;
import org.jhotdraw.util.Clipboard;

public abstract class FigureTransferCommand
extends AbstractCommand {
    protected FigureTransferCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    protected void deleteFigures(FigureEnumeration figureEnumeration) {
        DeleteFromDrawingVisitor deleteFromDrawingVisitor = new DeleteFromDrawingVisitor(this.view().drawing());
        while (figureEnumeration.hasNextFigure()) {
            figureEnumeration.nextFigure().visit(deleteFromDrawingVisitor);
        }
        this.view().clearSelection();
    }

    protected void copyFigures(FigureEnumeration figureEnumeration, int n) {
        Clipboard.getClipboard().setContents(new StandardFigureSelection(figureEnumeration, n));
    }

    public FigureEnumeration insertFigures(FigureEnumeration figureEnumeration, int n, int n2) {
        return this.view().insertFigures(figureEnumeration, n, n2, false);
    }
}

