/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.petzall.daapapplet.DAAPApplet;
import org.petzall.daapapplet.DAAPControls;
import org.petzall.daapapplet.gui.GUI;
import org.petzall.daapapplet.gui.components.Caption;
import org.petzall.daapapplet.tracklist.TrackList;

public class Browser
extends JPanel {
    GUI _gui;
    SubView _artistView;
    SubView _albumView;
    DAAPApplet _applet;

    public Browser(DAAPApplet dAAPApplet, TrackList trackList, DAAPControls dAAPControls, GUI gUI) {
        super(new GridBagLayout());
        this._gui = gUI;
        this._applet = dAAPApplet;
        this._artistView = new SubView("Artist");
        this._artistView.setModel(trackList.getArtistList());
        this._albumView = new SubView("Album");
        this._albumView.setModel(trackList.getAlbumList());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add(new Caption("Artist"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add(new Caption("Album"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this._artistView, 22, 31), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)new JScrollPane(this._albumView, 22, 31), gridBagConstraints);
        this._albumView.validate();
        this._albumView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Browser.this.doBrowse("album", Browser.this._albumView);
            }
        });
        this._artistView.validate();
        this._artistView.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Browser.this.doBrowse("artist", Browser.this._artistView);
            }
        });
    }

    private void doBrowse(String string, SubView subView) {
        int n = subView.getSelectedIndex();
        String string2 = n == 0 ? "" : (String)subView.getSelectedValue();
        this._applet.browseBy(string, string2);
    }

    public void updateFilter(String string, String string2) {
        if (string.equals("artist")) {
            this._albumView.selectNone();
        } else if (string.equals("album")) {
            this._artistView.selectNone();
        } else {
            this._artistView.selectNone();
            this._albumView.selectNone();
        }
    }

    class SubView
    extends JList {
        public SubView(String string) {
            this.setPrototypeCellValue("String String String String");
            this.setFont(Browser.this._gui.getFont("Browser"));
        }

        public void selectNone() {
            this.setSelectionInterval(0, 0);
        }
    }
}

