/*  VER 131  TAB P   $Id: common.h,v 1.17.2.3 2003/05/18 10:57:24 egil Exp $
 *
 *  common header file
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: common.h,v $
 *  Revision 1.17.2.3  2003/05/18 10:57:24  egil
 *  Version 1.6, with fixes from bug #237
 *
 *  Revision 1.17.2.2  2003/01/22 13:01:13  egil
 *  Support sys/malloc.h as used by Mac OS X.
 *
 *  Revision 1.17.2.1  2003/01/21 09:47:24  egil
 *  Renamed MAXHEADERSIZE to MAX_HEADER_SIZE due to name collision
 *
 *  Revision 1.17  1999/04/17 07:11:26  src
 *  malloc.h inclusion
 *
 *  Revision 1.16  1999/04/09 03:59:20  src
 *  NeXT detail
 *
 *  Revision 1.15  1999/03/31 03:38:28  src
 *  Moved errno.h to common.h
 *
 *  Revision 1.14  1999/03/30 05:30:31  src
 *  Added ifdef NeXT
 *
 *  Revision 1.13  1999/03/24 03:52:57  src
 *  Implemented "newsx" as magic exclude pattern
 *
 *  Revision 1.12  1999/03/11 07:30:00  src
 *  Implemented check for spool free space
 *
 *  Revision 1.11  1999/03/07 15:40:58  src
 *  Removed DBZ_VERSION from configuration
 *
 *  Revision 1.10  1999/03/05 11:20:40  src
 *  Delayed decision of dbz v3 vz. 6 to runtime.
 *
 *  Revision 1.9  1998/09/21 10:04:29  src
 *  Added new command line options for --inews
 *
 *  Revision 1.8  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.7  1998/09/02 06:50:30  src
 *  newsx version 1.0
 *
 *  Revision 1.6  1998/08/24 07:02:59  src
 *  Fixes for NeXT
 */

#ifndef _COMMON_H
#define _COMMON_H

#if HAVE_CONFIG_H
#  include "../config.h"
#endif

#include "tune.h"

/* standard stuff */
#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <errno.h>

#if STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#else 
#  if HAVE_STDLIB_H
#    include <stdlib.h>
#  endif
#  if HAVE_MALLOC_H
#    include <malloc.h>
#  endif
#  if HAVE_STRING_H
#    include <string.h>
#  else 
#    if HAVE_STRINGS_H
#      include <strings.h>
#    endif
#  endif
#endif

#if HAVE_SYS_MALLOC_H /* for Mac OS X */
#  include <sys/malloc.h>
#endif

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif

#if HAVE_LIMITS_H
#  include <limits.h>
#endif

#if TIME_WITH_SYS_TIME
#  include <time.h>
#  include <sys/time.h>
#else
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif

/*
 *  NeXT peculiarities
 *  could have included these from "libc.h", but that creates its
 *  own set of problems since it is without _POSIX_SOURCE defined
 */
#ifdef NeXT
#   include <math.h> /* to get errno defined on NeXT */
    extern int gethostname(char *, int);
    extern char *mktemp(char *);
#endif

/* 
 * not all versions define these..
 */
#ifndef PATH_MAX
#  define PATH_MAX 1024
#endif

#ifndef __STDC__
extern int errno;
#endif

/*
 *  own socket stuff
 */
#include "sock.h"

/* 
 *  names
 */
char *hostname;                 /* current NNTP server */
char *spoolname;                /* outgoing spool */
char *hostport;                 /* port for NNTP server */
char *pname;                    /* this program */
char *spooldir;                 /* news spool */
#define NNTP_PORT_NAME "nntp"

/* 
 *  misc status
 */
int post_allowed;
int newsx_path;                 /* "newsx" exclude specified */

/*
 *  for rnews and inews
 */
char *rnews_path;
char *rnews_name;

/* 
 *  log message types 
 */
#define L_ERR       '?'
#define L_ERRno     '!'
#define L_INFO      '&'
#define L_DEBUG     '='
#define L_DEBUGMORE '5'
#define L_GET       '<'
#define L_PUT       '>'

#endif /* _COMMON_H */
