#!/bin/sh
#
# 1. Rotate squid logfile access.log -> access.log.0
# 2. move access.log.0 -> access.log.YYYYMMDD
# 3. process logfiles
# 4. archive logfiles
# 5. delete logs older than specified days

#
# Change to suit your site
#
HOST=Your.Host.HERE
TOPN=100
LOGDIR=/oops/logs
BINDIR=/oops/bin
WWWDIR=/www/htdocs/proxy
PIDFILE=/oops/logs/oops.pid
GZIP=/usr/local/bin/gzip
FIND=/usr/bin/find
RM=/bin/rm
#
# Anything below here does NOT need changing!
#

umask 022
DATE=`date +%Y%m%d`
#
YEAR=`date +%Y`
MON=`date +%m`
DAY=`date +%d`
DATE2=${YEAR}${MON}
#
PID=`cat $PIDFILE`
LOGFILE=$LOGDIR/access.log.$DATE
SUMFILE=$WWWDIR/.SUM/summary.$DATE
WWWFILE=$WWWDIR/$DATE.html

if [ X"${PID}" = "X" ] ; then
	echo "No process, trying to recover ..."
	PID=`ps auxw | grep oops | egrep -v 'Run|grep' | awk '{print $1}'`
	if [ X"${PID}" = "X" ] ; then
		echo "No daemon, restarting ..."
		etc/rc2.d/S99proxy start
	else
		echo "Restarting the running daemon ... "
		kill ${PID}
	fi
fi

mv $LOGDIR/access.log $LOGFILE && {
  echo "kill -WINCH Proxy (pid $PID) ..."
  cat /dev/null >$LOGDIR/access.log
  kill -WINCH $PID

  if [ ! -d $WWWDIR ]; then
	  mkdir -p $WWWDIR
  fi

  date
  echo "Processing $LOGFILE ..."
  echo "Running access-extract.pl ..."
  $BINDIR/access-extract.pl < $LOGFILE > $SUMFILE
  echo "Running access-extract-urls.pl ..."
  $BINDIR/access-extract-urls.pl < $LOGFILE >> $SUMFILE
  echo "Generating $WWWFILE ..."
  echo "Running access-summary.pl ..."
  $BINDIR/access-summary.pl -p 8080 -m $HOST -n $TOPN -H < $SUMFILE > $WWWFILE
  date

### Decade statistics
#

  DECSTAT=0

  case X${DAY} in
      X10|X20|X30)
	  DECSTAT=1;
      ;;
  esac
  if [ "${MON}" = "02" ] ; then
     if [ "${DAY}" = "28" -o "${DAY}" = "29" ] ; then
	 DECSTAT=1;
     fi
  fi

  if [ ${DECSTAT} -eq 1 ] ; then
      WWWFILE1=${WWWDIR}/${DATE2}-last10.html
      SUMFILE1=`ls -tr1 ${WWWDIR}/.SUM | tail -10`
      echo "Running access-summary.pl for the last 10 days of $MON month ..."
      (cd ${WWWDIR}/.SUM ; cat ${SUMFILE1}) | $BINDIR/access-summary.pl -m $HOST -n $TOPN -H > $WWWFILE1
      date
  fi
###

### Monthly statistics
#
#  1   2    3  4  5  6  7  8  9 10 11 12
# 31,28/29,31,30,31,30,31,31,30,31,30,31
  case X${MON} in
      X04|X06|X09|X11)
	   LASTDATE=30;
      ;;
      X*)
      if [ $MON = 02 ] ; then # Check for February
	  LEAP=0;
	  YY=`expr $YEAR % 4`
	  if [ $YY -eq 0 ] ; then
	      LEAP=1;
	  fi
	  if [ $LEAP -eq 1 ] ; then
	      LASTDATE=29; # Leap year
	  else
	      LASTDATE=28; # Usual
	  fi
      else
	  LASTDATE=31;
      fi
      ;;
  esac

  if [ $DAY -eq $LASTDATE ] ; then
      WWWFILE2=$WWWDIR/$DATE2.html
      SUMFILE2=$WWWDIR/.SUM/summary.$DATE2
      echo "Running access-summary.pl for whole $MON month ..."
      cat ${SUMFILE2}* | $BINDIR/access-summary.pl -m $HOST -n $TOPN -H > $WWWFILE2
      date
  fi
###

  $FIND $LOGDIR -type f -mtime +7 | xargs $RM -f
  $FIND $WWWDIR -type f -name "summary.*" -mtime +31 | xargs $RM -f
##!!!#$RM -f $SUMFILE
  $GZIP $LOGFILE
}

exit 0
