/*
 * Copyright 1999 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @summary Basic functional test of InheritableThreadLocal
 * @author Josh Bloch
 */

public class Basic {
    static InheritableThreadLocal n = new InheritableThreadLocal() {
        protected Object initialValue() {
            return new Integer(0);
        }

        protected Object childValue(Object parentValue) {
            return new Integer(((Integer)parentValue).intValue() + 1);
        }
    };

    static int threadCount = 100;
    static int x[];

    public static void main(String args[]) throws Exception {
        x = new int[threadCount];
        Thread progenitor = new MyThread();
        progenitor.start();

        // Wait for *all* threads to complete
        progenitor.join();

        // Check results
        for(int i=0; i<threadCount; i++)
            if (x[i] != i)
                throw(new Exception("x[" + i + "] =" + x[i]));
    }

    private static class MyThread extends Thread {
        public void run() {
            Thread child = null;
            if (((Integer)(n.get())).intValue() < threadCount-1) {
                child = new MyThread();
                child.start();
            }
            Thread.currentThread().yield();

            int threadId = ((Integer)(n.get())).intValue();
            for (int j=0; j<threadId; j++) {
                x[threadId]++;
                Thread.currentThread().yield();
            }

            // Wait for child (if any)
            if (child != null) {
                try {
                    child.join();
                } catch(InterruptedException e) {
                    throw(new RuntimeException("Interrupted"));
                }
            }
        }
    }
}
