/*************************************************************************
 *
 *  $RCSfile: infotip.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2002/08/26 10:53:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _GLOBAL_HXX_ 
#include "global.hxx"
#endif

#ifndef _INFOTIP_HXX_
#include "infotip.hxx"
#endif

#ifndef _SHLXTHDL_HXX_
#include "shlxthdl.hxx"
#endif

#ifndef _METAACCESSOR_HXX_
#include "metaaccessor.hxx"
#endif

#ifndef _UTILITIES_HXX_
#include "utilities.hxx"
#endif

#ifndef _CONFIG_HXX_
#include "config.hxx"
#endif

#include "resource.h"

//-----------------------------
//
//-----------------------------

CInfoTip::CInfoTip(long RefCnt) : 
	m_RefCnt(RefCnt)
{
	ZeroMemory(m_szFileName, sizeof(m_szFileName));
	InterlockedIncrement(&g_DllRefCnt);
}

//-----------------------------
//
//-----------------------------

CInfoTip::~CInfoTip()
{
	InterlockedDecrement(&g_DllRefCnt);
}

//-----------------------------
// IUnknown methods
//-----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::QueryInterface(REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject)
{
	*ppvObject = 0;

	IUnknown* pUnk = 0;

	if (IID_IUnknown == riid || IID_IQueryInfo == riid)
	{
		pUnk = static_cast<IQueryInfo*>(this);
		pUnk->AddRef();
		*ppvObject = pUnk;
		return S_OK;
	}
	else if (IID_IPersistFile == riid)
	{
		pUnk = static_cast<IPersistFile*>(this);
		pUnk->AddRef();
		*ppvObject = pUnk;
		return S_OK;
	}

	return E_NOINTERFACE;
}

//----------------------------
// 
//----------------------------

ULONG STDMETHODCALLTYPE CInfoTip::AddRef(void)
{
	return InterlockedIncrement(&m_RefCnt);
}

//----------------------------
// 
//----------------------------
        
ULONG STDMETHODCALLTYPE CInfoTip::Release( void)
{
	long refcnt = InterlockedDecrement(&m_RefCnt);

	if (0 == m_RefCnt)
		delete this;

	return refcnt;
}

//----------------------------
// IQueryInfo methods
//----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::GetInfoTip(DWORD dwFlags, wchar_t** ppwszTip)
{
	try
	{
		DocumentMetaInfoAccessor meta_info_accessor(m_szFileName);
			
		XmlTags_t xml_tags;
		
		xml_tags[META_INFO_TITLE]       = EMPTY_XML_TAG;
		xml_tags[META_INFO_AUTHOR]      = EMPTY_XML_TAG;		
		xml_tags[META_INFO_SUBJECT]     = EMPTY_XML_TAG;
		xml_tags[META_INFO_KEYWORDS]    = EMPTY_XML_TAG;
		xml_tags[META_INFO_DESCRIPTION] = EMPTY_XML_TAG;		
		
		meta_info_accessor.Read(xml_tags);

		std::wstring msg;
			
		msg += GetResString(IDS_TITLE_COLON) + std::wstring(SPACE);

		if (xml_tags[META_INFO_TITLE].first.length() > 0)
			msg += xml_tags[META_INFO_TITLE].first;
		else
			msg += m_FileNameOnly;
			
		msg += L"\n";
		msg += GetResString(IDS_AUTHOR_COLON) + std::wstring(SPACE);
		msg += xml_tags[META_INFO_AUTHOR].first;				
		msg += L"\n";
		msg += GetResString(IDS_SUBJECT_COLON) + std::wstring(SPACE);
		msg += xml_tags[META_INFO_SUBJECT].first;
		
		LPMALLOC lpMalloc;
		HRESULT hr = SHGetMalloc(&lpMalloc);

		if (SUCCEEDED(hr))
		{
			size_t len = sizeof(wchar_t) * msg.length() + sizeof(wchar_t);
			wchar_t* pMem = reinterpret_cast<wchar_t*>(lpMalloc->Alloc(len));
			
			ZeroMemory(pMem, len);

			msg.copy(pMem,msg.length());

			*ppwszTip = pMem;
			lpMalloc->Release();
														
			return S_OK;
		}		
	}
	catch(...)
	{		
	}
	
	return E_FAIL;
}

//----------------------------
// 
//----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::GetInfoFlags(DWORD *pdwFlags)
{
	return E_NOTIMPL;
}

//----------------------------
// IPersist methods
//----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::GetClassID(CLSID* pClassID)
{
	pClassID = const_cast<CLSID*>(&CLSID_INFOTIP_HANDLER);
	return S_OK;
}

//----------------------------
// IPersistFile methods
//----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::Load(LPCOLESTR pszFileName, DWORD dwMode)
{
	std::wstring fname = pszFileName;

	// there must be a '\' and there must even be an
	// extension, else we would not have been called
	std::wstring::iterator begin = fname.begin() + fname.find_last_of(L"\\") + 1;
	std::wstring::iterator end   = fname.end();

	m_FileNameOnly = std::wstring(begin, end);
	
	std::string fnameA = WStringToString(fname);

	strcpy(m_szFileName, fnameA.c_str());

	return S_OK;
}

//----------------------------
// 
//----------------------------

HRESULT STDMETHODCALLTYPE CInfoTip::IsDirty(void)
{
	return E_NOTIMPL;
}

//----------------------------
// 
//----------------------------
                
HRESULT STDMETHODCALLTYPE CInfoTip::Save(LPCOLESTR pszFileName, BOOL fRemember)
{
	return E_NOTIMPL;
}

//----------------------------
// 
//----------------------------
        
HRESULT STDMETHODCALLTYPE CInfoTip::SaveCompleted(LPCOLESTR pszFileName)
{
	return E_NOTIMPL;
}

//----------------------------
// 
//----------------------------
        
HRESULT STDMETHODCALLTYPE CInfoTip::GetCurFile(LPOLESTR __RPC_FAR *ppszFileName)
{
	return E_NOTIMPL;
}
