/*************************************************************************
 *
 *  $RCSfile: genericbuffer.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hjs $ $Date: 2001/08/06 14:13:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _GENERICBUFFER_HXX_
#define _GENERICBUFFER_HXX_

#include <stdexcept>
#include <string>

//------------------------------------------------
// a simple template class for managing a block
// of memory used to manage an array of structs
// this class is not thread-safe
//------------------------------------------------

template< class T >
class TGenericBuffer
{
public:

    //---------------------------------
    //
    //---------------------------------

    explicit TGenericBuffer( size_t size = 0 ) :
        m_vsize( size ),
        m_rsize( size ),
        m_pBuff( NULL )
    {
        if ( m_vsize > 0 )
        {
            m_pBuff = new T[m_rsize];
            if ( !m_pBuff )
            {
                m_vsize = 0;
                m_rsize = 0;
            }
        }
    }
    
    //---------------------------------
    //
    //---------------------------------

    ~TGenericBuffer( ) 
    {
        delete [] m_pBuff;
    }

    //---------------------------------
    //
    //---------------------------------

    bool realloc( size_t new_size ) 
    {
        bool bRet = true;

        if ( new_size <= m_vsize || 
             new_size <= m_rsize )            
            m_vsize = new_size;
        else
        {
            T* tmpBuff = new T[new_size];
            if ( tmpBuff )
            {
                memcpy( 
                    tmpBuff, 
                    m_pBuff, 
                    m_vsize * sizeof( T ) );

                delete [] m_pBuff;
                m_pBuff = tmpBuff;
                m_rsize = new_size;
                m_vsize = m_rsize;
            }
            else
                bRet = false;
        }
        
        return bRet;
    }
    
    //---------------------------------
    //
    //---------------------------------

    void clean( )
    {
        if ( m_vsize > 0 )
            ZeroMemory( m_pBuff, m_vsize * sizeof( T ) );
    }

    //---------------------------------
    //
    //---------------------------------

    T* operator&( ) 
    {
        T* pBuff = NULL;

        if ( m_vsize > 0 )
            pBuff = m_pBuff;

        return pBuff;
    };

    //---------------------------------
    //
    //---------------------------------

    size_t size( ) 
    {
        return m_vsize;
    }

    //---------------------------------
    // lvalue index operator
    //---------------------------------

    T& operator[]( size_t index )
    {
        if ( index < 0 || index >= m_vsize ) 
            throw std::out_of_range( "invalid index" );

        return m_pBuff[index];
    }

    //---------------------------------
    // rvalue index operator
    //---------------------------------

    const T& operator[]( size_t index ) const
    {
        if ( index < 0 || index >= m_vsize ) 
            throw std::out_of_range( "invalid index" );

        return m_pBuff[index];
    }

private:
    TGenericBuffer( const TGenericBuffer< T >& );
    TGenericBuffer< T >& operator=( const TGenericBuffer< T >& );

private:
    T*      m_pBuff;
    size_t  m_vsize;
    size_t  m_rsize;
};

#endif 
