/*************************************************************************
 *
 *  $RCSfile: image.h,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: sb $ $Date: 2002/08/22 13:54:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_IMAGE_H
#define _SV_IMAGE_H

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_COLOR_HXX
#include <color.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <bitmap.hxx>
#endif
#ifndef _SV_BITMAPEX_HXX
#include <bitmapex.hxx>
#endif

// ----------------
// - ImplImageBmp -
// ----------------

class ImplImageBmp
{
	BitmapEx	aBmpEx;
	Bitmap		aBmp;
	Bitmap		aMask;
	Bitmap		aDisa;
	Bitmap		aBmpDisp;
	Bitmap		aMaskDisp;
	Bitmap		aDisaDisp;
	Size		aSize;
	BYTE*		pInfoAry;
	USHORT		nCount;
	USHORT		nSize;

	void		ImplUpdateDisaBmp( USHORT nPos );
	void		ImplUpdatePaintBmp( USHORT nPos );

public:

				ImplImageBmp();
				~ImplImageBmp();

	void		Create( long nItemWidth, long nItemHeight, USHORT nInitSize );
	void		Create( const Bitmap& rBmp, const Bitmap& rMaskBmp,
						const Color& rColor, BOOL bColor,long nItemWidth,
						long nItemHeight,USHORT nInitSize );

	void		Expand( USHORT nGrowSize );

	void		Replace( USHORT nPos, USHORT nSrcPos );
	void		Replace( USHORT nPos, const ImplImageBmp& rImageBmp, USHORT nSrcPos );
	void		Replace( USHORT nPos, const Bitmap& rBmp );
	void		Replace( USHORT nPos, const Bitmap& rBmp, const Bitmap& rMaskBmp );
	void		Replace( USHORT nPos, const Bitmap& rBmp, const Color& rColor );

    void        ReplaceColors( const Color* pSrcColors, const Color* pDstColors, ULONG nColorCount );

	void		Merge( USHORT nPos, USHORT nSrcPos );

	Bitmap		GetBitmap( USHORT nPosCount, USHORT* pPosAry ) const;

	BOOL		HasMaskBitmap() const;
	Bitmap		GetMaskBitmap( USHORT nPosCount, USHORT* pPosAry ) const;

	BOOL		HasMaskColor() const;
	Color		GetMaskColor() const;

	void		Draw( USHORT nPos, OutputDevice* pDev, const Point& rPos,
					  USHORT nStyle, const Size* pSize = NULL );

    void        ClearCaches();
};

// --------------
// - ImageTypes -
// --------------

enum ImageType { IMAGETYPE_BITMAP, IMAGETYPE_IMAGE, IMAGETYPE_IMAGEREF };

// -----------------
// - ImplImageList -
// -----------------

struct ImageAryData
{
	USHORT			mnId;					// Id vom Image
	USHORT			mnRefCount; 			// Anzahl Referenzen (inkl. extern)
};

class ImplImageList
{
public:
	ULONG			mnRefCount; 			// Anzahl ImageList-Referenzen
	ULONG			mnIRefCount;			// Anzahl Image-Referenzen
	USHORT			mnCount;				// Anzahl offizeller Images
	USHORT			mnRealCount;			// Anzahl Images (inkl. Referenzen)
	USHORT			mnArySize;				// Array-Groesse
	USHORT			mnDummy;
	ImageAryData*	mpAry;					// Pointer auf Verwaltungsstruktur
	Size			maImageSize;			// Groeese eines Images
	ImplImageBmp*	mpImageBitmap;			// Zeiger auf ImageBitmap

					ImplImageList() {}		 // Um Warning zu umgehen
					~ImplImageList();
};

// --------------------
// - ImplImageRefData -
// --------------------

struct ImplImageRefData
{
	ImplImageList*	mpImplData;
	USHORT			mnIndex;

					ImplImageRefData() {}	 // Um Warning zu umgehen
					~ImplImageRefData();

	BOOL			IsEqual( const ImplImageRefData& rData );
};

// ----------------
// - ImpImageData -
// ----------------

class ImplImageData
{
public:
	ImplImageBmp*	mpImageBitmap;			// Zeiger auf ImageBitmap
	Bitmap			maBmp;					// Bitmap
	Bitmap			maMaskBmp;				// Maske
	Color			maColor;				// Color
	BOOL			mbColor;				// Transparent Color

					ImplImageData( const Bitmap& rBmp, const Bitmap& rMaskBmp );
					ImplImageData( const Bitmap& rBmp, const Color& rColor );
					~ImplImageData();

	BOOL			IsEqual( const ImplImageData& rData );
};

// -------------
// - ImplImage -
// -------------

class ImplImage
{
public:
	ULONG			mnRefCount;
	void*			mpData;
	ImageType		meType;

					ImplImage() {}			// Um Warning zu umgehen
					~ImplImage();
};

#endif // _SV_IMAGE_H
