/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_XclChartsApiHelper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:21:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

// ----------------------------------------------------------------------------

#ifndef SC_XCLCHARTSAPIHELPER_HXX
#include "XclChartsApiHelper.hxx"
#endif

#ifndef _COMPHELPER_TYPES_HXX_
#include <comphelper/types.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef SC_XLSTYLE_HXX
#include "xlstyle.hxx"
#endif


#include "chrtdefs.hxx"
namespace binfilter {


using ::rtl::OUString;
using namespace ::com::sun::star;


// Line Properties ============================================================

// property names for line style - without dash -------------------------------

// MUST be sorted alphabetically
const sal_Char* ppLineMultiPSNames_NoDash[] =
{
    "LineColor",
    "LineStyle",
    "LineTransparence",
    "LineWidth"
};

const sal_Int32 PROPINDEX_LINECOLOR_NODASH  = 0;
const sal_Int32 PROPINDEX_LINESTYLE_NODASH  = 1;
const sal_Int32 PROPINDEX_LINETRANSP_NODASH = 2;
const sal_Int32 PROPINDEX_LINEWIDTH_NODASH  = 3;


// property names for line style - with dash ----------------------------------

// MUST be sorted alphabetically
const sal_Char* ppLineMultiPSNames_Dash[] =
{
    "LineColor",
    "LineDash",
    "LineStyle",
    "LineTransparence",
    "LineWidth"
};

const sal_Int32 PROPINDEX_LINECOLOR_DASH    = 0;
const sal_Int32 PROPINDEX_LINEDASH_DASH     = 1;
const sal_Int32 PROPINDEX_LINESTYLE_DASH    = 2;
const sal_Int32 PROPINDEX_LINETRANSP_DASH   = 3;
const sal_Int32 PROPINDEX_LINEWIDTH_DASH    = 4;


// ----------------------------------------------------------------------------

XclLineMultiPSHelper::XclLineMultiPSHelper() :
    aMultiPSHelper_NoDash( ppLineMultiPSNames_NoDash, STATIC_TABLE_SIZE( ppLineMultiPSNames_NoDash ) ),
    aMultiPSHelper_Dash( ppLineMultiPSNames_Dash, STATIC_TABLE_SIZE( ppLineMultiPSNames_Dash ) )
{
}

sal_Bool XclLineMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        drawing::LineStyle eStyle, const drawing::LineDash* pDash,
        sal_Int32 nWidth, sal_Int16 nTransp, sal_Int32 nRGBColor )
{
    sal_Bool bRet = sal_False;
    if( xMultiPS.is() || xPropSet.is() )
    {
        if( (eStyle == drawing::LineStyle_DASH) && pDash )
        {
            aMultiPSHelper_Dash.getAny( PROPINDEX_LINESTYLE_DASH )  <<= eStyle;
            aMultiPSHelper_Dash.getAny( PROPINDEX_LINEWIDTH_DASH )  <<= nWidth;
            aMultiPSHelper_Dash.getAny( PROPINDEX_LINECOLOR_DASH )  <<= nRGBColor;
            aMultiPSHelper_Dash.getAny( PROPINDEX_LINETRANSP_DASH ) <<= nTransp;
            aMultiPSHelper_Dash.getAny( PROPINDEX_LINEDASH_DASH )   <<= *pDash;
            bRet = aMultiPSHelper_Dash.setPropertyValues( xMultiPS, xPropSet );
        }
        else
        {
            aMultiPSHelper_NoDash.getAny( PROPINDEX_LINESTYLE_NODASH )  <<= eStyle;
            aMultiPSHelper_NoDash.getAny( PROPINDEX_LINEWIDTH_NODASH )  <<= nWidth;
            aMultiPSHelper_NoDash.getAny( PROPINDEX_LINECOLOR_NODASH )  <<= nRGBColor;
            aMultiPSHelper_NoDash.getAny( PROPINDEX_LINETRANSP_NODASH ) <<= nTransp;
            bRet = aMultiPSHelper_NoDash.setPropertyValues( xMultiPS, xPropSet );
        }
    }
    return bRet;
}


// Area Properties ============================================================

// property names for solid area style ----------------------------------------

// MUST be sorted alphabetically
const sal_Char* ppAreaMultiPSNames_Solid[] =
{
    "FillColor",
    "FillStyle"
};

const sal_Int32 PROPINDEX_FILLCOLOR_SOLID   = 0;
const sal_Int32 PROPINDEX_FILLSTYLE_SOLID   = 1;


// property names for gradient area style -------------------------------------

// MUST be sorted alphabetically
const sal_Char* ppAreaMultiPSNames_Gradient[] =
{
    "FillGradient",
    "FillGradientStepCount",
    "FillStyle"
};

const sal_Int32 PROPINDEX_FILLGRADIENT_GRADIENT     = 0;
const sal_Int32 PROPINDEX_FILLGRADIENTST_GRADIENT   = 1;
const sal_Int32 PROPINDEX_FILLSTYLE_GRADIENT        = 2;


// ----- property names for bitmap area style ---------------------------------

// MUST be sorted alphabetically
const sal_Char* ppAreaMultiPSNames_Bitmap[] =
{
    "FillBitmap",
    "FillBitmapMode",
    "FillStyle"
};

const sal_Int32 PROPINDEX_FILLBITMAP_BITMAP         = 0;
const sal_Int32 PROPINDEX_FILLBITMAPMODE_BITMAP     = 1;
const sal_Int32 PROPINDEX_FILLSTYLE_BITMAP          = 2;


// ----------------------------------------------------------------------------

XclAreaMultiPSHelper::XclAreaMultiPSHelper() :
    aMultiPSHelper_Solid( ppAreaMultiPSNames_Solid, STATIC_TABLE_SIZE( ppAreaMultiPSNames_Solid ) ),
    aMultiPSHelper_Gradient( ppAreaMultiPSNames_Gradient, STATIC_TABLE_SIZE( ppAreaMultiPSNames_Gradient ) ),
    aMultiPSHelper_Bitmap( ppAreaMultiPSNames_Bitmap, STATIC_TABLE_SIZE( ppAreaMultiPSNames_Bitmap ) )
{
}

sal_Bool XclAreaMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        drawing::FillStyle eStyle,
        sal_Int32 nRGBColor )
{
    sal_Bool bRet = sal_False;
    if( xMultiPS.is() || xPropSet.is() )
    {
        aMultiPSHelper_Solid.getAny( PROPINDEX_FILLSTYLE_SOLID ) <<= eStyle;
        aMultiPSHelper_Solid.getAny( PROPINDEX_FILLCOLOR_SOLID ) <<= nRGBColor;
        bRet = aMultiPSHelper_Solid.setPropertyValues( xMultiPS, xPropSet );
    }
    return bRet;
}

sal_Bool XclAreaMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const awt::Gradient& rGradient )
{
    sal_Bool bRet = sal_False;
    if( xMultiPS.is() || xPropSet.is() )
    {
        aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLSTYLE_GRADIENT )      <<= drawing::FillStyle_GRADIENT;
        aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLGRADIENT_GRADIENT )   <<= rGradient;
        aMultiPSHelper_Gradient.getAny( PROPINDEX_FILLGRADIENTST_GRADIENT ) <<= rGradient.StepCount;
        bRet = aMultiPSHelper_Gradient.setPropertyValues( xMultiPS, xPropSet );
    }
    return bRet;
}

sal_Bool XclAreaMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const uno::Reference< awt::XBitmap >& rXBitmap,
        drawing::BitmapMode eMode )
{
    sal_Bool bRet = sal_False;
    if( xMultiPS.is() || xPropSet.is() )
    {
        aMultiPSHelper_Bitmap.getAny( PROPINDEX_FILLSTYLE_BITMAP )      <<= drawing::FillStyle_BITMAP;
        aMultiPSHelper_Bitmap.getAny( PROPINDEX_FILLBITMAP_BITMAP )     <<= rXBitmap;
        aMultiPSHelper_Bitmap.getAny( PROPINDEX_FILLBITMAPMODE_BITMAP ) <<= eMode;
        bRet = aMultiPSHelper_Bitmap.setPropertyValues( xMultiPS, xPropSet );
    }
    return bRet;
}

// Font Properties ============================================================

// property names for font settings -------------------------------------------

// MUST be sorted alphabetically
const sal_Char* ppFontMultiPSNames[] =
{
    "CharContoured",
    "CharCrossedOut",
    "CharFontName",
    "CharHeight",
    "CharPosture",
    "CharShadowed",
    "CharUnderline",
    "CharWeight"
};

const sal_Int32 PROPINDEX_CHARCOUNTOURED    = 0;
const sal_Int32 PROPINDEX_CHARCROSSEDOUT    = 1;
const sal_Int32 PROPINDEX_CHARFONTNAME      = 2;
const sal_Int32 PROPINDEX_CHARHEIGHT        = 3;
const sal_Int32 PROPINDEX_CHARPOSTURE       = 4;
const sal_Int32 PROPINDEX_CHARSHADOWED      = 5;
const sal_Int32 PROPINDEX_CHARUNDERLINE     = 6;
const sal_Int32 PROPINDEX_CHARWEIGHT        = 7;


// ----------------------------------------------------------------------------

XclFontMultiPSHelper::XclFontMultiPSHelper() :
    ScfMultiPSHelper( ppFontMultiPSNames, STATIC_TABLE_SIZE( ppFontMultiPSNames ) )
{
}

sal_Bool XclFontMultiPSHelper::setProperties(
        const uno::Reference< beans::XMultiPropertySet >& xMultiPS,
        const uno::Reference< beans::XPropertySet >& xPropSet,
        const XclFontData& rFontData )
{
    sal_Bool bRet = sal_False;
    if( xMultiPS.is() || xPropSet.is() )
    {
        getAny( PROPINDEX_CHARFONTNAME )    <<= OUString( rFontData.maName );
        getAny( PROPINDEX_CHARHEIGHT )      <<= rFontData.GetApiHeight();
        getAny( PROPINDEX_CHARPOSTURE )     <<= rFontData.GetApiPosture();
        getAny( PROPINDEX_CHARUNDERLINE )   <<= rFontData.GetApiUnderline();
        getAny( PROPINDEX_CHARWEIGHT )      <<= rFontData.GetApiWeight();

        ::comphelper::setBOOL( getAny( PROPINDEX_CHARCOUNTOURED ), rFontData.mbOutline );
        ::comphelper::setBOOL( getAny( PROPINDEX_CHARCROSSEDOUT ), rFontData.mbStrikeout );
        ::comphelper::setBOOL( getAny( PROPINDEX_CHARSHADOWED ), rFontData.mbShadow );

        bRet = setPropertyValues( xMultiPS, xPropSet );
    }
    return bRet;
}


// ============================================================================

}
