/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_preview.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:32:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------
// auto strip #include <tools/pstm.hxx>
#include "scitems.hxx"
// auto strip #include <bf_svx/eeitem.hxx>
#define ITEMID_FIELD EE_FEATURE_FIELD

// auto strip #include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/fmview.hxx>
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <svtools/accessibilityoptions.hxx>
// auto strip #include <svtools/itemset.hxx>
// auto strip #include <tools/multisel.hxx>
// auto strip #include <vcl/waitobj.hxx>
// auto strip #include <vcl/sound.hxx>

// auto strip #include "preview.hxx"
// auto strip #include "prevwsh.hxx"
// auto strip #include "prevloc.hxx"
#include "docsh.hxx"
// auto strip #include "printfun.hxx"
// auto strip #include "printopt.hxx"
// auto strip #include "stlpool.hxx"
// auto strip #include "drwlayer.hxx"
// auto strip #include "scmod.hxx"
#include "globstr.hrc"
#include "bf_sc.hrc"			// fuer ShellInvalidate
// auto strip #include "AccessibleDocumentPagePreview.hxx"
// auto strip #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
// auto strip #include <com/sun/star/accessibility/XAccessible.hpp>
// auto strip #endif
// auto strip #ifndef SC_ACCESSIBILITYHINTS_HXX
// auto strip #include "AccessibilityHints.hxx"
// auto strip #endif
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//==================================================================

#define SC_PREVIEW_SHADOWSIZE	2

//STRIP001 long lcl_GetDisplayStart( USHORT nTab, ScDocument* pDoc, long* pPages )
//STRIP001 {
//STRIP001 	long nDisplayStart = 0;
//STRIP001 	for (USHORT i=0; i<nTab; i++)
//STRIP001 	{
//STRIP001 		if ( pDoc->NeedPageResetAfterTab(i) )
//STRIP001 			nDisplayStart = 0;
//STRIP001 		else
//STRIP001 			nDisplayStart += pPages[i];
//STRIP001 	}
//STRIP001 	return nDisplayStart;
//STRIP001 }


//STRIP001 ScPreview::ScPreview( Window* pParent, ScDocShell* pDocSh, ScPreviewShell* pViewSh ) :
//STRIP001 	Window( pParent ),
//STRIP001 	pDocShell( pDocSh ),
//STRIP001 	pViewShell( pViewSh ),
//STRIP001 	bInPaint( FALSE ),
//STRIP001 	bValid( FALSE ),
//STRIP001 	bStateValid( FALSE ),
//STRIP001 	bLocationValid( FALSE ),
//STRIP001 	bInGetState( FALSE ),
//STRIP001 	pLocationData( NULL ),
//STRIP001 	pDrawView( NULL ),
//STRIP001 	nTabsTested( 0 ),
//STRIP001 	nPageNo( 0 ),
//STRIP001 	nZoom( 100 ),
//STRIP001 	nTab( 0 ),
//STRIP001 	nTotalPages( 0 ),
//STRIP001 	nTabStart( 0 ),
//STRIP001 	nDisplayStart( 0 )
//STRIP001 {
//STRIP001     SetOutDevViewType( OUTDEV_VIEWTYPE_PRINTPREVIEW ); //#106611#
//STRIP001 	SetBackground();
//STRIP001 
//STRIP001 	SetHelpId( HID_SC_WIN_PREVIEW );
//STRIP001 	SetUniqueId( HID_SC_WIN_PREVIEW );
//STRIP001 
//STRIP001 	SetDigitLanguage( SC_MOD()->GetOptDigitLanguage() );
//STRIP001 }


//STRIP001 __EXPORT ScPreview::~ScPreview()
//STRIP001 {
//STRIP001 	delete pDrawView;
//STRIP001 	delete pLocationData;
//STRIP001 }


//STRIP001 void ScPreview::UpdateDrawView()		// nTab muss richtig sein
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	Rectangle aFull( 0, 0, LONG_MAX, LONG_MAX );
//STRIP001 	if ( pDoc->HasControl( nTab, aFull ) )
//STRIP001 	{
//STRIP001 		if ( pDrawView && !pDrawView->GetPageViewPgNum(nTab) )
//STRIP001 		{
//STRIP001 			//	die angezeigte Page der DrawView umzustellen (s.u.) funktioniert nicht ?!?
//STRIP001 			delete pDrawView;
//STRIP001 			pDrawView = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !pDrawView )									// neu anlegen?
//STRIP001 		{
//STRIP001 			ScDrawLayer* pModel = pDoc->GetDrawLayer();		// ist nicht 0
//STRIP001 			pDrawView = new FmFormView( pModel, this );
//STRIP001 			// #55259# die DrawView uebernimmt den Design-Modus vom Model
//STRIP001 			// (Einstellung "Im Entwurfsmodus oeffnen"), darum hier zuruecksetzen
//STRIP001 			pDrawView->SetDesignMode( TRUE );
//STRIP001 			pDrawView->SetPrintPreview( TRUE );
//STRIP001 			pDrawView->ShowPagePgNum( nTab, Point() );
//STRIP001 		}
//STRIP001 #if 0
//STRIP001 		else if ( !pDrawView->GetPageViewPgNum(nTab) )		// angezeigte Page umstellen
//STRIP001 		{
//STRIP001 			pDrawView->HideAllPages();
//STRIP001 			pDrawView->ShowPagePgNum( nTab, Point() );
//STRIP001 		}
//STRIP001 #endif
//STRIP001 	}
//STRIP001 	else if ( pDrawView )
//STRIP001 	{
//STRIP001 		delete pDrawView;			// fuer diese Tabelle nicht gebraucht
//STRIP001 		pDrawView = NULL;
//STRIP001 	}
//STRIP001 }


//STRIP001 void ScPreview::TestLastPage()
//STRIP001 {
//STRIP001 	if (nPageNo >= nTotalPages)
//STRIP001 	{
//STRIP001 		if (nTotalPages)
//STRIP001 		{
//STRIP001 			nPageNo = nTotalPages - 1;
//STRIP001 			nTab = nTabCount - 1;
//STRIP001 			while (nTab && !nPages[nTab])		// letzte nicht leere Tabelle
//STRIP001 				--nTab;
//STRIP001 			DBG_ASSERT(nPages[nTab],"alle Tabellen leer?");
//STRIP001 			nTabPage = nPages[nTab] - 1;
//STRIP001 			nTabStart = 0;
//STRIP001 			for (USHORT i=0; i<nTab; i++)
//STRIP001 				nTabStart += nPages[i];
//STRIP001 
//STRIP001 			ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 			nDisplayStart = lcl_GetDisplayStart( nTab, pDoc, nPages );
//STRIP001 		}
//STRIP001 		else		// leeres Dokument
//STRIP001 		{
//STRIP001 			nTab = 0;
//STRIP001 			nPageNo = nTabPage = nTabStart = nDisplayStart = 0;
//STRIP001 			aState.nPrintTab = aState.nStartCol = aState.nStartRow =
//STRIP001 			aState.nEndCol = aState.nEndRow = aState.nZoom =
//STRIP001 			aState.nPagesX = aState.nPagesY = 0;
//STRIP001 			aState.nTabPages = aState.nTotalPages =
//STRIP001 			aState.nPageStart = aState.nDocPages = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void ScPreview::CalcPages( USHORT nToWhichTab )
//STRIP001 {
//STRIP001 	WaitObject( this );
//STRIP001 
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	nTabCount = pDoc->GetTableCount();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	USHORT nAnz = Min( nTabCount, USHORT(nToWhichTab+1) );
//STRIP001 	USHORT nStart = nTabsTested;
//STRIP001 	if (!bValid)
//STRIP001 	{
//STRIP001 		nStart = 0;
//STRIP001 		nTotalPages = 0;
//STRIP001 		nTabsTested = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	//	PrintOptions is passed to PrintFunc for SkipEmpty flag,
//STRIP001 	//	but always all sheets are used (there is no selected sheet)
//STRIP001 	ScPrintOptions aOptions = SC_MOD()->GetPrintOptions();
//STRIP001 
//STRIP001 	for (i=nStart; i<nAnz; i++)
//STRIP001 	{
//STRIP001 		long nAttrPage = i ? nFirstAttr[i-1] : 1;
//STRIP001 
//STRIP001 		long nThisStart = nTotalPages;
//STRIP001 		ScPrintFunc aPrintFunc( this, pDocShell, i, nAttrPage, 0, NULL, &aOptions );
//STRIP001 		long nThisTab = aPrintFunc.GetTotalPages();
//STRIP001 		nPages[i] = nThisTab;
//STRIP001 		nTotalPages += nThisTab;
//STRIP001 		nFirstAttr[i] = aPrintFunc.GetFirstPageNo();	// behalten oder aus Vorlage
//STRIP001 
//STRIP001 		if (nPageNo>=nThisStart && nPageNo<nTotalPages)
//STRIP001 		{
//STRIP001 			nTab = i;
//STRIP001 			nTabPage = nPageNo - nThisStart;
//STRIP001 			nTabStart = nThisStart;
//STRIP001 
//STRIP001 			aPrintFunc.GetPrintState( aState );
//STRIP001 			aPageSize = aPrintFunc.GetPageSize();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nDisplayStart = lcl_GetDisplayStart( nTab, pDoc, nPages );
//STRIP001 
//STRIP001 	if (nAnz > nTabsTested)
//STRIP001 		nTabsTested = nAnz;
//STRIP001 
//STRIP001 	//	testen, ob hinter letzter Seite
//STRIP001 
//STRIP001 	if ( nTabsTested >= nTabCount )
//STRIP001 		TestLastPage();
//STRIP001 
//STRIP001 	aState.nDocPages = nTotalPages;
//STRIP001 
//STRIP001 	bValid = TRUE;
//STRIP001 	bStateValid = TRUE;
//STRIP001 	DoInvalidate();
//STRIP001 }


//STRIP001 void ScPreview::RecalcPages()					// nur nPageNo geaendert
//STRIP001 {
//STRIP001 	if (!bValid)
//STRIP001 		return;							// dann wird CalcPages aufgerufen
//STRIP001 
//STRIP001 	USHORT nOldTab = nTab;
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 	while (nPageNo >= nTotalPages && nTabsTested < nTabCount)
//STRIP001 	{
//STRIP001 		CalcPages( nTabsTested );
//STRIP001 		bDone = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bDone)
//STRIP001 	{
//STRIP001 		long nPartPages = 0;
//STRIP001 		for (i=0; i<nTabsTested; i++)
//STRIP001 		{
//STRIP001 			long nThisStart = nPartPages;
//STRIP001 			nPartPages += nPages[i];
//STRIP001 
//STRIP001 			if (nPageNo>=nThisStart && nPageNo<nPartPages)
//STRIP001 			{
//STRIP001 				nTab = i;
//STRIP001 				nTabPage = nPageNo - nThisStart;
//STRIP001 				nTabStart = nThisStart;
//STRIP001 
//STRIP001 //				aPageSize = aPrintFunc.GetPageSize();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 		nDisplayStart = lcl_GetDisplayStart( nTab, pDoc, nPages );
//STRIP001 	}
//STRIP001 
//STRIP001 	TestLastPage();			// testen, ob hinter letzter Seite
//STRIP001 
//STRIP001 	if ( nTab != nOldTab )
//STRIP001 		bStateValid = FALSE;
//STRIP001 
//STRIP001 	DoInvalidate();
//STRIP001 }


//STRIP001 void ScPreview::DoPrint( ScPreviewLocationData* pFillLocation )
//STRIP001 {
//STRIP001 	if (!bValid)
//STRIP001 	{
//STRIP001 		CalcPages(0);
//STRIP001 		RecalcPages();
//STRIP001 		UpdateDrawView();		// Tabelle evtl. geaendert
//STRIP001 	}
//STRIP001 
//STRIP001 	Fraction aPreviewZoom( nZoom, 100 );
//STRIP001 	Fraction aHorPrevZoom( (long)( 100 * nZoom / pDocShell->GetOutputFactor() ), 10000 );
//STRIP001 	MapMode aMMMode( MAP_100TH_MM, Point(), aHorPrevZoom, aPreviewZoom );
//STRIP001 
//STRIP001 	BOOL bDoPrint = ( pFillLocation == NULL );
//STRIP001 	BOOL bValidPage = ( nPageNo < nTotalPages );
//STRIP001 
//STRIP001 	ScModule* pScMod = SC_MOD();
//STRIP001     const svtools::ColorConfig& rColorCfg = pScMod->GetColorConfig();
//STRIP001     Color aBackColor( rColorCfg.GetColorValue(svtools::APPBACKGROUND).nColor );
//STRIP001 
//STRIP001 	if ( bDoPrint && ( aOffset.X() < 0 || aOffset.Y() < 0 ) && bValidPage )
//STRIP001 	{
//STRIP001 		SetMapMode( aMMMode );
//STRIP001 		SetLineColor();
//STRIP001 		SetFillColor(aBackColor);
//STRIP001 
//STRIP001 		Size aWinSize = GetOutputSize();
//STRIP001 		if ( aOffset.X() < 0 )
//STRIP001 			DrawRect(Rectangle( 0, 0, -aOffset.X(), aWinSize.Height() ));
//STRIP001 		if ( aOffset.Y() < 0 )
//STRIP001 			DrawRect(Rectangle( 0, 0, aWinSize.Width(), -aOffset.Y() ));
//STRIP001 	}
//STRIP001 
//STRIP001 	Size aPageSize;
//STRIP001 	if ( bValidPage )
//STRIP001 	{
//STRIP001 		ScPrintOptions aOptions = pScMod->GetPrintOptions();
//STRIP001 
//STRIP001 		ScPrintFunc* pPrintFunc;
//STRIP001 		if (bStateValid)
//STRIP001 			pPrintFunc = new ScPrintFunc( this, pDocShell, aState, &aOptions );
//STRIP001 		else
//STRIP001 			pPrintFunc = new ScPrintFunc( this, pDocShell, nTab, nFirstAttr[nTab], nTotalPages, NULL, &aOptions );
//STRIP001 
//STRIP001 		pPrintFunc->SetOffset(aOffset);
//STRIP001 		pPrintFunc->SetManualZoom(nZoom);
//STRIP001 		pPrintFunc->SetDateTime(aDate,aTime);
//STRIP001 		pPrintFunc->SetClearFlag(TRUE);
//STRIP001 		pPrintFunc->SetUseStyleColor( pScMod->GetAccessOptions().GetIsForPagePreviews() );
//STRIP001 
//STRIP001 		pPrintFunc->SetDrawView( pDrawView );
//STRIP001 
//STRIP001 		// MultiSelection fuer die eine Seite muss etwas umstaendlich erzeugt werden...
//STRIP001 		Range aPageRange( nPageNo+1, nPageNo+1 );
//STRIP001 		MultiSelection aPage( aPageRange );
//STRIP001 		aPage.SetTotalRange( Range(0,RANGE_MAX) );
//STRIP001 		aPage.Select( aPageRange );
//STRIP001 
//STRIP001 		long nPrinted = pPrintFunc->DoPrint( aPage, nTabStart, nDisplayStart, bDoPrint, NULL, pFillLocation );
//STRIP001 		DBG_ASSERT(nPrinted<=1, "was'n nu los?");
//STRIP001 
//STRIP001 		SetMapMode(aMMMode);
//STRIP001 //		USHORT nPrintZoom = pPrintFunc->GetZoom();
//STRIP001 
//STRIP001 		if (nPrinted)	// wenn nichts, alles grau zeichnen
//STRIP001 		{
//STRIP001 			aPageSize = pPrintFunc->GetPageSize();
//STRIP001 			aPageSize.Width()  = (long) (aPageSize.Width()  * HMM_PER_TWIPS );
//STRIP001 			aPageSize.Height() = (long) (aPageSize.Height() * HMM_PER_TWIPS );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!bStateValid)
//STRIP001 		{
//STRIP001 			pPrintFunc->GetPrintState( aState );
//STRIP001 			aState.nDocPages = nTotalPages;
//STRIP001 			bStateValid = TRUE;
//STRIP001 		}
//STRIP001 		delete pPrintFunc;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bDoPrint )
//STRIP001 	{
//STRIP001 		long nPageEndX = aPageSize.Width()  - aOffset.X();
//STRIP001 		long nPageEndY = aPageSize.Height() - aOffset.Y();
//STRIP001 		if ( !bValidPage )
//STRIP001 			nPageEndX = nPageEndY = 0;
//STRIP001 
//STRIP001 		Size aWinSize = GetOutputSize();
//STRIP001 		Point aWinEnd( aWinSize.Width(), aWinSize.Height() );
//STRIP001 		BOOL bRight  = nPageEndX <= aWinEnd.X();
//STRIP001 		BOOL bBottom = nPageEndY <= aWinEnd.Y();
//STRIP001 		if (bRight || bBottom)
//STRIP001 		{
//STRIP001 			SetLineColor();
//STRIP001 			SetFillColor(aBackColor);
//STRIP001 			if (bRight)
//STRIP001 				DrawRect(Rectangle(nPageEndX,0, aWinEnd.X(),aWinEnd.Y()));
//STRIP001 			if (bBottom)
//STRIP001 			{
//STRIP001 				if (bRight)
//STRIP001 					DrawRect(Rectangle(0,nPageEndY, nPageEndX,aWinEnd.Y()));	// Ecke nicht doppelt
//STRIP001 				else
//STRIP001 					DrawRect(Rectangle(0,nPageEndY, aWinEnd.X(),aWinEnd.Y()));
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bValidPage )
//STRIP001 		{
//STRIP001             Color aBorderColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
//STRIP001 
//STRIP001 			//	draw border
//STRIP001 
//STRIP001 			if ( aOffset.X() <= 0 || aOffset.Y() <= 0 || bRight || bBottom )
//STRIP001 			{
//STRIP001 				SetLineColor( aBorderColor );
//STRIP001 				SetFillColor();
//STRIP001 
//STRIP001 				Rectangle aPixel( LogicToPixel( Rectangle( -aOffset.X(), -aOffset.Y(), nPageEndX, nPageEndY ) ) );
//STRIP001 				--aPixel.Right();
//STRIP001 				--aPixel.Bottom();
//STRIP001 				DrawRect( PixelToLogic( aPixel ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			//	draw shadow
//STRIP001 
//STRIP001 			SetLineColor();
//STRIP001 			SetFillColor( aBorderColor );
//STRIP001 
//STRIP001 			Rectangle aPixel;
//STRIP001 
//STRIP001 			aPixel = LogicToPixel( Rectangle( nPageEndX, -aOffset.Y(), nPageEndX, nPageEndY ) );
//STRIP001 			aPixel.Top() += SC_PREVIEW_SHADOWSIZE;
//STRIP001 			aPixel.Right() += SC_PREVIEW_SHADOWSIZE - 1;
//STRIP001 			aPixel.Bottom() += SC_PREVIEW_SHADOWSIZE - 1;
//STRIP001 			DrawRect( PixelToLogic( aPixel ) );
//STRIP001 
//STRIP001 			aPixel = LogicToPixel( Rectangle( -aOffset.X(), nPageEndY, nPageEndX, nPageEndY ) );
//STRIP001 			aPixel.Left() += SC_PREVIEW_SHADOWSIZE;
//STRIP001 			aPixel.Right() += SC_PREVIEW_SHADOWSIZE - 1;
//STRIP001 			aPixel.Bottom() += SC_PREVIEW_SHADOWSIZE - 1;
//STRIP001 			DrawRect( PixelToLogic( aPixel ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


//STRIP001 void __EXPORT ScPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	DoPrint( NULL );
//STRIP001 	pViewShell->UpdateScrollBars();
//STRIP001 }


//STRIP001 void __EXPORT ScPreview::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	USHORT nCmd = rCEvt.GetCommand();
//STRIP001 	if ( nCmd == COMMAND_WHEEL || nCmd == COMMAND_STARTAUTOSCROLL || nCmd == COMMAND_AUTOSCROLL )
//STRIP001 	{
//STRIP001 		BOOL bDone = pViewShell->ScrollCommand( rCEvt );
//STRIP001 		if (!bDone)
//STRIP001 			Window::Command(rCEvt);
//STRIP001 	}
//STRIP001 	else if ( nCmd == COMMAND_CONTEXTMENU )
//STRIP001 		SfxDispatcher::ExecutePopup();
//STRIP001 	else
//STRIP001 		Window::Command( rCEvt );
//STRIP001 }


//STRIP001 void __EXPORT ScPreview::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     //  The + and - keys can't be configured as accelerator entries, so they must be handled directly
//STRIP001     //  (in ScPreview, not ScPreviewShell -> only if the preview window has the focus)
//STRIP001 
//STRIP001     const KeyCode& rKeyCode = rKEvt.GetKeyCode();
//STRIP001     USHORT nKey = rKeyCode.GetCode();
//STRIP001     BOOL bHandled = FALSE;
//STRIP001     if(!rKeyCode.GetModifier())
//STRIP001     {
//STRIP001         USHORT nSlot = 0;
//STRIP001         switch(nKey)
//STRIP001         {
//STRIP001             case KEY_ADD:      nSlot = SID_PREVIEW_ZOOMIN;  break;
//STRIP001             case KEY_SUBTRACT: nSlot = SID_PREVIEW_ZOOMOUT; break;
//STRIP001         }
//STRIP001         if(nSlot)
//STRIP001         {
//STRIP001             bHandled = TRUE;
//STRIP001             pViewShell->GetViewFrame()->GetDispatcher()->Execute( nSlot, SFX_CALLMODE_ASYNCHRON );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if ( !bHandled && !pViewShell->KeyInput(rKEvt) )
//STRIP001         Window::KeyInput(rKEvt);
//STRIP001 }


//STRIP001 const ScPreviewLocationData& ScPreview::GetLocationData()
//STRIP001 {
//STRIP001 	if ( !pLocationData )
//STRIP001 	{
//STRIP001 		pLocationData = new ScPreviewLocationData( pDocShell->GetDocument(), this );
//STRIP001 		bLocationValid = FALSE;
//STRIP001 	}
//STRIP001 	if ( !bLocationValid )
//STRIP001 	{
//STRIP001 		pLocationData->Clear();
//STRIP001 		DoPrint( pLocationData );
//STRIP001 		bLocationValid = TRUE;
//STRIP001 	}
//STRIP001 	return *pLocationData;
//STRIP001 }


//STRIP001 void ScPreview::DataChanged(BOOL bNewTime)
//STRIP001 {
//STRIP001 	if (bNewTime)
//STRIP001 	{
//STRIP001 		aDate = Date();
//STRIP001 		aTime = Time();
//STRIP001 	}
//STRIP001 
//STRIP001 	bValid = FALSE;
//STRIP001 	InvalidateLocationData( SC_HINT_DATACHANGED );
//STRIP001 	Invalidate();
//STRIP001 }


//STRIP001 String ScPreview::GetPosString()
//STRIP001 {
//STRIP001 	if (!bValid)
//STRIP001 	{
//STRIP001 		CalcPages(nTab);
//STRIP001 		UpdateDrawView();		// Tabelle evtl. geaendert
//STRIP001 	}
//STRIP001 
//STRIP001 	String aString( ScGlobal::GetRscString( STR_PAGE ) );
//STRIP001 	aString += ' ';
//STRIP001 	aString += String::CreateFromInt32(nPageNo+1);
//STRIP001 
//STRIP001 	if (nTabsTested >= nTabCount)
//STRIP001 	{
//STRIP001 		aString.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " / " ));
//STRIP001 		aString += String::CreateFromInt32(nTotalPages);
//STRIP001 	}
//STRIP001 
//STRIP001 	return aString;
//STRIP001 }


//STRIP001 void ScPreview::SetZoom(USHORT nNewZoom)
//STRIP001 {
//STRIP001 	if (nNewZoom < 20)
//STRIP001 		nNewZoom = 20;
//STRIP001 	if (nNewZoom > 400)
//STRIP001 		nNewZoom = 400;
//STRIP001 	if (nNewZoom != nZoom)
//STRIP001 	{
//STRIP001 		double nFact = nNewZoom / (double) nZoom;
//STRIP001 		nZoom = nNewZoom;
//STRIP001 
//STRIP001 		//	apply new MapMode and call UpdateScrollBars to update aOffset
//STRIP001 
//STRIP001 		Fraction aPreviewZoom( nZoom, 100 );
//STRIP001 		Fraction aHorPrevZoom( (long)( 100 * nZoom / pDocShell->GetOutputFactor() ), 10000 );
//STRIP001 		MapMode aMMMode( MAP_100TH_MM, Point(), aHorPrevZoom, aPreviewZoom );
//STRIP001 		SetMapMode( aMMMode );
//STRIP001 
//STRIP001 		bInPaint = TRUE;				// don't scroll during SetYOffset in UpdateScrollBars
//STRIP001 		pViewShell->UpdateScrollBars();
//STRIP001 		bInPaint = FALSE;
//STRIP001 
//STRIP001 		bStateValid = FALSE;
//STRIP001 		InvalidateLocationData( SC_HINT_ACC_VISAREACHANGED );
//STRIP001 		DoInvalidate();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }


//STRIP001 void ScPreview::SetPageNo( long nPage )
//STRIP001 {
//STRIP001 	nPageNo = nPage;
//STRIP001 	RecalcPages();
//STRIP001 	UpdateDrawView();		// Tabelle evtl. geaendert
//STRIP001 	InvalidateLocationData( SC_HINT_DATACHANGED );
//STRIP001 	Invalidate();
//STRIP001 }


//STRIP001 long ScPreview::GetFirstPage(USHORT nTab)
//STRIP001 {
//STRIP001 	USHORT nTabCount = pDocShell->GetDocument()->GetTableCount();
//STRIP001 	if (nTab >= nTabCount)
//STRIP001 		nTab = nTabCount-1;
//STRIP001 
//STRIP001 	long nPage = 0;
//STRIP001 	if (nTab>0)
//STRIP001 	{
//STRIP001 		CalcPages( nTab );
//STRIP001 		UpdateDrawView();		// Tabelle evtl. geaendert
//STRIP001 
//STRIP001 		for (USHORT i=0; i<nTab; i++)
//STRIP001 			nPage += nPages[i];
//STRIP001 
//STRIP001 		// bei leerer Tabelle vorhergehende Seite
//STRIP001 
//STRIP001 		if ( nPages[nTab]==0 && nPage > 0 )
//STRIP001 			--nPage;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nPage;
//STRIP001 }


//STRIP001 Size lcl_GetDocPageSize( ScDocument* pDoc, USHORT nTab )
//STRIP001 {
//STRIP001 	String aName = pDoc->GetPageStyle( nTab );
//STRIP001 	ScStyleSheetPool* pStylePool = pDoc->GetStyleSheetPool();
//STRIP001 	SfxStyleSheetBase* pStyleSheet = pStylePool->Find( aName, SFX_STYLE_FAMILY_PAGE );
//STRIP001 	if ( pStyleSheet )
//STRIP001 	{
//STRIP001 		SfxItemSet& rStyleSet = pStyleSheet->GetItemSet();
//STRIP001 		return ((const SvxSizeItem&) rStyleSet.Get(ATTR_PAGE_SIZE)).GetSize();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR( "PageStyle not found" );
//STRIP001 		return Size();
//STRIP001 	}
//STRIP001 }


//STRIP001 USHORT ScPreview::GetOptimalZoom(BOOL bWidthOnly)
//STRIP001 {
//STRIP001 	double nWinScaleX = ScGlobal::nScreenPPTX / pDocShell->GetOutputFactor();
//STRIP001 	double nWinScaleY = ScGlobal::nScreenPPTY;
//STRIP001 	Size aWinSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 	//	desired margin is 0.25cm in default MapMode (like Writer),
//STRIP001 	//	but some additional margin is introduced by integer scale values
//STRIP001 	//	-> add only 0.10cm, so there is some margin in all cases.
//STRIP001 	Size aMarginSize( LogicToPixel( Size( 100, 100 ), MAP_100TH_MM ) );
//STRIP001 	aWinSize.Width()  -= 2 * aMarginSize.Width();
//STRIP001 	aWinSize.Height() -= 2 * aMarginSize.Height();
//STRIP001 
//STRIP001 	Size aPageSize = lcl_GetDocPageSize( pDocShell->GetDocument(), nTab );
//STRIP001 	if ( aPageSize.Width() && aPageSize.Height() )
//STRIP001 	{
//STRIP001 		long nZoomX = (long) ( aWinSize.Width() * 100  / ( aPageSize.Width() * nWinScaleX ));
//STRIP001 		long nZoomY = (long) ( aWinSize.Height() * 100 / ( aPageSize.Height() * nWinScaleY ));
//STRIP001 
//STRIP001 		long nOptimal = nZoomX;
//STRIP001 		if (!bWidthOnly && nZoomY<nOptimal)
//STRIP001 			nOptimal = nZoomY;
//STRIP001 
//STRIP001 		if (nOptimal<20)
//STRIP001 			nOptimal = 20;
//STRIP001 		if (nOptimal>400)
//STRIP001 			nOptimal = 400;
//STRIP001 
//STRIP001 		return (USHORT) nOptimal;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return nZoom;
//STRIP001 }


//STRIP001 void ScPreview::SetXOffset( long nX )
//STRIP001 {
//STRIP001 	if ( aOffset.X() == nX )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if (bValid)
//STRIP001 	{
//STRIP001 		long nDif = LogicToPixel(aOffset).X() - LogicToPixel(Point(nX,0)).X();
//STRIP001 		aOffset.X() = nX;
//STRIP001 		if (nDif && !bInPaint)
//STRIP001 		{
//STRIP001 			MapMode aOldMode = GetMapMode(); SetMapMode(MAP_PIXEL);
//STRIP001 			Scroll( nDif, 0 );
//STRIP001 			SetMapMode(aOldMode);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aOffset.X() = nX;
//STRIP001 		if (!bInPaint)
//STRIP001 			Invalidate();
//STRIP001 	}
//STRIP001 	InvalidateLocationData( SC_HINT_ACC_VISAREACHANGED );
//STRIP001 }


//STRIP001 void ScPreview::SetYOffset( long nY )
//STRIP001 {
//STRIP001 	if ( aOffset.Y() == nY )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if (bValid)
//STRIP001 	{
//STRIP001 		long nDif = LogicToPixel(aOffset).Y() - LogicToPixel(Point(0,nY)).Y();
//STRIP001 		aOffset.Y() = nY;
//STRIP001 		if (nDif && !bInPaint)
//STRIP001 		{
//STRIP001 			MapMode aOldMode = GetMapMode(); SetMapMode(MAP_PIXEL);
//STRIP001 			Scroll( 0, nDif );
//STRIP001 			SetMapMode(aOldMode);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aOffset.Y() = nY;
//STRIP001 		if (!bInPaint)
//STRIP001 			Invalidate();
//STRIP001 	}
//STRIP001 	InvalidateLocationData( SC_HINT_ACC_VISAREACHANGED );
//STRIP001 }


//STRIP001 void ScPreview::DoInvalidate()
//STRIP001 {
//STRIP001 	//	Wenn das ganze aus dem GetState der Shell gerufen wird,
//STRIP001 	//	muss das Invalidate hinterher asynchron kommen...
//STRIP001 
//STRIP001 	if (bInGetState)
//STRIP001 		Application::PostUserEvent( STATIC_LINK( this, ScPreview, InvalidateHdl ) );
//STRIP001 	else
//STRIP001 		StaticInvalidate();		// sofort
//STRIP001 }

//STRIP001 void ScPreview::StaticInvalidate()
//STRIP001 {
//STRIP001 	//	static method, because it's called asynchronously
//STRIP001 	//	-> must use current viewframe
//STRIP001 
//STRIP001 	SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 	if (!pViewFrm)
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxBindings& rBindings = pViewFrm->GetBindings();
//STRIP001 	rBindings.Invalidate(SID_STATUS_DOCPOS);
//STRIP001 	rBindings.Invalidate(SID_STATUS_PAGESTYLE);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_PREVIOUS);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_NEXT);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_FIRST);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_LAST);
//STRIP001 	rBindings.Invalidate(SID_ATTR_ZOOM);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_ZOOMIN);
//STRIP001 	rBindings.Invalidate(SID_PREVIEW_ZOOMOUT);
//STRIP001 }

//STRIP001 IMPL_STATIC_LINK( ScPreview, InvalidateHdl, void*, EMPTYARG )
//STRIP001 {
//STRIP001 	StaticInvalidate();
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void ScPreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged(rDCEvt);
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_PRINTER) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) ||
//STRIP001 		 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 	{
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_FONTS )
//STRIP001 			pDocShell->UpdateFontList();
//STRIP001 
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_SETTINGS &&
//STRIP001 			  (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 		{
//STRIP001 			//	scroll bar size may have changed
//STRIP001 			pViewShell->InvalidateBorder();		// calls OuterResizePixel
//STRIP001 		}
//STRIP001 
//STRIP001 		Invalidate();
//STRIP001 		InvalidateLocationData( SC_HINT_DATACHANGED );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScPreview::InvalidateLocationData(ULONG nId)
//STRIP001 {
//STRIP001 	bLocationValid = FALSE;
//STRIP001     if (pViewShell->HasAccessibilityObjects())
//STRIP001     	pViewShell->BroadcastAccessibility( SfxSimpleHint( nId ) );
//STRIP001 }

//STRIP001 void ScPreview::GetFocus()
//STRIP001 {
//STRIP001     if (pViewShell->HasAccessibilityObjects())
//STRIP001         pViewShell->BroadcastAccessibility( ScAccWinFocusGotHint(GetAccessible()) );
//STRIP001 }

//STRIP001 void ScPreview::LoseFocus()
//STRIP001 {
//STRIP001     if (pViewShell->HasAccessibilityObjects())
//STRIP001         pViewShell->BroadcastAccessibility( ScAccWinFocusLostHint(GetAccessible()) );
//STRIP001 }

//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible> ScPreview::CreateAccessible()
//STRIP001 {
//STRIP001 	ScAccessibleDocumentPagePreview* pAccessible =
//STRIP001 		new ScAccessibleDocumentPagePreview( GetAccessibleParentWindow()->GetAccessible(), pViewShell );
//STRIP001 	::com::sun::star::uno::Reference < ::com::sun::star::accessibility::XAccessible > xAccessible = pAccessible;
//STRIP001 	pAccessible->Init();
//STRIP001 	return xAccessible;
//STRIP001 }


}
